<article <?php post_class('blog-item ' . (!has_post_thumbnail() ? 'no-thumbs' : '')); ?>>
    <?php if (has_post_thumbnail()) : ?>
        <div class="blog-img">
            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
        </div>
    <?php endif; ?>

    <div class="full-blog-content">
        <div class="user-info">
            <?php if ($args['show_author']) : ?>
                <div class="single-info author"><i class="rt-circle-user-regular"></i><span><?php the_author(); ?></span></div>
            <?php endif; ?>

            <?php if ($args['show_date']) : ?>
                <div class="single-info date"><i class="rt-clock-regular"></i><span><?php echo get_the_date(); ?></span></div>
            <?php endif; ?>

            <?php if ($args['show_category']) : ?>
                <div class="single-info cat"><i class="rt-tags"></i><span><?php the_category(', '); ?></span></div>
            <?php endif; ?>
        </div>

        <div class="title-wrap">
            <h3 class="blog-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
        </div>

        <?php if ($args['show_excerpt']) : ?>
            <div class="blog-desc"><?php echo wp_trim_words( get_the_excerpt(), 30, '' ); ?></div>
        <?php endif; ?>

        <div class="blog-button">
            <a class="button-blog" href="<?php the_permalink(); ?>"><?php echo esc_html($args['read_more']); ?></a>
        </div>
    </div>
</article>
