<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
  <div class="entry-content">
    <?php
    // Output the full post content.
    the_content();

    // Handle paginated posts.
    wp_link_pages([
      'before'      => '<div class="page-links"><div class="pagination-pages">' . esc_html__('Pages:', 'invena'),
      'after'       => '</div></div>',
      'link_before' => '<span class="page-number">',
      'link_after'  => '</span>',
    ]);

    // Load comments template if comments are open or exist.
    if (comments_open() || get_comments_number()) {
      comments_template();
    }
    ?>
  </div><!-- .entry-content -->

  <?php if (get_edit_post_link()) : ?>
    <footer class="entry-footer">
      <span class="edit-link">
        <?php
        edit_post_link(
          sprintf(
            wp_kses(
              __('Edit <span class="screen-reader-text">%s</span>', 'invena'),
              ['span' => ['class' => []]]
            ),
            get_the_title()
          )
        );
        ?>
      </span>
    </footer><!-- .entry-footer -->
  <?php endif; ?>
</article><!-- #post-<?php the_ID(); ?> -->
