<?php
    get_header();
    $post_id      = get_the_id();
    $author_id    = get_post_field ('post_author', $post_id);
    $display_name = get_the_author_meta( 'display_name' , $author_id );    
    $blog_layout  = get_theme_mod('single_layout', 'full');

    $layout = 'full-layout-right';
    $col = '8';

    if (
        $blog_layout === 'full' || !is_active_sidebar('sidebar-1') || (isset($_GET['layout']) && $_GET['layout'] === 'layout-full')
    ) {
        $layout = 'full-layout';
        $col = '12';
    } elseif ($blog_layout === '2left' || (isset($_GET['layout']) && $_GET['layout'] === 'layout-ls')) {
        $layout = 'full-layout-left';
    } elseif ($blog_layout === '2right' || (isset($_GET['layout']) && $_GET['layout'] === 'layout-rs')) {
        $layout = 'full-layout-right';
    }
    $not_kirki = !class_exists( '\Elementor\Plugin' ) ? '' : 'col-lg-' . esc_attr($col);
    ?>
    <div class="reactheme-blog-details pt-70 pb-70">
        <div class="row padding-<?php echo esc_attr($layout); ?>">
            <div class="contents-sticky col-md-12 <?php echo esc_attr($not_kirki); ?> <?php echo esc_attr($layout); ?>">
                <div class="news-details-inner">
                    <?php while ( have_posts() ) : the_post();?>             
                        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>> 
                            <?php
                                get_template_part( 'template-parts/post/content', get_post_format() );         
                            ?>
                            <div class="clear-fix"></div>      
                        </article> 
                        <?php 
                        if( get_theme_mod('single_blog_author_meta') == 'show' ) :
                            if ( is_single() ) {
                                $author_ID = get_the_author_meta('ID');
                                $twitter_url = get_the_author_meta('twitter_url', $author_ID);
                                $instagram_url = get_the_author_meta('instagram_url', $author_ID);
                                $pinterest_url = get_the_author_meta('pinterest_url', $author_ID);
                                $designation = get_the_author_meta( 'author_designations', get_the_author_meta( 'ID' ) );
                            } ?>
                            <div class="author-block">
                                <?php 
                                if ( function_exists( 'get_avatar' ) ) : ?>
                                    <div class="author-img"> <?php echo get_avatar( get_the_author_meta( 'ID' ), 200); ?> </div>
                                    <?php 
                                endif; ?>
                                <div class="author-desc">                                   
                                    <?php                                    
                                    if ( ! empty( $designation ) ) : ?>
                                        <span> <?php echo esc_html( $designation ); ?></span>
                                        <?php 
                                    endif; ?>                                        
                                    <h3 class="author-title">
                                        <?php the_author();?>
                                    </h3>

                                    <?php   
                                    echo wpautop( get_the_author_meta( 'description' ) );

                                    if ( ! empty( $twitter_url ) || ! empty( $instagram_url ) || ! empty( $pinterest_url ) ) : ?>
                                        <!-- Author Socila Info  -->
                                        <div class="rts-author-social-area">
                                            <ul>
                                                <?php                                            
                                                    if ($twitter_url) {
                                                        echo '<li><a href="' . esc_url($twitter_url) . '" target="_blank" class="t"><i class="fab fa-twitter"></i></a></li>';
                                                    }
                                                    if ($instagram_url) {
                                                        echo '<li><a href="' . esc_url($instagram_url) . '" target="_blank" class="in"><i class="fab fa-instagram"></i></a></li>';
                                                    }
                                                    if ($pinterest_url) {
                                                        echo '<li><a href="' . esc_url($pinterest_url) . '" target="_blank" class="p"><i class="fab fa-pinterest"></i></a></li>';
                                                    }
                                                ?>
                                            </ul>                                            
                                        </div>
                                        <?php 
                                    endif; ?>
                                </div>
                            </div>
                            <!-- .author-block -->
                            <?php 
                        endif; 

                        // Pagination 
                        if( get_theme_mod( 'single_blog_pagination' ) == 'show' ){
                            get_template_part( 'pagination' );  
                        }

                        // Comments 
                        if( get_theme_mod('single_blog_comment') == 'show' ){
                            // If comments are open or we have at least one comment, load up the comment template.
                            if ( comments_open() || get_comments_number() ) :
                                add_filter('comment_form_default_fields', function ($fields) {
                                    unset($fields['url']); 
                                    unset($fields['cookies']);
                                    return $fields;
                                });
                                comments_template();
                            endif;
                        }
                    endwhile; ?>
                </div>
            </div>
            <?php   
            $blog_layout =  get_theme_mod('single_layout','full');            
            if ( isset($blog_layout) && $blog_layout !== 'full' && class_exists( '\Elementor\Plugin' )) {        
                get_sidebar('single');
            }            
            ?>    
        </div>
    </div>      
<?php
get_footer();