<?php
/*
* portfolio single page template
*/
get_header(); 
?>
<!-- Portfolio Detail Start -->
<div class="reactheme-porfolio-details"> 
   <?php 
   while ( have_posts() ) : the_post(); 
      $post_id = get_the_ID(); // Save the post ID for later use
   ?>  
      <div class="project-desc">       
         <?php the_content(); ?>           
      </div> 
   <?php 
   endwhile; 
   wp_reset_postdata(); 
   
   $categories = wp_get_post_terms($post_id, 'rt-portfolio-category', array('fields' => 'slugs'));
   $args = array(
      'post_type'      => 'rt-portfolios',
      'posts_per_page' => -1,
      'post__not_in'   => array($post_id),
   );   

   if (!empty($categories)) {
      $args['tax_query'] = array(
         array(
            'taxonomy' => 'rt-portfolio-category',
            'field'    => 'slug',
            'terms'    => $categories,
         ),
      );
   }   

   $related_posts = new WP_Query($args);
   if ($related_posts->have_posts()) : ?>
   
      <?php 
      // pagination 
      if( get_theme_mod( 'invena_portfolio_single_pagination' ) == 'on' ) : ?>
         <div class="portfolio-navigation">
            <?php get_template_part( 'pagination' ); ?>
         </div>
         <?php 
      endif; 

      //  related posts 
      if( get_theme_mod( 'invena_portfolio_related' ) == 'on' ) :
         
         $per_perview_desktop = get_theme_mod('project_related_post_perview', '2');
         $per_perview_tablet  = get_theme_mod('project_related_post_perview_tablet', '1');
         $per_perview_mobile  = get_theme_mod('project_related_post_perview_mobile', '1');

         static $instance = 0;
         $instance++;
         $slider_data_attributes = sprintf(
            'data-slides-per-view="%s" 
            data-slides-per-view-tablet="%s" 
            data-slides-per-view-mobile="%s" ',
            esc_attr($per_perview_desktop),
            esc_attr($per_perview_tablet),
            esc_attr($per_perview_mobile),
        );      
      
      ?>
         <h2 class="related_post_section_title"><?php echo esc_html( 'Related Project', 'invena' ); ?></h2>
         <div class="swiper rt-portfolio-related-post" <?php echo $slider_data_attributes; ?>>
            <div class="swiper-wrapper">
               <?php 
                  while ($related_posts->have_posts()): $related_posts->the_post(); 
                     $cat_name      = get_the_terms( get_the_ID(), 'rt-portfolio-category' ); 
                     $style         = get_theme_mod( 'project_related_post_style' );
                     $excerpt_data  = get_the_excerpt();
                  ?>
                     <div class="swiper-slide">	
                     <?php
                     if( $style == 'style2' ) : ?>
                        <div class="portfolio-slider-two">
                           <?php 
                           if( has_post_thumbnail() ): ?>
                              <a aria-label="project thumbnail" class="thumbnail" href="<?php the_permalink(); ?>">
                                 <?php the_post_thumbnail(); ?>
                              </a>
                              <?php 
                           endif; ?>	
                           <div class="inner-content">
                              <?php 
                              if ( get_the_title() ) : ?>
                                    <a  aria-label="project title" href="<?php the_permalink(); ?>">
                                       <h3 class="title">
                                          <?php echo esc_html( get_the_title() ); ?>
                                       </h3>
                                       <?php 
                                       if ( !empty( $cat_name ) && !is_wp_error( $cat_name ) ) :
                                          echo'<span class="cat">' . esc_html( $cat_name[0]->name ) . '</span>';
                                       endif; ?>
                                    </a>
                                 <?php 
                              endif; ?>
                           </div>
                           <div class="icon">
                              <svg xmlns="http://www.w3.org/2000/svg" width="19" height="14" viewBox="0 0 19 14" fill="none">
                              <path d="M6 7C6 4.8125 7.78125 3 10 3C12.1875 3 14 4.8125 14 7C14 9.21875 12.1875 11 10 11C7.78125 11 6 9.21875 6 7ZM10 9.5C11.375 9.5 12.5 8.40625 12.5 7C12.5 5.625 11.375 4.5 10 4.5C9.96875 4.5 9.9375 4.5 9.90625 4.5C9.96875 4.6875 10 4.84375 10 5C10 6.125 9.09375 7 8 7C7.8125 7 7.65625 7 7.5 6.9375C7.5 6.96875 7.5 7 7.5 7C7.5 8.40625 8.59375 9.5 10 9.5ZM3.96875 2.53125C5.4375 1.15625 7.46875 0 10 0C12.5 0 14.5312 1.15625 16 2.53125C17.4688 3.875 18.4375 5.5 18.9062 6.625C19 6.875 19 7.15625 18.9062 7.40625C18.4375 8.5 17.4688 10.125 16 11.5C14.5312 12.875 12.5 14 10 14C7.46875 14 5.4375 12.875 3.96875 11.5C2.5 10.125 1.53125 8.5 1.0625 7.40625C0.96875 7.15625 0.96875 6.875 1.0625 6.625C1.53125 5.5 2.5 3.875 3.96875 2.53125ZM10 1.5C7.9375 1.5 6.28125 2.4375 5 3.625C3.78125 4.75 2.96875 6.0625 2.53125 7C2.96875 7.9375 3.78125 9.28125 5 10.4062C6.28125 11.5938 7.9375 12.5 10 12.5C12.0312 12.5 13.6875 11.5938 14.9688 10.4062C16.1875 9.28125 17 7.9375 17.4375 7C17 6.0625 16.1875 4.75 14.9688 3.625C13.6875 2.4375 12.0312 1.5 10 1.5Z" fill="#20282D"/>
                              </svg>
                           </div>
                        </div>	
                     <?php 
                     elseif( $style == 'style3' ) : ?>
                        <div class="portfolio-slider-three">
                           <div class="inner-content">
                              <div class="icon">
                                 <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 100 100" fill="none">
                                 <path d="M71.0604 49.8146H56.3164C55.4535 49.8146 54.7539 50.5143 54.7539 51.3771V98.4373C54.7539 99.3002 55.4535 99.9998 56.3164 99.9998H71.0604C71.9232 99.9998 72.6229 99.3002 72.6229 98.4373V51.3771C72.6229 50.5143 71.9234 49.8146 71.0604 49.8146ZM69.4979 96.8748H57.8789V52.9396H69.4979V96.8748ZM43.6832 55.96H28.9393C28.0764 55.96 27.3768 56.6596 27.3768 57.5225V98.4375C27.3768 99.3004 28.0764 100 28.9393 100H43.6832C44.5461 100 45.2457 99.3004 45.2457 98.4375V57.5225C45.2457 56.6594 44.5463 55.96 43.6832 55.96ZM42.1207 96.875H30.5018V59.085H42.1207V96.875ZM16.3064 30.4742H1.5625C0.699609 30.4742 0 31.1738 0 32.0367V98.4371C0 99.3 0.699609 99.9996 1.5625 99.9996H16.3064C17.1693 99.9996 17.8689 99.3 17.8689 98.4371V32.0367C17.8689 31.1736 17.1693 30.4742 16.3064 30.4742ZM14.7439 96.8746H3.125V33.5992H14.7439V96.8746ZM98.4375 68.0693H83.6937C82.8309 68.0693 82.1312 68.7689 82.1312 69.6318V98.4371C82.1312 99.3 82.8309 99.9996 83.6937 99.9996H98.4375C99.3004 99.9996 100 99.3 100 98.4371V69.6318C100 68.7687 99.3004 68.0693 98.4375 68.0693ZM96.875 96.8746H85.2562V71.1943H96.875V96.8746ZM82.641 55.1629C81.7816 55.0852 81.1479 54.3254 81.2258 53.466C81.3035 52.6066 82.0656 51.9729 82.9227 52.0508L85.908 52.3209L63.382 34.7809L36.7928 43.3984C36.2318 43.5803 35.6166 43.4309 35.2016 43.0121L7.825 15.4018C7.21738 14.7889 7.22168 13.7996 7.83437 13.1922C8.44707 12.5848 9.43652 12.5887 10.0439 13.2016L36.7438 40.1295L63.2066 31.5525C63.6994 31.3928 64.2395 31.4877 64.6484 31.8061L88.1285 50.0891L86.8859 46.0209C86.6338 45.1955 87.0984 44.3223 87.9238 44.0701C88.7492 43.8178 89.6225 44.2826 89.8746 45.108L92.5602 53.9C92.7121 54.3975 92.6064 54.9379 92.2785 55.3416C91.9803 55.7086 91.5338 55.9189 91.066 55.9189C91.0191 55.9189 90.9723 55.9168 90.925 55.9125L82.641 55.1629ZM45.8313 20.4506C46.0684 20.1766 46.1516 19.8697 46.1014 19.4561C46.0137 18.7338 45.5633 17.8473 42.8352 17.3996C38.4926 16.6865 37.4773 14.4016 37.3906 12.6105C37.2723 10.1754 38.925 8.13672 41.5127 7.49531V6.83066C41.5127 5.96777 42.2123 5.26816 43.0752 5.26816C43.9381 5.26816 44.6377 5.96777 44.6377 6.83066V7.47754C46.3154 7.87344 47.9033 8.9543 48.7395 10.9461C49.0734 11.7418 48.6994 12.6576 47.9037 12.9916C47.1076 13.3256 46.1922 12.9514 45.8582 12.1559C45.21 10.6123 43.6209 10.2164 42.333 10.5082C42.0166 10.5801 40.4414 11.0113 40.5117 12.4588C40.5303 12.8428 40.5797 13.8621 43.3412 14.3156C46.9186 14.9027 48.891 16.5055 49.2033 19.0793C49.36 20.3695 49.0111 21.5506 48.1945 22.4947C47.3793 23.4371 46.102 24.1018 44.6375 24.3785V24.9879C44.6375 25.8508 43.9379 26.5504 43.075 26.5504C42.2121 26.5504 41.5125 25.8508 41.5125 24.9879V24.3527C39.2361 23.8564 37.4937 22.3014 36.9564 20.1463C36.7477 19.309 37.2572 18.4609 38.0945 18.2521C38.9326 18.0432 39.7799 18.5529 39.9887 19.3902C40.3699 20.9191 41.9695 21.4256 43.2252 21.3965C44.3172 21.3705 45.3645 20.9904 45.8313 20.4506ZM43.075 31.8186C51.8475 31.8186 58.9844 24.6816 58.9844 15.9092C58.9844 7.13672 51.8475 0 43.075 0C34.3025 0 27.1656 7.13691 27.1656 15.9094C27.1656 24.6818 34.3027 31.8186 43.075 31.8186ZM43.075 3.125C50.1244 3.125 55.8594 8.85996 55.8594 15.9094C55.8594 22.9588 50.1244 28.6938 43.075 28.6938C36.0256 28.6938 30.2906 22.9588 30.2906 15.9094C30.2906 8.85996 36.0258 3.125 43.075 3.125Z" fill="#20282D"/>
                                 </svg>
                              </div>
                              <div class="title-area">
                                 <?php 
                                 if ( get_the_title() ) : ?>							
                                    <h3 class="title">
                                       <?php echo esc_html( get_the_title() ); ?>
                                    </h3>							
                                    <?php 
                                 endif; 

                                 if ( !empty( $cat_name ) && !is_wp_error( $cat_name ) ) :
                                    echo'<span class="cat">' . esc_html( $cat_name[0]->name ) . '</span>';
                                 endif; ?>
                              </div>
                              <div class="inner">
                                 <p class="des">
                                    <?php echo wp_kses_post( wp_trim_words( $excerpt_data, 20, '' ) ); ?>
                                 </p>
                                 <a href="<?php the_permalink(); ?>" class="react_button elementor-button"><?php echo esc_html( 'View Project', 'invena' ); ?></a>
                              </div>
                           </div>	
                           <?php 		
                           if( has_post_thumbnail() ): ?>
                              <a aria-label="project thumbnail" class="thumbnail" href="<?php the_permalink(); ?>">
                                 <?php the_post_thumbnail(); ?>
                              </a>
                              <?php 
                           endif; ?>	
                        </div>  

                     <?php 
                     else : ?>
                        <div class="portfolio-slider-one">
                           <?php 
                           if( has_post_thumbnail() ): ?>
                              <a aria-label="project thumbnail" class="thumbnail" href="<?php the_permalink(); ?>">
                                 <?php the_post_thumbnail(); ?>
                              </a>
                              <?php 
                           endif; ?>
                           <div class="inner-content">
                              <?php 
                              if ( get_the_title() ) : ?>
                                    <a  aria-label="project title" href="<?php the_permalink(); ?>">
                                       <h3 class="title">
                                          <?php echo get_the_title(); ?>
                                       </h3>
                                    </a>
                                 <?php 
                              endif;
                              if ( !empty( $cat_name ) && !is_wp_error( $cat_name ) ) :
                                 echo'<span class="cat">' . esc_html( $cat_name[0]->name ) . '</span>';
                              endif; ?>
                           </div>
                        </div>		
                        <?php 
                     endif; ?> 
                     </div>
                  <?php 
               endwhile;
               wp_reset_postdata(); ?>
            </div>
            <div class="swiper-navigaiton">
               <span class="swiper-prev"><i class="rt rt-arrow-left"></i></span>
               <span class="swiper-next"><i class="rt rt-arrow-right"></i></span>
            </div>
         </div>
         <?php 
      endif;
   endif; ?>
</div>
<?php  get_footer(); ?>