<?php
get_header();
$blog_layout     = get_theme_mod('blog_layout', 'full');
$blog_grid       = get_theme_mod('blog_grid', '12');
$show_author     = get_theme_mod('blog_author_post', 'show') === 'show';
$show_date       = get_theme_mod('blog_date', 'show') === 'show';
$show_category   = get_theme_mod('blog_category', 'show') === 'show';
$show_excerpt    = get_theme_mod('blog_post_content', 'show') === 'show';
$read_more_text  = get_theme_mod('read_more_text', __('Read More', 'invena'));

// Determine layout and column
$layout = 'full-layout-right';
$col = '8';

if (
    $blog_layout === 'full' || !is_active_sidebar('sidebar-1') || (isset($_GET['layout']) && $_GET['layout'] === 'layout-full')
) {
    $layout = 'full-layout';
    $col = '12';
} elseif ($blog_layout === '2left' || (isset($_GET['layout']) && $_GET['layout'] === 'layout-ls')) {
    $layout = 'full-layout-left';
} elseif ($blog_layout === '2right' || (isset($_GET['layout']) && $_GET['layout'] === 'layout-rs')) {
    $layout = 'full-layout-right';
}
$not_kirki = !class_exists( '\Elementor\Plugin' ) ? '' : 'col-lg-' . esc_attr($col);

?>

<div id="reactheme-blog" class="reactheme-blog blog-page">
    <div class="row padding-<?php echo esc_attr($layout); ?>">
        <div class="contents-sticky col-md-12 <?php echo esc_attr($not_kirki); ?> <?php echo esc_attr($layout); ?>">
            <div class="row">
                <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                    <div class="col-sm-<?php echo esc_attr($blog_grid); ?> col-12">
                        <?php
                        get_template_part('template-parts/content-post', null, [
                            'show_author'   => $show_author,
                            'show_date'     => $show_date,
                            'show_category' => $show_category,
                            'show_excerpt'  => $show_excerpt,
                            'read_more'     => $read_more_text,
                        ]);
                        ?>
                    </div>
                <?php endwhile; wp_reset_postdata(); ?>

                <div class="pagination-area">
                    <?php the_posts_pagination(); ?>
                </div>

                <?php else : get_template_part('template-parts/content', 'none'); endif; ?>
            </div>
        </div>

        <?php 
            if ( isset($layout) && $layout !== 'full-layout' && class_exists( '\Elementor\Plugin' )) {
                get_sidebar('single');
            }
        ?>
    </div>
</div>

<?php get_footer(); ?>
