<?php
function invena_scripts() {
	wp_enqueue_style( 'invena-plugins', get_template_directory_uri() .'/assets/css/plugins.css' );
	wp_enqueue_style( 'invena-theme-check', get_template_directory_uri() .'/assets/scss/theme.css' );
	wp_enqueue_style( 'invena-responsive', get_template_directory_uri() .'/assets/css/responsive.css' );
	wp_enqueue_style( 'invena-style', get_stylesheet_uri() );
	wp_enqueue_script('invena-main', get_template_directory_uri() . '/assets/js/main.js', array('jquery'), wp_get_theme()->get( 'Version' ), true);	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

add_action( 'wp_enqueue_scripts', 'invena_scripts' );

add_action( 'admin_enqueue_scripts', 'invena_load_admin_styles' );
function invena_load_admin_styles($screen) {
	wp_enqueue_style( 'invena-admin-style', get_template_directory_uri() . '/assets/css/admin-style.css', true, '1.0.0' );
	wp_enqueue_script( 'invena-admin-script', get_template_directory_uri() . '/assets/js/admin-script.js', array('jquery'), '1.0.0', true );
} 
