<?php
/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function invena_body_classes( $classes ) {
  // Adds a class of hfeed to non-singular pages.
  if ( ! is_singular() ) {
    $classes[] = 'hfeed';
  }

  return $classes;
}
add_filter( 'body_class', 'invena_body_classes' );


function invena_custom_logo_setup() {
  add_theme_support( 'custom-logo', array(
    'height'      => 100,
    'width'       => 300,
    'flex-height' => true,
    'flex-width'  => true,
    'header-text' => array( 'site-title', 'invena' ),
  ) );
}
add_action( 'after_setup_theme', 'invena_custom_logo_setup' );


/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function invena_pingback_header() {
  if ( is_singular() && pings_open() ) {
    echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
  }
}

add_action( 'wp_head', 'invena_pingback_header' );
/**  kses_allowed_html */
function invena_prefix_kses_allowed_html($tags, $context) {
  switch($context) {
    case 'invena': 
      $tags = array( 
        'a' => array('href' => array()),
        'b' => array()
      );
      return $tags;
    default: 
      return $tags;
  }
}
add_filter( 'wp_kses_allowed_html', 'invena_prefix_kses_allowed_html', 10, 2);

/*
Register Fonts theme google font*/

function invena_studio_fonts_url() {
    $font_url = '';    
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'invena' ) ) {
        $query_args = array(
            'family' => 'DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000|Red+Hat+Display:ital,wght@0,300..900;1,300..900',
            'display' => 'swap',
        );
        $font_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }
    return $font_url;
}


function invena_studio_scripts() {
    wp_enqueue_style( 'studio-fonts', invena_studio_fonts_url(), array(), '1.0.0' );
}
add_action( 'wp_enqueue_scripts', 'invena_studio_scripts' );

//Demo content file include here

function invena_import_files() {
    return array( 
       // Multipage Page Demo Business
        array(
            'import_file_name' => 'Business Multipage O1',
            'categories' => array( 'Business' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/02.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business One',      
        ),

        array(
            'import_file_name' => 'Business Multipage O2',
            'categories' => array( 'Business' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/01.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Two',      
        ),

        array(
            'import_file_name' => 'Business Multipage O3',
            'categories' => array( 'Business' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/03.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Three',      
        ),

        array(
            'import_file_name' => 'Business Multipage O4',
            'categories' => array( 'Business' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/04.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Four',      
        ),

        array(
            'import_file_name' => 'Business Multipage O5',
            'categories' => array( 'Business' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/08.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Management',      
        ),

        array(
            'import_file_name' => 'Business Multipage O6',
            'categories' => array( 'Business' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/10.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Website',      
        ),

        array(
            'import_file_name' => 'Business Multipage O7',
            'categories' => array( 'Business' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/12.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Video',      
        ),

        array(
            'import_file_name' => 'Business Coach Multipage O8',
            'categories' => array( 'Business' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/coach/coach.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/coach/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/coach/coach-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/12.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Home',      
        ),


        // Landing Page Demo Business

        array(
            'import_file_name' => 'Business Landing O1',
            'categories' => array( 'Business Landing' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/02.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business One Landing ',      
        ),

        array(
            'import_file_name' => 'Business Landing O2',
            'categories' => array( 'Business Landing' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/01.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Two Landing',      
        ),

        array(
            'import_file_name' => 'Business Landing O3',
            'categories' => array( 'Business Landing' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/03.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Three Landing ',      
        ),

        array(
            'import_file_name' => 'Business Landing O4',
            'categories' => array( 'Business Landing' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/04.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Four Landing',      
        ),

        array(
            'import_file_name' => 'Business Landing O5',
            'categories' => array( 'Business Landing' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/08.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Management Landing',      
        ),

        array(
            'import_file_name' => 'Business Landing O6',
            'categories' => array( 'Business Landing' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/10.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Website Landing',      
        ),

        array(
            'import_file_name' => 'Business Landing O7',
            'categories' => array( 'Business Landing' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/12.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Video Landing',      
        ),

        array(
            'import_file_name' => 'Business Coach Landing O8',
            'categories' => array( 'Business Landing' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/coach/coach.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/coach/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/coach/coach-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/16.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Landing',      
        ),

        // Multipage Page Demo SEO
        array(
            'import_file_name' => 'SEO Multipage O1',
            'categories' => array( 'SEO' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/seo/seo.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/seo/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/seo/seo-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/17.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Home',      
        ),

        // Landing Page Demo SEO
        array(
            'import_file_name' => 'SEO Landing 01',
            'categories' => array( 'SEO' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/seo/seo.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/seo/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/seo/seo-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/17.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Landing',      
        ),
        
        // Technology Landing Page Demo
        array(
            'import_file_name' => 'Technology Multipage 01',
            'categories' => array( 'Technology' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/technology/technology.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/technology/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/technology/technology-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/18.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Home',      
        ),

        // Technology Landing Page Demo
        array(
            'import_file_name' => 'Technology Landing 01',
            'categories' => array( 'Technology' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/technology/technology.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/technology/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/technology/technology-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/18.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Landing',      
        ),

        // Multipage Page Demo Agency
        array(
            'import_file_name'           => 'Agency Multipage O1',
            'categories' => array( 'Agency' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/07.webp',   
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Agency',      
        ),

        // Landing Page Demo Agency
        array(
            'import_file_name'           => 'Agency Landing O1',
            'categories' => array( 'Agency' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/business/business-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/07.webp',   
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Business Agency',      
        ),

        // Multipage Page Demo Marketing
        array(
            'import_file_name'           => 'Marketing Multipage O1',
            'categories' => array( 'Marketing' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/marketing/marketing.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/marketing/invena-export.txt',
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/marketing/marketing-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/06.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Home',      
        ),

        // Landing Page Demo Marketing
        array(
            'import_file_name'           => 'Marketing Landing O1',
            'categories' => array( 'Marketing' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/marketing/marketing.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/marketing/invena-export.txt',
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/marketing/marketing-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/06.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Landing Page',      
        ),

        // Multipage Page Demo HR
        array(
            'import_file_name'           => 'HR Multipage O1',
            'categories' => array( 'HR' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/hr/hr.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/hr/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/hr/hr-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/15.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Home',      
        ),

        // Landing Page Demo HR
        array(
            'import_file_name'           => 'HR Landing O1',
            'categories' => array( 'HR' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/hr/hr.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/hr/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/hr/hr-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/15.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Landing Page',      
        ),

        // Multipage Page Demo Tax
        array(
            'import_file_name'           => 'Tax Multipage O1',
            'categories' => array( 'Tax' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/tax/tax.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/tax/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/tax/tax-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/13.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Home',      
        ),

        array(
            'import_file_name'           => 'Tax Multipage O2',
            'categories' => array( 'Tax' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/tax/tax2.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/tax/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/tax/tax-kit2.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/14.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Home',      
        ),

        // Landing Page Demo Tax
        array(
            'import_file_name'           => 'Tax Landing O1',
            'categories' => array( 'Tax' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/tax/tax.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/tax/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/tax/tax-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/13.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Landing Page',      
        ),

        array(
            'import_file_name'           => 'Tax Landing O2',
            'categories' => array( 'Tax' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/tax/tax2.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/tax/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/tax/tax-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/14.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Landing Page',      
        ),
        
        // Multipage Page Demo Finance
        array(
            'import_file_name'           => 'Finance Multipage O1',
            'categories' => array( 'Finance' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/finance/finance.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/finance/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/finance/finance-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/02.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Home',      
        ),

        // Landing Page Demo Finance
        array(
            'import_file_name'           => 'Finance Landing O1',
            'categories' => array( 'Finance' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/finance/finance.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/finance/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/finance/finance-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/02.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Landing Page',      
        ),

        // Multipage Page Demo Insurance
        array(
            'import_file_name'           => 'Insurance Multipage O1',
            'categories' => array( 'Insurance' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/insurance/insurance.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/insurance/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/insurance/insurance-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/09.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Home',      
        ),

        // Landing Page Demo Insurance
        array(
            'import_file_name'           => 'Insurance Landing O1',
            'categories' => array( 'Insurance' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/insurance/insurance.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/insurance/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/insurance/insurance-kit.zip',
            'import_preview_image_url'   => 'https://html.themewant.com/landing/invena/assets/images/demos/09.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Landing Page',      
        ),

        // Multipage Page Demo Mangement
        array(
            'import_file_name'           => 'Business Management',
            'categories' => array( 'Management' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/management/management.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/management/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/management/management-kit.zip',
            'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/landing/invena/assets/images/demos/19.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Home',      
        ),

        // Landing Page Demo mangement
        array(
            'import_file_name'           => 'Business Management Landing',
            'categories' => array( 'Management' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/management/management.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/management/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/management/management-kit.zip',
            'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/landing/invena/assets/images/demos/19.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Landing Page',      
        ),

        // Multipage Page Demo Business Partner
        array(
            'import_file_name'           => 'Business Partner',
            'categories' => array( 'Business' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/partner/partner.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/partner/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/partner/partner-kit.zip',
            'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/landing/invena/assets/images/demos/20.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Home',      
        ),

        // Landing Page Demo Busines Partner
        array(
            'import_file_name'           => 'Business Partner Landing',
            'categories' => array( 'Business' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/partner/partner.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/partner/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/partner/partner-kit.zip',
            'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/landing/invena/assets/images/demos/20.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Landing',      
        ),

        // Multipage Page Demo Business Investment
        array(
            'import_file_name'           => 'Investment',
            'categories' => array( 'Business' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/investment/investment.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/investment/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/investment/investment-kit.zip',
            'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/landing/invena/assets/images/demos/21.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Home',      
        ),

        // Landing Page Demo Business Investment
        array(
            'import_file_name'           => 'Investment Landing',
            'categories' => array( 'Business' ), 
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/investment/investment.xml',
            'import_customizer_file_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/investment/invena-export.txt', 
            'import_elementor_url'       => trailingslashit( get_template_directory_uri() ) . 'inc/demo-data/investment/investment-kit.zip',
            'import_preview_image_url'   => 'https://reactheme.com/products/wordpress/landing/invena/assets/images/demos/21.webp',    
            'import_notice'              => esc_html__( 'Note: For making demo site just click "Import Demo Data" button. During demo data installation please do not refresh the page.', 'invena' ),  
            'default_home' => 'Landing',      
        ),
    );
}

add_filter( 'pt-ocdi/import_files', 'invena_import_files' );

function invena_after_import_setup($selected_import) {
    // Assign menus to their locations.
    $main_menu     = get_term_by( 'name', 'Primary Menu', 'nav_menu' );  
    set_theme_mod( 'nav_menu_locations', array(
    'menu-1' => $main_menu->term_id,          
    )
    );
    $homepage_title = $selected_import ['default_home'];
    $front_page_id = get_page_by_title( $homepage_title );
    $blog_page_id  = get_page_by_title( 'Blog' );

    // Import Elementor kit data.
    if ( ! empty( $selected_import['import_elementor_url'] ) && class_exists( '\Elementor\Plugin' ) ) {
        $kit_path = str_replace( trailingslashit( get_template_directory_uri() ), trailingslashit( get_template_directory() ), $selected_import['import_elementor_url'] );

        if ( file_exists( $kit_path ) ) {
            $import_export_module        = \Elementor\Plugin::$instance->app->get_component( 'import-export' );
            $import_settings['referrer'] = 'remote';
            $import_export_module->import_kit( $kit_path, $import_settings );
        }
    }

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );  

    if (class_exists('RevSlider')) {
        $slider_paths = array(
            get_template_directory() . '/inc/demo-data/slider/business-agency.zip',
            get_template_directory() . '/inc/demo-data/slider/business-four.zip',
            get_template_directory() . '/inc/demo-data/slider/Business-One.zip',
        );
        $slider = new RevSlider();
        foreach ($slider_paths as $path) {
            if (file_exists($path)) {
                $slider->importSliderFromPost(true, true, $path);
            }
        }
    }

}
add_action( 'pt-ocdi/after_import', 'invena_after_import_setup' );

//added elementor support for custom post type
function invena_enable_elementor_for_custom_post_type() {
  add_post_type_support( 'rt-portfolios', 'elementor' );
}
add_action( 'init', 'invena_enable_elementor_for_custom_post_type' );

function invena_theme_support() {
  remove_theme_support( 'widgets-block-editor' );
}
add_action( 'after_setup_theme', 'invena_theme_support' );

// blog single social share options 
function invena_social_share_buttons() {
  global $post;  
  // Check if we are in a single post view
   if ( is_singular('post') ) {
      // Get the current post URL
      $post_url = get_permalink($post);        
      // Generate social share links for facebook, Instagram, and Twitter other social
      $twitter_share_link = 'https://twitter.com/share?url=' . urlencode($post_url) . '&text=' . urlencode(get_the_title($post));
      $facebook_share_link = 'https://www.facebook.com/sharer.php?u=' . urlencode($post_url);
      $instagram_share_link = 'https://www.instagram.com/share.php?u=' . urlencode($post_url);
      $linkedin_share_link = 'https://linkedin.com/m?u=' . urlencode($post_url);
      $behance_share_link = 'https://behance.com/m?u=' . urlencode($post_url);
      
      // Build the social share buttons
      $social_share_buttons = '          
              <?php
              if( !empty( $facebook_share_link ) ) : ?>
                <a href="' . esc_url( $facebook_share_link ) . '" target="_blank" rel="nofollow"><i class="rt-facebook-f"></i></a>
                <?php
              endif; 
              if( !empty( $twitter_share_link ) ) : ?>
                <a href="' . esc_url( $twitter_share_link ) . '" target="_blank" rel="nofollow"><i class="rt-twitter"></i></a>
                <?php
              endif; 

              if( !empty( $instagram_share_link ) ) : ?>
                <a href="' . esc_url( $instagram_share_link ) . '" target="_blank" rel="nofollow"><i class="rt-instagram"></i></a>
                <?php
              endif; 

              if( !empty( $linkedin_share_link ) ) : ?>
                <a href="' . esc_url( $linkedin_share_link ) . '" target="_blank" rel="nofollow"><i class="rt-linkedin-in"></i></a>
                <?php 
              endif; ?>
          
      ';      
      // Output the social share buttons
      echo wp_kses_post( $social_share_buttons );
   }
}