<?php
/**
 * invena customizer
 *
 * @package invena
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Added Panels & Sections
 */
function invena_customizer_panels_sections( $wp_customize ) {
    //Add panel
    $wp_customize->add_panel( 'invena_customizer', [
        'priority' => 40,
        'title'    => esc_html__( 'Invena Theme Options', 'invena' ),
    ] );

    /**
     * Customizer Section
     */
    $wp_customize->add_section( 'header_top_setting', [
        'title'       => esc_html__( 'Invena Info Settings', 'invena' ),
        'description' => '',
        'priority'    => 10,
        'capability'  => 'edit_theme_options',
        'panel'       => 'invena_customizer',
    ] );

    $wp_customize->add_section( 'invena_blog_option', [
        'title'       => esc_html__( 'Blog Settings', 'invena' ),
        'description' => 'If you want to change your blog & single blog option, change here!',
        'priority'    => 11,
        'capability'  => 'edit_theme_options',
        'panel'       => 'invena_customizer',
    ] );


    $wp_customize->add_section('invena_blog_single', [
        'title' => __('Blog Single Settings', 'invena'),
        'description' => 'If you want to change your single blog options, change from here.',
        'priority' => 12,
        'capability' => 'edit_theme_options',
        'panel' => 'invena_customizer',
    ]);

    $wp_customize->add_section ( 'invena_change_taxonomy', [
        'title'       => esc_html__( 'Portfolio Settings', 'invena' ),
        'description' => 'If you want to change the portfolio slug or adjust other settings.',
        'priority'    => 13,
        'capability'  => 'edit_theme_options',
        'panel'       => 'invena_customizer',
    ] );

    $wp_customize->add_section( '404_page', [
        'title'       => esc_html__( '404 Page', 'invena' ),
        'description' => '',
        'priority'    => 14,
        'capability'  => 'edit_theme_options',
        'panel'       => 'invena_customizer',
    ] );
}

add_action( 'customize_register', 'invena_customizer_panels_sections' );

function _header_top_fields( $fields ) {
    
    $default_kit_id = get_option('elementor_active_kit');
    $edit_link = admin_url('post.php?post=' . $default_kit_id . '&action=elementor');

    $fields[] = [
        'type'        => 'custom',
        'settings'    => 'e_global_color_font_change',
        'label'       => esc_html__( 'Global Color & Font Changes', 'invena' ),
        'description' => wp_kses_post( sprintf(
            __( 'If you want to change global colors, fonts and other options just <a class="rt-e-kit-btn" href="%s" target="_blank">Click Here</a>', 'invena' ),
            esc_url($edit_link)
        ) ),
        'section'     => 'header_top_setting',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'invena_preloader',
        'label'    => esc_html__( 'Preloader On/Off', 'invena' ),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'invena' ),
            'off' => esc_html__( 'Disable', 'invena' ),
        ],
    ];

     $fields[] = [
        'type'        => 'select',
        'settings'    => 'preloader_type',
        'label'       => esc_html__( 'Select Type', 'invena' ),
        'section'     => 'header_top_setting',
        'placeholder' => esc_html__( 'Choose an option', 'invena' ),
        'default'     => 'animate',
		'choices'     => [
			'animate' => esc_html__( 'Animation', 'invena' ),
			'image' => esc_html__( 'Image', 'invena' ),
		],
        'active_callback' => [
            [
                'setting'  => 'invena_preloader',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'invena_preloader_color',
        'label'    => esc_html__( 'Preloader Background Color', 'invena' ),
        'section'  => 'header_top_setting',
        'default'  => 'transparent',
        'priority' => 10,
        'choices'  => [
            'alpha' => true,
        ],
        'output'   => [
            [
                'element'  => '#de-loader',
                'property' => 'background',
            ],
        ],
        'active_callback' => [
            [
                'setting'  => 'invena_preloader',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];
    
    $fields[] = [
        'type'     => 'color',
        'settings' => 'invena_preloader_dot_color',
        'label'    => esc_html__( 'Preloader Dot Color', 'invena' ),
        'section'  => 'header_top_setting',
        'default'  => '#d1d1d1',
        'priority' => 10,
        'choices'  => [
            'alpha' => true,
        ],
        'output' =>
        [
            [
            'element' => '.lds-roller div:after',
            'property' => 'background',
            ],
        ],
        'active_callback' => [
            [
                'setting'  => 'preloader_type',
                'operator' => '===',
                'value'    => 'animate',
            ],
            [
                'setting'  => 'invena_preloader',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'image',
        'settings'    => 'invena_preloader_img',
        'label'       => esc_html__( 'Image', 'invena' ),
        'description' => esc_html__( 'Upload your preloader image here.', 'invena' ),
        'section'     => 'header_top_setting',
        'active_callback' => [
            [
                'setting'  => 'preloader_type',
                'operator' => '===',
                'value'    => 'image',
            ],            
            [
                'setting'  => 'invena_preloader',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'slider',
        'settings' => 'invena_preloader_img_width',
        'label'    => esc_html__( 'Image Size (px)', 'invena' ),
        'section'  => 'header_top_setting',
        'default'  => 300,
        'choices'  => [
            'min'  => 10,
            'max'  => 1000,
            'step' => 1,
        ],
        'output' => [
            [
                'element'  => '.preloader-image img', 
                'property' => 'max-width',
                'units'    => 'px',
            ],
        ],
        'active_callback' => [
            [
                'setting'  => 'preloader_type',
                'operator' => '===',
                'value'    => 'image',
            ],            
            [
                'setting'  => 'invena_preloader',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'invena_backtotop',
        'label'    => esc_html__( 'Back To Top On/Off', 'invena' ),
        'section'  => 'header_top_setting',
        'default'  => '0',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'invena' ),
            'off' => esc_html__( 'Disable', 'invena' ),
        ],
    ];

    $fields[] = [
        'type'     => 'color',
        'settings' => 'invena_backtop_icon_color',
        'label'    => esc_html__( 'Icon Color', 'invena' ),
        'section'  => 'header_top_setting',
        'priority' => 10,
        'choices'  => [
            'alpha' => true,
        ],
        'output' =>
        [
            [
            'element' => '#top-to-bottom',
            'property' => 'color',
            ],
        ],
        'active_callback' => [
            [
                'setting'  => 'invena_backtotop',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];
    $fields[] = [
        'type'     => 'color',
        'settings' => 'invena_backtop_bgcolor',
        'label'    => esc_html__( 'Background Color', 'invena' ),
        'section'  => 'header_top_setting',
        'priority' => 10,
        'choices'  => [
            'alpha' => true,
        ],
        'output' =>
        [
            [
            'element' => '#top-to-bottom',
            'property' => 'background',
            ],
        ],
        'active_callback' => [
            [
                'setting'  => 'invena_backtotop',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    return $fields;

}
add_filter( 'kirki/fields', '_header_top_fields' );


// blog fields
function invena_blog_page_fields( $fields ) {
    $fields[] = [
        'type'        => 'select',
        'settings'    => 'blog_layout',
        'label'       => esc_html__( 'Blog Layout.', 'invena' ),
        'section'     => 'invena_blog_option',
        'placeholder' => esc_html__( 'Choose an option', 'invena' ),
        'default'     => 'full',
		'choices'     => [
			'full' => esc_html__( 'Full Layout', 'invena' ),
			'2left' => esc_html__( 'Left Sidebar', 'invena' ),
			'2right' => esc_html__( 'Right Sidebar', 'invena' ),
		],
    ];
    
    $fields[] = [
        'type'        => 'select',
        'settings'    => 'blog_grid',
        'label'       => esc_html__( 'Blog Grid Column.', 'invena' ),
        'section'     => 'invena_blog_option',
        'placeholder' => esc_html__( 'Choose an option', 'invena' ),
        'default'     => '12',
		'choices'     => [
			'12' => esc_html__( '1 Column', 'invena' ),
			'6' => esc_html__( '2 Column', 'invena' ),
			'4' => esc_html__( '3 Column', 'invena' ),
			'3' => esc_html__( '4 Column', 'invena' ),
			'2' => esc_html__( '6 Column', 'invena' ),
		],
    ];
    $fields[] = [
        'type'        => 'select',
        'settings'    => 'blog_author_post',
        'label'       => esc_html__( 'Author Name Show / Hide.', 'invena' ),
        'section'     => 'invena_blog_option',
        'placeholder' => esc_html__( 'Choose an option', 'invena' ),
        'default'     => 'show',
		'choices'     => [
			'show' => esc_html__( 'Show', 'invena' ),
			'hide' => esc_html__( 'Hide', 'invena' ),
		],
    ];
    $fields[] = [
        'type'        => 'select',
        'settings'    => 'blog_date',
        'label'       => esc_html__( 'Date Show / Hide.', 'invena' ),
        'section'     => 'invena_blog_option',
        'placeholder' => esc_html__( 'Choose an option', 'invena' ),
        'default'     => 'show',
		'choices'     => [
			'show' => esc_html__( 'Show', 'invena' ),
			'hide' => esc_html__( 'Hide', 'invena' ),
		],
    ];
    $fields[] = [
        'type'        => 'select',
        'settings'    => 'blog_category',
        'label'       => esc_html__( 'Category Show / Hide.', 'invena' ),
        'section'     => 'invena_blog_option',
        'placeholder' => esc_html__( 'Choose an option', 'invena' ),
        'default'     => 'show',
		'choices'     => [
			'show' => esc_html__( 'Show', 'invena' ),
			'hide' => esc_html__( 'Hide', 'invena' ),
		],
    ];
    $fields[] = [
        'type'        => 'text',
        'settings'    => 'read_more_text',
        'label'       => esc_html__( 'Read More Text', 'invena' ),
        'section'     => 'invena_blog_option',
        'default'  => esc_html__( 'Read More', 'invena' ),
    ];
    return $fields;
}
add_filter( 'kirki/fields', 'invena_blog_page_fields' );

// single options
function invena_single_options($fields){
    $fields[] = [
        'type' => 'select',
        'settings' => 'single_layout',
        'label' => __('Post Layout', 'invena'),
        'section' => 'invena_blog_single',
        'placeholder' => __('Choose Option', 'invena'),
        'default' => 'full',
        'choices' => [
            'full' => esc_html__( 'Full Layout', 'invena' ),
            '2left' => esc_html__( 'Left Sidebar', 'invena' ),
            '2right' => esc_html__( 'Right Sidebar', 'invena' ),
        ],
    ];  
         
    $fields[] = [
        'type'        => 'select',
        'settings'    => 'single_blog_tags',
        'label'       => esc_html__( 'Tags Show / Hide.', 'invena' ),
        'section'     => 'invena_blog_single',
        'placeholder' => esc_html__( 'Choose an option', 'invena' ),
        'default'     => 'show',
		'choices'     => [
			'show' => esc_html__( 'Show', 'invena' ),
			'hide' => esc_html__( 'Hide', 'invena' ),
		],
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'single_blog_social_share',
        'label'       => esc_html__( 'Social Share Show / Hide.', 'invena' ),
        'section'     => 'invena_blog_single',
        'placeholder' => esc_html__( 'Choose an option', 'invena' ),
        'default'     => 'show',
		'choices'     => [
			'show' => esc_html__( 'Show', 'invena' ),
			'hide' => esc_html__( 'Hide', 'invena' ),
		],
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'single_blog_author_meta',
        'label'       => esc_html__( 'Author Biographical Info Show / Hide.', 'invena' ),
        'section'     => 'invena_blog_single',
        'placeholder' => esc_html__( 'Choose an option', 'invena' ),
        'default'     => 'show',
		'choices'     => [
			'show' => esc_html__( 'Show', 'invena' ),
			'hide' => esc_html__( 'Hide', 'invena' ),
		],
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'single_blog_comment',
        'label'       => esc_html__( 'Comments Form Show / Hide.', 'invena' ),
        'section'     => 'invena_blog_single',
        'placeholder' => esc_html__( 'Choose an option', 'invena' ),
        'default'     => 'show',
		'choices'     => [
			'show' => esc_html__( 'Show', 'invena' ),
			'hide' => esc_html__( 'Hide', 'invena' ),
		],
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'single_blog_pagination',
        'label'       => esc_html__( 'Pagination Show / Hide.', 'invena' ),
        'section'     => 'invena_blog_single',
        'placeholder' => esc_html__( 'Choose an option', 'invena' ),
        'default'     => 'show',
		'choices'     => [
			'show' => esc_html__( 'Show', 'invena' ),
			'hide' => esc_html__( 'Hide', 'invena' ),
		],  
    ];


    return $fields;
}
add_filter('kirki/fields', 'invena_single_options');


// change custom post type taxonomy fields
function invena_taxonomies_fields( $fields ) {
    $fields [] = [
        'type'     => 'text',
        'settings' => 'portfolio_slug',
        'label'    => esc_html__( 'Project Slug', 'invena' ),
        'section'  => 'invena_change_taxonomy',
        'default'  => 'rt-projects',
        'priority' => 10,
    ];

    $edit_link = admin_url( 'options-permalink.php' );
    $fields[] = [
        'type'        => 'custom',
        'settings'    => 'post_permalink_update',
        'description' => wp_kses_post( sprintf(
           __( 'To modify the <strong>Project Slug</strong>, please update it from the <a class="rt-e-kit-btn" href="%s" target="_blank">Permalink Settings</a> page.', 'invena' ),
            esc_url( $edit_link )
        ) ),
        'section'     => 'invena_change_taxonomy',
        'priority'    => 10,
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'invena_portfolio_single_pagination',
        'label'    => esc_html__( 'Pagination', 'invena' ),
        'section'  => 'invena_change_taxonomy',
        'default'  => 'on',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'invena' ),
            'off' => esc_html__( 'Disable', 'invena' ),
        ],
    ];

    $fields[] = [
        'type'     => 'switch',
        'settings' => 'invena_portfolio_related',
        'label'    => esc_html__( 'Related Posts', 'invena' ),
        'section'  => 'invena_change_taxonomy',
        'default'  => 'on',
        'priority' => 10,
        'choices'  => [
            'on'  => esc_html__( 'Enable', 'invena' ),
            'off' => esc_html__( 'Disable', 'invena' ),
        ],
    ];

    $fields[] = [
        'type'        => 'select',
        'settings'    => 'project_related_post_style',
        'label'       => esc_html__( 'Select Another Style', 'invena' ),
        'section'     => 'invena_change_taxonomy',
        'placeholder' => esc_html__( 'Choose an option', 'invena' ),
        'default'     => 'style1',
		'choices'     => [
			'style1' => esc_html__( 'Style 01', 'invena' ),
			'style2' => esc_html__( 'Style 02', 'invena' ),
			'style3' => esc_html__( 'Style 03', 'invena' )
		],
        'active_callback' => [
            [
                'setting'  => 'invena_portfolio_related',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'slider',
        'settings' => 'related_post_img_height',
        'label'    => esc_html__( 'Image Height (px)', 'invena' ),
        'section'  => 'invena_change_taxonomy',
        'default'  => 500,
        'choices'  => [
            'min'  => 10,
            'max'  => 1000,
            'step' => 1,
        ],
        'output'      => [
            [
                'element'  => [
                    '.portfolio-slider-one .thumbnail img',
                    '.portfolio-slider-two .thumbnail img',
                    '.portfolio-slider-three .thumbnail img',
                ],
                'property' => 'height',
                'units'    => 'px',
            ],
        ],
        'active_callback' => [
            [
                'setting'  => 'invena_portfolio_related',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'project_related_post_perview',
        'label'    => esc_html__( 'Slider Per View (Desktop)', 'invena' ),
        'section'  => 'invena_change_taxonomy',
        'default'  => esc_html__( '2', 'invena' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'invena_portfolio_related',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    $fields[] = [
        'type'     => 'text',
        'settings' => 'project_related_post_perview_tablet',
        'label'    => esc_html__( 'Slider Per View (Tablet)', 'invena' ),
        'section'  => 'invena_change_taxonomy',
        'default'  => esc_html__( '2', 'invena' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'invena_portfolio_related',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];
    
    $fields[] = [
        'type'     => 'text',
        'settings' => 'project_related_post_perview_mobile',
        'label'    => esc_html__( 'Slider Per View (Mobile)', 'invena' ),
        'section'  => 'invena_change_taxonomy',
        'default'  => esc_html__( '1', 'invena' ),
        'priority' => 10,
        'active_callback' => [
            [
                'setting'  => 'invena_portfolio_related',
                'operator' => '===',
                'value'    => true,
            ],
        ],
    ];

    return $fields;
}
add_filter( 'kirki/fields', 'invena_taxonomies_fields' );

// 404
function invena_404_fields( $fields ) {
    // 404 settings
    $fields[] = [
        'type'        => 'image',
        'settings'    => 'invena_404_bg',
        'label'       => esc_html__( '404 Image.', 'invena' ),
        'description' => esc_html__( '404 Image.', 'invena' ),
        'section'     => '404_page',
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'invena_error_title',
        'label'    => esc_html__( 'Not Found Title', 'invena' ),
        'section'  => '404_page',
        'default'  => esc_html__( '404', 'invena' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'textarea',
        'settings' => 'invena_error_desc',
        'label'    => esc_html__( '404 Description Text', 'invena' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Oops! The page you are looking for does not exist. It might have been moved or deleted', 'invena' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'text',
        'settings' => 'invena_error_link_text',
        'label'    => esc_html__( '404 Link Text', 'invena' ),
        'section'  => '404_page',
        'default'  => esc_html__( 'Back To Home', 'invena' ),
        'priority' => 10,
    ];
    $fields[] = [
        'type'     => 'color',
        'settings' => 'invena_error_color',
        'label'    => esc_html__( 'Title Color', 'invena' ),
        'section'  => '404_page',
        'priority' => 10,
        'choices'  => [
            'alpha' => true,
        ],
        'output' =>
        [
            [
            'element' => '.page-error .content-area h2 span',
            'property' => 'color',
            ],
        ],
    ];    
    $fields[] = [
        'type'     => 'color',
        'settings' => 'invena_error_btn_color',
        'label'    => esc_html__( 'Button Text Color', 'invena' ),
        'section'  => '404_page',
        'priority' => 10,
        'choices'  => [
            'alpha' => true,
        ],
        'output' =>
        [
            [
            'element' => '.page-error .reacbutton',
            'property' => 'color',
            ],
        ],
    ];
    $fields[] = [
        'type'     => 'color',
        'settings' => 'invena_error_btn_bgcolor',
        'label'    => esc_html__( 'Button Background Color', 'invena' ),
        'section'  => '404_page',
        'priority' => 10,
        'choices'  => [
            'alpha' => true,
        ],
        'output' =>
        [
            [
            'element' => '.page-error .reacbutton',
            'property' => 'background',
            ],
        ],
    ];
    return $fields;
}
add_filter( 'kirki/fields', 'invena_404_fields' );



/**
 * Added Fields
 */
function invena_typo_fields( $fields ) {
    // typography settings
    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_body_setting',
        'label'       => esc_html__( 'Body Font', 'invena' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'body',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h_setting',
        'label'       => esc_html__( 'Heading h1 Fonts', 'invena' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h1',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h2_setting',
        'label'       => esc_html__( 'Heading h2 Fonts', 'invena' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h2',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h3_setting',
        'label'       => esc_html__( 'Heading h3 Fonts', 'invena' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h3',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h4_setting',
        'label'       => esc_html__( 'Heading h4 Fonts', 'invena' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h4',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h5_setting',
        'label'       => esc_html__( 'Heading h5 Fonts', 'invena' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h5',
            ],
        ],
    ];

    $fields[] = [
        'type'        => 'typography',
        'settings'    => 'typography_h6_setting',
        'label'       => esc_html__( 'Heading h6 Fonts', 'invena' ),
        'section'     => 'typo_setting',
        'default'     => [
            'font-family'    => '',
            'variant'        => '',
            'font-size'      => '',
            'line-height'    => '',
            'letter-spacing' => '0',
            'color'          => '',
        ],
        'priority'    => 10,
        'transport'   => 'auto',
        'output'      => [
            [
                'element' => 'h6',
            ],
        ],
    ];
    return $fields;
}

add_filter( 'kirki/fields', 'invena_typo_fields' );

/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function invena_THEME_option( $name ) {
    $value = '';
    if ( class_exists( 'invena' ) ) {
        $value = Kirki::get_option( invena_get_theme(), $name );
    }

    return apply_filters( 'invena_THEME_option', $value, $name );
}

/**
 * Get config ID
 *
 * @return string
 */
function invena_get_theme() {
    return 'invena';
}