<?php

if ( ! function_exists( 'invena_setup' ) ) :
function invena_setup() {
	load_theme_textdomain( 'invena', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'responsive-embeds' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'customize-selective-refresh-widgets' );
	add_theme_support( 'align-wide' );

	register_nav_menus( array(
		'menu-1' => esc_html__( 'Primary Menu', 'invena' ),
	) );

	// Enable Elementor for custom post types
	add_action('init', function() {
		$post_types = [ 'rts-canvans', 'rt-portfolios', 'teams' ];
		foreach ( $post_types as $post_type ) {
			add_post_type_support( $post_type, 'elementor' );
		}
	});
}
endif;
add_action( 'after_setup_theme', 'invena_setup' );

// Custom image size
add_image_size( 'invena-blog-sideabr', 87, 87, true );

// Content width
function invena_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'invena_content_width', 640 );
}
add_action( 'after_setup_theme', 'invena_content_width', 0 );

// Required files
require_once get_template_directory() . '/inc/template-tags.php';
require_once get_template_directory() . '/inc/theme-scripts.php';
require_once get_template_directory() . '/inc/theme-functions.php';
require_once get_template_directory() . '/inc/theme-sidebar.php';

/**
 * Kirki Customizer additions.
 */
if (class_exists( 'Kirki' ) ) {
	require_once get_template_directory() . '/inc/kirki_customizer.php';
}

/**
 * TGM Plugin Activation.
 */
if (is_admin()) {
	require_once get_template_directory() . '/inc/tgm/class-tgm-plugin-activation.php';
	require_once get_template_directory() . '/inc/tgm/tgm-config.php';	
	require_once get_template_directory() . '/inc/license.php';
}

// default gallery style
add_filter( 'use_default_gallery_style', '__return_false' );

// Editor style
function invena_theme_add_editor_styles() {
	add_editor_style( 'css/custom-editor-style.css' );
}
add_action( 'admin_init', 'invena_theme_add_editor_styles' );

// Optimize comment form field order
function invena_wpb_move_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}
add_filter( 'comment_form_fields', 'invena_wpb_move_comment_field_to_bottom' );

// Placeholder for comment textarea
function invena_comment_textarea_placeholder( $args ) {
	$args['comment_field'] = str_replace( '<textarea', '<textarea placeholder="Comment"', $args['comment_field'] );
	return $args;
}
add_filter( 'comment_form_defaults', 'invena_comment_textarea_placeholder' );

// Placeholder for comment fields
function invena_comment_form_fields( $fields ) {
	foreach( $fields as &$field ) {
		$field = str_replace( 'id="author"', 'id="author" placeholder="Name*"', $field );
		$field = str_replace( 'id="email"', 'id="email" placeholder="Email*"', $field );
		$field = str_replace( 'id="url"', 'id="url" placeholder="Website"', $field );
	}
	return $fields;
}
add_filter( 'comment_form_default_fields', 'invena_comment_form_fields' );

// Add menu description
function invena_menu_add_description_to_menu($item_output, $item, $depth, $args) {
	if (strlen($item->description) > 0 ) {
		$item_output .= sprintf('<span class="description">%s</span>', esc_html($item->description));
	}
	return $item_output;
}
add_filter('walker_nav_menu_start_el', 'invena_menu_add_description_to_menu', 10, 4);

// Optional: Disable emoji support
remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );


// Optional: Remove dashicons for non-logged-in users
function invena_dequeue_dashicons() {
	if ( ! is_user_logged_in() ) {
		wp_dequeue_style( 'dashicons' );
	}
}
add_action( 'wp_enqueue_scripts', 'invena_dequeue_dashicons' );

function mytheme_get_elementor_templates() {
    $templates = get_posts(array(
        'post_type'      => 'elementor_library',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
    ));

    $options = array( '' => 'Select a Template' );

    if ( $templates ) {
        foreach ( $templates as $template ) {
            $options[ $template->ID ] = $template->post_title;
        }
    }

    return $options;
}

// category widgets span include 
function invena_cat_count_span($links) {
  $links = str_replace('</a> (', '</a> <span>(', $links);
  $links = str_replace(')', ')</span>', $links);
  return $links;
}
add_filter( 'wp_list_categories', 'invena_cat_count_span' );

// archive widgets span include 
function invena_archive_count($links) {
    $links = str_replace('</a>&nbsp;(', '</a> <span class="archiveCount">(', $links);
    $links = str_replace(')', ')</span>', $links);
    return $links;
}
add_filter( 'get_archives_link', 'invena_archive_count' );

/**
 * woocommerce file exists
 */
require_once get_template_directory() . '/inc/woocommerce-functions.php';

