(function($) {
    "use strict";
    
   document.addEventListener('DOMContentLoaded', function() {
        var links = document.getElementsByTagName('link');
        for (var i = 0; i < links.length; i++) {
            var link = links[i];
            if (link.href && link.href.includes('elementor/assets/lib/animations/animations.min.css')) {
                // Remove Elementor's animations.min.css
                link.parentNode.removeChild(link)
                ;
                break; // Exit the loop after removing the stylesheet
            }
        }
    });

    $('#de-loader ').prepend($('<div class="lds-roller"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>'));
    
    $(document).ready(function(){
         $(".menu-button, .close-button").on('click', function() {
             event.preventDefault();
             $(".nav-toggle, .menu-ofcn, .close-button, body").toggleClass("off-open");
         }); 
         
         $( "ul.children" ).addClass( "sub-menu" );
    });

    if ($('.menu-area').length) {
        document.addEventListener("DOMContentLoaded", function () {
            const menuItems = document.querySelectorAll('.menu-item-has-children > a');
            menuItems.forEach(item => {
                item.addEventListener('click', function (e) {
                    e.preventDefault();
                    const subMenu = this.nextElementSibling;

                    if (subMenu && subMenu.classList.contains('sub-menu')) {
                        if (subMenu.style.maxHeight) {
                          subMenu.style.maxHeight = null;
                          subMenu.style.opacity = '0';
                          this.classList.remove('rt-open');
                          subMenu.classList.remove('sub-open');
                        } else {
                          subMenu.style.maxHeight = subMenu.scrollHeight + 'px';
                          subMenu.style.opacity = '1';
                          this.classList.add('rt-open');
                          subMenu.classList.add('sub-open');
                        }
                    }
                });
            });
        });
    }


    var win=$(window);
    var totop = $('#top-to-bottom');    
    win.on('scroll', function() {
        if (win.scrollTop() > 150) {
            totop.fadeIn();
            $('.rts_header__switch').addClass('btt__enable');
            $('#top-to-bottom').addClass('scroll_visible');  
        } else {
            totop.slideDown(400);
            $('.rts_header__switch').removeClass('btt__enable');
            $('#top-to-bottom').removeClass('scroll_visible');
            
        }
    });
    totop.on('click', function() {
        $("html,body").animate({
            scrollTop: 0
        }, 500)
    }); 

    $(window).on('load', function() {
        $('#de-loader').fadeOut();
    });

    
    function initBackPostSlider($scope) {
        var $slider = $scope.find('.rt-all-slider');
        if (!$slider.length) {
            return;
        }
        var loop = $slider.data('loop') === true || $slider.data('loop') === 'true';
        var autoplay = $slider.data('autoplay') === true || $slider.data('autoplay') === 'true';
        var autoplayDelay = parseInt($slider.data('autoplay-delay'), 10) || 3000;
        var slidesPerView = parseInt($slider.data('slides-per-view'), 10) || 3;
        var speed = parseInt($slider.data('speed'), 10) || 600;
        var centeredSlides = $slider.data('centered-slides') === true || $slider.data('centered-slides') === 'true';
        var freeMode = $slider.data('free-mode') === true || $slider.data('free-mode') === 'true';
        var spaceBetween = parseInt($slider.data('space-between'), 10) || 0;
        var slidesPerViewTablet = parseInt($slider.data('slides-per-view-tablet'), 10) || 2;
        var slidesPerViewMobile = parseInt($slider.data('slides-per-view-mobile'), 10) || 1;
        var paginationType = $slider.data('pagination') !== 'none' ? $slider.data('pagination') : false;
        var navigation = $slider.data('navigation') === true || $slider.data('navigation') === 'true';
        var mousewheel = $slider.data('mousewheel') === true || $slider.data('mousewheel') === 'true';
        var effect = $slider.data('effect') || 'slide';

        var thumbsEnabled = $slider.data('thumbnail-pagination') === true || $slider.data('thumbnail-pagination') === 'true';
        var $thumbs = $scope.find('.rt-thumb-slider');
        var thumbSlidesPerView = parseInt($slider.data('thumb-slides-per-view'), 10) || 'auto';
        var thumbSlidesPerViewMobile = parseInt($slider.data('thumb-slides-per-view-mobile'), 10) || 'auto';
        var thumbsSwiper;
        if (thumbsEnabled && $thumbs.length) {
            thumbsSwiper = new Swiper($thumbs[0], {
                slidesPerView: thumbSlidesPerView,
                spaceBetween: spaceBetween,
                centeredSlides: true,
                loop: loop,
                slideToClickedSlide: false,
                 breakpoints: {
                    0: {
                        slidesPerView: thumbSlidesPerViewMobile,
                    },
                    1024: {
                        slidesPerView: thumbSlidesPerView,
                    }
                },
            });
        }

        new Swiper($slider[0], {
            loop: loop,
            speed: speed,
            simulateTouch: true,
            touchRatio: 1,
            grabCursor: true,
            autoplay: autoplay ? {
                delay: autoplayDelay,
                disableOnInteraction: false,
            } : false,
            slidesPerView: slidesPerView,
            spaceBetween: spaceBetween,
            centeredSlides: centeredSlides,
            freeMode: freeMode,
            mousewheel: mousewheel ? { enabled: true } : false,
            effect: effect,     
            fadeEffect: effect === 'fade' ? { crossFade: true } : undefined,       
            pagination: paginationType ? {
                el: '#' + $slider.attr('id') + ' .swiper-pagination',
                clickable: true,
                type: paginationType,
            } : false,
            navigation: navigation ? {
                nextEl: '#' + $slider.attr('id') + ' .swiper-next',
                prevEl: '#' + $slider.attr('id') + ' .swiper-prev',
            } : false,
            thumbs: thumbsEnabled && thumbsSwiper ? { swiper: thumbsSwiper } : undefined,
            breakpoints: {
                0: {
                    slidesPerView: slidesPerViewMobile,
                },
                768: {
                    slidesPerView: slidesPerViewTablet,
                },
                1024: {
                    slidesPerView: slidesPerView,
                },
            },
        });
    }
    jQuery(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/global', initBackPostSlider);
    });

    // Canvas Menu Js
    $( ".nav-link-container > a" ).off("click").on("click", function(event){
        event.preventDefault();
        $(".nav-link-container").toggleClass("nav-inactive-menu-link-container");
        $(".mobile-menus").toggleClass("nav-active-menu-container");
    });    
    
    $(".nav-close-menu-li > a").on('click', function(event){
        $(".mobile-menus").toggleClass("nav-active-menu-container");
        $(".content").toggleClass("inactive-body");
    });
    
    // portfolio related post slider 
   $(document).ready(function($){
        var $relatedPostSlider = $('.rt-portfolio-related-post');

        if ($relatedPostSlider.length === 0) return;
        var slideCount = $relatedPostSlider.find('.swiper-slide').length;

        var relatedSlidesPerView       = Math.min(parseInt($relatedPostSlider.data('slides-per-view'), 10) || 3, slideCount);
        var relatedSlidesPerViewTablet = Math.min(parseInt($relatedPostSlider.data('slides-per-view-tablet'), 10) || 2, slideCount);
        var relatedSlidesPerViewMobile = Math.min(parseInt($relatedPostSlider.data('slides-per-view-mobile'), 10) || 1, slideCount);

        new Swiper($relatedPostSlider[0], {
            slidesPerView: relatedSlidesPerView,
            spaceBetween: 24,
            loop: slideCount > relatedSlidesPerView,
            speed: 1000,
            navigation: {
                nextEl: $relatedPostSlider.find(".swiper-next")[0],
                prevEl: $relatedPostSlider.find(".swiper-prev")[0],
            },
            breakpoints: {
                0: {
                    slidesPerView: relatedSlidesPerViewMobile,
                },
                768: {
                    slidesPerView: relatedSlidesPerViewTablet,
                },
                1024: {
                    slidesPerView: relatedSlidesPerView,
                },
            },
        });
    });
  
})(jQuery);