<?php
/**
 * The Template for displaying 404 pages (not found).
 *
 * @package invena
 * @since 1.0
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 */

wp_head();

// Fetch customizer settings or fallback to defaults
$invena_error_bg = get_theme_mod('invena_404_bg', '');
$invena_error_title = get_theme_mod('invena_error_title', __('404', 'invena'));
$invena_error_text = get_theme_mod('invena_error_desc', __('Oops! Nothing Was Found', 'invena'));
$invena_back_home = get_theme_mod('invena_error_link_text', __('Return to Homepage', 'invena'));
?>

<div class="page-error">
    <div id="primary" class="content-area">
        <main id="main" class="site-main">
            <div class="container">
                <section class="error-404 not-found">
                    <div class="page-content">                        
                        <?php if (!empty($invena_error_bg)) { ?>
                            <img src="<?php echo esc_url($invena_error_bg); ?>" alt="<?php esc_attr_e('Error 404', 'invena'); ?>">
                        <?php } else { ?>
                            <h2>
                                <span>
                                    <?php 
                                       echo esc_html($invena_error_title);
                                    ?>
                                </span>                           
                            </h2>                 
                        <?php } ?>

                        <?php if (!empty($invena_error_text)) { ?>
                            <p class="error-msg">
                                <?php echo esc_html($invena_error_text); ?>
                            </p>
                        <?php } ?>

                        <?php if (!empty($invena_back_home)) { ?> 
                            
                        <?php } ?>


                        <a class="reacbutton" href="<?php echo esc_url(home_url('/')); ?>">
                            <?php
                            if (!empty($invena_back_home)) {
                                echo esc_html($invena_back_home);
                            } else {
                                esc_html_e('Return to Homepage', 'invena');
                            }
                            ?>
                        </a>
                    </div><!-- .page-content -->
                </section><!-- .error-404 -->
            </div>
        </main><!-- #main -->
    </div><!-- #primary -->
</div> <!-- .page-error -->

<?php
wp_footer();
?>
