<?php
/**
 * Plugin Name: RT Mega Menu
 * Description: Elementor Page Builder supported mega menu builder. You make any type of mega menu by using this plugin.
 * Plugin URI:  https://rtmega.themewant.com/
 * Author:      Themewant
 * Author URI:  http://themewant.com/
 * Version:     1.3.9
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: rt-mega-menu
 * Domain Path: /languages
 * Requires Plugins: elementor
*/
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


    define( 'RTMEGA_MENU_VERSION', '1.3.9' );
    define( 'RTMEGA_MENU_PL_ROOT', __FILE__ );
    define( 'RTMEGA_MENU_PL_URL', plugins_url( '/', RTMEGA_MENU_PL_ROOT ) );
    define( 'RTMEGA_MENU_PL_PATH', plugin_dir_path( RTMEGA_MENU_PL_ROOT ) );
    define( 'RTMEGA_MENU_DIR_URL', plugin_dir_url( RTMEGA_MENU_PL_ROOT ) );
    define( 'RTMEGA_MENU_PLUGIN_BASE', plugin_basename( RTMEGA_MENU_PL_ROOT ) );
    define( 'RTMEGA_MENU_NAME', 'RTMEGA Menu' );

    include 'admin/includes/admin-settings.php';
    include 'admin/includes/menu-metabox.php';
    include 'admin/includes/plugin-scripts.php';
    include 'admin/includes/admin-ajax-request.php';

    include 'public/includes/plugin-scripts.php';
    include 'public/includes/rtmega-nav-walker.php';
    include 'public/includes/rt-mega-menu-terms.php';
    include 'public/includes/rtmega-dynamic-css.php';
    include 'admin/includes/template-library.php';
    include 'admin/includes/notice.php';
    include 'class.rtmega-menu.php';
    
    RTMEGA_MENU::instance();
   
    
    add_action( 'plugins_loaded', 'rtmega_appsero_init_tracker' );

    function rtmega_appsero_init_tracker() {

        if ( ! class_exists( 'Appsero\Client' ) ) {
        require_once __DIR__ . '/apps/Client.php';
        }

        $client = new Appsero\Client( '1e51d718-e4b3-4fb7-bc97-7845f1f2d007', 'RT Mega Menu', __FILE__ );

        // Active insights
        $client->insights()->init();

    }












