<?php
/**
 * Logo widget class
 *
 */
use Elementor\Group_Control_Css_Filter;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

defined( 'ABSPATH' ) || die();

class back_pro_timeline_Showcase_Widget extends \Elementor\Widget_Base {
    /**
     * Get widget name.
     *
     * Retrieve logo widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */

    public function get_name() {
        return 'rtelements-timeline';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */

    public function get_title() {
        return esc_html__( 'RT Timeline', 'rtelements' );
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-gallery-grid';
    }


    public function get_categories() {
        return [ 'rtelementsthemecore_category' ];
    }

    public function get_keywords() {
        return [ 'timeline', 'time', 'company', 'history'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            '_section_logo',
            [
                'label' => esc_html__( 'Timeline Item', 'rtelements' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );


        $repeater = new Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'rtelements'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-circle',
					'library' => 'fa-solid',
				],
			]
		);
        $repeater->add_control(
            'title',
            [
                'label'       => esc_html__( 'Title', 'rtelements' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => 'Title',
            ]
        );
        $repeater->add_control(
            'time',
            [
                'label'       => esc_html__( 'Time', 'rtelements' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => 'Title',
            ]
        );
        $repeater->add_control(
            'text',
            [
                'label'       => esc_html__( 'Text', 'rtelements' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => 'Text',
            ]
        );
        $this->add_control(
			'items_list',
			[
				'label' => esc_html__( 'Repeater List', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
                        'icon' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
						'title' => esc_html__( 'THE FIRST STEPS', 'rtelements' ),
						'time' => esc_html__( '1999-2002', 'rtelements' ),
						'text' => esc_html__( 'Our Lord which in which I was born in the city of Oakland which lies in the state of California.

', 'rtelements' ),
					],
					[
                        'icon' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
						'title' => esc_html__( 'THE SECOND STEPS', 'rtelements' ),
						'time' => esc_html__( '1999-2002', 'rtelements' ),
						'text' => esc_html__( 'Our Lord which in which I was born in the city of Oakland which lies in the state of California.

', 'rtelements' ),
					],
				],
				'title_field' => '{{{ title }}}',
			]
		); 
        $this->add_control(
			'title_tag',
			[
				'label'   => esc_html__('Select Heading Tag', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h2',
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('span', 'rtelements'),

				],
			]
		);
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'large',
                'separator' => 'before',
                'exclude' => [
                    'custom'
                ]
            ]
        );  
        $this->add_responsive_control(
			'img_text_mid_gap',
			[
				'label' => esc_html__( 'Middle Gap', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rtelements-timeline .timeline-box-inner' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'img_right_gap',
			[
				'label' => esc_html__( 'Image Right Spacing', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rtelements-timeline .timeline-box-inner .left-content' => 'padding-right: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'img_area_width',
			[
				'label' => esc_html__( 'Image Box Width', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rtelements-timeline .timeline-box-inner .left-content' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Content', 'rtelements' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        
        $this->add_control(
			'divide_color',
			[
				 'label' => esc_html__('Divider Color', 'rtelements'),
				 'type' => \Elementor\Controls_Manager::COLOR,
				 'selectors' => [
                    '{{WRAPPER}} .rts-timeline .timeline ul li' => 'background: {{VALUE}};',           
                    '{{WRAPPER}} .rts-timeline .timeline ul li div::before' => 'border-color: {{VALUE}};',           
				],
			]
	    );
        $this->add_control(
			'title_color',
			[
				 'label' => esc_html__('Title Color', 'rtelements'),
				 'type' => \Elementor\Controls_Manager::COLOR,
				 'selectors' => [
					'{{WRAPPER}} .timeline .title' => 'color: {{VALUE}};',
				 ],
                 'separator' => 'before'
			]
	    );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                 'name' => 'title_typography',
                 'label' => esc_html__('Typography', 'rtelements'),
                 'selector' => '{{WRAPPER}} .timeline .title',
            ]
        );
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Margin', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .timeline .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'time_styles',
			[
				 'label' => esc_html__('Time', 'rtelements'),
				 'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
	    );
        $this->add_control(
			'time_color',
			[
				 'label' => esc_html__('Color', 'rtelements'),
				 'type' => \Elementor\Controls_Manager::COLOR,
				 'selectors' => [
					  '{{WRAPPER}} .timeline .time' => 'color: {{VALUE}};',
				 ],
			]
	    );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                 'name' => 'time_typography',
                 'label' => esc_html__('Typography', 'rtelements'),
                 'selector' => '{{WRAPPER}} .timeline .time',
            ]
        );
        $this->add_responsive_control(
			'time_margin',
			[
				'label' => esc_html__( 'Margin', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .timeline .time' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'time_padding',
			[
				'label' => esc_html__( 'Padding', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .timeline .time' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'des_styles',
			[
				 'label' => esc_html__('Description', 'rtelements'),
				 'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
			]
	    );
        $this->add_control(
			'des_color',
			[
				 'label' => esc_html__('Color', 'rtelements'),
				 'type' => \Elementor\Controls_Manager::COLOR,
				 'selectors' => [
					  '{{WRAPPER}} .timeline .des' => 'color: {{VALUE}};',
				 ],
			]
	    );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                 'name' => 'des_typography',
                 'label' => esc_html__('Typography', 'rtelements'),
                 'selector' => '{{WRAPPER}} .timeline .des',
            ]
        );
        $this->add_responsive_control(
			'des_padding',
			[
				'label' => esc_html__( 'Padding', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .timeline .des' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'icon_styles',
			[
				'label' => esc_html__( 'Icon', 'rtelements' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);    
        $this->add_control(
			'icon_color',
			[
				 'label' => esc_html__('Color', 'rtelements'),
				 'type' => \Elementor\Controls_Manager::COLOR,
				 'selectors' => [
					'{{WRAPPER}}  .rts-timeline .timeline section i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rts-timeline .timeline section svg path' => 'fill: {{VALUE}};',
				 ],
                 'separator' => 'before'
			]
	    );    
        $this->add_control(
			'icon_border_color',
			[
				 'label' => esc_html__('Border Color', 'rtelements'),
				 'type' => \Elementor\Controls_Manager::COLOR,
				 'selectors' => [
					'{{WRAPPER}}  .rts-timeline .timeline section i' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .rts-timeline .timeline section svg' => 'border-color: {{VALUE}};',
				 ],
			]
	    );    
        $this->add_control(
			'icon_bgcolor',
			[
				 'label' => esc_html__('Background', 'rtelements'),
				 'type' => \Elementor\Controls_Manager::COLOR,
				 'selectors' => [
					'{{WRAPPER}} .rts-timeline .timeline section i' => 'background: {{VALUE}};',
					'{{WRAPPER}} .rts-timeline .timeline section svg' => 'background: {{VALUE}};',
				 ],
			]
	    ); 
        $this->add_control(
			'icon_width',
			[
				'label' => esc_html__( 'Size', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rts-timeline .timeline section i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rts-timeline .timeline section svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'icon_padding',
			[
				'label' => esc_html__( 'Padding', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}}  .rts-timeline .timeline section svg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}}  .rts-timeline .timeline section i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        if ( empty($settings['items_list'] ) ) {
            return;
        }
        ?>
            <div class="rts-timeline"> 
                <div class="timeline"> 
                    <ul>
                        <?php                                    
                            foreach ( $settings['items_list'] as $index => $item ) :                                     
                            $title   = !empty($item['title']) ? $item['title'] : '';                         
                            $time   = !empty($item['time']) ? $item['time'] : '';                         
                            $text   = !empty($item['text']) ? $item['text'] : '';             
                            $image = wp_get_attachment_image_url( $item['image']['id'], $settings['thumbnail_size'] );
                            $image_alt = ! empty( $item['image']['alt'] ) ? $item['image']['alt'] : '';
                            if ( ! $image ) {
                                $image = Utils::get_placeholder_image_src();
                            } 
                            ?>
                            <li class="item in-view">
                                <div>
                                    <section>
                                        <img class="thumb" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr($image_alt); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        <?php 
                                        if(!empty($time)) : ?>
                                            <span class="time"><?php echo esc_html($time);?></span>
                                            <?php 
                                        endif; ?>
                                        <<?php echo esc_attr($settings['title_tag']); ?> class="title"><?php echo esc_html($title);?></<?php echo esc_attr($settings['title_tag']); ?>>
                                        <?php 
                                        if(!empty($text)) : ?>
                                            <p class="des"><?php echo esc_html($text);?></p>
                                            <?php 
                                        endif; ?>
                                    </section>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        <?php

    }
}