<?php
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\register_controls;

defined('ABSPATH') || die();

class Reactheme_Elementor_Testimonial_Slider_Widget  extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'rt-testimonial-slider';
    }

	public function get_style_depends() {
		wp_register_style( 'testimonial-slider-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'testimonial-slider-style'
		];
	}

    public function get_title()
    {
        return esc_html__('RT Testimonial Slider', 'rtelements');
    }

    public function get_icon()
    {
        return 'rt-e-icon';
    }
    public function get_categories()
    {
        return ['pielements_category'];
    }
    public function get_keywords()
    {
        return ['slider'];
    }
    protected function register_controls() {

        $this->start_controls_section(
            '_section_logo',
            [
                'label' => esc_html__('Slider Item', 'rtelements'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );     
        
        $this->add_control(
            'rt_slider_style',
            [
                'label'   => esc_html__('Select Style', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [
                    'style1' => esc_html__('Style 1', 'rtelements'),
                    'style2' => esc_html__('Style 2', 'rtelements'),
                    'style3' => esc_html__('Style 3', 'rtelements'),
                    'style4' => esc_html__('Style 4', 'rtelements'),
                    'style5' => esc_html__('Style 5', 'rtelements'),
                    'style6' => esc_html__('Style 6', 'rtelements'),
                    'style7' => esc_html__('Style 7', 'rtelements'),
                    'style8' => esc_html__('Style 8', 'rtelements'),
                    'style9' => esc_html__('Style 9', 'rtelements')
                ],
            ]
        ); 

        $repeater = new Repeater();

        $repeater->add_control(
            'rt_slider_style',
            [
                'label'   => esc_html__('Select Style', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [
                    'style1' => esc_html__('Style 1', 'rtelements'),
                    'style2' => esc_html__('Style 2', 'rtelements'),
                    'style3' => esc_html__('Style 3', 'rtelements'),
                    'style4' => esc_html__('Style 4', 'rtelements'),
                    'style5' => esc_html__('Style 5', 'rtelements'),
                    'style6' => esc_html__('Style 6', 'rtelements'),
                    'style7' => esc_html__('Style 7', 'rtelements'),
                    'style8' => esc_html__('Style 8', 'rtelements'),
                    'style9' => esc_html__('Style 9', 'rtelements')
                ],
            ]
        );        
        $repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Client Image', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
            'name',
            [
                'label' => esc_html__('Name', 'rtelements'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Testimonial Name', 'rtelements'),
                'label_block' => true,
                'placeholder' => esc_html__('Name', 'rtelements'),
            ]
        );

        $repeater->add_control(
            'designation',
            [
                'label' => esc_html__('Designation', 'rtelements'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Designation', 'rtelements'),
                'label_block' => true,
                'placeholder' => esc_html__('designation', 'rtelements'),
            ]
        ); 

        $repeater->add_control(
            'des_title',
            [
                'label' => esc_html__('Title', 'rtelements'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Great Business Solution', 'rtelements'),
                'label_block' => true,
                'placeholder' => esc_html__('Insert you title here', 'rtelements'),                   
                'condition' => [      
                    'rt_slider_style' => 'style6'
                ]
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label' => esc_html__( 'Description', 'rtelements' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( "I can't recommend The Gourmet Haven enough. It a place for special occasions, date nights, or whenever you're in the mood for a culinary adventure. The combination of exceptional.", "rtelements" ),
                'label_block' => true,
                'placeholder' => esc_html__( 'Description', 'rtelements' ),
            ]
        ); 

        $repeater->add_control(
			'client_logo',
			[
				'label' => esc_html__( 'logo', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],     
                'condition' => [      
                    'rt_slider_style' => ['style2', 'style4', 'style5', 'style7', 'style8']
                ]
			]
		);

        $repeater->add_control(
            'client_link',
            [
                'label' => esc_html__('Link', 'rtelements'),
                'type' => Controls_Manager::URL,
                'default' => array (
                    'url' => '#'
                ),
                'placeholder' => esc_html__('Insert your link here.', 'rtelements'),    
                'condition' => [
                    'rt_slider_style' => ['style2', 'style5', 'style7']
                ]
            ]
        ); 

        $repeater->add_control(
            'rating_unmber',
            [
                'label'   => esc_html__('Select Rating', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => '5',
                'options' => [
                    '1' => esc_html__('1', 'rtelements'),
                    '2' => esc_html__('2', 'rtelements'),
                    '3' => esc_html__('3', 'rtelements'),
                    '4' => esc_html__('4', 'rtelements'),
                    '5' => esc_html__('5', 'rtelements'),
                ],    
                'condition' => [
                    'rt_slider_style' => ['style2', 'style5', 'style6']
                ] 
            ]
        ); 

        $this->add_control(
			'list',
			[
				'label' => esc_html__( 'Item List', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'name' => esc_html__( 'William Henry', 'rtelements' ),
						'designation' => esc_html__( 'Founder', 'rtelements' ),
						'description' => esc_html__( "I can't recommend The Gourmet Haven enough. It's a place for special occasions, date nights, or whenever you're in the mood for a culinary adventure. The combination of exceptional.", 'rtelements' ),
					],
				],
				'title_field' => '{{{ name }}}',
			]
		);     	

		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__('Title HTML Tag', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('span', 'rtelements'),
				],
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
           'slider___section__',
           [
               'label' => esc_html__( 'Slider Settings', 'rtelements' ),
               'tab' => Controls_Manager::TAB_CONTENT,
           ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__( 'Loop', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'rtelements' ),
                'label_off' => esc_html__( 'No', 'rtelements' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
        'autoplay',
        [
           'label' => esc_html__('Autoplay', 'rtelements'),
           'type' => \Elementor\Controls_Manager::SWITCHER,
           'label_on' => esc_html__('On', 'rtelements'),
           'label_off' => esc_html__('Off', 'rtelements'),
           'return_value' => 'yes',
           'default' => '',
        ]
        );

        $this->add_control(
          'autoplay_delay',
          [
              'label' => esc_html__('Autoplay Delay (ms)', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'default' => 3000,
          ]
        );

        // Speed
        $this->add_control(
            'speed',
            [
                'label' => esc_html__('Speed (ms)', 'rtelements'),
                'type' => Controls_Manager::NUMBER,
                'default' => 900,
            ]
        );

        $this->add_control(
            'centered_slides',
            [
                'label' => esc_html__('Centered Slides', 'rtelements'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
                'label_off' => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        $this->add_control(
            'free_mode',
            [
                'label' => esc_html__('Free Mode', 'rtelements'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
                'label_off' => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->add_control(
          'slides_per_view',
          [
              'label' => esc_html__('Slides Per View', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'default' => 1,
          ]
        );

        $this->add_control(
         'slides_per_view_tablet',
         [
             'label' => esc_html__('Slides Per View (Tablet)', 'rtelements'),
             'type' => \Elementor\Controls_Manager::NUMBER,
             'default' => 1,
         ]
        );

        $this->add_control(
         'slides_per_view_mobile',
         [
             'label' => esc_html__('Slides Per View (Mobile)', 'rtelements'),
             'type' => \Elementor\Controls_Manager::NUMBER,
             'default' => 1,
         ]
        );

        $this->add_control(
          'space_between',
          [
              'label' => esc_html__('Space Between (px)', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'default' => 20,
          ]
        );

        $this->add_control(
           'pagination',
           [
               'label' => esc_html__('Pagination', 'rtelements'),
               'type' => \Elementor\Controls_Manager::SELECT,
               'default' => 'bullets',
               'options' => [
                   'none' => esc_html__('None', 'rtelements'),
                   'bullets' => esc_html__('Bullets', 'rtelements'),
                   'fraction' => esc_html__('Fraction', 'rtelements'),
                   'progressbar' => esc_html__('Progressbar', 'rtelements'),
               ],
           ]
        );

        $this->add_responsive_control(
			'pagination_top_spacing',
			[
				'label' => esc_html__( 'Position (Y)', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction'],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);	
        $this->add_responsive_control(
			'pagination_x_positon',
			[
				'label' => esc_html__( 'Right Gap', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction'],                    
                    'rt_slider_style' => 'style9'
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'padding-right: {{SIZE}}{{UNIT}};',
				],
			]
		);	

		$this->add_control(
			'pagination_color',
			[
				'label' => esc_html__( 'Pagination Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-progressbar' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-fraction' => 'color: {{VALUE}}',
					
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction', 'progressbar']
				],
			]
		); 

		$this->add_control(
			'pagination_active_color',
			[
				'label' => esc_html__( 'Pagination Active Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active::before' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-progressbar-fill' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-fraction .swiper-pagination-current' => 'color: {{VALUE}}',
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction', 'progressbar']
				],
			]
		); 

        $this->add_control(
			'pagination_bordercolor',
			[
				'label' => esc_html__( 'Pagination Border Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active::before' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'pagination' => ['bullets']
				],
			]
		);
        
        $this->add_responsive_control(
			'pagination_alignments',
			[
				'label' => esc_html__( 'Alignment', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'text-align: {{VALUE}};',
				],                
				'condition' => [
					'pagination' => ['bullets', 'fraction']
				],
			]
		);

        $this->add_control(
           'navigation',
           [
               'label' => esc_html__('Navigation Arrows', 'rtelements'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => esc_html__('Show', 'rtelements'),
               'label_off' => esc_html__('Hide', 'rtelements'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );

        $this->add_control(
			'navigation_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev' => 'color: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next' => 'color: {{VALUE}}',					
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);
        
        $this->add_control(
			'navigation_hover_color',
			[
				'label' => esc_html__( 'Hover Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev:hover' => 'color: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next:hover' => 'color: {{VALUE}}',						
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);

        $this->add_control(
			'navigation_bgcolor',
			[
				'label' => esc_html__( 'Background Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev' => 'background: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next' => 'background: {{VALUE}}',					
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);
        
        $this->add_control(
			'navigation_hover_bgcolor',
			[
				'label' => esc_html__( 'Hover Background Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev:hover' => 'background: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next:hover' => 'background: {{VALUE}}',					
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);

        $this->add_responsive_control(
			'navigation_top_position',
			[
				'label' => esc_html__( 'Position (Y)', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
                    'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],					
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'navigation' => 'yes',   
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-navigaiton .swiper-prev' => 'top: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .swiper-navigaiton .swiper-next' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);	
        $this->add_responsive_control(
			'navigation_mid_gap',
			[
				'label' => esc_html__( 'Middle Gap', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
                    'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],					
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'navigation' => 'yes',
                    'rt_slider_style' => ['style1', 'style2', 'style9']
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-navigaiton .swiper-prev' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
            'thumbnail_pagination',
            [
                'label' => esc_html__('Thumbnail Pagination', 'rtelements'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'condition' => [
                    'rt_slider_style' => ['style7','style8']
                ],
            ]
        );  

        $this->add_control(
          'thumb_slides_per_view',
          [
              'label' => esc_html__('Slides Per View', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'placeholder' => esc_html__('5', 'rtelements'),
              'condition' => [
                    'thumbnail_pagination' => 'yes',
                    'rt_slider_style' => ['style7','style8']
                ],
          ]
        );

        $this->add_control(
          'thumb_slides_per_view_mobile',
          [
              'label' => esc_html__('Slides Per View (Mobile)', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'placeholder' => esc_html__('5', 'rtelements'),
              'condition' => [
                    'thumbnail_pagination' => 'yes',
                    'rt_slider_style' => ['style7','style8']
                ],
          ]
        );
        
        $this->add_control(
            'thumb-nav-default-color',
            [
                'label' => esc_html__('Default Color', 'rtelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rt-thumb-slider.style8 .swiper-wrapper .thumbnail' => 'border-color: {{VALUE}}',
                ],
                 'condition' => [
                    'thumbnail_pagination' => 'yes',
                    'rt_slider_style' => ['style8']
                ] 
            ]
        ); 

        $this->add_control(
            'thumb-nav-active-color',
            [
                'label' => esc_html__('Active Color', 'rtelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rt-thumb-slider .swiper-wrapper .swiper-slide.swiper-slide-thumb-active img' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .rt-thumb-slider.style8 .swiper-wrapper .swiper-slide-thumb-active .thumbnail' => 'border-color: {{VALUE}}',
                ],
                 'condition' => [
                    'thumbnail_pagination' => 'yes',
                    'rt_slider_style' => ['style7','style8']
                ] 
            ]
        ); 

        $this->add_control(
            'slider_full_width',
            [
                'label' => esc_html__('Slider Right Stretch', 'rtelements'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
            ]
        );
        $this->end_controls_section(); 

        $this->start_controls_section(
            'slider_item_styles',
            [
                'label' => esc_html__('Item', 'rtelements'),
                'tab' => Controls_Manager::TAB_STYLE,                
                'condition' => [
                    'rt_slider_style' => ['style1', 'style2', 'style3', 'style5', 'style6', 'style9']
                ] 
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .slider_item',
                'css' => [
                    'important' => true,
                ],
                'condition' => [
                    'rt_slider_style!' => 'style9'
                ] 
            ]
        );
        $this->add_control(
            'item_border_color',
            [
                'label' => esc_html__('Border Color', 'rtelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider_item' => 'border-color: {{VALUE}} !important',
                ],
                'condition' => [
                    'rt_slider_style' => 'style2'
                ],
            ]
        );
        $this->add_responsive_control(
            'item_radius',
            [
                'label' => esc_html__('Border Radius', 'rtelements'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .slider_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('Padding', 'rtelements'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .slider_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->end_controls_section();        

        $this->start_controls_section(
            '_section_style_grid',
            [
                'label' => esc_html__('Name', 'rtelements'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'name_color',
            [
                'label' => esc_html__('Color', 'rtelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .name' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'rtelements'),
                'name'     => 'name_typography',
                'selector' => '{{WRAPPER}} .name',
                'fields_options' => [
                    'font_size' => [
                        'selectors' => [
                            '{{WRAPPER}} .name' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                        ],
                    ],
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'designation_style',
            [
                'label' => esc_html__('Designation', 'rtelements'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'designation_color',
            [
                'label' => esc_html__('Color', 'rtelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .designation' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .designation b' => 'color: {{VALUE}} !important',
                    '{{WRAPPER}} .designation span' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'rtelements'),
                'name'     => 'designation_typography',
                'selector' => '{{WRAPPER}} .designation',
                'fields_options' => [
                    'font_size' => [
                        'selectors' => [
                            '{{WRAPPER}} .designation' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                        ],
                    ],
                ],
            ]
        ); 
        $this->end_controls_section();

        $this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__('Title', 'rtelements'),
                'tab' => Controls_Manager::TAB_STYLE,                
                 'condition' => [
                    'rt_slider_style' => 'style6'
                ] 
            ]
        );

        $this->add_control(
            'title__color',
            [
                'label' => esc_html__('Color', 'rtelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}} !important',
                ],
            ]
        );   

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'rtelements'),
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .title',
                'fields_options' => [
                    'font_size' => [
                        'selectors' => [
                            '{{WRAPPER}} .title' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                        ],
                    ],
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'des__style',
            [
                'label' => esc_html__('Description', 'rtelements'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'des__color',
            [
                'label' => esc_html__('Color', 'rtelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .disc' => 'color: {{VALUE}} !important',
                ],
            ]
        );   

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'rtelements'),
                'name'     => 'des_typography',
                'selector' => '{{WRAPPER}} .disc',
                'fields_options' => [
                    'font_size' => [
                        'selectors' => [
                            '{{WRAPPER}} .disc' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'des_border_color',
            [
                'label' => esc_html__('Divider Color', 'rtelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .disc' => 'border-color: {{VALUE}} !important',
                ],
                 'condition' => [
                    'rt_slider_style' => ['style5', 'style6']
                ] 
            ]
        );   
        $this->end_controls_section();

        $this->start_controls_section(
            'img_style',
            [
                'label' => esc_html__('Image', 'rtelements'),
                'tab' => Controls_Manager::TAB_STYLE,     
                'condition' => [
                    'rt_slider_style!' => 'style9'
                ],    
            ]
        );  

        $this->add_responsive_control(
			'pagination-img-width',
			[
				'label' => esc_html__( 'Width', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
                'condition' => [
                    'thumbnail_pagination' => 'yes',
                    'rt_slider_style' => ['style7','style8']
                ],
				'selectors' => [
					'{{WRAPPER}} .rt-thumb-slider .swiper-wrapper .swiper-slide img' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		); 

        $this->add_responsive_control(
			'img-size',
			[
				'label' => esc_html__( 'Height', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .thumbnail img' => 'height: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);  

        $this->add_responsive_control(
            'image_radius',
            [
                'label' => esc_html__('Border Radius', 'rtelements'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
			'client-logo-size',
			[
				'label' => esc_html__( 'Logo Size', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 120,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .client-logo img' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
                'condition' => [
                    'rt_slider_style' => ['style2', 'style4', 'style5', 'style7', 'style8']
                ] 
			]
		);    
        $this->end_controls_section();  

        $this->start_controls_section(
            'ratting_style',
            [
                'label' => esc_html__('Ratting', 'rtelements'),
                'tab' => Controls_Manager::TAB_STYLE,    
                'condition' => [
                    'rt_slider_style' => ['style2', 'style5', 'style6']
                ]      
            ]
        );

        $this->add_control(
            'ratting_color',
            [
                'label' => esc_html__('Color', 'rtelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .stars i' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'rtelements'),
                'name'     => 'rating_typography',
                'selector' => '{{WRAPPER}} .stars i',
                'fields_options' => [
                    'font_size' => [
                        'selectors' => [
                            '{{WRAPPER}} .stars i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                        ],
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
			'ratting-gap',
			[
				'label' => esc_html__( 'Middle Gap', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .stars i' => 'margin-right: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);                
        $this->end_controls_section();
        
    }
    protected function render(){
        $settings = $this->get_settings_for_display();
        $style    = $settings['rt_slider_style'];
        static $instance = 0;
        $instance++;
        $unique_id = 'swiper-' . $instance;
        $unique_id = 'swiper-' . uniqid();
        $data_loop = $settings['loop'] === 'yes' ? 'true' : 'false';
        $data_autoplay = ($settings['autoplay'] === 'yes' || $settings['autoplay'] === true) ? 'true' : 'false';
        $data_navigation = ($settings['navigation'] === 'yes' || $settings['navigation'] === true) ? 'true' : 'false';
        $slider_data_attributes = sprintf(
            'data-loop="%s" 
            data-autoplay="%s" 
            data-speed="%s" 
            data-centered-slides="%s" 
            data-autoplay-delay="%s" 
            data-free-mode="%s" 
            data-slides-per-view="%s" 
            data-space-between="%s" 
            data-slides-per-view-tablet="%s" 
            data-slides-per-view-mobile="%s" 
            data-pagination="%s" 
            data-navigation="%s",
            data-thumbnail-pagination="%s",
            data-thumb-slides-per-view="%s",
            data-thumb-slides-per-view-mobile="%s"',
            esc_attr($settings['loop']) === 'yes' ? 'true' : 'false',
            esc_attr($data_autoplay),
            esc_attr($settings['speed']),
            $settings['centered_slides'] === 'yes' ? 'true' : 'false',
            esc_attr($settings['autoplay_delay']),
            $settings['free_mode'] === 'yes' ? 'true' : 'false',
            esc_attr($settings['slides_per_view']),
            esc_attr($settings['space_between']),
            esc_attr($settings['slides_per_view_tablet']),
            esc_attr($settings['slides_per_view_mobile']),
            esc_attr($settings['pagination']),
            esc_attr($data_navigation),
            esc_attr($settings['thumbnail_pagination']) === 'yes' ? 'true' : 'false',
            esc_attr($settings['thumb_slides_per_view']),
            esc_attr($settings['thumb_slides_per_view_mobile'])
        );

        if ( empty( $settings['list'] ) ) {
            return;
        }      
        $full_slider = ( $settings['slider_full_width'] === 'yes' ) ? 'rt_slider_full_width' : '';
        ?> 

        <div id="<?php echo esc_attr( $unique_id ); ?>"  <?php echo $slider_data_attributes; ?>  class="swiper rt--slider rt-all-slider testimonial-<?php echo esc_attr( $style ); ?> <?php echo esc_attr( $full_slider ); ?>">
            <div class="swiper-wrapper">
                <?php
                foreach ( $settings['list'] as $index => $item ) :
                    $title        = !empty( $item['name'] ) ? $item['name'] : '';
                    $designation  = !empty( $item['designation'] ) ? $item['designation'] : '';
                    $description  = !empty( $item['description'] ) ? $item['description'] : '';                     
                    $des_title    = !empty( $item['des_title'] ) ? $item['des_title'] : '';                     
                    $img          = !empty( $item['image']['url'] ) ? $item['image']['url'] : '';                       
                    $img_alt      = !empty( $item['image']['alt'] ) ? $item['image']['alt'] : '';  
                    $link         = !empty( $item['client_link']['url'] ) ? $item['client_link']['url'] : '';     
                    $client_logo  = !empty( $item['client_logo']['url'] ) ? $item['client_logo']['url'] : '';                     
                    $client_logo_alt = !empty( $item['client_logo']['alt'] ) ? $item['client_logo']['alt'] : '';         

                    if ( $style == $style ) {
                        require plugin_dir_path(__FILE__) . "/$style.php";
                    }
                endforeach; ?>
            </div>
            <?php 
            if ( $settings['navigation'] === 'yes' ) : ?>
                <div class="swiper-navigaiton">
                    <span class="swiper-prev"><i class="rt rt-arrow-left"></i></span>
                    <span class="swiper-next"><i class="rt rt-arrow-right"></i></span>
                </div>
                <?php
            endif; 
            if ( $settings['pagination'] !== 'none' ) : ?>
                    <div class="swiper-pagination"><span class="swiper-pagination"></span></div>
                <?php 
            endif; ?>	
        </div>  

        <!-- Thumbnail Pagination -->
        <?php if ($settings['thumbnail_pagination'] === 'yes') : ?>
            <div class="swiper rt-thumb-slider <?php echo esc_attr( $style ); ?>" id="<?php echo esc_attr($unique_id); ?>-thumbs">
                <div class="swiper-wrapper">
                    <?php foreach ($settings['list'] as $items) : 
                        $nav_img = !empty($items['image']['url']) ? $items['image']['url'] : '';
                        $nav_img_alt = !empty($items['image']['alt']) ? $items['image']['alt'] : '';
                        $title       = !empty( $items['name'] ) ? $items['name'] : '';
                        $designation = !empty( $items['designation'] ) ? $items['designation'] : '';
                    ?>
                        <div class="swiper-slide">
                            <div class="thumbnail">
                                <?php if ( !empty( $nav_img ) ) : ?>
                                    <img loading="lazy" src="<?php echo esc_url($nav_img); ?>" alt="<?php echo esc_attr($nav_img_alt); ?>">
                                    <?php 
                                endif;                                 
                                if( $style === 'style8' ) : ?>
                                    <div class="thumb-nav-text">
                                        <?php 
                                        if ( !empty(  $title ) ) : ?>
                                            <<?php echo esc_attr( $settings['title_tag'] ); ?> class="name"><?php echo wp_kses_post(  $title ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                            <?php
                                        endif; 
                                        if ( !empty( $designation ) ) : ?>
                                            <span class="designation"><?php echo wp_kses_post( $designation ); ?></span>
                                            <?php 
                                        endif; ?>
                                    </div>  
                                    <?php 
                                endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php 
        endif; 
    }
}
