<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

defined( 'ABSPATH' ) || die();

class ReacTheme_Elementor_Team_Slider_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'rt-team-slider';
	}

	public function get_style_depends() {
		wp_register_style( 'team-slider-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'team-slider-style'
		];
	}

	public function get_title() {
		return __( 'RT Team Slider', 'rtelements' );
	}

	public function get_icon() {
		return 'rt-e-icon';
	}

	public function get_categories() {
        return [ 'pielements_category' ];
    }

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Team Settings', 'rtelements' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);			
		$this->add_control(
			'team_slider_style',
			[
				 'label'   => esc_html__('Select Style', 'rtelements'),
				 'type'    => Controls_Manager::SELECT,
				 'default' => 'style1',
				 'options' => [
					  'style1' => esc_html__('Style 1', 'rtelements'),
				 ],
			]
	  );
		$this->add_control(
			'team_category',
			[
				'label'   => esc_html__( 'Category', 'rtelements' ),
				'type'    => Controls_Manager::SELECT2,	
				'default' => 0,			
				'options' => $this->getCategories(),
				'multiple' => true,	
			]
		);
		$this->add_control(
			'per_page',
			[
				 'label' => esc_html__('Portfolio Show Per Page', 'rtelements'),
				 'type' => Controls_Manager::TEXT,
				 'placeholder' => esc_html__('example 3', 'rtelements'),       
				'default' => -1,
			]
	   );

		$this->add_control(
            'order_by',
            [
                'label' => __('Order By', 'rtelements'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => __('Date', 'rtelements'),
                    'title' => __('Title', 'rtelements'),
                    'rand' => __('Random', 'rtelements'),
                    'comment_count' => __('Comment Count', 'rtelements'),
                    'menu_order' => __('Menu Order', 'rtelements'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('Order', 'rtelements'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'ASC' => __('Ascending', 'rtelements'),
                    'DESC' => __('Descending', 'rtelements'),
                ],
            ]
        );
	  
	  $this->add_control(
		'title_word_show',
			[
				'label' => esc_html__('Title Word Limit', 'rtelements'),
				'type' => Controls_Manager::NUMBER,
				'default' => 5,
				'placeholder' => esc_html__('10', 'rtelements'),        
			]
		);

	  	$this->add_control(
	  	    'team_link_dis',
	  	    [
	  	        'label' => esc_html__('Link Disable', 'rtelements'),
	  	        'type' => Controls_Manager::SWITCHER,
	  	        'label_on' => esc_html__('Yes', 'rtelements'),
	  	        'label_off' => esc_html__('No', 'rtelements'),
	  	        'return_value' => 'yes',
	  	        'default' => '',
	  	    ]
	  	);
		
	  $this->add_control(
		'title_tag',
		[
			'label'   => esc_html__('Title HTML Tag', 'rtelements'),
			'type'    => Controls_Manager::SELECT,
			'default' => 'h3',
			'options' => [
				'h1' => esc_html__('H1', 'rtelements'),
				'h2' => esc_html__('H2', 'rtelements'),
				'h3' => esc_html__('H3', 'rtelements'),
				'h4' => esc_html__('H4', 'rtelements'),
				'h5' => esc_html__('H5', 'rtelements'),
				'h6' => esc_html__('H6', 'rtelements'),
				'p' => esc_html__('P', 'rtelements'),
				'span' => esc_html__('Span', 'rtelements'),
			],
		]
	  	);
		$this->end_controls_section();  

		$this->start_controls_section(
		   'slider___section__',
		   [
		       'label' => esc_html__( 'Slider Settings', 'rtelements' ),
		       'tab' => Controls_Manager::TAB_CONTENT,
		   ]
		);

		$this->add_control(
		    'loop',
		    [
		        'label' => esc_html__( 'Loop', 'rtelements' ),
		        'type' => \Elementor\Controls_Manager::SWITCHER,
		        'label_on' => esc_html__( 'Yes', 'rtelements' ),
		        'label_off' => esc_html__( 'No', 'rtelements' ),
		        'return_value' => 'yes',
		        'default' => 'no',
		    ]
		);

		$this->add_control(
		'autoplay',
		[
		   'label' => esc_html__('Autoplay', 'rtelements'),
		   'type' => \Elementor\Controls_Manager::SWITCHER,
		   'label_on' => esc_html__('On', 'rtelements'),
		   'label_off' => esc_html__('Off', 'rtelements'),
		   'return_value' => 'yes',
		   'default' => '',
		]
		);

		$this->add_control(
		  'autoplay_delay',
		  [
		      'label' => esc_html__('Autoplay Delay (ms)', 'rtelements'),
		      'type' => \Elementor\Controls_Manager::NUMBER,
		      'default' => 3000,
		  ]
		);

		// Speed
		$this->add_control(
		    'speed',
		    [
		        'label' => esc_html__('Speed (ms)', 'rtelements'),
		        'type' => Controls_Manager::NUMBER,
		        'default' => 900,
		    ]
		);

		$this->add_control(
		    'centered_slides',
		    [
		        'label' => esc_html__('Centered Slides', 'rtelements'),
		        'type' => Controls_Manager::SWITCHER,
		        'label_on' => esc_html__('Yes', 'rtelements'),
		        'label_off' => esc_html__('No', 'rtelements'),
		        'return_value' => 'yes',
		        'default' => '',
		    ]
		);
		$this->add_control(
		    'free_mode',
		    [
		        'label' => esc_html__('Free Mode', 'rtelements'),
		        'type' => \Elementor\Controls_Manager::SWITCHER,
		        'label_on' => esc_html__('Yes', 'rtelements'),
		        'label_off' => esc_html__('No', 'rtelements'),
		        'return_value' => 'yes',
		        'default' => '',
		    ]
		);

		$this->add_control(
		  'slides_per_view',
		  [
		      'label' => esc_html__('Slides Per View', 'rtelements'),
		      'type' => \Elementor\Controls_Manager::NUMBER,
		      'default' => 3,
		  ]
		);

		$this->add_control(
		 'slides_per_view_tablet',
		 [
		     'label' => esc_html__('Slides Per View (Tablet)', 'rtelements'),
		     'type' => \Elementor\Controls_Manager::NUMBER,
		     'default' => 2,
		 ]
		);

		$this->add_control(
		 'slides_per_view_mobile',
		 [
		     'label' => esc_html__('Slides Per View (Mobile)', 'rtelements'),
		     'type' => \Elementor\Controls_Manager::NUMBER,
		     'default' => 1,
		 ]
		);

		$this->add_control(
		  'space_between',
		  [
		      'label' => esc_html__('Space Between (px)', 'rtelements'),
		      'type' => \Elementor\Controls_Manager::NUMBER,
		      'default' => 20,
		  ]
		);

		$this->add_control(
		   'pagination',
		   [
		       'label' => esc_html__('Pagination', 'rtelements'),
		       'type' => \Elementor\Controls_Manager::SELECT,
		       'default' => 'bullets',
		       'options' => [
		           'none' => esc_html__('None', 'rtelements'),
		           'bullets' => esc_html__('Bullets', 'rtelements'),
		           'fraction' => esc_html__('Fraction', 'rtelements'),
		           'progressbar' => esc_html__('Progressbar', 'rtelements'),
		       ],
		   ]
		);

		$this->add_responsive_control(
			'pagination_top_spacing',
			[
				'label' => esc_html__( 'Position (Y)', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'pagination' => [ 'bullets', 'fraction', 'progressbar' ]
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'top: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);	

		$this->add_control(
			'pagination_color',
			[
				'label' => esc_html__( 'Pagination Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-progressbar' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-fraction' => 'color: {{VALUE}}',
					
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction', 'progressbar']
				],
			]
		); 

		$this->add_control(
			'pagination_active_color',
			[
				'label' => esc_html__( 'Pagination Active Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-progressbar-fill' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-fraction .swiper-pagination-current' => 'color: {{VALUE}}',
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction', 'progressbar']
				],
			]
		);

		$this->add_control(
			'pagination_bordercolor',
			[
				'label' => esc_html__( 'Pagination Border Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active::before' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'pagination' => ['bullets']
				],
			]
		);
        
      $this->add_responsive_control(
			'pagination_alignments',
			[
				'label' => esc_html__( 'Alignment', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'text-align: {{VALUE}};',
				],                
				'condition' => [
					'pagination' => ['bullets', 'fraction']
				],
			]
		);

		$this->add_control(
		   'navigation',
		   [
		       'label' => esc_html__('Navigation Arrows', 'rtelements'),
		       'type' => \Elementor\Controls_Manager::SWITCHER,
		       'label_on' => esc_html__('Show', 'rtelements'),
		       'label_off' => esc_html__('Hide', 'rtelements'),
		       'return_value' => 'yes',
		       'default' => 'yes',
		   ]
		);

		$this->add_control(
			'navigation_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev' => 'color: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next' => 'color: {{VALUE}}',					
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);
        
      $this->add_control(
			'navigation_hover_color',
			[
				'label' => esc_html__( 'Hover Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev:hover' => 'color: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next:hover' => 'color: {{VALUE}}',						
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);

      $this->add_control(
			'navigation_bgcolor',
			[
				'label' => esc_html__( 'Background Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev' => 'background-color: {{VALUE}} !important; border-color: {{VALUE}} !important;',
					'{{WRAPPER}} .swiper-next' => 'background-color: {{VALUE}} !important; border-color: {{VALUE}} !important;',			
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);
        
      $this->add_control(
			'navigation_hover_bgcolor',
			[
				'label' => esc_html__( 'Hover Background Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev:hover' => 'background: {{VALUE}} !important; border-color: {{VALUE}} !important;',
					'{{WRAPPER}} .swiper-next:hover' => 'background: {{VALUE}} !important; border-color: {{VALUE}} !important;',		
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);

		$this->add_responsive_control(
			'navigation_top_position',
			[
				'label' => esc_html__( 'Position (Y)', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
                    'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],					
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'navigation' => 'yes',   
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-navigaiton .swiper-prev' => 'top: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .swiper-navigaiton .swiper-next' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);	
		$this->end_controls_section(); 

		$this->start_controls_section(
			'title__style',
			[
				'label' => esc_html__( 'Title', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'title_color',
			[
					'label' => esc_html__( 'Color', 'rtelements' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [					
						'{{WRAPPER}} .title' => 'color: {{VALUE}} !important;',						
					],                
			]
		);
		$this->add_control(
			'title_color_hover',
			[
					'label' => esc_html__( 'Hover Color', 'rtelements' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .title:hover' => 'color: {{VALUE}} !important;',		
					],                
			]
		);   
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Typography', 'rtelements' ),				
				'selector' => '{{WRAPPER}} .title'
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'designation__style',
			[
				'label' => esc_html__( 'Designation', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
            'designation_color',
            [
                'label' => esc_html__( 'Color', 'rtelements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .designation' => 'color: {{VALUE}} !important;',
                ],                
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'designation_typography',
				'label' => esc_html__( 'Typography', 'rtelements' ),				
				'selector' =>'{{WRAPPER}} .designation'
			]
		);		
		$this->end_controls_section();  
		
		$this->start_controls_section(
			'share_btn_styles',
			[
				'label' => esc_html__( 'Share Button', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'share_btn_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => Controls_Manager::COLOR,		      
				'selectors' => [
					'{{WRAPPER}} .dynamic .share-btn' => 'color: {{VALUE}};',
				],
			]
		);		
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'share_btn_bg',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .dynamic .share-btn',
			]
		);	
		$this->end_controls_section();  

		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Social Icon', 'rtelements' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'rtelements' ),
			]
		);         
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => Controls_Manager::COLOR,		      
				'selectors' => [
					'{{WRAPPER}} .team-social ul li .social-icon' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'icon_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .team-social ul li .social-icon',
			]
		);	
		$this->end_controls_tab();
	
		$this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'rtelements' ),
			]
		); 
		$this->add_control(
			'icon_hover_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => Controls_Manager::COLOR,		      
				'selectors' => [
					'{{WRAPPER}} .team-social ul li .social-icon:hover' => 'color: {{VALUE}};',
				],
			]
		);		
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'icon_hover_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .team-social ul li .social-icon:hover',
			]
		);	
		$this->end_controls_tab();	
		$this->end_controls_tabs();			
		$this->end_controls_section();  

		$this->start_controls_section(
        'image_styles',
			[
					'label' => esc_html__( 'Image', 'rtelements' ),
					'tab' => Controls_Manager::TAB_STYLE,
			]
		);	

		$this->add_responsive_control(
			'image_size',
			[
				'label'      => esc_html__( 'Height', 'rtelements' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thumbnail img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);		
    $this->end_controls_section();  

	 $this->start_controls_section(
		'section_content_style',
		[
			'label' => esc_html__( 'Content Area', 'rtelements' ),
			'tab' => Controls_Manager::TAB_STYLE,
		]
	);

	$this->add_control(
		'content_bgcolor',
		[
				'label' => esc_html__( 'Background', 'rtelements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [                           
					'{{WRAPPER}} .content-inner' => 'background: {{VALUE}};',                              
				],                
		]
	);
	$this->end_controls_section();
	}

	protected function render() {
		static $instance	= 0;
		$instance++;
		$settings    		= $this->get_settings_for_display();				
		$style				= $settings['team_slider_style'];	
		$unique_id 			= 'swiper-' . $instance;
		$unique_id 			= 'swiper-' . uniqid();
		$data_loop 			= $settings['loop'] === 'yes' ? 'true' : 'false';
		$data_autoplay 	= ( $settings['autoplay'] === 'yes' || $settings['autoplay'] === true ) ? 'true' : 'false';
		$data_navigation 	= ( $settings['navigation'] === 'yes' || $settings['navigation'] === true ) ? 'true' : 'false';
			
		$slider_data_attributes = sprintf(
		    'data-loop="%s" 
		    data-autoplay="%s" 
		    data-speed="%s" 
		    data-centered-slides="%s" 
		    data-autoplay-delay="%s" 
		    data-free-mode="%s" 
		    data-slides-per-view="%s" 
		    data-space-between="%s" 
		    data-slides-per-view-tablet="%s" 
		    data-slides-per-view-mobile="%s" 
		    data-pagination="%s" 
		    data-navigation="%s"',
		    esc_attr($settings['loop']) === 'yes' ? 'true' : 'false',
		    esc_attr($data_autoplay),
		    esc_attr($settings['speed']),
		    $settings['centered_slides'] === 'yes' ? 'true' : 'false',
		    esc_attr($settings['autoplay_delay']),
		    $settings['free_mode'] === 'yes' ? 'true' : 'false',
		    esc_attr($settings['slides_per_view']),
		    esc_attr($settings['space_between']),
		    esc_attr($settings['slides_per_view_tablet']),
		    esc_attr($settings['slides_per_view_mobile']),
		    esc_attr($settings['pagination']),
		    esc_attr($data_navigation)
		);
	
		$x=1;
		$cat = $settings['team_category'];	
		$args = array(
			'post_type'      => 'teams',
			'posts_per_page' => $settings['per_page'],
			'orderby'        => isset( $settings['order_by'] ) ? $settings['order_by'] : 'date',
			'order'          => isset( $settings['order'] ) ? $settings['order'] : 'DESC',
		);
		if( !empty( $cat ) ){
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'team-category',
					'field'    => 'slug', 
					'terms'    => $cat
				),
			); 
		}   			
		$best_wp = new wp_Query( $args );	
		$team_link_dis = ( $settings['team_link_dis'] == 'yes' ) ? 'rt--link-dis' : '' ;		
		$t_word_count = !empty( $settings['title_word_show'] ) ? $settings['title_word_show'] : '5';				
	?>

		<div id="<?php echo esc_attr( $unique_id ); ?>"  <?php echo $slider_data_attributes; ?> class="swiper rt-all-slider team-slider-<?php echo esc_attr( $style ); ?>">
			<div class="swiper-wrapper">
				<?php 
				while( $best_wp->have_posts() ): $best_wp->the_post();	
					// info data
					$designation	= !empty( get_post_meta( get_the_ID(), 'team_designation', true ) ) ? get_post_meta( get_the_ID(), 'team_designation', true ):'';										
						
					// Social Links
					$facebook  = get_post_meta( get_the_ID(), 'team_facebook', true );
					$twitter   = get_post_meta( get_the_ID(), 'team_twitter', true );
					$instagram = get_post_meta( get_the_ID(), 'team_instagram', true );
					$linkedin  = get_post_meta( get_the_ID(), 'team_linkedin', true );

					// Initialize social icons
					$rt_fb = $rt_tw = $rt_in = $rt_li = '';

					if ( !empty( $facebook ) ) {
						$rt_fb = '<li><a aria-label="Team Social" class="social-icon" href="' . esc_url( $facebook ) . '"><i class="fab fa-facebook-f"></i></a></li>';
					}
					if ( !empty( $twitter ) ) {
						$rt_tw = '<li><a aria-label="Team Social" class="social-icon" href="' . esc_url( $twitter ) . '"><i class="fab fa-twitter"></i></a></li>';
					}
					if ( !empty( $instagram ) ) {
						$rt_in = '<li><a aria-label="Team Social" class="social-icon" href="' . esc_url( $instagram ) . '"><i class="fab fa-instagram"></i></a></li>';
					}
					if ( !empty( $linkedin ) ) {
						$rt_li = '<li><a aria-label="Team Social" class="social-icon" href="' . esc_url( $linkedin ) . '"><i class="fab fa-linkedin-in"></i></a></li>';
					}
					
					if ( $style == $style ) : 					
						require plugin_dir_path(__FILE__) . "/$style.php"; 						 
					endif;	

				endwhile;
				wp_reset_query();  ?>				
			</div>	

			<?php 
			if ( $settings['navigation'] === 'yes' ) : ?>
				<div class="swiper-navigaiton">
					<span class="swiper-prev"><i class="rt rt-arrow-left"></i></span>
					<span class="swiper-next"><i class="rt rt-arrow-right"></i></span>
				</div>
				<?php
			endif; 
			if ( $settings['pagination'] !== 'none' ) : ?>
					<div class="swiper-pagination"><span class="swiper-pagination"></span></div>
				<?php 
			endif; ?>	
		</div>	
	<?php
	$x++; 
	} 
	public function getCategories(){
		$cat_list = [];
		if ( post_type_exists( 'teams' ) ) { 
		$terms = get_terms( array(
			'taxonomy'    => 'team-category',
			'hide_empty'  => true            
		) ); 
		foreach( $terms as $post ) {
		$cat_list[$post->slug]  = [$post->name];
		}
	}  
		return $cat_list;
	}
} ?>