<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

defined('ABSPATH') || die();

class Reactheme_Elementor_Team_Single_Content_Widget extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'react-team-single';
	}

	public function get_title()
	{
		return esc_html__('RT Team Single', 'rtelements');
	}

	public function get_icon()
	{
		return 'rt-e-icon';
	}

	public function get_categories() {
		return ['pielements_category'];
	}

	protected function register_controls()
	{		
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'rtelements' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-phone-alt',
					'library' => 'fa-solid',
				],			
				'condition' => [
					'team_single_select' => [ 'mail', 'phone', 'location' ],
				]
			]
		);

		$this->add_control(
			'team_single_select',
			[
				'label'   => esc_html__('Select Single Data', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'name',
				'options' => [
					'name' 			=> esc_html__('Name', 'rtelements'),
					'designation' 	=> esc_html__('Designation', 'rtelements'),
					'excerpt' 		=> esc_html__('Excerpt Data', 'rtelements'),
					'thumbnail'		=> esc_html__('Thumbnail', 'rtelements'),
					'phone' 			=> esc_html__('Contact', 'rtelements'),
					'mail' 			=> esc_html__('Mail', 'rtelements'),
					'location' 		=> esc_html__('Location', 'rtelements'),
					'social' 		=> esc_html__('Social', 'rtelements')
				],
			]
		);

		$this->add_control(
			'label',
			[
				'label'   => esc_html__( 'Label', 'rtelements' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Email Address', 'rtelements' ),		
				'condition' => [
					'team_single_select' => [ 'mail', 'phone', 'location' ],
				]
			]
		);

		$this->add_responsive_control(
			'alignments',
			[
				'label' => esc_html__( 'Alignment', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .rt-team-single' => 'text-align: {{VALUE}};',
				],						
				'condition' => [
					'team_single_select' => [ 'name', 'designation', 'excerpt' ],
				]		
			]
		);	 
      		
		$this->add_control(
			'html_tag',
			[
				'label'   => esc_html__('Title HTML Tag', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('span', 'rtelements'),
				],
				'condition' => [
					'team_single_select' => [ 'name', 'designation', 'excerpt', 'mail', 'phone', 'location' ],
				]
			]
		);

	  	$this->add_responsive_control(
			'image_height',
			[
				 'label' => esc_html__( 'Height', 'rtelements' ),
				 'type' => Controls_Manager::SLIDER,
				 'size_units' => [ 'px', '%' ],
				 'range' => [
				'px' => [
					'min' => 0,
					'max' => 500,
					'step' => 1,
				],
				'%' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors' => [             
				'{{WRAPPER}} .rt-team-single-thumbnail img' => 'height: {{SIZE}}{{UNIT}} !important;',                 
			],  				
			'condition' => [
				'team_single_select' => [ 'thumbnail' ],
			]               
		]
	  ); 

	  	$this->add_responsive_control(
			'image_border_radius',
			[
				 'label' => esc_html__( 'Border Radius', 'rtelements' ),
				 'type' => Controls_Manager::DIMENSIONS,
				 'size_units' => [ 'px', '%' ], 
				 'selectors' => [
					'{{WRAPPER}} .rt-team-single-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				], 				
				'condition' => [
					'team_single_select' => [ 'thumbnail' ],
				]              
			]
	  ); 
		$this->end_controls_section();

		$this->start_controls_section(
			'label_styles',
			[
				'label' => esc_html__( 'Label', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'team_single_select' => [ 'mail', 'phone', 'location' ],
				]
			]
		);

		$this->add_control(
			'label_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .label' => 'color: {{VALUE}} !important;',
				],
			]
		);		
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'label_typography',
				'selector' => '{{WRAPPER}} .label',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'content_style_section',
			[
				'label' => esc_html__( 'Text', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'team_single_select' => [ 'name', 'designation', 'excerpt', 'mail', 'phone', 'location' ],
				]
			]
		);

		$this->add_control(
			'txt_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .e_dynamic' => 'color: {{VALUE}} !important;',
				],
			]
		);		
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .e_dynamic',
			]
		);
		
		$this->add_responsive_control(
			'text_margin',
			[
				'label' => esc_html__('Margin', 'rtelements'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .e_dynamic' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'icon_styles',
			[
				'label' => esc_html__( 'Icon', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'team_single_select' => [ 'mail', 'phone', 'location', 'social' ],
				]
			]
		);	
			
		$this->start_controls_tabs('_tabs_button');

		$this->start_controls_tab(
			'icon_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'rtelements' ),
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .social-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rt-team-single .icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rt-team-single .icon svg path' => 'fill: {{VALUE}};',
				],
			]
		);	

		$this->add_control(
			'icon_bg_color',
			[
				'label' => esc_html__('Background', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-team-single .icon' => 'background: {{VALUE}};',
					'{{WRAPPER}} .social-icon' => 'background: {{VALUE}};',
				],
			]
		);	

		$this->add_control(
			'icon_border_color',
			[
				'label' => esc_html__('Border Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-team-single .icon' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .social-icon' => 'border-color: {{VALUE}};',
				],
			]
		);	
		$this->end_controls_tab();

		$this->start_controls_tab(
			'icon_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'rtelements' ),
			]
		);

		$this->add_control(
			'icon_h_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .social-icon:hover i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rt-team-single .icon:hover i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rt-team-single .icon:hover svg path' => 'fill: {{VALUE}};',
				],
			]
		);	

		$this->add_control(
			'icon_bg_h_color',
			[
				'label' => esc_html__('Background', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-team-single .icon:hover' => 'background: {{VALUE}};',
					'{{WRAPPER}} .social-icon:hover' => 'background: {{VALUE}};',
				],
			]
		);	

		$this->add_control(
			'icon_h_border_color',
			[
				'label' => esc_html__('Border Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-team-single .icon:hover' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .social-icon:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();	 		
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();	
		// query start 
		$x		= 1;
		$cat 	= 'team-category';	
		$args = array(
			'post_type'      => 'teams',
		);
		if( !empty( $cat ) ){
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'team-category',
					'field'    => 'slug', //can be set to ID
					'terms'    => $cat //if field is ID you can reference by cat/term number
				),
			); 
		}   			
		$best_wp = new wp_Query( $args );	
		
		$termsArray  = get_the_terms( $best_wp->ID, "team-category" );  //Get the terms for this particular item
		$termsString = ""; //initialize the string that will contain the terms
		$termsSlug   = "";
		if(!empty($termsArray)): 
			foreach ( $termsArray as $term ) { 
				$termsString .= 'filter_'.$term->slug.' '; 
				$termsSlug .= $term->name;
			}		
		endif;		

		$excerpt = get_the_excerpt();	
		$designation	= !empty( get_post_meta( get_the_ID(), 'team_designation', true ) ) ? get_post_meta( get_the_ID(), 'team_designation', true ):'';										
						
		// Social Links
		$facebook  = get_post_meta( get_the_ID(), 'team_facebook', true );
		$twitter   = get_post_meta( get_the_ID(), 'team_twitter', true );
		$instagram = get_post_meta( get_the_ID(), 'team_instagram', true );
		$linkedin  = get_post_meta( get_the_ID(), 'team_linkedin', true );

		// Initialize social icons
		$rt_fb = $rt_tw = $rt_in = $rt_li = '';

		if ( !empty( $facebook ) ) {
			$rt_fb = '<li><a class="social-icon" href="' . esc_url( $facebook ) . '"><i class="fab fa-facebook-f"></i></a></li>';
		}
		if ( !empty( $twitter ) ) {
			$rt_tw = '<li><a class="social-icon" href="' . esc_url( $twitter ) . '"><i class="fab fa-twitter"></i></a></li>';
		}
		if ( !empty( $instagram ) ) {
			$rt_in = '<li><a class="social-icon" href="' . esc_url( $instagram ) . '"><i class="fab fa-instagram"></i></a></li>';
		}
		if ( !empty( $linkedin ) ) {
			$rt_li = '<li><a class="social-icon" href="' . esc_url( $linkedin ) . '"><i class="fab fa-linkedin-in"></i></a></li>';
		}

		$contact 	= !empty( get_post_meta( get_the_ID(), 'team_contact', true ) ) ? get_post_meta( get_the_ID(), 'team_contact', true ) : '';
		$mail 		= !empty( get_post_meta( get_the_ID(), 'team_mail', true ) ) ? get_post_meta( get_the_ID(), 'team_mail', true ) : '';	
		$locations 	= !empty( get_post_meta( get_the_ID(), 'team_location', true ) ) ? get_post_meta( get_the_ID(), 'team_location', true ) : '';	

		// Select Data 
		$name 		= $settings['team_single_select'] == 'name';
		$subtitle	= $settings['team_single_select'] == 'designation';
		$des			= $settings['team_single_select'] == 'excerpt';
		$thumb		= $settings['team_single_select'] == 'thumbnail';
		$phone		= $settings['team_single_select'] == 'phone';
		$gmail		= $settings['team_single_select'] == 'mail';
		$social		= $settings['team_single_select'] == 'social';
		$location	= $settings['team_single_select'] == 'location';

		if( $name ) :		
			if( !empty( get_the_title() ) ) : ?>
				<div class="rt-team-single">
					<<?php echo esc_attr( $settings['html_tag'] ); ?> class="title e_dynamic">
						<?php the_title(); ?>
					</<?php echo esc_attr( $settings['html_tag'] ); ?>>
				</div>
		  		<?php
			endif;  
		elseif( $subtitle ) : 
			if( !empty( $designation ) ) : ?>
				<div class="rt-team-single">
					<<?php echo esc_attr( $settings['html_tag'] ); ?> class="e_dynamic"><?php echo esc_html( $designation ); ?></<?php echo esc_attr( $settings['html_tag'] ); ?>>
				</div>
				<?php
			endif; 
		elseif( $des ) :  
			if( !empty( $excerpt ) ) : ?>
				<div class="rt-team-single">
					<<?php echo esc_attr( $settings['html_tag'] ); ?> class="e_dynamic"><?php echo esc_html( $excerpt ); ?></<?php echo esc_attr( $settings['html_tag'] ); ?>>
				</div>
				<?php
			endif; 
		elseif( $thumb ) :
			if( has_post_thumbnail() ) : ?>
				<div class="rt-team-single-thumbnail">
					<?php the_post_thumbnail(); ?>
				</div>
				<?php 
			endif; 		
		elseif( $phone ) : ?>
			<div class="rt-team-single icon-text">
				<div class="icon">					
					<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
				</div>
				<div class="text">
					<?php
					if ( !empty( $settings['label'] ) ) : ?>
						<span class="label"><?php echo wp_kses_post( $settings['label'] ); ?></span>
						<?php 
					endif; ?>
					<a href="tel:<?php echo esc_attr( str_replace(" ","",( $contact ) ) ); ?>">
						<<?php echo esc_attr( $settings['html_tag'] ); ?> class="e_dynamic">					
							<?php echo esc_html( $contact ); ?>
						</<?php echo esc_attr( $settings['html_tag'] ); ?>>	
					</a>			
				</div>	
			</div>	
			<?php 
		elseif( $gmail ) : ?>
			<div class="rt-team-single icon-text">
				<div class="icon">					
					<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
				</div>
				<div class="text">
					<?php
					if ( !empty( $settings['label'] ) ) : ?>
						<span class="label"><?php echo wp_kses_post( $settings['label'] ); ?></span>
						<?php 
					endif; ?>
					<a href="mailto:<?php echo esc_attr($mail);?>">
						<<?php echo esc_attr( $settings['html_tag'] ); ?> class="e_dynamic">
							<?php echo esc_html( $mail ); ?>
						</<?php echo esc_attr( $settings['html_tag'] ); ?>>	
					</a>
				</div>			
			</div>
			<?php 	
		elseif( $location ) : ?>
			<div class="rt-team-single icon-text">
				<div class="icon">					
					<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
				</div>
				<div class="text">
					<?php
					if ( !empty( $settings['label'] ) ) : ?>
						<span class="label"><?php echo wp_kses_post( $settings['label'] ); ?></span>
						<?php 
					endif; ?>
					<<?php echo esc_attr( $settings['html_tag'] ); ?> class="e_dynamic">
						<?php echo esc_html( $locations ); ?>
					</<?php echo esc_attr( $settings['html_tag'] ); ?>>				
				</div>
			</div>
			<?php 
		elseif( $social ) : 
			if ( !empty( $rt_fb ) || !empty( $rt_tw ) || !empty( $rt_in ) || !empty( $rt_li ) ) : ?>
				<div class="rt-team-single-social">
					<ul>
						<?php 
							echo wp_kses_post( $rt_fb );
							echo wp_kses_post( $rt_tw );
							echo wp_kses_post( $rt_in );
							echo wp_kses_post( $rt_li );
						?>
					</ul>
				</div>
				<?php 
			endif; 
		else : 			
			echo esc_html( 'Not Found' );			
		endif; 
	} 	
} ?>