<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

defined( 'ABSPATH' ) || die();

class ReacTheme_Elementor_Team_Grid_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'rt-team-grid';
	}	
	
	public function get_style_depends() {
		wp_register_style( 'team-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'team-style'
		];
	}

	public function get_title() {
		return __( 'RT Team Grid', 'rtelements' );
	}

	public function get_icon() {
		return 'rt-e-icon';
	}

	public function get_categories() {
        return [ 'pielements_category' ];
    }

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Team Settings', 'rtelements' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);			
		$this->add_control(
			'team_grid_style',
			[
				 'label'   => esc_html__('Select Style', 'rtelements'),
				 'type'    => Controls_Manager::SELECT,
				 'default' => 'style1',
				 'options' => [
					  'style1' => esc_html__('Style 1', 'rtelements'),
					  'style2' => esc_html__('Style 2', 'rtelements'),
					  'style3' => esc_html__('Style 3', 'rtelements'),
					  'style4' => esc_html__('Style 4', 'rtelements'),
				 ],
			]
	  	);

		$this->add_control(
			'team_category',
			[
				'label'   => esc_html__( 'Category', 'rtelements' ),
				'type'    => Controls_Manager::SELECT2,	
				'default' => 0,			
				'options' => $this->getCategories(),
				'multiple' => true,	
			]
		);

		$this->add_control(
			'order_by',
			[
					'label' => __('Order By', 'rtelements'),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'date',
					'options' => [
						'date' => __('Date', 'rtelements'),
						'title' => __('Title', 'rtelements'),
						'rand' => __('Random', 'rtelements'),
						'comment_count' => __('Comment Count', 'rtelements'),
						'menu_order' => __('Menu Order', 'rtelements'),
					],
			]
		);

		$this->add_control(
			'order',
			[
				'label' => __('Order', 'rtelements'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC' => __('Ascending', 'rtelements'),
					'DESC' => __('Descending', 'rtelements'),
				],
			]
		);

		$this->add_control(
			'per_page',
			[
				'label' => esc_html__('Per Page', 'rtelements'),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__('example 3', 'rtelements'),
				'default' => 3,
			]
	   );	
	  
	  	$this->add_control(
			'title_word_show',
			[
				'label' => esc_html__('Title Word Limit', 'rtelements'),
				'type' => Controls_Manager::NUMBER,
				'default' => 5,
				'placeholder' => esc_html__('10', 'rtelements'),        
			]
		);

	  	$this->add_control(
	  	    'team_link_dis',
	  	    [
	  	        'label' => esc_html__('Link Disable', 'rtelements'),
	  	        'type' => Controls_Manager::SWITCHER,
	  	        'label_on' => esc_html__('Yes', 'rtelements'),
	  	        'label_off' => esc_html__('No', 'rtelements'),
	  	        'return_value' => 'yes',
	  	        'default' => '',
	  	    ]
	  	);	

		$this->add_control(
	  	    'pagination_show_hide',
	  	    [
	  	        'label' => esc_html__('Pagination', 'rtelements'),
	  	        'type' => Controls_Manager::SWITCHER,
	  	        'label_on' => esc_html__('Yes', 'rtelements'),
	  	        'label_off' => esc_html__('No', 'rtelements'),
	  	        'return_value' => 'yes',
	  	        'default' => 'no',
	  	    ]
	  	);			

		$this->add_responsive_control(
			'pagination_top_spacing',
			[
				'label' => esc_html__( 'Spacing', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .reactheme-pagination-area' => 'padding-top: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'pagination_show_hide' => 'yes'
				]
			]
		);	

		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__('Title HTML Tag', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('Span', 'rtelements'),
				],
			]
	  	);
		$this->end_controls_section();

		$this->start_controls_section(
			'team_grid_section',
			[
				'label' => esc_html__( 'Grid Settings', 'rtelements' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);		

		$this->add_control(
			'team_columns',
			[
				'label'   => esc_html__( 'Columns', 'rtelements' ),
				'type'    => Controls_Manager::SELECT,	
				'default' => 4,			
				'options' => [
					'6' => esc_html__( '2 Column', 'rtelements' ),
					'4' => esc_html__( '3 Column', 'rtelements' ),
					'3' => esc_html__( '4 Column', 'rtelements' ),
					'2' => esc_html__( '6 Column', 'rtelements' ),
					'12' => esc_html__( '1 Column', 'rtelements' ),					
				],						
			]
		);

		$this->add_control(
		    'team_columns_md',
		    [
		        'label'   => esc_html__( 'Columns ≥768px', 'rtelements' ),
		        'type'    => Controls_Manager::SELECT,
		        'default' => '12',
		        'options' => [
		            '12' => esc_html__( '1 Column', 'rtelements' ),
		            '6'  => esc_html__( '2 Columns', 'rtelements' ),
		            '4'  => esc_html__( '3 Columns', 'rtelements' ),
		        ],
		    ]
		);

		$this->add_control(
			'team_columns_sm',
			[
				 'label'   => esc_html__( 'Columns ≥576px', 'rtelements' ),
				 'type'    => Controls_Manager::SELECT,
				 'default' => '12',
				 'options' => [
					  '12' => esc_html__( '1 Column', 'rtelements' ),
					  '6'  => esc_html__( '2 Columns', 'rtelements' ),
					  '4'  => esc_html__( '3 Columns', 'rtelements' ),
				 ],
			]
	  	);

		$this->add_responsive_control(
			'team_columns_spacing',
			[
				'label' => esc_html__( 'Middle Gap', 'rtelements' ),
				'type' => Controls_Manager::SLIDER,
				'show_label' => true,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],	
				'selectors' => [
					'{{WRAPPER}} .team-grid .row' => '--bs-gutter-x: {{SIZE}}{{UNIT}} !important;',
				],
			]
		); 	

		$this->add_responsive_control(
			'item_bottom_spacing',
			[
				'label' => esc_html__( 'Item Bottom Spacing', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .grid-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);	  	
		$this->end_controls_section();  

		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__( 'Title', 'rtelements' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'rtelements' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .title' => 'color: {{VALUE}} !important;',
				],
			]
		);

		$this->add_control(
			'title_color_hover',
			[
				'label'     => esc_html__( 'Hover Color', 'rtelements' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .title:hover' => 'color: {{VALUE}} !important;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Typography', 'rtelements' ),
				'selector' => '{{WRAPPER}} .title',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'designation_style',
			[
				'label' => esc_html__( 'Designation', 'rtelements' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'designation_color',
			[
				'label'     => esc_html__( 'Color', 'rtelements' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .designation' => 'color: {{VALUE}} !important;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'designation_typography',
				'label'    => esc_html__( 'Typography', 'rtelements' ),
				'selector' => '{{WRAPPER}} .designation',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'share_btn_styles',
			[
				'label' => esc_html__( 'Share Button', 'rtelements' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'team_grid_style' => 'style1'
				]
			]
		);

		$this->add_control(
			'share_btn_color',
			[
				'label'     => esc_html__( 'Color', 'rtelements' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .dynamic .share-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'     => 'share_btn_bg',
				'types'    => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .dynamic .share-btn',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'social_style_section',
			[
				'label' => esc_html__( 'Social Icon', 'rtelements' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'team_grid_style' => ['style1', 'style2', 'style3']
				]
			]
		);

		$this->add_control(
			'social_divider_color',
			[
				'label'     => esc_html__( 'Divider Color', 'rtelements' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .team-social' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'team_grid_style' => ['style2', 'style3']
				]
			]
		);

		$this->start_controls_tabs( 'style_tabs' );

		$this->start_controls_tab(
			'social_style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'rtelements' ),
			]
		);

		$this->add_control(
			'social_icon_color',
			[
				'label'     => esc_html__( 'Color', 'rtelements' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .team-social .social-icon' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'     => 'social_icon_background',
				'types'    => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .team-social .social-icon',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'social_style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'rtelements' ),
			]
		);

		$this->add_control(
			'social_icon_hover_color',
			[
				'label'     => esc_html__( 'Color', 'rtelements' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .team-social .social-icon:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'     => 'social_icon_hover_background',
				'types'    => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .team-social .social-icon:hover',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section(
			'image_styles',
			[
				'label' => esc_html__( 'Image', 'rtelements' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'image_size',
			[
				'label'      => esc_html__( 'Height', 'rtelements' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thumbnail img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content Area', 'rtelements' ),
				'tab'   => Controls_Manager::TAB_STYLE,				
				'condition' => [
					'team_grid_style' => ['style1', 'style2', 'style3']
				]
			]
		);

		$this->add_control(
			'content_bgcolor',
			[
				'label'     => esc_html__( 'Background', 'rtelements' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .content-inner' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
        'pagination_styles',
        [
            'label' => esc_html__( 'Pagination', 'rtelements' ),
            'tab' => Controls_Manager::TAB_STYLE,
            'condition' => [
                'pagination_show_hide' => 'yes' 
            ]
        ]
    	);

    	$this->add_control(
        'pagination_color',
        [
            'label' => esc_html__( 'Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a' => 'color: {{VALUE}};',                       
            ],           
        ]
    );

	  $this->add_control(
        'pagination_border_color',
        [
            'label' => esc_html__( 'Border Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a' => 'border-color: {{VALUE}};',                       
            ],           
        ]
    );
    
    $this->add_control(
        'pagination_active_color',
        [
            'label' => esc_html__( 'Hover & Active Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a:hover' => 'color: {{VALUE}};',                       
                '{{WRAPPER}} .reactheme-pagination-area .nav-links .current' => 'color: {{VALUE}};',                       
            ],           
        ]
    );

    $this->add_control(
        'pagination_bgcolor',
        [
            'label' => esc_html__( 'Background', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a' => 'background: {{VALUE}};',                       
            ],           
        ]
    );
    
    $this->add_control(
        'pagination_active_bgcolor',
        [
            'label' => esc_html__( 'Hover & Active Background', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [                     
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a:hover' => 'background: {{VALUE}};',   
                '{{WRAPPER}} .reactheme-pagination-area .nav-links .current' => 'background: {{VALUE}};',                      
            ],           
        ]
    );

	$this->add_control(
		'pagination_active_border_color',
		[
			'label' => esc_html__( 'Hover & Active Border Color', 'rtelements' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .reactheme-pagination-area .nav-links a:hover' => 'border-color: {{VALUE}};', 
				'{{WRAPPER}} .reactheme-pagination-area .nav-links .current' => 'border-color: {{VALUE}};',                         
			],           
		]
    );
    
    $this->end_controls_section();
	}

	protected function render() {
		$settings	= $this->get_settings_for_display();				
		$style 		= $settings['team_grid_style'];	
		$x				= 1;
		$cat 			= $settings['team_category'];			
		
		global $paged;
		$paged = get_query_var('paged') ? get_query_var('paged') : 1;		
		$args = array(
			'post_type'      => 'teams',
			'posts_per_page' => $settings['per_page'],
			'orderby'        => isset( $settings['order_by'] ) ? $settings['order_by'] : 'date',
			'order'          => isset( $settings['order'] ) ? $settings['order'] : 'DESC',
		);

		if ( $settings['pagination_show_hide'] === 'yes' ) {
            $args['paged'] = $paged;
        }

		if( !empty( $cat ) ){
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'team-category',
					'field'    => 'slug', 
					'terms'    => $cat
				),
			); 
		}   			
		$best_wp = new wp_Query( $args );	 

		$team_link_dis = ( $settings['team_link_dis'] == 'yes' ) ? 'rt--link-dis' : '' ;		
		$t_word_count = !empty( $settings['title_word_show'] ) ? $settings['title_word_show'] : '5';	?>

		<div class="team-grid">	
			<div class="row">
				<?php 
				while( $best_wp->have_posts() ): $best_wp->the_post();	
					// info data
					$designation = get_post_meta( get_the_ID(), 'team_designation', true );
					$designation = !empty( $designation ) ? $designation : '';										

					// Social Links
					$facebook  = get_post_meta( get_the_ID(), 'team_facebook', true );
					$twitter   = get_post_meta( get_the_ID(), 'team_twitter', true );
					$instagram = get_post_meta( get_the_ID(), 'team_instagram', true );
					$linkedin  = get_post_meta( get_the_ID(), 'team_linkedin', true );

					// Initialize social icons
					$rt_fb = $rt_tw = $rt_in = $rt_li = '';

					if ( !empty( $facebook ) ) {
						$rt_fb = '<li><a aria-label="Team Social" class="social-icon" href="' . esc_url( $facebook ) . '"><i class="fab fa-facebook-f"></i></a></li>';
					}
					if ( !empty( $twitter ) ) {
						$rt_tw = '<li><a aria-label="Team Social" class="social-icon" href="' . esc_url( $twitter ) . '"><i class="fab fa-twitter"></i></a></li>';
					}
					if ( !empty( $instagram ) ) {
						$rt_in = '<li><a aria-label="Team Social" class="social-icon" href="' . esc_url( $instagram ) . '"><i class="fab fa-instagram"></i></a></li>';
					}
					if ( !empty( $linkedin ) ) {
						$rt_li = '<li><a aria-label="Team Social" class="social-icon" href="' . esc_url( $linkedin ) . '"><i class="fab fa-linkedin-in"></i></a></li>';
					}
				?>
					<div class="col-lg-<?php echo esc_html( $settings['team_columns'] );?> col-md-<?php echo esc_attr( $settings['team_columns_md'] ); ?> col-sm-<?php echo esc_attr( $settings['team_columns_sm'] ); ?>">
						<?php 
						if( $style == 'style2' ) : ?>
							<div class="team-style-two grid-item">
								<?php 
								if( has_post_thumbnail() ): ?>
									<a aria-label="thumbnail" class="thumbnail <?php echo esc_attr( $team_link_dis ); ?>" href="<?php the_permalink(); ?>">
										<?php the_post_thumbnail(); ?>
									</a>
									<?php 
								endif; ?>
								<div class="content-inner">
									<div class="text-top <?php echo esc_attr( $team_link_dis ); ?>">
										<?php 
										if ( get_the_title() ) : ?>
											<a aria-label="Team Member Name" href="<?php the_permalink(); ?>">
												<<?php echo esc_attr($settings['title_tag']); ?> class="title">
													<?php echo wp_trim_words( get_the_title(), $t_word_count, '' ); ?>
												</<?php echo esc_attr($settings['title_tag']); ?>>
											</a>
											<?php 
										endif; 
										if ( $designation ) : ?>
											<span class="designation"><?php echo esc_html( $designation );?></span>				
											<?php 
										endif; ?>
									</div>
									
									<?php 
									if ( !empty( $rt_fb ) || !empty( $rt_tw ) || !empty( $rt_in ) || !empty( $rt_li ) ) : ?>
										<div class="team-social">
											<ul>
												<?php 
													echo wp_kses_post( $rt_fb );
													echo wp_kses_post( $rt_tw );
													echo wp_kses_post( $rt_in );
													echo wp_kses_post( $rt_li );
												?>
											</ul>
										</div>
										<?php 
									endif; ?>
								</div>
							</div>	
							<?php 
						elseif( $style == 'style3' ) : ?>
							<div class="team-style-three grid-item">
                       	<?php 
								if( has_post_thumbnail() ): ?>
									<a aria-label="thumbnail" class="thumbnail <?php echo esc_attr( $team_link_dis ); ?>" href="<?php the_permalink(); ?>">
										<?php the_post_thumbnail(); ?>
									</a>
									<?php 
								endif; ?>
                        <div class="content-inner">
                           <div class="inner">
										<div class="text-top <?php echo esc_attr( $team_link_dis ); ?>">
											<?php 
											if ( get_the_title() ) : ?>
												<a aria-label="Team Member Name" href="<?php the_permalink(); ?>">
													<<?php echo esc_attr($settings['title_tag']); ?> class="title">
														<?php echo wp_trim_words( get_the_title(), $t_word_count, '' ); ?>
													</<?php echo esc_attr($settings['title_tag']); ?>>
												</a>
												<?php 
											endif; 
											if ( $designation ) : ?>
												<span class="designation"><?php echo esc_html( $designation );?></span>				
												<?php 
											endif; ?>
										</div>
										<?php 
										if ( !empty( $rt_fb ) || !empty( $rt_tw ) || !empty( $rt_in ) || !empty( $rt_li ) ) : ?>
											<div class="team-social">
												<ul>
													<?php 
														echo wp_kses_post( $rt_fb );
														echo wp_kses_post( $rt_tw );
														echo wp_kses_post( $rt_in );
														echo wp_kses_post( $rt_li );
													?>
												</ul>
											</div>
											<?php 
										endif; ?>
                           </div>
                        </div>
                    	</div>							
							<?php 
						elseif( $style == 'style4' ) : ?>
							<div class="team-style-four dynamic grid-item <?php echo esc_attr( $team_link_dis ); ?>">
								<?php 
								if ( has_post_thumbnail() ) : ?>
									<a href="<?php the_permalink(); ?>" aria-label="Thumbnail" class="thumbnail">
										<?php the_post_thumbnail(); ?>
									</a>
									<?php 
								endif; ?>
                        <div class="content-inner">
									<?php 
									if ( get_the_title() ) : ?>	
										<a aria-label="Team Member Name" href="<?php the_permalink(); ?>">
											<<?php echo esc_attr( $settings['title_tag'] ); ?> class="title">
												<?php echo wp_trim_words( get_the_title(), $t_word_count, '' ); ?>
											</<?php echo esc_attr( $settings['title_tag'] ); ?>>		
										</a>
										<?php 
									endif; 
									if ( $designation ) : ?>
										<p class="designation"><?php echo wp_kses_post( $designation ); ?></p>				
										<?php 
									endif; ?>
                        </div>
                    	</div>
							<?php
						else : ?>
							<div class="team-style-one dynamic grid-item">
								<div class="team-image-area">
									<?php 
									if ( has_post_thumbnail() ) : ?>
										<a href="<?php the_permalink(); ?>" aria-label="Thumbnail" class="thumbnail <?php echo esc_attr( $team_link_dis ); ?>">
											<?php the_post_thumbnail(); ?>
										</a>
										<?php 
									endif;
									// social
									if ( !empty( $rt_fb ) || !empty( $rt_tw ) || !empty( $rt_in ) || !empty( $rt_li ) ) : ?>
										<div class="team-social">
											<div class="share-btn">
												<i class="rt rt-plus"></i>
											</div>
												<ul>
													<?php 
														echo wp_kses_post( $rt_fb );
														echo wp_kses_post( $rt_tw );
														echo wp_kses_post( $rt_in );
														echo wp_kses_post( $rt_li );
													?>
												</ul>
										</div>
										<?php 
									endif; ?>
								</div>
								<div class="content-inner <?php echo esc_attr( $team_link_dis ); ?>">
									<?php 
									if ( get_the_title() ) : ?>	
										<a aria-label="Team Member Name" href="<?php the_permalink(); ?>">
											<<?php echo esc_attr( $settings['title_tag'] ); ?> class="title">
												<?php echo wp_trim_words( get_the_title(), $t_word_count, '' ); ?>
											</<?php echo esc_attr( $settings['title_tag'] ); ?>>		
										</a>
										<?php 
									endif; 
									if ( $designation ) : ?>
										<p class="designation"><?php echo wp_kses_post( $designation ); ?></p>				
										<?php 
									endif; ?>
								</div>
							</div>	
							<?php 
						endif; ?>	
					</div>		
				<?php 
				endwhile;
			wp_reset_postdata(); ?>		

			</div>
		</div>	
		<?php		
		$paginate = paginate_links( array(
			'total' => $best_wp->max_num_pages
		));

		if( !empty( $paginate ) && ( $settings['pagination_show_hide'] == 'yes' ) ) { ?>
			<div class="reactheme-pagination-area"><div class="nav-links"><?php echo wp_kses_post( $paginate ); ?></div></div>
			<?php 
		} 
	} 
	private function getCategories() {
		$terms = get_terms( array(
			'taxonomy'   => 'team-category',
			'hide_empty' => false,
		) );

		$options = [];

		if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) {
			foreach ( $terms as $term ) {
				$options[$term->slug] = $term->name;
			}
		}

		return $options;
	}
} ?>