<?php
class EasyElements_Advance_Tab_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'rt-tab-advance';
    }

     public function get_style_depends() {
		wp_register_style( 'tab-advanced-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'tab-advanced-style'
		];
	}

    public function get_title() {
        return esc_html__( 'RT Tabs Advanced', 'rtelements' );
    }

    public function get_icon() {
        return 'rt-e-icon';
    }

    public function get_categories() {
        return [ 'easyelements_category' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'tabs_section',
            [
                'label' => esc_html__( 'Tabs Settings', 'rtelements' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tab_title',
            [
                'label' => esc_html__( 'Tab Title', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Tab Title', 'rtelements' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tab_subtitle',
            [
                'label' => esc_html__( 'Subtitle', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tab_title_icon_image_type',
            [
                'label' => esc_html__( 'Icon / Image', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'none' => esc_html__( 'None', 'rtelements' ),
                    'icon' => esc_html__( 'Icon', 'rtelements' ),
                    'image' => esc_html__( 'Image', 'rtelements' ),
                    'number' => esc_html__( 'Number', 'rtelements' ),
                ],
                'default' => 'none',
            ]
        );

        $repeater->add_control(
            'tab_icon',
            [
                'label' => esc_html__( 'Icon', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'condition' => [
                    'tab_title_icon_image_type' => 'icon',
                ],
            ]
        );

        $repeater->add_control(
            'tab_image',
            [
                'label' => esc_html__( 'Image', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tab_title_icon_image_type' => 'image',
                ],
            ]
        );

        $repeater->add_control(
            'tab_number',
            [
                'label' => esc_html__( 'Number', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '01', 'rtelements' ),
                'condition' => [
                    'tab_title_icon_image_type' => 'number',
                ],
            ]
        );

        $repeater->add_control(
            'content_source',
            [
                'label' => esc_html__( 'Content Source', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'default' => esc_html__( 'Default', 'rtelements' ),
                    'template' => esc_html__( 'Template', 'rtelements' ),
                ],
                'default' => 'default',
            ]
        );

        $repeater->add_control(
            'content_template',
            [
                'label' => esc_html__( 'Select Template', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $this->get_eligible_templates(),
                'condition' => [
                    'content_source' => 'template',
                ],
            ]
        );

        $repeater->add_control(
            'content_title',
            [
                'label' => esc_html__( 'Content Title', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Your Title Here', 'rtelements' ),
                'label_block' => true,
                'condition' => [
                    'content_source' => 'default',
                ],
            ]
        );

        $repeater->add_control(
            'content_description',
            [
                'label' => esc_html__( 'Description', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'Your description here.', 'rtelements' ),
                'condition' => [
                    'content_source' => 'default',
                ],
            ]
        );

        $repeater->add_control(
			'content_image',
			[
				'label' => esc_html__( 'Choose Image', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
                 'condition' => [
                    'content_source' => 'default',
                ],
			]
		);

        $repeater->add_control(
            'read_more_text',
            [
                'label' => esc_html__( 'Button Text', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Let’s find out', 'rtelements' ),
                'condition' => [
                    'content_source' => 'default',
                ],
            ]
        );

        $repeater->add_control(
            'read_more_link',
            [
                'label' => esc_html__( 'Button URL', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://your-link.com',
                'condition' => [
                    'content_source' => 'default',
                ],
            ]
        );

        $this->add_control(
            'tabs',
            [
                'label' => esc_html__( 'Tabs Items', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tab_title' => 'Tab 1',
                        'content_title' => 'Content Title 1',
                        'content_description' => 'Description for tab 1.',
                        'content_image' => [
                            'url' => ''
                        ],
                        'read_more_text' => 'Read More',
                        'read_more_link' => ['url' => '#'],
                    ],
                    [
                        'tab_title' => 'Tab 2',
                        'content_title' => 'Content Title 2',
                        'content_description' => 'Description for tab 2.',
                        'read_more_text' => 'Read More',
                        'read_more_link' => ['url' => '#'],
                    ],
                    [
                        'tab_title' => 'Tab 3',
                        'content_title' => 'Content Title 3',
                        'content_description' => 'Description for tab 3.',
                        'content_image' => [
                            'url' => ''
                        ],
                        'read_more_text' => 'Read More',
                        'read_more_link' => ['url' => '#'],
                    ],
                    [
                        'tab_title' => 'Tab 4',
                        'content_title' => 'Content Title 4',
                        'content_description' => 'Description for tab 4.',
                        'content_image' => [
                            'url' => ''
                        ],
                        'read_more_text' => 'Read More',
                        'read_more_link' => ['url' => '#'],
                    ],
                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );       

        $this->end_controls_section();


        $this->start_controls_section(
            'tabs_nav_section',
            [
                'label' => esc_html__( 'Tab Title Settings', 'rtelements' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'tab_nav_position',
            [
                'label' => esc_html__( 'Position', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'default' => 'top',
                'options' => [                    
                    'start' => [
                        'title' => esc_html__( 'Left', 'rtelements' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'rtelements' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => esc_html__( 'Right', 'rtelements' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                    'stretch' => [
                        'title' => esc_html__( 'stretch', 'rtelements' ),
                        'icon'  => 'eicon-text-align-justify',
                    ],
                ],
                'toggle' => false,
                'selectors' => [
					'{{WRAPPER}} .ee-tab-titles' => 'justify-content: {{VALUE}};',
				],
            ]
        );

        $this->add_responsive_control(
            'tab_icon_position',
            [
                'label' => esc_html__( 'Icon Position', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'default' => 'top',
                'options' => [                    
                    'left' => [
                        'title' => esc_html__( 'Left', 'rtelements' ),
                        'icon'  => 'eicon-h-align-left',
                    ],
                    'top' => [
                        'title' => esc_html__( 'Top', 'rtelements' ),
                        'icon'  => 'eicon-v-align-top',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'rtelements' ),
                        'icon'  => 'eicon-h-align-right',
                    ],
                ],
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'tab_layout_direction',
            [
                'label' => esc_html__( 'Layout', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'default' => 'top',
                'options' => [                    
                    'left' => [
                        'title' => esc_html__( 'Left', 'rtelements' ),
                        'icon'  => 'eicon-h-align-left',
                    ],
                    'top' => [
                        'title' => esc_html__( 'Top', 'rtelements' ),
                        'icon'  => 'eicon-v-align-top',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'rtelements' ),
                        'icon'  => 'eicon-h-align-right',
                    ],
                ],
                'toggle' => false,
            ]
        );

        $this->end_controls_section();

        // Style Tab - Tab Titles
         $this->start_controls_section(
            'tab_title_parts_style',
            [
                'label' => esc_html__( 'Titles Part', 'rtelements' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'tab_layout_direction' => 'top'
                ]
            ]
        );

        $this->add_control(
			't_part_max_wrap',
			[
				'label' => esc_html__( 'Max Content Wrap', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_responsive_control(
            'tab_title_space',
            [
                'label' => esc_html__( 'Bottom Spacing', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 6,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ee-tabs-wrapper[data-tab-direction="top"] .ee-tab-titles' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_title_mid_space',
            [
                'label' => esc_html__( 'Middle Spacing', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ee-tabs-wrapper[data-tab-direction="top"] .ee-tab-titles' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tab_title_bottom_border',
                'selector' => '{{WRAPPER}} .ee-tabs-wrapper[data-tab-direction="top"] .ee-tab-titles',
            ]
        );
        
        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'tab_t_part_box_shadow',
				'selector' => '{{WRAPPER}} .ee-tabs-wrapper[data-tab-direction="top"] .ee-tab-titles',
			]
		);
        
        $this->add_control(
            'tab_title_bottom_radius',
            [
                'label' => esc_html__( 'Border Radius', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-tabs-wrapper[data-tab-direction="top"] .ee-tab-titles' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'tab_title_style_section',
            [
                'label' => esc_html__( 'Tab Titles', 'rtelements' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'tab_title_colors' );

        $this->start_controls_tab(
            'tab_title_normal',
            [
                'label' => esc_html__( 'Normal', 'rtelements' ),
            ]
        );

        $this->add_control(
            'tab_title_color',
            [
                'label' => esc_html__( 'Text Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-title-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tab_title_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-titles li' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tab_title_typography',
                'selector' => '{{WRAPPER}} .ee-tab-title-text',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tab_title_border',
                'selector' => '{{WRAPPER}} .ee-tab-titles li',
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'tab_title_box_shadow',
				'selector' => '{{WRAPPER}} .ee-tab-titles li',
			]
		);

        $this->add_control(
            'tab_title_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-titles li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_title_padding',
            [
                'label' => esc_html__( 'Padding', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-titles li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tab_title_margin',
            [
                'label' => esc_html__( 'Margin', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-titles li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'tab_icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-titles i, {{WRAPPER}} .ee-tab-titles svg' => 'color: {{VALUE}}; fill: {{VALUE}}',
                ],
                'description' => esc_html__( 'Only works when "Icon" is selected as icon type. 😊', 'rtelements' ),
            ]
        );

        $this->add_control(
            'tab_icon_bg_color',
            [
                'label' => esc_html__( 'Icon/image Bg Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-image, {{WRAPPER}} .ee-tab-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );    
        
        $this->add_control(
            'tab_number_heading',
            [
                'label' => esc_html__( 'Number', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'tab_number_color',
            [
                'label' => esc_html__( 'Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-titles .ee-tab-number' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tab_number_typography',
                'selector' => '{{WRAPPER}} .ee-tab-titles .ee-tab-number',
            ]
        );

        $this->add_control(
            'tab_number_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-titles .ee-tab-number' => 'background-color: {{VALUE}}',
                ],
            ]
        );   
        
        $this->add_control(
            'subtitle_heading',
            [
                'label' => esc_html__( 'Subtitle', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'tab_subtitle_color',
            [
                'label' => esc_html__( 'Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-title-text .subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tab_subtitle_typography',
                'selector' => '{{WRAPPER}} .ee-tab-title-text .subtitle',
            ]
        );

         $this->add_responsive_control(
            'tab_subtitle_margin',
            [
                'label' => esc_html__( 'Margin', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-title-text .subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_title_active',
            [
                'label' => esc_html__( 'Active', 'rtelements' ),
            ]
        );

        $this->add_control(
            'tab_title_active_color',
            [
                'label' => esc_html__( 'Text Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-titles li.active .ee-tab-title-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tab_title_active_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-titles li.active' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tab_title_active_border_color',
            [
                'label' => esc_html__( 'Border Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-titles li.active' => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'tab_title_border_border!' => '',
                ],
            ]
        );

        $this->add_control(
            'tab_subtitle_active_color',
            [
                'label' => esc_html__( 'Subtitle Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-titles li.active .ee-tab-title-text .subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // Style Tab - Tab Contents
        $this->start_controls_section(
            'tab_content_style_section',
            [
                'label' => esc_html__( 'Tab Contents', 'rtelements' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_title_heading',
            [
                'label' => esc_html__( 'Title', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_title_typography',
                'selector' => '{{WRAPPER}} .ee-content-title',
            ]
        );

        $this->add_control(
            'content_title_color',
            [
                'label' => esc_html__( 'Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-content-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_title_margin',
            [
                'label' => esc_html__( 'Margin', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-content-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_description_heading',
            [
                'label' => esc_html__( 'Description', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_description_typography',
                'selector' => '{{WRAPPER}} .ee-content-description',
            ]
        );

        $this->add_control(
            'content_description_color',
            [
                'label' => esc_html__( 'Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-content-description' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_description_margin',
            [
                'label' => esc_html__( 'Margin', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-content-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'img_heading',
            [
                'label' => esc_html__( 'Image', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

         $this->add_responsive_control(
            'img_width',
            [
                'label' => esc_html__( 'With', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-content-image' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'img_radius',
            [
                'label' => esc_html__( 'Border Radius', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-content-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'img_margin',
            [
                'label' => esc_html__( 'Margin', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-content-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'read_more_btn_heading',
            [
                'label' => esc_html__( 'Read More', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'read_more_btn_typography',
                'selector' => '{{WRAPPER}} .ee-read-more',
            ]
        );

        $this->start_controls_tabs( 'read_more_btn_colors' );

        $this->start_controls_tab(
            'read_more_btn_normal',
            [
                'label' => esc_html__( 'Normal', 'rtelements' ),
            ]
        );

        $this->add_control(
            'read_more_btn_color',
            [
                'label' => esc_html__( 'Text Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-read-more' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'read_more_btn_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-read-more' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'read_more_btn_hover',
            [
                'label' => esc_html__( 'Hover', 'rtelements' ),
            ]
        );

        $this->add_control(
            'read_more_btn_hover_color',
            [
                'label' => esc_html__( 'Text Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-read-more:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'read_more_btn_hover_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-read-more:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'read_more_btn_hover_border_color',
            [
                'label' => esc_html__( 'Border Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-read-more:hover' => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'read_more_btn_border_border!' => '',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'read_more_btn_border',
                'selector' => '{{WRAPPER}} .ee-read-more',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'read_more_btn_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-read-more' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'read_more_btn_padding',
            [
                'label' => esc_html__( 'Padding', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-read-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'read_more_btn_margin',
            [
                'label' => esc_html__( 'Margin', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-read-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_area_heading',
            [
                'label' => esc_html__( 'Content Part', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'content_area_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-content' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'content_area_border',
                'selector' => '{{WRAPPER}} .ee-tab-content',
            ]
        );

        $this->add_control(
            'content_area_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_area_padding',
            [
                'label' => esc_html__( 'Padding', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_area_margin',
            [
                'label' => esc_html__( 'Margin', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .ee-tab-content, {{WRAPPER}} .ee-tabs-wrapper[data-tab-direction="top"] .ee-tab-contents .ee-tab-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    private function get_eligible_templates() {
        $templates = [];

        $posts = get_posts([
            'post_type' => 'elementor_library',
            'posts_per_page' => -1,
            'post_status' => 'publish',
        ]);

        foreach ( $posts as $post ) {
            $templates[ $post->ID ] = $post->post_title;
        }

        return $templates;
    }

    protected function render() {
        $settings        = $this->get_settings_for_display();
        $direction       = ! empty( $settings['tab_layout_direction'] ) ? $settings['tab_layout_direction'] : 'left';
        $icon_position   = isset( $settings['tab_icon_position'] ) ? $settings['tab_icon_position'] : 'top';
        $t_part_max_wrap = ( $settings['t_part_max_wrap'] === 'yes' ) ? 'max-content-wrap' : '';
        $nav_position    = !empty($settings['tab_nav_position']) ? $settings['tab_nav_position'] : '';
       
        if ( ! empty( $settings['tabs'] ) ) {
            echo '<div class="ee-tabs-wrapper" data-tab-direction="' . esc_attr( $settings['tab_layout_direction'] ) . '" data-icon-position="' . esc_attr( $icon_position ) . '">';
            echo '<ul class="ee-tab-titles '. $t_part_max_wrap .' '. $nav_position .'">';
            foreach ( $settings['tabs'] as $index => $item ) {
                 $subtitle = ! empty( $item['tab_subtitle'] ) ? ' <span class="subtitle">' . esc_html( $item['tab_subtitle'] ) . '</span>' : '';
                echo '<li data-tab="ee-tab-' . esc_attr( $index ) . '">';
                if ( isset( $item['tab_title_icon_image_type'] ) ) {
                    if ( $item['tab_title_icon_image_type'] === 'icon' && ! empty( $item['tab_icon']['value'] ) ) {
                        echo '<span class="ee-tab-icon">';
                        \Elementor\Icons_Manager::render_icon( $item['tab_icon'], [ 'aria-hidden' => 'true' ] );
                        echo '</span>';
                    } elseif ( $item['tab_title_icon_image_type'] === 'image' && ! empty( $item['tab_image']['url'] ) ) {
                        echo '<span class="ee-tab-image">';
                        echo '<img src="' . esc_url( $item['tab_image']['url'] ) . '" alt="">';
                        echo '</span>';
                    }
                    elseif ( $item['tab_title_icon_image_type'] === 'number' && ! empty( $item['tab_number'] ) ) {
                        echo '<span class="ee-tab-number">' . wp_kses_post( $item['tab_number'] ) . '</span>';
                    }
                }
                echo '<span class="ee-tab-title-text">' . esc_html( $item['tab_title'] ) . $subtitle . '</span>';

                echo '</li>';
            }
            echo '</ul>';
            echo '<div class="ee-tab-contents">';

            foreach ( $settings['tabs'] as $index => $item ) {
                echo '<div class="ee-tab-content" id="ee-tab-' . $index . '">';
                if ( isset( $item['content_source'] ) && $item['content_source'] === 'template' && ! empty( $item['content_template'] ) ) {
                    echo \Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $item['content_template'] );
                } else {

                    if ( ! empty( $item['content_title'] ) ) {
                        echo '<h4 class="ee-content-title">' . esc_html( $item['content_title'] ) . '</h4>';
                    }

                    if ( ! empty( $item['content_description'] ) ) {
                        echo '<p class="ee-content-description">' . esc_html( $item['content_description'] ) . '</p>';
                    }

                    if ( ! empty( $item['content_image']['url'] ) ) {
                        echo '<img class="ee-content-image" src="' . esc_url( $item['content_image']['url'] ) . '" />';
                    }

                    if ( ! empty( $item['read_more_text'] ) && ! empty( $item['read_more_link']['url'] ) ) {
                        echo '<a aria-label="Tab Button" class="ee-read-more" href="' . esc_url( $item['read_more_link']['url'] ) . '" target="' . esc_attr( $item['read_more_link']['is_external'] ? '_blank' : '_self' ) . '">' . esc_html( $item['read_more_text'] ) . ' <i class="unicon-chevron-right"> </i> </a>';
                    }
                }

                echo '</div>';
            }

            echo '</div>';
            echo '</div>';
        }
    }
}
?>