<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\register_controls;

defined('ABSPATH') || die();

class ReacTheme_Services_Slider_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'rt-services-slider';
    }

	public function get_style_depends() {
		wp_register_style( 'service-slider-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'service-slider-style'
		];
	}
	
    public function get_title()
    {
        return __('RT Services Slider', 'rtelements');
    }

    public function get_icon()
    {
        return 'rt-e-icon';
    }

    public function get_categories()
    {
        return ['pielements_category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_sections',
            [
                'label' => esc_html__('Service Settings', 'rtelements'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'slider_style',
			[
				'label'   => esc_html__('Slider Style', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => esc_html__('Style 1', 'rtelements'),

				],
			]
		);

      $repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'rt rt-icon-check',
					'library' => 'rt-icons',
				],
				'recommended' => [
					'fa-solid' => [
						'circle',
						'dot-circle',
						'square-full',
					],
					'fa-regular' => [
						'circle',
						'dot-circle',
						'square-full',
					],
				],
			]
		);

		$repeater->add_control(
			'name',
			[
				'label' => esc_html__( 'Title', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Strategy & Planning' , 'rtelements' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'des',
			[
				'label' => esc_html__( 'Content', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Sagitis himos pulvinar morb socis laoreet posuere enim non auctor etiam pretium libero' , 'rtelements' ),
				'show_label' => false,
			]
		); 

      $repeater->add_control(
			'button',
			[
				'label' => esc_html__( 'Button', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Explore More' , 'rtelements' ),
				'show_label' => true,
			]
		); 

      $repeater->add_control(
			'link',
			[
				'label' => esc_html__( 'URL', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::URL,
				'default' => array(
					'url' => '#'
				),
				'placeholder' => esc_html__( 'Insert your link here', 'rtelements' ),
			]
		);

		$repeater->add_control(
			'btn_icon',
			[
				'label' => esc_html__( 'Icon', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'rt rt-arrow-right-regular',
					'library' => 'rt-icons',
				],
			]
		);

		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Services List', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'name' => esc_html__( 'Business Goal', 'rtelements' ),
						'des' => esc_html__( 'Sagitis himos pulvinar morb socis laoreet posuere enim non auctor etiam pretium libero', 'rtelements' ),
                  'button' => esc_html__( 'Read More', 'rtelements' ),
						'link' => [ 'url' => '#' ],
					],
				],
				'title_field' => '{{{ name }}}',
			]
		);              
		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__(' Title HTML Tag', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('span', 'rtelements'),

				],
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
           'slider__part_section',
           [
               'label' => esc_html__( 'Slider Settings', 'rtelements' ),
               'tab' => Controls_Manager::TAB_CONTENT,
           ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__( 'Loop', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'rtelements' ),
                'label_off' => esc_html__( 'No', 'rtelements' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

       $this->add_control(
       'autoplay',
       [
           'label' => esc_html__('Autoplay', 'rtelements'),
           'type' => \Elementor\Controls_Manager::SWITCHER,
           'label_on' => esc_html__('On', 'rtelements'),
           'label_off' => esc_html__('Off', 'rtelements'),
           'return_value' => 'yes',
           'default' => '',
       ]
        );

        $this->add_control(
          'autoplay_delay',
          [
              'label' => esc_html__('Autoplay Delay (ms)', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'default' => 3000,
          ]
        );

        // Speed
        $this->add_control(
            'speed',
            [
                'label' => esc_html__('Speed (ms)', 'rtelements'),
                'type' => Controls_Manager::NUMBER,
                'default' => 900,
            ]
        );

        $this->add_control(
            'centered_slides',
            [
                'label' => esc_html__('Centered Slides', 'rtelements'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
                'label_off' => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        $this->add_control(
            'free_mode',
            [
                'label' => esc_html__('Free Mode', 'rtelements'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
                'label_off' => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

       $this->add_control(
          'slides_per_view',
          [
              'label' => esc_html__('Slides Per View', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'default' => 3,
          ]
       );

       $this->add_control(
         'slides_per_view_tablet',
         [
             'label' => esc_html__('Slides Per View (Tablet)', 'rtelements'),
             'type' => \Elementor\Controls_Manager::NUMBER,
             'default' => 2,
         ]
       );

       $this->add_control(
         'slides_per_view_mobile',
         [
             'label' => esc_html__('Slides Per View (Mobile)', 'rtelements'),
             'type' => \Elementor\Controls_Manager::NUMBER,
             'default' => 1,
         ]
       );

       $this->add_control(
          'space_between',
          [
              'label' => esc_html__('Space Between (px)', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'default' => 20,
          ]
       );

       $this->add_control(
           'pagination',
           [
               'label' => esc_html__('Pagination', 'rtelements'),
               'type' => \Elementor\Controls_Manager::SELECT,
               'default' => 'bullets',
               'options' => [
                   'none' => esc_html__('None', 'rtelements'),
                   'bullets' => esc_html__('Bullets', 'rtelements'),
                   'fraction' => esc_html__('Fraction', 'rtelements'),
                   'progressbar' => esc_html__('Progressbar', 'rtelements'),
               ],
           ]
       );
		 
		$this->add_responsive_control(
			'pagination_top_spacing',
			[
				'label' => esc_html__( 'Position (Y)', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction']
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'top: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);	

		$this->add_control(
			'pagination_color',
			[
				'label' => esc_html__( 'Pagination Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-progressbar' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-fraction' => 'color: {{VALUE}}',
					
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction', 'progressbar']
				],
			]
		); 

		$this->add_control(
			'pagination_active_color',
			[
				'label' => esc_html__( 'Pagination Active Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-progressbar-fill' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-fraction .swiper-pagination-current' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active::before' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction', 'progressbar']
				],
			]
		); 

		$this->add_control(
			'pagination_bordercolor',
			[
				'label' => esc_html__( 'Pagination Border Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active::before' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'pagination' => ['bullets']
				],
			]
		);

      $this->add_control(
           'navigation',
           [
               'label' => esc_html__('Navigation Arrows', 'rtelements'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => esc_html__('Show', 'rtelements'),
               'label_off' => esc_html__('Hide', 'rtelements'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
       );
		 
		 $this->add_control(
			'navigation_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev' => 'color: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next' => 'color: {{VALUE}}',					
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);
        
      $this->add_control(
			'navigation_hover_color',
			[
				'label' => esc_html__( 'Hover Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev:hover' => 'color: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next:hover' => 'color: {{VALUE}}',						
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);

      $this->add_control(
			'navigation_bgcolor',
			[
				'label' => esc_html__( 'Background Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev' => 'background-color: {{VALUE}} !important; border-color: {{VALUE}} !important;',
					'{{WRAPPER}} .swiper-next' => 'background-color: {{VALUE}} !important; border-color: {{VALUE}} !important;',			
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);
        
      $this->add_control(
			'navigation_hover_bgcolor',
			[
				'label' => esc_html__( 'Hover Background Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev:hover' => 'background: {{VALUE}} !important; border-color: {{VALUE}} !important;',
					'{{WRAPPER}} .swiper-next:hover' => 'background: {{VALUE}} !important; border-color: {{VALUE}} !important;',		
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);

		$this->add_responsive_control(
			'navigation_top_position',
			[
				'label' => esc_html__( 'Position (Y)', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
                    'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],					
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'navigation' => 'yes',   
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-navigaiton .swiper-prev' => 'top: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .swiper-navigaiton .swiper-next' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);	
      $this->end_controls_section();		  
        
        $this->start_controls_section(
            '_section_styles',
            [
                'label' => esc_html__( 'Item', 'rtelements' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );   

		$this->start_controls_tabs( 'item_style_tabs' );

		$this->start_controls_tab(
			'item_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'rtelements' ),
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'item_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .item',
			]
		);	

      $this->add_responsive_control(
			'item_padding',
			[
				'label' => esc_html__( 'Padding', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	
		$this->end_controls_tab();

		$this->start_controls_tab(
			'item__active_tab',
			[
				'label' => esc_html__( 'Active', 'rtelements' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'item_active_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .swiper-slide-active .item',
			]
		);	

      $this->add_responsive_control(
			'item_active_padding',
			[
				'label' => esc_html__( 'Padding', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-slide-active .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section(
				'icon_styles',
				[
					'label' => esc_html__( 'Icon', 'rtelements' ),
					'tab' => Controls_Manager::TAB_STYLE,
				]
		);	
        $this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 120,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .icon svg' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);      
      $this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon svg path' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .icon i' => 'color: {{VALUE}}',
				],
			]
		);    
      $this->end_controls_section();
        
      $this->start_controls_section(
            'title_styles',
            [
               'label' => esc_html__( 'Title', 'rtelements' ),
               'tab' => Controls_Manager::TAB_STYLE,					
            ]
        );	
        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);    
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'rtelements'),
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .title',
				'fields_options' => [
					'font_size' => [
						'selectors' => [
							'{{WRAPPER}} .title' => 'font-size: {{SIZE}}{{UNIT}} !important;',
						],
					],
				],
			]
		);   
      $this->end_controls_section();

        $this->start_controls_section(
            'description_styles',
            [
                'label' => esc_html__( 'Description', 'rtelements' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );	
        $this->add_control(
			'description_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .disc' => 'color: {{VALUE}} !important',
				],
			]
		);    		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'rtelements'),
				'name'     => 'description_typography',
				'selector' => '{{WRAPPER}} .disc',
				'fields_options' => [
					'font_size' => [
						'selectors' => [
							'{{WRAPPER}} .disc' => 'font-size: {{SIZE}}{{UNIT}} !important;',
						],
					],
				],
			]
		); 
      $this->end_controls_section();

      $this->start_controls_section(
			'button_styles',
			[
				'label' => esc_html__( 'Button', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,	
			]
		);	
        $this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .button' => 'color: {{VALUE}}',
				],
			]
		);        
      $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'rtelements'),
				'name'     => 'btn_typography',
				'selector' => '{{WRAPPER}} .button',
				'fields_options' => [
					'font_size' => [
						'selectors' => [
							'{{WRAPPER}} .button' => 'font-size: {{SIZE}}{{UNIT}} !important;',
						],
					],
				],
			]
		);   
		
		$this->add_control(
			'button_icon_style',
			[
				'label' => esc_html__( 'Icon Style', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);   
		$this->start_controls_tabs(
			'btn_icon_style_tabs'
		);

		$this->start_controls_tab(
			'btnicon_style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'rtelements' ),
			]
		);
		$this->add_control(
			'button_icon_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .button i' => 'color: {{VALUE}}',
				],
			]
		); 

      $this->add_control(
			'button_icon_bgcolor',
			[
				'label' => esc_html__( 'Background', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .button i' => 'background: {{VALUE}}',
				],
			]
		);  
		$this->end_controls_tab();

		$this->start_controls_tab(
			'btn_icon_active_style_tab',
			[
				'label' => esc_html__( 'Active', 'rtelements' ),
			]
		);
		
      $this->add_control(
			'active_btn_icon_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-slide-active .button i' => 'color: {{VALUE}}',
				],
			]
		); 

      $this->add_control(
			'active_btn_icon_bgcolor',
			[
				'label' => esc_html__( 'Background', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-slide-active .button i' => 'background: {{VALUE}}',
				],
			]
		); 
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
     
    }
	 
    protected function render(){
        $settings    = $this->get_settings_for_display();
		  $style 		= $settings['slider_style'];
        if ( empty($settings['list'] )) {
            return;
        }
        static $instance = 0;
        $instance++;
        $unique_id = 'swiper-' . $instance;
        $settings = $this->get_settings_for_display();
        $data_loop = $settings['loop'] === 'yes' ? 'true' : 'false';
        $data_autoplay = ($settings['autoplay'] === 'yes' || $settings['autoplay'] === true) ? 'true' : 'false';
        $data_navigation = ($settings['navigation'] === 'yes' || $settings['navigation'] === true) ? 'true' : 'false';

        $slider_data_attributes = sprintf(
            'data-loop="%s" 
            data-autoplay="%s" 
            data-speed="%s" 
            data-centered-slides="%s" 
            data-autoplay-delay="%s" 
            data-free-mode="%s" 
            data-slides-per-view="%s" 
            data-space-between="%s" 
            data-slides-per-view-tablet="%s" 
            data-slides-per-view-mobile="%s" 
            data-pagination="%s" 
            data-navigation="%s"',
            esc_attr($settings['loop']) === 'yes' ? 'true' : 'false',
            esc_attr($data_autoplay),
            esc_attr($settings['speed']),
            $settings['centered_slides'] === 'yes' ? 'true' : 'false',
            esc_attr($settings['autoplay_delay']),
            $settings['free_mode'] === 'yes' ? 'true' : 'false',
            esc_attr($settings['slides_per_view']),
            esc_attr($settings['space_between']),
            esc_attr($settings['slides_per_view_tablet']),
            esc_attr($settings['slides_per_view_mobile']),
            esc_attr($settings['pagination']),
            esc_attr($data_navigation)
        );

        ?>
       
        	<div class="rt-slider">
            <div id="<?php echo esc_attr($unique_id); ?>" class="swiper rt-all-slider" <?php echo $slider_data_attributes; ?>>
               <div class="swiper-wrapper">
						<?php 
						foreach( $settings['list'] as $items ) :     
							$title = !empty($items['name']) ? $items['name'] : '';
							$des = !empty($items['des']) ? $items['des'] : '';
							$button = !empty($items['button']) ? $items['button'] : ''; 
							$link = !empty($items['link']['url']) ? $items['link']['url'] : '#'; 
							$title_tag = !empty($settings['title_tag']) ? esc_attr($settings['title_tag']) : 'h3'; 
					
							if ( $style == $style ) {
								require plugin_dir_path(__FILE__)."/$style.php";
							}
							
						endforeach; ?>                    
					</div>
					<?php 
					if ( $settings['navigation'] === 'yes' ) : ?>
						<div class="swiper-navigaiton">
							<span class="swiper-prev"><i class="rt rt-arrow-left"></i></span>
							<span class="swiper-next"><i class="rt rt-arrow-right"></i></span>
						</div>
						<?php
					endif; 
					if ( $settings['pagination'] !== 'none' ) : ?>
							<div class="swiper-pagination"><span class="swiper-pagination"></span></div>
						<?php 
					endif; ?>
				</div>
			</div>  
        <?php 
    }
} ?>