<div class="service-grid-2 item ">
   <?php 
   foreach( $settings['repeater_items'] as $items ) :    
		$des_hidden = ( $items['des_2_hide'] === 'yes' ) ? 'des_hidden_yes' : '';
   ?>
      <div class="single-item <?php echo esc_attr( $des_hidden ); ?>" style="background-image: url('<?php echo esc_url($items['image_2']['url']); ?>');">
         <div class="left-side">
            <?php 
            if( !empty( $items['icon_2']['value'] ) ) : ?>
               <div class="icon">
                  <?php \Elementor\Icons_Manager::render_icon( $items['icon_2'], [ 'aria-hidden' => 'true' ] ); ?>
               </div>
               <?php 
            else : ?>
               <div class="icon">
                  <i class="rt rt-icon-check"></i>
               </div>
            <?php 
         endif;
            if( !empty( $items['title_2'] ) ) : ?>
               <<?php echo esc_attr( $settings['title_tag'] ); ?> class="title">
                  <?php echo wp_kses_post( $items['title_2'] ); ?>
               </<?php echo esc_attr( $settings['title_tag'] ); ?>>
               <?php
            endif;  ?>
         </div>
         <div class="right">
            <?php
            if( !empty( $items['des_2'] ) ) : ?>
               <p class="des"><?php echo wp_kses_post( $items['des_2'] ); ?></p>
               <?php 
            endif; ?>
            <a aria-label="service button" href="<?php echo esc_url( $items['button_url_2']['url'] ); ?>" class="button">
               <i class="rt-arrow-right-regular"></i>
            </a>
         </div>
      </div>
      <?php 
   endforeach; ?>
</div>

