<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Reactheme_Elementor_Search_Widget extends Widget_Base {

	public function get_name() {
		return 'eel-search';
	}

	public function get_title() {
		return __( 'RT Search', 'rtelements' );
	}

	public function get_icon() {
		return 'rt-e-icon';
	}

	public function get_categories() {
		return [ 'pielements_category' ];
	}

	protected function register_controls() {

	    $this->start_controls_section(
	        'content_section',
	        [
	            'label' => esc_html__('Search Settings', 'rtelements'),
	            'tab' => Controls_Manager::TAB_CONTENT,
	        ]
	    );

	    $this->add_control(
	        'search_placeholder',
	        [
	            'label' => esc_html__('Search Placeholder', 'rtelements'),
	            'type' => Controls_Manager::TEXT,
	            'default' => esc_html__('Type to search...', 'rtelements'),
	        ]
	    );

	    $this->add_control(
	        'open_icon',
	        [
	            'label' => esc_html__('Search Icon', 'rtelements'),
	            'type' => \Elementor\Controls_Manager::ICONS,
	            'default' => [
	                'value' => 'fas fa-search',
	                'library' => 'fa-solid',
	            ],
	        ]
	    );

	    $this->add_control(
	        'close_icon',
	        [
	            'label' => esc_html__('Close Icon', 'rtelements'),
	            'type' => \Elementor\Controls_Manager::ICONS,
	            'default' => [
	                'value' => 'fas fa-times', 
	                'library' => 'fa-solid', 
	            ],
	        ]
	    );
		 $this->end_controls_section();

		 $this->start_controls_section(
            'section_toggle_style',
            [
                'label'     => __('Icon', 'rtelements'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs('tabs_toggle_color');

        $this->start_controls_tab(
            'tab_toggle_normal',
            [
                'label' => __('Normal', 'rtelements'),
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label'     => __('Color', 'rtelements'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eel-search-open-btn i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .eel-search-open-btn svg path' => 'fill: {{VALUE}};',                 
                ],
            ]
        );

		  
			$this->add_control(
            'icon_bgcolor',
            [
                'label'     => __('Background', 'rtelements'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eel-search-open-btn' => 'background: {{VALUE}};',               
                ],
            ]
        );


        $this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Size', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 120,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .eel-search-open-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .eel-search-open-btn svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
			);
			$this->add_responsive_control(
				'box_width',
				[
						'label' => esc_html__('Box width', 'plugin-name'),
						'type' => \Elementor\Controls_Manager::SLIDER,
						'size_units' => ['px', '%'],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 100,
								'step' => 1,
							],
							'%' => [
								'min' => 0,
								'max' => 100,
							],
						],
						'selectors' => [
							'{{WRAPPER}} .eel-search-open-btn' => 'width: {{SIZE}}{{UNIT}};',
						],
				]
			);
			$this->add_responsive_control(
				'box_height',
				[
					'label' => esc_html__('Box Height', 'plugin-name'),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => ['px', '%'],
					'range' => [
						'px' => [
								'min' => 0,
								'max' => 100,
								'step' => 1,
						],
						'%' => [
								'min' => 0,
								'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .eel-search-open-btn' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'box_line-height',
				[
					'label' => esc_html__('Box Line Height', 'plugin-name'),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => ['px', '%'],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 1,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .eel-search-open-btn' => 'line-height: {{SIZE}}{{UNIT}};',
					],
				]
			);  

			$this->add_responsive_control(
				'icon_border_radius',
				[
					'label' => esc_html__('Border Radius', 'rtelements'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%'],
					'selectors' => [
						'{{WRAPPER}} .eel-search-open-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);          
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_toggle_hover',
            [
                'label' => __('Hover', 'rtelements'),
            ]
        );       
        
			$this->add_control(
            'icon_hover_color',
            [
                'label'     => __('Color', 'rtelements'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eel-search-open-btn:hover i' => 'color: {{VALUE}};',               
                    '{{WRAPPER}} .eel-search-open-btn:hover svg path' => 'fill: {{VALUE}};',               
                ],
            ]
        );

			$this->add_control(
            'icon_hover_bgcolor',
            [
                'label'     => __('Background', 'rtelements'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eel-search-open-btn:hover' => 'background: {{VALUE}};',               
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		 
		$this->start_controls_section(
			'content_styles',
			[
				'label' => esc_html__('Input Field', 'rtelements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'input_text_color',
			[
				'label'     => esc_html__('Color', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .eel-search-content .eel-search-field' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'input_focus_border_color',
			[
				'label'     => esc_html__('Focus Border Color', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .eel-search-content .eel-search-field:focus' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'input_bg_color',
			[
				'label'     => esc_html__('Background Color', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .eel-search-content .eel-search-field' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();

		// Submit Button Styles
		$this->start_controls_section(
			'submit_btn_styles',
			[
				'label' => esc_html__('Submit Button', 'rtelements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'submit_btn_color',
			[
				'label'     => esc_html__('Color', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .eel-search-content .eel-search-submit' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'submit_btn_hover_color',
			[
				'label'     => esc_html__('Hover Color', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .eel-search-content .eel-search-submit:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'submit_btn_bg_color',
			[
				'label'     => esc_html__('Background', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .eel-search-content .eel-search-submit' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'submit_btn_bg_hover_color',
			[
				'label'     => esc_html__('Hover Background', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .eel-search-content .eel-search-submit:hover' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();

		// Close Button Styles
		$this->start_controls_section(
			'close_btn_styles',
			[
				'label' => esc_html__('Close Button', 'rtelements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'close_btn_color',
			[
				'label'     => esc_html__('Color', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .eel-search-close-btn i'        => 'color: {{VALUE}};',
						'{{WRAPPER}} .eel-search-close-btn path'     => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'close_btn_hover_color',
			[
				'label'     => esc_html__('Hover Color', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .eel-search-close-btn:hover i'        => 'color: {{VALUE}};',
						'{{WRAPPER}} .eel-search-close-btn:hover svg path' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'close_btn_bg_color',
			[
				'label'     => esc_html__('Background', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .eel-search-close-btn' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'close_btn_bg_hover_color',
			[
				'label'     => esc_html__('Hover Background', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .eel-search-close-btn:hover' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();

		// Overlay
		$this->start_controls_section(
			'overlay_styles',
			[
				'label' => esc_html__('Overlay & Form Area', 'rtelements'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'content_bg',
			[
				'label'     => esc_html__('Content Background', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
						'{{WRAPPER}} .eel-search-content' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'     => 'overlay_background',
				'types'    => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .eel-search-lightbox, {{WRAPPER}} .eel-search-overlay',
			]
		);
		$this->end_controls_section();

	}


	protected function render() {
	    $settings = $this->get_settings_for_display();
	    ?>
	    <span class="eel-search-open-btn">
	        <?php \Elementor\Icons_Manager::render_icon( $settings['open_icon'], [ 'aria-hidden' => 'true' ] ); ?>
	    </span>
	    <div class="eel-search-lightbox">
	        <div class="eel-search-overlay">	            
	        </div>
	        <div class="eel-search-content">	
	            <form role="search" method="get" class="eel-search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	                <i class="eel-absl unicon-search"></i>
	                <input type="search" class="eel-search-field" placeholder="<?php echo esc_attr( $settings['search_placeholder'] ?? 'Type to search...' ); ?>" value="" name="s" />
	                <button type="submit" class="eel-search-submit" aria-label="Submit Search Button">
	                    <?php esc_html_e('Search', 'rtelements'); ?>
	                </button>
	            </form>
					<span class="eel-search-close-btn">
	                <?php \Elementor\Icons_Manager::render_icon( $settings['close_icon'], [ 'aria-hidden' => 'true' ] ); ?>
	            </span> 
	        </div>
	    </div>

	    <?php
	}
}
