<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

defined( 'ABSPATH' ) || die();

class Reactheme_Elementor_Progress_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'rt-progress-bar';
	}

	public function get_style_depends() {
		wp_register_style( 'progress-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'progress-style'
		];
	}

	public function get_title() {
		return esc_html__( 'RT Progress Bar', 'rtelements' );
	}

	public function get_icon() {
		return 'rt-e-icon';
	}

	public function get_categories() {
        return [ 'pielements_category' ];
    }

	protected function register_controls() {
		$this->start_controls_section(
			'section_progress',
			[
				'label' => esc_html__( 'Progress Bar', 'rtelements' ),
			]
		);

		$this->add_control(
			'select_style',
			[
				'label' => esc_html__( 'Select Style', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => esc_html__( 'Style 1', 'rtelements' ),
					'style2' => esc_html__( 'Style 2', 'rtelements' ),
				],
			]
		);		
		
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'rtelements' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_html__( 'Web Designer', 'rtelements' ),
				'default' => esc_html__( 'Web Designer', 'rtelements' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'percent',
			[
				 'label' => __( 'Percent', 'plugin-domain' ),
				 'type' => \Elementor\Controls_Manager::NUMBER,
				 'min' => 0,
				 'max' => 100,
				 'default' => 50,
			]
	  	);
		$this->end_controls_section();

		$this->start_controls_section(
			'rt_progress_style',
			[
				'label' => esc_html__( 'Progress', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'progress_color',
			[
				'label' => esc_html__( 'Progress Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-progress-bar .progress' => 'background: {{VALUE}}',
				],
				'condition' => [
					'select_style' => 'style1'
				]
			]
		);
		
		$this->add_control(
			'progress_bar_color',
			[
				'label' => esc_html__( 'Progress Bar Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-progress-bar .progress-bar' => 'background: {{VALUE}}',
				],
				'condition' => [
					'select_style' => 'style1'
				]
			]
		);

		// progress style 2 bg settings
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'progress_color',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .rt-progress-bar .progress',
				'condition' => [
					'select_style' => 'style2'
				]
			]
		);


		$this->add_control(
			'progress_height',
			[
				'label' => esc_html__( 'Height', 'rtelements' ),
				'type' => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .rt-progress-bar .progress' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'title_styles',
			[
				'label' => esc_html__( 'Title', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-progress-bar .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .rt-progress-bar .title',
			]
		);	
		$this->end_controls_section();

		$this->start_controls_section(
			'percent_styles',
			[
				'label' => esc_html__( 'Percent', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'percent_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-progress-bar .percent' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'percent_typography',
				'selector' => '{{WRAPPER}} .rt-progress-bar .percent',
			]
		);	
		$this->end_controls_section();
	}

	protected function render() {
	$settings = $this->get_settings_for_display();
	$percent = !empty($settings['percent']) ? rtrim($settings['percent']) : 0;
	$title = !empty($settings['title']) ? $settings['title'] : '';
	?>		
	<div class="rt-progress-bar">
		<?php 
		if( $settings['select_style'] == 'style2' ) : ?>
			<div class="progress-style2">
				<?php if ( $title ) : ?>
					<p class="title"><?php echo wp_kses_post( $title ); ?></p>
				<?php endif; ?>
				<div class="progress">
					<div class="progress-bar wow fadeInLeft" data-wow-duration="0.5s" data-wow-delay=".3s" role="progressbar" style="width: <?php echo esc_html( $percent ); ?>%" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100">
					</div>
					<span class="percent"><?php echo esc_html( $percent ); ?>%</span>
				</div>
			</div>
			<?php 
		else : ?>
			<div class="progress-top">
				<?php if ( $title ) : ?>
					<p class="title"><?php echo wp_kses_post( $title ); ?></p>
				<?php endif; ?>
				<?php if ( $percent ) : ?>
					<span class="percent"><?php echo esc_html( $percent ); ?>%</span>
				<?php endif; ?>
			</div>
			<div class="progress">
				<div class="progress-bar"
					style="width: 0%;" 
					aria-valuenow="<?php echo esc_attr( $percent ); ?>"
					aria-valuemin="0"
					aria-valuemax="100">
				</div>
			</div>
			<?php 
		endif; ?>
	</div>
	<?php
	}
}
