<?php
use Elementor\Repeater;
use Elementor\Controls_Manager;

defined( 'ABSPATH' ) || die();

class ReacTheme_Elementor_Parallax_Slider_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'rt-parallax-slider';
    }   

    public function get_title() {
        return __( 'RT Parallax Slider', 'rtelements' );
    }

    public function get_icon() {
        return 'rt-e-icon';
    }

    public function get_categories() {
        return [ 'pielements_category' ];
    }
    
    protected function register_controls() {            

        $this->start_controls_section(
            'general_section',
            [
                'label' => esc_html__( 'Blog Settings', 'rtelements' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );      
        
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'parallax_list_item',
            [
                'label' => esc_html__( 'Content', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => esc_html__( 'Welcome Parallax Slider', 'rtelements' ),
                'placeholder' => esc_html__( 'Insert your Data', 'rtelements' ),
            ]
        );

        $this->add_control(
            'parallax_list',
            [
                'label' => esc_html__( 'Parallax List', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'parallax_list_item' => esc_html__( 'Parallax Title', 'rtelements' ),
                    ],
                ],
                'title_field' => '{{{ parallax_list_item }}}',
            ]
        );
        $this->end_controls_section();       

        $this->start_controls_section(
           'slider___section',
           [
               'label' => esc_html__( 'Slider Settings', 'rtelements' ),
               'tab' => Controls_Manager::TAB_CONTENT,
           ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__( 'Loop', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'rtelements' ),
                'label_off' => esc_html__( 'No', 'rtelements' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
        'autoplay',
        [
           'label' => esc_html__('Autoplay', 'rtelements'),
           'type' => \Elementor\Controls_Manager::SWITCHER,
           'label_on' => esc_html__('On', 'rtelements'),
           'label_off' => esc_html__('Off', 'rtelements'),
           'return_value' => 'yes',
           'default' => '',
        ]
        );

        $this->add_control(
          'autoplay_delay',
          [
              'label' => esc_html__('Autoplay Delay (ms)', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'default' => 3000,
          ]
        );

        // Speed
        $this->add_control(
            'speed',
            [
                'label' => esc_html__('Speed (ms)', 'rtelements'),
                'type' => Controls_Manager::NUMBER,
                'default' => 900,
            ]
        );

        $this->add_control(
            'centered_slides',
            [
                'label' => esc_html__('Centered Slides', 'rtelements'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
                'label_off' => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->add_control(
            'free_mode',
            [
                'label' => esc_html__('Free Mode', 'rtelements'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
                'label_off' => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->add_control(
            'mouse_wheel',
            [
                'label' => esc_html__('Mouse Wheel', 'rtelements'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
                'label_off' => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->add_control(
            'effect',
            [
                'label' => esc_html__('Effect', 'rtelements'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'slide' => 'Slide',
                    'fade'  => 'Fade',
                ],
                'default' => 'slide',
            ]
        );

        $this->add_control(
          'slides_per_view',
          [
              'label' => esc_html__('Slides Per View', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'default' => 3,
          ]
        );

        $this->add_control(
         'slides_per_view_tablet',
         [
             'label' => esc_html__('Slides Per View (Tablet)', 'rtelements'),
             'type' => \Elementor\Controls_Manager::NUMBER,
             'default' => 2,
         ]
        );

        $this->add_control(
         'slides_per_view_mobile',
         [
             'label' => esc_html__('Slides Per View (Mobile)', 'rtelements'),
             'type' => \Elementor\Controls_Manager::NUMBER,
             'default' => 1,
         ]
        );

        $this->add_control(
          'space_between',
          [
              'label' => esc_html__('Space Between (px)', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'default' => 20,
          ]
        );

        $this->add_control(
           'pagination',
           [
               'label' => esc_html__('Pagination', 'rtelements'),
               'type' => \Elementor\Controls_Manager::SELECT,
               'default' => 'bullets',
               'options' => [
                   'none' => esc_html__('None', 'rtelements'),
                   'bullets' => esc_html__('Bullets', 'rtelements'),
                   'fraction' => esc_html__('Fraction', 'rtelements'),
                   'progressbar' => esc_html__('Progressbar', 'rtelements'),
               ],
           ]
        );

        $this->add_responsive_control(
			'pagination_top_spacing',
			[
				'label' => esc_html__( 'Top Spacing', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px', 'em', 'rem', 'custom' ],				
				'condition' => [
					'pagination' => ['bullets', 'fraction']
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);	

		$this->add_control(
			'pagination_color',
			[
				'label' => esc_html__( 'Pagination Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-progressbar' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-fraction' => 'color: {{VALUE}}',
					
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction', 'progressbar']
				],
			]
		); 

		$this->add_control(
			'pagination_active_color',
			[
				'label' => esc_html__( 'Pagination Active Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-progressbar-fill' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-fraction .swiper-pagination-current' => 'color: {{VALUE}}',
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction', 'progressbar']
				],
			]
		); 

        $this->add_control(
			'pagination_bordercolor',
			[
				'label' => esc_html__( 'Pagination Border Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active::before' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'pagination' => ['bullets']
				],
			]
		);
        
        $this->add_responsive_control(
			'pagination_alignments',
			[
				'label' => esc_html__( 'Alignment', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'text-align: {{VALUE}};',
				],                
				'condition' => [
					'pagination' => ['bullets', 'fraction']
				],
			]
		);

        $this->add_control(
           'navigation',
           [
               'label' => esc_html__('Navigation Arrows', 'rtelements'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => esc_html__('Show', 'rtelements'),
               'label_off' => esc_html__('Hide', 'rtelements'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
        );

        $this->add_control(
			'navigation_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev' => 'color: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next' => 'color: {{VALUE}}',					
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);
        
        $this->add_control(
			'navigation_hover_color',
			[
				'label' => esc_html__( 'Hover Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev:hover' => 'color: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next:hover' => 'color: {{VALUE}}',						
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);

        $this->add_control(
			'navigation_bgcolor',
			[
				'label' => esc_html__( 'Background Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev' => 'background: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next' => 'background: {{VALUE}}',					
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);
        
        $this->add_control(
			'navigation_hover_bgcolor',
			[
				'label' => esc_html__( 'Hover Background Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev:hover' => 'background: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next:hover' => 'background: {{VALUE}}',					
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);
        $this->end_controls_section();          
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        static $instance = 0;
        $instance++;
        $unique_id = 'swiper-' . $instance;
        $unique_id = 'swiper-' . uniqid();
        $data_loop = $settings['loop'] === 'yes' ? 'true' : 'false';
        $data_autoplay = ($settings['autoplay'] === 'yes' || $settings['autoplay'] === true) ? 'true' : 'false';
        $data_navigation = ($settings['navigation'] === 'yes' || $settings['navigation'] === true) ? 'true' : 'false';
        $slider_data_attributes = sprintf(
            'data-loop="%s" 
            data-autoplay="%s" 
            data-speed="%s" 
            data-centered-slides="%s" 
            data-autoplay-delay="%s" 
            data-free-mode="%s" 
            data-mousewheel="%s"
            data-effect="' . esc_attr($settings['effect']) . '"
            data-slides-per-view="%s" 
            data-space-between="%s" 
            data-slides-per-view-tablet="%s" 
            data-slides-per-view-mobile="%s" 
            data-pagination="%s" 
            data-navigation="%s"',
            esc_attr($settings['loop']) === 'yes' ? 'true' : 'false',
            esc_attr($data_autoplay),
            esc_attr($settings['speed']),
            $settings['centered_slides'] === 'yes' ? 'true' : 'false',
            esc_attr($settings['autoplay_delay']),
            $settings['free_mode'] === 'yes' ? 'true' : 'false',
            esc_attr($settings['mouse_wheel'] === 'yes' ? 'true' : 'false'),
            esc_attr($settings['slides_per_view']),
            esc_attr($settings['space_between']),
            esc_attr($settings['slides_per_view_tablet']),
            esc_attr($settings['slides_per_view_mobile']),
            esc_attr($settings['pagination']),
            esc_attr($data_navigation)
        );       

        ?> 
        <div id="<?php echo esc_attr( $unique_id ); ?>"  <?php echo $slider_data_attributes; ?>  class="swiper rt--slider rt-all-slider">
            <div class="swiper-wrapper">
                <?php if ( ! empty( $settings['parallax_list'] ) && is_array( $settings['parallax_list'] ) ) : ?>
                    <?php foreach ( $settings['parallax_list'] as $item ) : ?>                                
                        <div class="swiper-slide">	
                            <div class="parallax-item">
                                <h2><?php echo wp_kses_post( $item['parallax_list_item'] ); ?></h2>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
            <?php 
            if ( $settings['navigation'] === 'yes' ) : ?>
                <div class="swiper-navigaiton">
                    <span class="swiper-prev"><i class="rt rt-arrow-left"></i></span>
                    <span class="swiper-next"><i class="rt rt-arrow-right"></i></span>
                </div>
                <?php
            endif; 
            if ( $settings['pagination'] !== 'none' ) : ?>
                <div class="swiper-pagination"><span class="swiper-pagination"></span></div>
                <?php 
            endif; ?>	
        </div>  
    <?php
    }    
}?>