<?php
// marque 
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Utils;
defined('ABSPATH') || die();

class Reactheme_Elementor_Marque_Widget extends \Elementor\Widget_Base
{

	public function get_name()
	{
		return 'react-marque';
	}

	public function get_title()
	{
		return __('RT Marque', 'rtelements');
	}

	public function get_icon()
	{
		return 'glyph-icon flaticon-multimedia';
	}

	public function get_categories()
	{
		return ['rtelements_category'];
	}

	public function get_keywords()
	{
		return ['marque'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'section_counter',
			[
				'label' => esc_html__('Content', 'rtelements'),
			]
		);
		$this->add_control(
         'list',
         [
             'label' => esc_html__('Marquee Title', 'rtelements'),
             'type'  => \Elementor\Controls_Manager::REPEATER,
             'fields' => [
                 [
                     'name'        => 'list_title',
                     'label'       => esc_html__('Title', 'rtelements'),
                     'type'        => \Elementor\Controls_Manager::TEXTAREA,
                     'default'     => esc_html__('Reactheme Marquee Text', 'rtelements'),
                     'label_block' => true,
                 ],
             ],
             'default' => [
                 [
                     'list_title' => esc_html__('Reactheme Marquee Text', 'rtelements'),
                 ],
					  [
							'list_title' => esc_html__('Reactheme Marquee Text', 'rtelements'),
						],
						[
							'list_title' => esc_html__('Reactheme Marquee Text', 'rtelements'),
						],
						[
							'list_title' => esc_html__('Reactheme Marquee Text', 'rtelements'),
						],
             ],
            'title_field' => '{{{ list_title }}}',
         ]
     	);     
		$this->end_controls_section();

		$this->start_controls_section(
			'styles',
			[
				'label' => esc_html__('Style', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);		
		$this->add_control(
			'color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .marque-wrapper.one .marquee span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'selector' => '{{WRAPPER}} .marque-wrapper.one .marquee span',
			]
		);
		$this->add_responsive_control(
			'padding',
			[
				'label' => esc_html__( 'Padding', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .marque-wrapper.one .marquee span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'margin',
			[
				'label' => esc_html__( 'Margin', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .marque-wrapper.one .marquee span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$unique = rand(2012,35120);
	?>
		<div class="container-sss" dir="ltr">
			<div class="marque-wrapper one">
				<div class="marquee marquee<?php echo esc_attr($unique); ?>">
					<?php 
					foreach( $settings['list'] as $items ) : ?>
						<span><?php echo wp_kses_post($items['list_title']); ?></span>
						<?php 
					endforeach; ?>
				</div>
			</div>
		</div>
		<script>
			jQuery(document).ready(function () {
				let lastScrollY = window.scrollY;
				let marquee = document.querySelector('.marquee<?php echo esc_attr($unique); ?>');
				if (!marquee) return; // Ensure marquee exists before proceeding
				let position = 0; // Current position of the marquee text
				function updateMarqueeOnScroll() {
					const currentScrollY = window.scrollY;
					// Determine scroll direction
					position += (currentScrollY > lastScrollY) ? -4 : 4; // Adjust speed as needed					
					// Update marquee position
					marquee.style.transform = `translateX(${position}px)`;					
					lastScrollY = currentScrollY;
				}
				// Listen for scroll events with requestAnimationFrame for better performance
				window.addEventListener('scroll', () => requestAnimationFrame(updateMarqueeOnScroll));
			});
    	</script>
   <?php
	}
}