<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\register_controls;

defined('ABSPATH') || die();

class ReacThemes_Client_Logo_Widget extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'rt-client-logo';
    }

	public function get_style_depends() {
		wp_register_style( 'client-logo-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'client-logo-style'
		];
	}
	
    public function get_title()
    {
        return __('RT Client Logo', 'rtelements');
    }

    public function get_icon()
    {
        return 'rt-e-icon';
    }

    public function get_categories()
    {
        return ['pielements_category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_sections',
            [
                'label' => esc_html__('Content Settings', 'rtelements'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Logo', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
			'link',
			[
				'label' => esc_html__( 'URL', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'Insert your link here', 'rtelements' ),
				'default' => array(
					'url' => '#'
				),
			]
		);

		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Client Logo List', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'image' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                  
					],
				],
				'title_field' => '{{{ name }}}',
			]
		);  

        $this->add_responsive_control(
			'text_align',
			[
				'label' => esc_html__( 'Alignment', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
                'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .rt-client-logo .swiper-slide' => 'text-align: {{VALUE}};',
				],
			]
		);
        $this->add_control(
            'link_disable',
            [
                'label' => esc_html__('Link Disable', 'rtelements'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
                'label_off' => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
           'slider__part_section',
           [
               'label' => esc_html__( 'Slider Settings', 'rtelements' ),
               'tab' => Controls_Manager::TAB_CONTENT,
           ]
        );

        $this->add_control(
            'loop',
            [
                'label' => esc_html__( 'Loop', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'rtelements' ),
                'label_off' => esc_html__( 'No', 'rtelements' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

       $this->add_control(
       'autoplay',
       [
           'label' => esc_html__('Autoplay', 'rtelements'),
           'type' => \Elementor\Controls_Manager::SWITCHER,
           'label_on' => esc_html__('On', 'rtelements'),
           'label_off' => esc_html__('Off', 'rtelements'),
           'return_value' => 'yes',
           'default' => '',
       ]
        );

        $this->add_control(
          'autoplay_delay',
          [
              'label' => esc_html__('Autoplay Delay (ms)', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'default' => 3000,
          ]
        );

        // Speed
        $this->add_control(
            'speed',
            [
                'label' => esc_html__('Speed (ms)', 'rtelements'),
                'type' => Controls_Manager::NUMBER,
                'default' => 900,
            ]
        );

        $this->add_control(
            'centered_slides',
            [
                'label' => esc_html__('Centered Slides', 'rtelements'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
                'label_off' => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        $this->add_control(
            'free_mode',
            [
                'label' => esc_html__('Free Mode', 'rtelements'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
                'label_off' => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

       $this->add_control(
          'slides_per_view',
          [
              'label' => esc_html__('Slides Per View', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'default' => 3,
          ]
       );

       $this->add_control(
         'slides_per_view_tablet',
         [
             'label' => esc_html__('Slides Per View (Tablet)', 'rtelements'),
             'type' => \Elementor\Controls_Manager::NUMBER,
             'default' => 2,
         ]
       );

       $this->add_control(
         'slides_per_view_mobile',
         [
             'label' => esc_html__('Slides Per View (Mobile)', 'rtelements'),
             'type' => \Elementor\Controls_Manager::NUMBER,
             'default' => 1,
         ]
       );

       $this->add_control(
          'space_between',
          [
              'label' => esc_html__('Space Between (px)', 'rtelements'),
              'type' => \Elementor\Controls_Manager::NUMBER,
              'default' => 20,
          ]
       );

       $this->add_control(
           'pagination',
           [
               'label' => esc_html__('Pagination', 'rtelements'),
               'type' => \Elementor\Controls_Manager::SELECT,
               'default' => 'bullets',
               'options' => [
                   'none' => esc_html__('None', 'rtelements'),
                   'bullets' => esc_html__('Bullets', 'rtelements'),
                   'fraction' => esc_html__('Fraction', 'rtelements'),
                   'progressbar' => esc_html__('Progressbar', 'rtelements'),
               ],
           ]
       );
		 
		$this->add_responsive_control(
			'pagination_top_spacing',
			[
				'label' => esc_html__( 'Top Spacing', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction']
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'top: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);	

		$this->add_control(
			'pagination_color',
			[
				'label' => esc_html__( 'Pagination Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-progressbar' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-fraction' => 'color: {{VALUE}}',
					
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction', 'progressbar']
				],
			]
		); 

		$this->add_control(
			'pagination_active_color',
			[
				'label' => esc_html__( 'Pagination Active Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-progressbar-fill' => 'background: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination-fraction .swiper-pagination-current' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active::before' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'pagination' => ['bullets', 'fraction', 'progressbar']
				],
			]
		); 

		$this->add_control(
			'pagination_bordercolor',
			[
				'label' => esc_html__( 'Pagination Border Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active::before' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'pagination' => ['bullets']
				],
			]
		);

      $this->add_control(
           'navigation',
           [
               'label' => esc_html__('Navigation Arrows', 'rtelements'),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => esc_html__('Show', 'rtelements'),
               'label_off' => esc_html__('Hide', 'rtelements'),
               'return_value' => 'yes',
               'default' => 'yes',
           ]
       );
		 
		 $this->add_control(
			'navigation_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev' => 'color: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next' => 'color: {{VALUE}}',					
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);
        
      $this->add_control(
			'navigation_hover_color',
			[
				'label' => esc_html__( 'Hover Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev:hover' => 'color: {{VALUE}}',					
					'{{WRAPPER}} .swiper-next:hover' => 'color: {{VALUE}}',						
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);

      $this->add_control(
			'navigation_bgcolor',
			[
				'label' => esc_html__( 'Background Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev' => 'background-color: {{VALUE}} !important; border-color: {{VALUE}} !important;',
					'{{WRAPPER}} .swiper-next' => 'background-color: {{VALUE}} !important; border-color: {{VALUE}} !important;',			
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);
        
      $this->add_control(
			'navigation_hover_bgcolor',
			[
				'label' => esc_html__( 'Hover Background Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-prev:hover' => 'background: {{VALUE}} !important; border-color: {{VALUE}} !important;',
					'{{WRAPPER}} .swiper-next:hover' => 'background: {{VALUE}} !important; border-color: {{VALUE}} !important;',		
				],
				'condition' => [
					'navigation' => 'yes'
				],
			]
		);

      $this->end_controls_section();	

        $this->start_controls_section(
                'logo_styles',
                [
                    'label' => esc_html__( 'Item', 'rtelements' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                ]
        );	
        $this->add_responsive_control(
            'item_size',
            [
                'label' => esc_html__( 'Size', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .rt-client-logo .logo' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );  

        $this->add_control(
		    'item_bg_color',
		    [
		        'label' => esc_html__( 'Background', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .rt-client-logo .logo img' => 'background: {{VALUE}};',
		        ],
		    ]
		);	

        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'item_box_shadow',
				'selector' => '{{WRAPPER}} .rt-client-logo .logo img',
			]
		);

		$this->add_control(
		    'item_border_radius',
		    [
		        'label' => esc_html__( 'Border Radius', 'rtelements' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .rt-client-logo .logo img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',       
		        ],
		    ]
		);

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__( 'Padding', 'rtelements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ], 
                'selectors' => [
					'{{WRAPPER}} .rt-client-logo .logo img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],               
            ]
        ); 
      $this->end_controls_section();     
    }
    
    protected function render(){
        $settings    = $this->get_settings_for_display();
        $link_dis    = ( $settings['link_disable'] == 'yes' ) ? 'rt--link-dis' : '';
        if ( empty($settings['list'] )) {
            return;
        }
        static $instance = 0;
        $instance++;
        $unique_id = 'swiper-' . $instance;
        $settings = $this->get_settings_for_display();
        $data_loop = $settings['loop'] === 'yes' ? 'true' : 'false';
        $data_autoplay = ($settings['autoplay'] === 'yes' || $settings['autoplay'] === true) ? 'true' : 'false';
        $data_navigation = ($settings['navigation'] === 'yes' || $settings['navigation'] === true) ? 'true' : 'false';

        $slider_data_attributes = sprintf(
            'data-loop="%s" 
            data-autoplay="%s" 
            data-speed="%s" 
            data-centered-slides="%s" 
            data-autoplay-delay="%s" 
            data-free-mode="%s" 
            data-slides-per-view="%s" 
            data-space-between="%s" 
            data-slides-per-view-tablet="%s" 
            data-slides-per-view-mobile="%s" 
            data-pagination="%s" 
            data-navigation="%s"',
            esc_attr($settings['loop']) === 'yes' ? 'true' : 'false',
            esc_attr($data_autoplay),
            esc_attr($settings['speed']),
            $settings['centered_slides'] === 'yes' ? 'true' : 'false',
            esc_attr($settings['autoplay_delay']),
            $settings['free_mode'] === 'yes' ? 'true' : 'false',
            esc_attr($settings['slides_per_view']),
            esc_attr($settings['space_between']),
            esc_attr($settings['slides_per_view_tablet']),
            esc_attr($settings['slides_per_view_mobile']),
            esc_attr($settings['pagination']),
            esc_attr($data_navigation)
        );

        ?>       
            <div id="<?php echo esc_attr( $unique_id ); ?>" class="swiper rt-all-slider rt-client-logo" <?php echo $slider_data_attributes; ?>>
                <div class="swiper-wrapper">
                    <?php 
                    foreach( $settings['list'] as $items ) : 
                        $img       = !empty( $items['image']['url'] ) ? $items['image']['url'] : '';   
                        $img_alt   = !empty( $items['image']['alt'] ) ? $items['image']['alt'] : '';   
                        $link      = !empty( $items['link']['url'] ) ? $items['link']['url'] : '#'; 
                    ?>
                        <div class="swiper-slide">
                            <a aria-label="Brand Logo" href="<?php echo esc_url( $link ); ?>" class="logo <?php echo esc_attr( $link_dis ); ?>">
                                <img loading="lazy" src="<?php echo esc_url( $img ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
                            </a> 
                        </div>
                        <?php 
                    endforeach; ?>                    
                </div>
                <?php 
                if ( $settings['navigation'] === 'yes' ) : ?>
                    <div class="swiper-navigaiton">
                        <span class="swiper-prev swiper-prev"><i class="rt rt-arrow-left"></i></span>
                        <span class="swiper-next swiper-next"><i class="rt rt-arrow-right"></i></span>
                    </div>
                    <?php
                endif; 
                if ( $settings['pagination'] !== 'none' ) : ?>
                        <div class="swiper-pagination"><span class="swiper-pagination"></span></div>
                    <?php 
                endif; ?>
            </div>
        <?php 
    }
} ?>