<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Widget_Base;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Border;

if (!defined('ABSPATH')) {
    exit;   // Exit if accessed directly.
}

class RT_Social_Icon extends Widget_Base
{
    public function get_name()
    {
        return 'rt-social-icon';
    }

    public function get_title()
    {
        return __('RT Social Icon', 'rtelements');
    }

    public function get_icon()
    {
        return 'rt-e-icon';
    }

    public function get_categories()
    {
        return ['pielements_category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'rt-social-contents',
            [
                'label' => __('Social Icon', 'rtelements'),
            ]
        );        
         $repeater = new \Elementor\Repeater();

         $repeater->add_control(
            'list_title',
            [
               'label' => esc_html__( 'Title', 'rtelements' ),
               'type' => \Elementor\Controls_Manager::TEXT,
               'default' => esc_html__( 'List Title' , 'rtelements' ),
               'label_block' => true,
            ]
         );  
         $repeater->add_control(
            'link',
            [
               'label' => esc_html__('Enter Link Here', 'rtelements'),
               'type' => Controls_Manager::URL,
               'default'     => array(
                  'url' => '#'
               ),
               'placeholder' => esc_html__('Insert your link here', 'rtelements'),
            ]
         ); 
         $repeater->add_control(
            'icon',
            [
               'label' => esc_html__( 'Icon', 'rtelements' ),
               'type' => \Elementor\Controls_Manager::ICONS,
               'default' => [
                  'value' => 'fab fa-facebook-f',
                  'library' => 'Font Awesome 5 Brands',
               ],
            ]
         );
         $this->add_control(
            'list',
            [
               'label' => esc_html__( 'Social List', 'rtelements' ),
               'type' => \Elementor\Controls_Manager::REPEATER,
               'fields' => $repeater->get_controls(),
               'default' => [
                  [
                     'list_title' => esc_html__( 'Facebook', 'rtelements' ),
                     'link' => array(
                        'url' => '#'
                     ),
                  ],
               ],
               'title_field' => '{{{ list_title }}}',
            ]
         );
         $this->end_controls_section();  

         $this->start_controls_section(
            'style_section',
            [
               'label' => esc_html__( 'Social', 'rtelements' ),
               'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
         );
         $this->add_responsive_control(
            'social_width',
            [
               'label' => esc_html__( 'With', 'rtelements' ),
               'type' => Controls_Manager::SLIDER,
               'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
               'range' => [
                  'px' => [
                     'min' => 0,
                     'max' => 100,
                     'step' => 1,
                  ],
                  '%' => [
                     'min' => 0,
                     'max' => 100,
                  ],
               ],
               'selectors' => [
                       '{{WRAPPER}} .rt-social ul li a' => 'width: {{SIZE}}{{UNIT}} !important;',
                   ],
            ]
         );
         $this->add_responsive_control(
            'social_height',
            [
               'label' => esc_html__( 'Height', 'rtelements' ),
               'type' => Controls_Manager::SLIDER,
               'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
               'range' => [
                  'px' => [
                     'min' => 0,
                     'max' => 100,
                     'step' => 1,
                  ],
                  '%' => [
                     'min' => 0,
                     'max' => 100,
                  ],
               ],
               'selectors' => [
                       '{{WRAPPER}} .rt-social ul li a' => 'height: {{SIZE}}{{UNIT}} !important;',
                   ],
            ]
         );
         $this->add_responsive_control(
            'social_line_height',
            [
               'label' => esc_html__( 'Line Height', 'rtelements' ),
               'type' => Controls_Manager::SLIDER,
               'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
               'range' => [
                  'px' => [
                     'min' => 0,
                     'max' => 100,
                     'step' => 1,
                  ],
                  '%' => [
                     'min' => 0,
                     'max' => 100,
                  ],
               ],
               'selectors' => [
                       '{{WRAPPER}} .rt-social ul li a' => 'line-height: {{SIZE}}{{UNIT}} !important;',
                   ],
            ]
         );
         $this->add_control(
            'icon_alignments',
            [
               'label' => esc_html__( 'Alignment', 'rtelements' ),
               'type' => \Elementor\Controls_Manager::CHOOSE,
               'options' => [
                  'left' => [
                     'title' => esc_html__( 'Left', 'rtelements' ),
                     'icon' => 'eicon-text-align-left',
                  ],
                  'center' => [
                     'title' => esc_html__( 'Center', 'rtelements' ),
                     'icon' => 'eicon-text-align-center',
                  ],
                  'right' => [
                     'title' => esc_html__( 'Right', 'rtelements' ),
                     'icon' => 'eicon-text-align-right',
                  ],
               ],
               'toggle' => true,
               'selectors' => [
                  '{{WRAPPER}} .rt-social ul li a' => 'text-align: {{VALUE}};',
               ],
            ]
         );  
         $this->add_responsive_control(
            'social_mid_gap',
            [
               'label' => esc_html__( 'Gap', 'rtelements' ),
               'type' => Controls_Manager::SLIDER,
               'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
               'range' => [
                  'px' => [
                     'min' => 0,
                     'max' => 100,
                     'step' => 1,
                  ],
                  '%' => [
                     'min' => 0,
                     'max' => 100,
                  ],
               ],
               'selectors' => [
                  '{{WRAPPER}} .rt-social ul' => 'gap: {{SIZE}}{{UNIT}};',
               ],
            ]
         );
         $this->start_controls_tabs(
            'style_tabs'
         );
   
         $this->start_controls_tab(
            'style_normal_tab',
            [
               'label' => esc_html__( 'Normal', 'rtelements' ),
            ]
         );         
         $this->add_control(
            'icon_color',
            [
               'label' => esc_html__( 'Color', 'rtelements' ),
               'type' => Controls_Manager::COLOR,		      
               'selectors' => [
                  '{{WRAPPER}} .rt-social ul li a svg path' => 'fill: {{VALUE}};',
                  '{{WRAPPER}} .rt-social ul li a i' => 'color: {{VALUE}};',
               ],
            ]
         );		
         $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
               'name' => 'icon_background',
               'types' => [ 'classic', 'gradient', 'video' ],
               'selector' => '{{WRAPPER}} .rt-social ul li a',
            ]
         );	
         $this->add_responsive_control(
            'social_size',
            [
               'label' => esc_html__( 'Size', 'rtelements' ),
               'type' => Controls_Manager::SLIDER,
               'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
               'range' => [
                  'px' => [
                     'min' => 0,
                     'max' => 100,
                     'step' => 1,
                  ],
                  '%' => [
                     'min' => 0,
                     'max' => 100,
                  ],
               ],
               'selectors' => [
                       '{{WRAPPER}} .rt-social ul li a i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                       '{{WRAPPER}} .rt-social ul li a svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}} !important;',
                   ],
            ]
         );
         $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
               'name' => 'icon_border',
               'selector' => '{{WRAPPER}} .rt-social ul li a',
            ]
         );
         $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
               'name' => 'icon_box_shadow',
               'selector' => '{{WRAPPER}} .rt-social ul li a',
            ]
         );
         $this->add_responsive_control(
            'icon_border_radius',
            [
               'label' => esc_html__( 'Border Radius', 'rtelements' ),
               'type' => \Elementor\Controls_Manager::DIMENSIONS,
               'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
               'selectors' => [
                  '{{WRAPPER}} .rt-social ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
               ],
            ]
         );
         $this->add_responsive_control(
            'icon_border_padding',
            [
               'label' => esc_html__( 'Padding', 'rtelements' ),
               'type' => \Elementor\Controls_Manager::DIMENSIONS,
               'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
               'selectors' => [
                  '{{WRAPPER}} .rt-social ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
               ],
            ]
         );
         $this->add_responsive_control(
            'icon_border_margin',
            [
               'label' => esc_html__( 'Margin', 'rtelements' ),
               'type' => \Elementor\Controls_Manager::DIMENSIONS,
               'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
               'selectors' => [
                  '{{WRAPPER}} .rt-social ul li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
               ],
            ]
         );
         $this->end_controls_tab();
      
         $this->start_controls_tab(
            'style_hover_tab',
            [
               'label' => esc_html__( 'Hover', 'rtelements' ),
            ]
         ); 

         $this->add_control(
            'icon_hover_color',
            [
               'label' => esc_html__( 'Color', 'rtelements' ),
               'type' => Controls_Manager::COLOR,		      
               'selectors' => [
                  '{{WRAPPER}} .rt-social ul li a:hover svg path' => 'fill: {{VALUE}};',
                  '{{WRAPPER}} .rt-social ul li a:hover i' => 'color: {{VALUE}};',
               ],
            ]
         );		
         $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
               'name' => 'icon_hover_background',
               'types' => [ 'classic', 'gradient', 'video' ],
               'selector' => '{{WRAPPER}} .rt-social ul li a:hover',
            ]
         );	
         $this->add_responsive_control(
            'social_hover_size',
            [
               'label' => esc_html__( 'Size', 'rtelements' ),
               'type' => Controls_Manager::SLIDER,
               'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
               'range' => [
                  'px' => [
                     'min' => 0,
                     'max' => 100,
                     'step' => 1,
                  ],
                  '%' => [
                     'min' => 0,
                     'max' => 100,
                  ],
               ],
               'selectors' => [
                       '{{WRAPPER}} .rt-social ul li a:hover i' => 'transform: scale({{SIZE}}) !important;',
                       '{{WRAPPER}} .rt-social ul li a:hover svg' => 'transform: scale({{SIZE}}) !important;',
                   ],
            ]
         );

         $this->add_control(
            'animate',
            [
               'label' => esc_html__( 'Animation', 'rtelements' ),
               'type' => \Elementor\Controls_Manager::SWITCHER,
               'label_on' => esc_html__( 'Yes', 'rtelements' ),
               'label_off' => esc_html__( 'No', 'rtelements' ),
               'return_value' => 'yes',
               'default' => 'no',
            ]
         );

         $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
               'name' => 'icon_hover_border',
               'selector' => '{{WRAPPER}} .rt-social ul li a:hover',
            ]
         );
         $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
               'name' => 'icon_hover_shadow',
               'selector' => '{{WRAPPER}} .rt-social ul li a:hover',
            ]
         );
         $this->add_responsive_control(
            'icon_hover_radius',
            [
               'label' => esc_html__( 'Border Radius', 'rtelements' ),
               'type' => \Elementor\Controls_Manager::DIMENSIONS,
               'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
               'selectors' => [
                  '{{WRAPPER}} .rt-social ul li a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
               ],
            ]
         );
         $this->add_responsive_control(
            'icon_hover_padding',
            [
               'label' => esc_html__( 'Padding', 'rtelements' ),
               'type' => \Elementor\Controls_Manager::DIMENSIONS,
               'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
               'selectors' => [
                  '{{WRAPPER}} .rt-social ul li a:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
               ],
            ]
         );
         $this->add_responsive_control(
            'icon_hover_margin',
            [
               'label' => esc_html__( 'Margin', 'rtelements' ),
               'type' => \Elementor\Controls_Manager::DIMENSIONS,
               'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
               'selectors' => [
                  '{{WRAPPER}} .rt-social ul li a:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
               ],
            ]
         );
         $this->end_controls_tab();
      
         $this->end_controls_tabs();
      
         $this->end_controls_section();      
      }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $animate  = ( $settings['animate'] == 'yes' ) ? 'animate' : '';
      ?>
        <div class="rt-social">
            <ul>
               <?php 
               foreach( $settings['list'] as $items ) : ?> 
                  <li><a class="<?php echo esc_attr( $animate ); ?>" aria-label="Social" href="<?php echo esc_url($items['link']['url']); ?>">
                     <?php \Elementor\Icons_Manager::render_icon( $items['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                  </a></li>
                  <?php 
               endforeach; ?>
            </ul>
         </div>
      <?php 
   }
}