<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Stroke;

defined('ABSPATH') || die();

class ReacTheme_Elementor_Counter_Widget extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'rt-counter';
	}

	public function get_style_depends() {
		wp_register_style( 'counterup-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'counterup-style'
		];
	}

	public function get_title()
	{
		return esc_html__('RT Counter', 'rtelements');
	}

	public function get_icon()
	{
		return 'rt-e-icon';
	}

	public function get_categories()
	{
		return ['pielements_category'];
	}

	public function get_keywords()
	{
		return ['counter'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_counter',
			[
				'label' => esc_html__('Counter', 'rtelements'),
			]
		);

		$this->add_control(
			'select_style',
			[
				'label' => esc_html__( 'Counter Type', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'rtelements' ),
					'circle' => esc_html__( 'Circle', 'rtelements' ),
					'circle-2' => esc_html__( 'Circle 2', 'rtelements' ),
				],
			]
		);

		$this->add_control(
			'counter-icon-enable',
			[
				'label' => esc_html__( 'Icon Show', 'rtelements' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'no',	
				'condition' => [
					'select_style' => ['default', 'circle-2']
				]
			]
		);  

		$this->add_control(
			'counter-icon',
			[
				'label' => esc_html__( 'Icon', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-cogs',
					'library' => 'fa-solid',
				],
				'condition' => [
					'counter-icon-enable' => 'yes',
					'select_style' => ['default', 'circle-2']
				]
			]
		);

		$this->add_control(
			'number',
			[
				'label' => esc_html__('Counter Number', 'rtelements'),
				'type' => Controls_Manager::NUMBER,
				'default' => 2000,
			]
		);

		$this->add_control(
			'prefix',
			[
				'label' => esc_html__('Prefix', 'rtelements'),
				'type' => Controls_Manager::TEXT,
				'default' => '',
				'placeholder' => esc_html__('Prefix', 'rtelements'),
				'condition' => [
					'select_style' => 'default'
				]
			]
		);

		$this->add_control(
			'suffix',
			[
				'label' => esc_html__('Suffix', 'rtelements'),
				'type' => Controls_Manager::TEXT,
				'default' => '',
				'placeholder' => 'Suffix',
				'condition' => [
					'select_style' => 'default'
				]
			]
		);

		$this->add_control(
			'label',
			[
				'label' => esc_html__('Label', 'rtelements'),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__('Label', 'rtelements'),
				'condition' => [
					'select_style' => ['default', 'circle']
				]
			]
		);

		$this->add_responsive_control(
			'text_align',
			[
				'label' => esc_html__( 'Alignment', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .rt-counter' => 'text-align: {{VALUE}};',
				],
				'condition' => [
					'select_style' => ['default', 'circle']
				]
			]
		);

		$this->add_responsive_control(
			'p_overlay_width',
			[
				'label' => esc_html__( 'Progress Overlay Width', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
						'step' => 0,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rt-counter .radial-progress circle.bar--animated' => 'stroke-width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'select_style' => 'circle'
				]
			]
		);

		$this->add_control(
			'scroll_animate',
			[
				'label' => esc_html__( 'Scroll Animation', 'rtelements' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'rtelements' ),
				'label_off' => esc_html__( 'Hide', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'no',				
				'condition' => [
					'select_style' => 'circle'
				]
			]
		); 		
		$this->end_controls_section();

		/******* STYLE ********/
		$this->start_controls_section(
			'section_wrapper',
			[
				'label' => esc_html__('Wrapper', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'select_style' => ['default', 'circle']
				]
			]
		);

		$this->add_control(
			'circle-clip-path',
			[
				'label' => esc_html__( 'Clip Path', 'rtelements' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'no',				
			]
		);  

		$this->add_control(
			'wrapper_bg',
			[
				'label' => esc_html__('Background', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-counter' => 'background: {{VALUE}} !important;',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'wrapper_border',
				'selector' => '{{WRAPPER}} .rt-counter',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'wrapper_box_shadow',
				'selector' => '{{WRAPPER}} .rt-counter',
			]
		);

      $this->add_responsive_control(
			'wrapper_radius',
			[
				'label' => esc_html__( 'Border Radius', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .rt-counter' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

      $this->add_responsive_control(
			'wrapper_padding',
			[
				'label' => esc_html__( 'Padding', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .rt-counter' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_icon',
			[
				'label' => esc_html__('Icon', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'counter-icon-enable' => 'yes',
					'select_style' => ['default', 'circle-2']
				]
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon svg' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .icon svg path' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .icon i' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_bgcolor',
			[
				'label' => esc_html__('Background Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon' => 'background: {{VALUE}};',
				],				
				'condition' => [
					'select_style' => 'circle-2'
				]
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Size', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 0,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .icon svg' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

      $this->add_responsive_control(
			'icon_padding',
			[
				'label' => esc_html__( 'Padding', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'select_style' => ['default', 'circle']
				]
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'section_number',
			[
				'label' => esc_html__('Number / Progress', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,				
				'condition' => [
					'number!' => '' 
				]
			]
		);

		$this->add_control(
			'number_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rt-counter .radial-progress text' => 'fill: {{VALUE}} !important;',
				],
				'condition' => [
					'select_style' => ['default', 'circle']
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'rtelements'),
				'name' => 'typography_number',
				'selector' => '{{WRAPPER}} .title,{{WRAPPER}} .odometer.odometer-auto-theme',		
				'condition' => [
					'select_style' => ['default', 'circle']
				]		
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Text_Stroke::get_type(),
			[
				'name' => 'title_stroke',
				'selector' => '{{WRAPPER}} .title',
				'condition' => [
					'select_style' => 'default'
				]
			]
		);	

		$this->add_control(
			'progress_color',
			[
				'label' => esc_html__('Progress Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-counter .radial-progress circle.bar-static' => 'stroke: {{VALUE}} !important;',
				],
				'condition' => [
					'select_style' => ['circle', 'circle-2']
				]
			]
		);
		
		$this->add_control(
			'progress_overlay',
			[
				'label' => esc_html__('Progress Overlay', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-counter .radial-progress circle.bar--animated' => 'stroke: {{VALUE}};',
				],				
				'condition' => [
					'select_style' =>  ['circle', 'circle-2']
				]
			]
		);
		$this->end_controls_section();	

		$this->start_controls_section(
			'prefix_styles',
			[
				'label' => esc_html__('Prefix', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'prefix!' => '',
					'select_style' =>  'default'
				]
			]
		);
		$this->add_control(
			'prefix_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title .prefix' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'rtelements'),
				'name' => 'prefix_typography',
				'selector' => '{{WRAPPER}} .title .prefix',
			]
		);
		$this->add_responsive_control(
			'prefix_padding',
			[
				'label' => esc_html__('Padding', 'rtelements'),
				'type' => Controls_Manager::DIMENSIONS,'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .title .prefix' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);		
		$this->end_controls_section();

		$this->start_controls_section(
			'suffix_styles',
			[
				'label' => esc_html__('Suffix', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'suffix!' => '',
					'select_style' =>  'default'
				]
			]
		);
		$this->add_control(
			'suffix_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title .suffix' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'rtelements'),
				'name' => 'suffix_typography',
				'selector' => '{{WRAPPER}} .title .suffix',
			]
		);
		$this->add_responsive_control(
			'suffix_padding',
			[
				'label' => esc_html__('Padding', 'rtelements'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .title .suffix' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);		
		$this->end_controls_section();

		$this->start_controls_section(
			'label_styles',
			[
				'label' => esc_html__('Label', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,				
				'condition' => [
					'label!' => '',
					'select_style' =>  ['default', 'circle'] 
				]
			]
		);

		$this->add_control(
			'label_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'rtelements'),
				'name' => 'label_typography',
				'selector' => '{{WRAPPER}} .label',
			]
		);

		$this->add_responsive_control(
			'label_padding',
			[
				'label' => esc_html__( 'Padding', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render() {
		$settings 		 = $this->get_settings_for_display();			
      $scroll_animate = ( $settings['scroll_animate'] == 'yes' ) ? 'scroll-animate-img' : '';
		$values 			 = 0;	
		$clip_path 		 = ( $settings['circle-clip-path'] === 'yes' ) ? 'clip-path-yes' : '';
		
		$this->add_inline_editing_attributes('suffix', 'basic');
		$this->add_render_attribute('suffix', 'class', 'suffix');
  
		$this->add_inline_editing_attributes('prefix', 'basic');
		$this->add_render_attribute('prefix', 'class', 'prefix');
	?>	
		<div class="rt-counter <?php echo esc_attr( $scroll_animate ); ?> <?php echo esc_attr( $clip_path ); ?>">
			<?php
			if( $settings['select_style'] === 'circle-2' ) : ?>
				<div class="single-progress-circle circle-2">
					<svg class="radial-progress title" data-countervalue="<?php echo esc_attr( $settings['number'] ); ?>" viewBox="0 0 80 80">
						<circle class="bar-static" cx="40" cy="40" r="35"></circle>
						<circle class="bar--animated" cx="40" cy="40" r="35" style="stroke-dashoffset: 217.8;"></circle>
						<text class="countervalue start title" x="50%" y="55%" transform="matrix(0, 1, -1, 0, 80, 0)"> 
						</text>
						<?php 
						if( $settings['counter-icon-enable'] === 'yes' && !empty( $settings['counter-icon']['value'] ) ) : ?>
							<div class="icon">								
								<?php \Elementor\Icons_Manager::render_icon( $settings['counter-icon'], [ 'aria-hidden' => 'true' ] ); ?>
							</div>
							<?php 
						endif; ?>
					</svg>	
				</div>
				<?php 				
			elseif( $settings['select_style'] === 'circle' ) :			
				if( !empty( $settings['number'] ) ) : ?>
					<div class="single-progress-circle">
						<svg class="radial-progress title" data-countervalue="<?php echo esc_attr( $settings['number'] ); ?>" viewBox="0 0 80 80">
							<circle class="bar-static" cx="40" cy="40" r="35"></circle>
							<circle class="bar--animated" cx="40" cy="40" r="35" style="stroke-dashoffset: 217.8;"></circle><text class="countervalue start title" x="50%" y="55%" transform="matrix(0, 1, -1, 0, 80, 0)"><?php echo esc_attr( $settings['number'] ); ?></text>
						</svg>
					</div>
					<?php 
				endif;
			else : 				
				if( $settings['counter-icon-enable'] === 'yes' && !empty( $settings['counter-icon']['value'] ) ) : ?>
					<div class="icon">
						<?php \Elementor\Icons_Manager::render_icon( $settings['counter-icon'], [ 'aria-hidden' => 'true' ] ); ?>
					</div>
					<?php 
				endif; 
				if( !empty( $settings['number'] ) ) : ?>			
					<div class="title">
						<?php 
						if( !empty( $settings['prefix'] ) ) : ?><span <?php echo $this->print_render_attribute_string('prefix'); ?>><?php echo esc_html( $settings['prefix'] ); ?></span><?php endif; ?>
						<span class="odometer" data-count="<?php echo esc_attr( $settings['number'] ); ?>"><?php echo wp_kses_post( $values ); ?></span><?php if ( !empty( $settings['suffix'] ) ) : ?><span <?php echo $this->print_render_attribute_string('suffix'); ?>><?php echo esc_html( $settings['suffix'] ); ?></span><?php endif; ?>
					</div>				
					<?php 
				endif;
			endif; 			
			if( !empty( $settings['label'] ) ) : ?>
				<span class="label"><?php echo wp_kses_post( $settings['label'] ); ?></span>
				<?php 
			endif; ?>
		</div>
	<?php
	}
}
