<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

defined( 'ABSPATH' ) || die();

class Reactheme_Button_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'react-button';
	}

	public function get_title() {
		return esc_html__( 'RT Button', 'rtelements' );
	}

	public function get_icon() {
		return  'rt-e-icon';
	}

	public function get_categories() {
        return [ 'rtelements_category' ];
    }

	public function get_keywords() {
		return [ 'button' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_button',
			[
				'label' => esc_html__( 'Button', 'rtelements' ),
			]
		);		
		$this->add_control(
			'btn_text',
			[
				'label'       => esc_html__( 'Button Text', 'rtelements' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => esc_html__( 'React Button', 'rtelements' ),
				'placeholder' => esc_html__( 'Button Text', 'rtelements' ),
				'separator'   => 'before',
			]
		);
		$this->add_control(
			'btn_link',
			[
				'label'       => esc_html__( 'Button Link', 'rtelements' ),
				'type'        => Controls_Manager::URL,
				'label_block' => true,	
			]
		);
		$this->add_control(
         'show_icon',
            [
				'label'        => esc_html__( 'Icon', 'rtelements' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', 'rtelements' ),
				'label_off'    => esc_html__( 'Hide', 'rtelements' ),
				'return_value' => 'yes',
				'default'      => 'no',
         ]
      );
		$this->add_control(
			'btn_icon',
			[
				'label'     => esc_html__( 'Icon', 'rtelements' ),
				'type'      => Controls_Manager::ICONS,
				'default' => [
					'value' => 'rt rt-arrow-right-regular',	
					'library' => 'rt-icons',		
				],
				'condition' => [
					'show_icon' => 'yes'
				]			
			]
		);

		$this->add_responsive_control(
			'icon_spacing',
			[
				'label' => esc_html__( 'Icon Spacing', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rt-btn-text-wrap' => 'gap: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'show_icon' => 'yes'
				]
			]
		);	
		
		$this->add_control(
         'btn_stretch',
            [
				'label'        => esc_html__( 'Button Stretch', 'rtelements' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', 'rtelements' ),
				'label_off'    => esc_html__( 'Hide', 'rtelements' ),
				'return_value' => 'yes',
				'default'      => 'no',
         ]
      );
		
		$this->add_responsive_control(
			'btn_stretch_align',
			[
				 'label' => esc_html__( 'Alignment', 'rtelements' ),
				 'type' => Controls_Manager::CHOOSE,
				 'options' => [
					  'start' => [
							'title' => esc_html__( 'Left', 'rtelements' ),
							'icon' => 'eicon-text-align-left',
					  ],
					  'center' => [
							'title' => esc_html__( 'Center', 'rtelements' ),
							'icon' => 'eicon-text-align-center',
					  ],
					  'end' => [
							'title' => esc_html__( 'Right', 'rtelements' ),
							'icon' => 'eicon-text-align-right',
					  ],
					  'space-between' => [
							'title' => esc_html__( 'Space Between', 'rtelements' ),
							'icon' => 'eicon-text-align-justify',
					  ],
				],
				'toggle' => true,				 			
				'condition' => [
					'btn_stretch' => 'yes'
				],
				'selectors' => [
					'{{WRAPPER}} .rt-btn-text-wrap' => 'justify-content: {{VALUE}}'
				]
			]
	  	);		

		$this->add_responsive_control(
			'btn_position',
			[
				'label' => esc_html__( 'Position', 'rtelements' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .react-button-wrap' => 'text-align:{{VALUE}}'
				],				
				'condition' => [
					'btn_stretch!' => 'yes'
				]
			]
      );	

		$this->end_controls_section();	

		//********** STYLE **********//
		$this->start_controls_section(
		    '_section_style_button',
		    [
		        'label' => esc_html__( 'Button', 'rtelements' ),
		        'tab' => Controls_Manager::TAB_STYLE,
				  'condition' => [
						'btn_text!' => '' 
				  ]
		    ]
		);
		$this->start_controls_tabs('_tabs_button');

		$this->start_controls_tab(
			'style_normal_tab',
			[
					'label' => esc_html__( 'Normal', 'rtelements' ),
			]
		); 
		$this->add_control(
		    'btn_text_color',
		    [
		        'label' => esc_html__( 'Text Color', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .rt-btn-text-wrap' => 'color: {{VALUE}};',
		        ],
		    ]
		);	
		$this->add_control(
		    'btn_bg_color',
		    [
		        'label' => esc_html__( 'Background', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .react_button' => 'background: {{VALUE}};',
		        ],
		    ]
		);		
		$this->add_group_control(
		    Group_Control_Typography::get_type(),
		    [
		        'name' => 'btn_typography',
		        'selector' => '{{WRAPPER}} .rt-btn-text-wrap',
		        
		    ]
		);	
		$this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
		        'name' => 'btn_border',
		        'selector' => '{{WRAPPER}} .react_button',
		    ]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'btn_box_shadow',
				'selector' => '{{WRAPPER}} .react_button',
			]
		);
		$this->add_control(
		    'btn_border_radius',
		    [
		        'label' => esc_html__( 'Border Radius', 'rtelements' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .react_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',       
		        ],
		    ]
		);
		$this->add_responsive_control(
		    'btn_padding',
		    [
		        'label' => esc_html__( 'Padding', 'rtelements' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', 'em', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .react_button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],
		    ]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_hover_tab',
			[
					'label' => esc_html__( 'Hover', 'rtelements' ),
			]
		); 
		$this->add_control(
		    'btn_hover_text_color',
		    [
		        'label' => esc_html__( 'Text Color', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .react_button:hover .rt-btn-text-wrap' => 'color: {{VALUE}};',
		            '{{WRAPPER}} .react_button:hover span i' => 'color: {{VALUE}};',
		            '{{WRAPPER}} .react_button:hover span svg path' => 'fill: {{VALUE}};',
		        ],
		    ]
		);	
		$this->add_control(
		    'btn_hover_bg_color',
		    [
		        'label' => esc_html__( 'Background', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .react_button:hover' => 'background: {{VALUE}} !important;',
		            '{{WRAPPER}} .react_button::before' => 'background: {{VALUE}} !important;',
		        ],
		    ]
		);			
		$this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
		        'name' => 'btn_hover_border',
		        'selector' => '{{WRAPPER}} .react_button:hover',
		    ]
		);
		$this->add_control(
		    'btn_hover_border_radius',
		    [
		        'label' => esc_html__( 'Border Radius', 'rtelements' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .react_button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',       
		        ],
		    ]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'btn_hover_box_shadow',
				'selector' => '{{WRAPPER}} .react_button:hover',
			]
		);
		$this->add_responsive_control(
		    'btn_hover_padding',
		    [
		        'label' => esc_html__( 'Padding', 'rtelements' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', 'em', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .react_button:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		        ],
		    ]
		);	
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section(
		    '_section_style_icon',
		    [
		        'label' => esc_html__( 'Icon', 'rtelements' ),
		        'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_icon' => 'yes'
				]
		    ]
		);
		$this->add_control(
		    'icon_text_color',
		    [
		        'label' => esc_html__( 'Color', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .react_button i' => 'color: {{VALUE}};',
		            '{{WRAPPER}} .react_button svg path' => 'stroke: {{VALUE}};',
		            '{{WRAPPER}} .react_button svg path' => 'fill: {{VALUE}};',
		        ],
		    ]
		);
		$this->add_control(
		    'icon_hover_color',
		    [
		        'label' => esc_html__( 'Hover Color', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .react_button:hover i' => 'color: {{VALUE}};',
						'{{WRAPPER}} .react_button:hover svg path' => 'stroke: {{VALUE}};',
					'{{WRAPPER}} .react_button:hover svg path' => 'fill: {{VALUE}};',
		        ],
		    ]
		);
			
		$this->add_responsive_control(
		    'btn_icon_size',
		    [
		        'label' => esc_html__( 'Size', 'rtelements' ),
		        'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
		        'selectors' => [		      		            
		            '{{WRAPPER}} .react_button i' => 'font-size: {{SIZE}}{{UNIT}};',		            
		            '{{WRAPPER}} .react_button svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',		            
		        ],
		    ]
		);
		$this->end_controls_section();
	}

	protected function render() {	
			$settings = $this->get_settings_for_display();
			$this->add_inline_editing_attributes( 'btn_text', 'basic' );
			$this->add_render_attribute( 'btn_text', 'class', 'btn_text' );
			$link_target = !empty($settings['btn_link']['is_external']) ? ' target="_blank" rel="noopener noreferrer"' : '';
			$btn_stretch = ( $settings['btn_stretch'] == 'yes' ) ? 'button-stretch' : '';
		?>		
		<div class="react-button-wrap">
			<a aria-label="Reacthemes Button"  href="<?php echo esc_url($settings['btn_link']['url']);?>" class="react_button elementor-button <?php echo esc_attr( $btn_stretch ); ?>" <?php echo $link_target; ?>>
				<span class="rt-btn-text-wrap">
					<?php echo esc_html($settings['btn_text']);?>				
					<?php if (!empty($settings['btn_icon']['value'])) : ?>
						<?php \Elementor\Icons_Manager::render_icon($settings['btn_icon'], ['aria-hidden' => 'true']); ?>
					<?php endif; ?>
				</span>
			</a>
		</div>
		<?php 
	}
}