<?php
include 'helper.php';
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

defined( 'ABSPATH' ) || die();

class ReacTheme_Breadrumb_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'rtbreadrumb';
    }   
    
	public function get_style_depends() {
		wp_register_style( 'breadcrumb-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'breadcrumb-style'
		];
	}

    public function get_title() {
        return esc_html__( 'RT Breadrumb', 'pielements' );
    }

    public function get_icon() {
        return 'rt-e-icon';
    }

    public function get_categories() {
        return [ 'pielements_category' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'breadrumb_section',
            [
                'label' => esc_html__( 'Content', 'pielements' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_responsive_control(
			'breadrumb_height',
			[
				'type' => \Elementor\Controls_Manager::SLIDER,
				'label' => esc_html__( 'Height', 'pielements' ),
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
                'default' => [
                    'unit' => 'px',
                    'size' => 400,
                ],
				'selectors' => [
					'{{WRAPPER}} .reactheme-breadcrumb' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'breadrumb_inner_with',
			[
				'type' => \Elementor\Controls_Manager::SLIDER,
				'label' => esc_html__( 'Inner Width', 'pielements' ),
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 2000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner' => 'max-width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'custom_title',
            [
                'label'       => esc_html__( 'Custom Title', 'pielements' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => false,                    
                'separator'   => 'before', 
            ]
        );   
        
        $this->add_control(
            'custom_home_title',
            [
                'label'       => esc_html__( 'Custom Home Title', 'pielements' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => false,                    
                'separator'   => 'before', 
            ]
        ); 
        $this->add_control(
            'custom_path',
            [
                'label'       => esc_html__( 'Custom Path Title', 'pielements' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => false,                    
                'separator'   => 'before', 
            ]
        );        

        $this->add_control(
			'separator_icon',
			[
				'label' => esc_html__( 'Separator Icon', 'pielements' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-chevron-right',
					'library' => 'fa-solid',
				],
			]
		); 
        $this->add_control(
            'search_custom_title',
            [
                'label'       => esc_html__( 'Search Page Title', 'pielements' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => false,                    
                'separator'   => 'before', 
                'default'     => esc_html__( 'Search Result', 'pielements' ),
            ]
        );  
        $this->add_control(
            'search_result_title',
            [
                'label'       => esc_html__( 'Search Result Title', 'pielements' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => false,                    
                'separator'   => 'before', 
                'default'     => esc_html__( 'Search Results for:', 'pielements' ),
            ]
        );  
        $this->add_control(
			'title_tag',
			[
				'label'   => esc_html__('Select Heading Tag', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h2',             
                'separator'   => 'before', 
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('span', 'rtelements'),

				],
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
            'breadrumb_container_style',
            [
                'label' => esc_html__( 'Container', 'pielements' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );   
        $this->add_control(
            'breadrumb_bg_style',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Background', 'pielements' ),
                'separator' => 'before',               
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'breadcrumb_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .reactheme-breadcrumb',
			]
		);
        $this->add_control(
            'breadrumb_bg_overlay_style',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Background Overlay', 'pielements' ),
                'separator' => 'before',               
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'breadcrumb_background_overlay',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .reactheme-breadcrumb:before',
			]
		);
        $this->add_responsive_control(
            'breadrumb_padding',
            [
                'label' => esc_html__( 'Padding', 'pielements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],               
            ]
        );
        $this->add_responsive_control(
            'breadcrumb_inner_pading',
            [
                'label' => esc_html__( 'Inner Padding', 'pielements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );
        $this->end_controls_section();


        
        $this->start_controls_section(
            'breadrumb_title_style',
            [
                'label' => esc_html__( 'Title', 'pielements' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );    
        $this->add_responsive_control(
			'content_title_align',
			[
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'label' => esc_html__( 'Alignment', 'pielements' ),
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'pielements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'pielements' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'pielements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'devices' => [ 'desktop', 'tablet' ],
				'prefix_class' => 'content-align-%s',
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .page-title' => 'text-align: {{VALUE}}',
                ],
			]
		);      
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'pielements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .page-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__( 'Typography', 'pielements' ),
                'selector' => '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .page-title',
            ]
        );        
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__( 'Padding', 'pielements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .page-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__( 'Margin', 'pielements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .page-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'breadrumb_path_style',
            [
                'label' => esc_html__( 'Path', 'pielements' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );  
          
        $this->add_responsive_control(
			'content_path_align',
			[
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'label' => esc_html__( 'Alignment', 'pielements' ),
				'options' => [
					'start' => [
						'title' => esc_html__( 'Left', 'pielements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'pielements' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( 'Right', 'pielements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'devices' => [ 'desktop', 'tablet' ],
				'prefix_class' => 'content-align-%s',
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-path' => 'justify-content: {{VALUE}}',
                ],
			]
		);      
        $this->add_control(
            'path_color',
            [
                'label' => esc_html__( 'Path Color', 'pielements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-path' => 'color: {{VALUE}};',
                ],
            ]
        );        
        $this->add_control(
            'path_bgcolor',
            [
                'label' => esc_html__( 'Background Color', 'pielements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-path' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'path_typography',
                'label' => esc_html__( 'Typography', 'pielements' ),
                'selector' => '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-path',
            ]
        );
        $this->add_responsive_control(
            'path_radius',
            [
                'label' => esc_html__( 'Border Radius', 'pielements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-path' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'path_padding',
            [
                'label' => esc_html__( 'Padding', 'pielements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-path' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'path_margin',
            [
                'label' => esc_html__( 'Margin', 'pielements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-path' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'path_link_styles',
            [
                'label' => esc_html__( 'Link', 'pielements' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'path_link_typography',
                'label' => esc_html__( 'Typography', 'pielements' ),
                'selector' => '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-path a',
            ]
        );
        $this->add_control(
            'path_link_color',
            [
                'label' => esc_html__( 'Path Link Color', 'pielements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-path a' => 'color: {{VALUE}};',
                ],
            ]
        );     
        $this->end_controls_section();

        $this->start_controls_section(  
            'breadrumb_separtor_style',
            [
                'label' => esc_html__( 'Separtor', 'pielements' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );          
        $this->add_responsive_control(
			'separtor_size',
			[
				'type' => \Elementor\Controls_Manager::SLIDER,
				'label' => esc_html__( 'Size', 'pielements' ),
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 2000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-separator' => 'font-size: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
        $this->add_control(
            'separtor_color',
            [
                'label' => esc_html__( 'Separtor Color', 'pielements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-separator' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'separtor_padding',
            [
                'label' => esc_html__( 'Padding', 'pielements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-separator' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'separtor_margin',
            [
                'label' => esc_html__( 'Margin', 'pielements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .reactheme-breadcrumb .breadcrumb-inner .breadcrumb-separator' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );
        $this->end_controls_section();
    }  

    protected function render() {
        $settings = $this->get_settings_for_display();          
        $custom_home_title = $settings['custom_home_title'];     
        $custom_title = $settings['custom_title'];     
        $custom_path = $settings['custom_path'];     
        $separator_icon = $settings['separator_icon'];
        $search_custom_title = $settings['search_custom_title'];
        $search_result_title = $settings['search_result_title'];
        $title_tag = $settings['title_tag'];

        echo get_rt_breadcrumb($custom_title, $custom_path, $separator_icon, $custom_home_title, $search_custom_title,$search_result_title,$title_tag);
        
    }
}
