<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

defined( 'ABSPATH' ) || die();

class ReacTheme_Elementor_Blog_Grid_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'react-blog';
	}	   
    
	public function get_style_depends() {
		wp_register_style( 'blog-grid-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'blog-grid-style'
		];
	}

	public function get_title() {
		return esc_html__( 'RT Blog Grid', 'rtelements' );
	}

	public function get_icon() {
		return 'rt-e-icon';
	}

	public function get_categories() {
        return [ 'pielements_category' ];
    }

	protected function register_controls() {		

		$post_categories = get_terms( 'category' );

        $post_options = [];
        foreach ( $post_categories as $category ) {
            $post_options[ $category->slug ] = $category->name;
        }

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Blog Settings', 'rtelements' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'blog_grid_style',
			[
				'label'   => esc_html__( 'Select Style', 'rtelements' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [					
                    'style1' => esc_html__( 'Style 1', 'rtelements'),
                    'style2' => esc_html__( 'Style 2', 'rtelements'),
                    'style3' => esc_html__( 'Style 3', 'rtelements'),
                    'style4' => esc_html__( 'Style 4', 'rtelements'),
                    'style5' => esc_html__( 'Style 5', 'rtelements'),
				],
			]
		); 

		$this->add_control(
			'category',
			[
				'label'   => esc_html__( 'Category', 'rtelements' ),				
				'type'        => Controls_Manager::SELECT2,
                'options'     => $post_options,
                'default'     => [],
				'multiple' => true,		
			]
		);

         $this->add_control(
            'order_by',
            [
                'label' => __('Order By', 'rtelements'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => __('Date', 'rtelements'),
                    'title' => __('Title', 'rtelements'),
                    'rand' => __('Random', 'rtelements'),
                    'comment_count' => __('Comment Count', 'rtelements'),
                    'menu_order' => __('Menu Order', 'rtelements'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('Order', 'rtelements'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'ASC' => __('Ascending', 'rtelements'),
                    'DESC' => __('Descending', 'rtelements'),
                ],
            ]
        );

		$this->add_control(
			'per_page',
			[
				'label' => esc_html__( 'Per Page', 'rtelements' ),
				'type' => Controls_Manager::NUMBER,
				'default' => esc_html__( '6', 'rtelements' ),
			]
		);

        $this->add_control(
            'post_offset',
            [
                'label' => esc_html__( 'Offset', 'rtelements' ),
                'type' => Controls_Manager::NUMBER,   
            ]
        ); 

        $this->add_control(
            'title_word_count',
            [
                'label' => esc_html__( 'Title Word Limit', 'rtelements' ),
                'type' => Controls_Manager::NUMBER,     
                'placeholder' => 5,    
            ]
        );   

        $this->add_control(
            'des_word_count',
            [
                'label' => esc_html__( 'Description Word Limit', 'rtelements' ),
                'type' => Controls_Manager::NUMBER,     
                'placeholder' => 10,    
                'condition' => [
                    'blog_grid_style' => 'style4'
                ]
            ]
        );  

        $this->add_control(
            'blog_category_show_hide',
            [
                'label' => esc_html__( 'Category', 'rtelements' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
	  	        'label_off' => esc_html__('No', 'rtelements'),      
	  	        'return_value' => 'yes', 
                'default' => 'yes',        
            ]
        );

        $this->add_control(
            'blog_author_show_hide',
            [
                'label' => esc_html__( 'Author', 'rtelements' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
	  	        'label_off' => esc_html__('No', 'rtelements'),      
	  	        'return_value' => 'yes', 
                'default' => 'yes',                
            ]
        );

        $this->add_control(
            'blog_date_show_hide',
            [
                'label' => esc_html__( 'Date', 'rtelements' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
	  	        'label_off' => esc_html__('No', 'rtelements'),      
	  	        'return_value' => 'yes', 
                'default' => 'no',               
            ]
        );

        $this->add_control(
            'blog_pagination_show_hide',
            [
                'label' => esc_html__( 'Pagination', 'rtelements' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
	  	        'label_off' => esc_html__('No', 'rtelements'),      
	  	        'return_value' => 'yes', 
                'default' => 'no',               
            ]
        );  

        $this->add_responsive_control(
            'pagination_top_spacing',
            [
                'label' => esc_html__('Spacing', 'rtelements'),
                'type' => Controls_Manager::SLIDER,
                'show_label' => true,
                'size_units' => [ '%', 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .reactheme-pagination-area' => 'padding-top:{{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'blog_pagination_show_hide' => 'yes'
                ]
            ]
        ); 
        
        $this->add_control(
	  	    'blog_link_dis',
	  	    [
	  	        'label' => esc_html__('Link Disable', 'rtelements'),
	  	        'type' => Controls_Manager::SWITCHER,
	  	        'label_on' => esc_html__('Yes', 'rtelements'),
	  	        'label_off' => esc_html__('No', 'rtelements'),
	  	        'return_value' => 'yes',
	  	        'default' => '',
	  	    ]
	  	);

        $this->add_control(
	  	    'blog_img_dis',
	  	    [
	  	        'label' => esc_html__('Featured Image Disable', 'rtelements'),
	  	        'type' => Controls_Manager::SWITCHER,
	  	        'label_on' => esc_html__('Yes', 'rtelements'),
	  	        'label_off' => esc_html__('No', 'rtelements'),
	  	        'return_value' => 'yes',
	  	        'default' => '',
                'condition' => [
                    'blog_grid_style' => 'style4'
                ]
	  	    ]
	  	);       
       
        $this->add_control(
            'blog_btn_text',
            [
                'label' => esc_html__( 'Button Text', 'rtelements' ),
                'type' => Controls_Manager::TEXT,   
                'default' => esc_html__( 'Read More', 'rtelements' ),
                'condition' => [
                    'blog_grid_style' => ['style2', 'style3', 'style4', 'style5']
                ]
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'   => esc_html__('Title HTML Tag', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'h3',
                'options' => [
                    'h1' => esc_html__('H1', 'rtelements'),
                    'h2' => esc_html__('H2', 'rtelements'),
                    'h3' => esc_html__('H3', 'rtelements'),
                    'h4' => esc_html__('H4', 'rtelements'),
                    'h5' => esc_html__('H5', 'rtelements'),
                    'h6' => esc_html__('H6', 'rtelements'),
                    'p' => esc_html__('P', 'rtelements'),
                    'span' => esc_html__('Span', 'rtelements'),
                ],
            ]
        ); 
        $this->end_controls_section();

        $this->start_controls_section(
            'grid_section',
            [
                'label' => esc_html__( 'Grid Settings', 'rtelements' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'blog_columns',
			[
				'label'   => esc_html__( 'Desktops > 1199px', 'rtelements' ),
				'type'    => Controls_Manager::SELECT,
                'default' => 3,			
				'options' => [
                    '1' => esc_html__('1 Column', 'rtelements'),
                    '2' => esc_html__('2 Column', 'rtelements'),
                    '3' => esc_html__('3 Column', 'rtelements'),
                    '4' => esc_html__('4 Column', 'rtelements'),
                    '5' => esc_html__('5 Column', 'rtelements'),
                    '6' => esc_html__('6 Column', 'rtelements'),				
				],						
			]
		);

        $this->add_control(
            'col_md',
            [
                'label'   => esc_html__('Laptop > 991px', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 2,
                'options' => [
                    '1' => esc_html__('1 Column', 'rtelements'),
                    '2' => esc_html__('2 Column', 'rtelements'),
                    '3' => esc_html__('3 Column', 'rtelements'),
                    '4' => esc_html__('4 Column', 'rtelements'),
                    '5' => esc_html__('5 Column', 'rtelements'),
                    '6' => esc_html__('6 Column', 'rtelements'),
                ],
            ]
        );

        $this->add_control(
            'col_sm',
            [
                'label'   => esc_html__('Tablets > 767px', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 1,
                'options' => [
                    '1' => esc_html__('1 Column', 'rtelements'),
                    '2' => esc_html__('2 Column', 'rtelements'),
                    '3' => esc_html__('3 Column', 'rtelements'),
                    '4' => esc_html__('4 Column', 'rtelements'),
                    '5' => esc_html__('5 Column', 'rtelements'),
                    '6' => esc_html__('6 Column', 'rtelements'),
                ],
            ]
        );

        $this->add_responsive_control(
            'item_middle_gap',
            [
                'label' => esc_html__('Item Middle Gap', 'rtelements'),
                'type' => Controls_Manager::SLIDER,
                'show_label' => true,
                'size_units' => [ '%', 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .row.blog-gird-item' => '--bs-gutter-x:{{SIZE}}{{UNIT}} !important;',
                ],  
            ]
        );    

        $this->add_responsive_control(
            'item_bottom_gap',
            [
                'label' => esc_html__('Item Bottom Gap', 'rtelements'),
                'type' => Controls_Manager::SLIDER,
                'show_label' => true,
                'size_units' => [ '%', 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .grid-item' => 'margin-bottom:{{SIZE}}{{UNIT}};',
                ],
            ]
        );  
    $this->end_controls_section();         

    // ========Style========//
    $this->start_controls_section(
        'section_item_style',
        [
            'label' => esc_html__( 'Item', 'rtelements' ),
            'tab' => Controls_Manager::TAB_STYLE,
            'condition' => [
                'blog_grid_style' => ['style1', 'style2'],
            ]
        ]
    );

    $this->add_control(
        'item_color',
        [
            'label' => esc_html__( 'Background', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [                  
                '{{WRAPPER}} .item' => 'background: {{VALUE}};',                   
            ],                
        ]
    );

    $this->add_control(
        'item_border_color',
        [
            'label' => esc_html__( 'Border Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [                  
                '{{WRAPPER}} .item' => 'border-color: {{VALUE}};',                   
            ],             
            'condition' => [
                'blog_grid_style' => 'style2',
            ]              
        ]
    );

    $this->add_responsive_control(
        'item_radius',
        [
            'label' => esc_html__( 'Border Radius', 'rtelements' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],            
            'selectors' => [
                '{{WRAPPER}} .item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );

    $this->add_responsive_control(
        'item_padding',
        [
            'label' => esc_html__( 'Padding', 'rtelements' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],            
            'selectors' => [
                '{{WRAPPER}} .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
    $this->end_controls_section();   

	$this->start_controls_section(
        'section_title_style',
        [
            'label' => esc_html__( 'Title', 'rtelements' ),
            'tab' => Controls_Manager::TAB_STYLE,
        ]
    );

    $this->add_control(
        'title_color',
        [
            'label' => esc_html__( 'Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [                  
                '{{WRAPPER}} .title' => 'color: {{VALUE}};',                   
            ],                
        ]
    );

    $this->add_control(
        'title_color_hover',
        [
            'label' => esc_html__( 'Hover Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .title:hover' => 'color: {{VALUE}};',                    
            ],                
        ]            
    );

    $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'title_typography',
            'label' => esc_html__( 'Typography', 'rtelements' ),
            'selector' => '{{WRAPPER}} .title',                    
        ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
        'section_des_style',
        [
            'label' => esc_html__( 'Description', 'rtelements' ),
            'tab' => Controls_Manager::TAB_STYLE,           
            'condition' => [
                'blog_grid_style' => 'style4',
            ] 
        ]
    );

    $this->add_control(
        'des_color',
        [
            'label' => esc_html__( 'Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [                  
                '{{WRAPPER}} .disc' => 'color: {{VALUE}};',                   
            ],                
        ]
    );

    $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'des_typography',
            'label' => esc_html__( 'Typography', 'rtelements' ),
            'selector' => '{{WRAPPER}} .disc',                    
        ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
    'meta_category_style',
        [
            'label' => esc_html__( 'Category', 'rtelements' ),
            'tab' => Controls_Manager::TAB_STYLE,
            'condition' => ['blog_category_show_hide' => 'yes'],  
        ]
    );

    $this->add_control(
        'cat_color',
        [
            'label' => esc_html__( 'Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .blog-meta .cat' => 'color: {{VALUE}};',                    
                '{{WRAPPER}} .blog-meta .cat a' => 'color: {{VALUE}};',                    
            ],
            'condition' => ['blog_category_show_hide' => 'yes'],              
        ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'name' => 'cat_typography',
            'selector' => '{{WRAPPER}} .blog-meta .cat a,{{WRAPPER}} .blog-meta .cat',
            'condition' => ['blog_category_show_hide' => 'yes'],  
        ]
    ); 
    $this->end_controls_section();

    $this->start_controls_section(
        'meta_author_style',
        [
            'label' => esc_html__( 'Author', 'rtelements' ),
            'tab' => Controls_Manager::TAB_STYLE,
            'condition' => ['blog_author_show_hide' => 'yes'],   
        ]
    );

    $this->add_control(
        'author_color',
        [
            'label' => esc_html__( 'Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .blog-meta .author' => 'color: {{VALUE}};',                    
                '{{WRAPPER}} .blog-meta .author a' => 'color: {{VALUE}};',                    
            ],
            'condition' => ['blog_author_show_hide' => 'yes'],              
        ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'name' => 'author_typography',
            'selector' => '{{WRAPPER}} .blog-meta .author',
            'condition' => ['blog_author_show_hide' => 'yes'],  
        ]
    ); 
    $this->end_controls_section();

    $this->start_controls_section(
        'meta_date_style',
        [
            'label' => esc_html__( 'Date', 'rtelements' ),
            'tab' => Controls_Manager::TAB_STYLE,
            'condition' => [
                'blog_date_show_hide' => 'yes'
            ],   
        ]
    );

    $this->add_control(
        'date_color',
        [
            'label' => esc_html__( 'Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .blog-meta .date' => 'color: {{VALUE}};',                    
            ],
            'condition' => ['blog_date_show_hide' => 'yes'],              
        ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'name' => 'date_typography',
            'selector' => '{{WRAPPER}} .blog-meta .date',
            'condition' => ['blog_date_show_hide' => 'yes'],  
        ]
    ); 
    $this->end_controls_section();

    $this->start_controls_section(
        'blog_btn_styles',
        [
            'label' => esc_html__( 'Button', 'rtelements' ),
            'tab' => Controls_Manager::TAB_STYLE,                  
            'condition' => [
                'blog_grid_style' => ['style2', 'style3', 'style4', 'style5'],
                'blog_btn_text!' => '',
            ]
        ]
    );
     $this->add_control(
        'btn_color',
        [
            'label' => esc_html__( 'Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .button' => 'color: {{VALUE}};',                    
            ],            
        ]
    );

    $this->add_control(
        'btn_hover_color',
        [
            'label' => esc_html__( 'Hover Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .button:hover' => 'color: {{VALUE}};',                    
            ],            
        ]
    );    

    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'name' => 'btn_typography',
            'selector' => '{{WRAPPER}} .button',
        ]
    ); 

    $this->add_control(
        'btn_icon_styles',
        [
            'label' => esc_html__( 'Icon', 'rtelements' ),
            'type' => Controls_Manager::HEADING,
            'separator' => 'before'        
        ]
    );

    $this->add_control(
        'btn_icon_color',
        [
            'label' => esc_html__( 'Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .button i' => 'color: {{VALUE}};',                    
            ],            
        ]
    );

    $this->add_control(
        'btn_icon_h_color',
        [
            'label' => esc_html__( 'Hover Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .button:hover i' => 'color: {{VALUE}};',                    
            ],            
        ]
    );

    $this->add_control(
        'btn_icon_bgcolor',
        [
            'label' => esc_html__( 'Background', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .button i' => 'background: {{VALUE}};',                    
            ],          
            'condition' => [
                'blog_grid_style' => 'style2',
            ]  
        ]
    );   

    $this->add_control(
        'btn_icon_h_bgcolor',
        [
            'label' => esc_html__( 'Hover Background', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .button:hover i' => 'background: {{VALUE}};',                    
            ],          
            'condition' => [
                'blog_grid_style' => 'style2',
            ]          
        ]
    );
    $this->end_controls_section();

     $this->start_controls_section(
        'blog_img',
        [
            'label' => esc_html__( 'Image', 'rtelements' ),
            'tab' => Controls_Manager::TAB_STYLE,
        ]
    );

    $this->add_control(
        'img_divider_color',
        [
            'label' => esc_html__( 'Divider Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .blog-image' => 'border-color: {{VALUE}};',                    
            ],      
            'condition' => [
                'blog_grid_style' => 'style1'
            ]    
        ]
    );

    $this->add_responsive_control(
        'img_height',
        [
            'label' => esc_html__( 'Height', 'rtelements' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', 'em', 'rem', 'custom' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 500,
                    'step' => 1,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .thumbnail img' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ]
    );	
    $this->end_controls_section();

    $this->start_controls_section(
        'pagination_styles',
        [
            'label' => esc_html__( 'Pagination', 'rtelements' ),
            'tab' => Controls_Manager::TAB_STYLE,
            'condition' => [
                'blog_pagination_show_hide' => 'yes' 
            ]
        ]
    );

    $this->add_control(
        'pagination_color',
        [
            'label' => esc_html__( 'Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a' => 'color: {{VALUE}};',                       
            ],           
        ]
    );

     $this->add_control(
        'pagination_border_color',
        [
            'label' => esc_html__( 'Border Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a' => 'border-color: {{VALUE}};',                       
            ],           
        ]
    );
    
    $this->add_control(
        'pagination_active_color',
        [
            'label' => esc_html__( 'Hover & Active Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a:hover' => 'color: {{VALUE}};',                       
                '{{WRAPPER}} .reactheme-pagination-area .nav-links .current' => 'color: {{VALUE}};',                       
            ],           
        ]
    );

    $this->add_control(
        'pagination_bgcolor',
        [
            'label' => esc_html__( 'Background', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a' => 'background: {{VALUE}};',                       
            ],           
        ]
    );
    
    $this->add_control(
        'pagination_active_bgcolor',
        [
            'label' => esc_html__( 'Hover & Active Background', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [                     
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a:hover' => 'background: {{VALUE}};',   
                '{{WRAPPER}} .reactheme-pagination-area .nav-links .current' => 'background: {{VALUE}};',                      
            ],           
        ]
    );

    $this->add_control(
		'pagination_active_border_color',
		[
			'label' => esc_html__( 'Hover & Active Border Color', 'rtelements' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .reactheme-pagination-area .nav-links a:hover' => 'border-color: {{VALUE}};', 
				'{{WRAPPER}} .reactheme-pagination-area .nav-links .current' => 'border-color: {{VALUE}};',                         
			],           
		]
    );
    $this->end_controls_section();
	}

	protected function render() {
		$settings     = $this->get_settings_for_display();
        $style        = $settings['blog_grid_style'];       
        $col_lg       = 12 / $settings['blog_columns'] ;
        $col_md       = 12 / $settings['col_md'];
        $col_sm       = 12 / $settings['col_sm'];
        $col          = 'col-lg-'.$col_lg.' col-md-'.$col_md.' col-sm-'.$col_sm.' col-12';  
        $limit        = !empty( $settings['title_word_count'] ) ? $settings['title_word_count'] : 3;        
        $des_limit    = !empty( $settings['des_word_count'] ) ? $settings['des_word_count'] : 12;  
        $author_show  = ( $settings['blog_author_show_hide'] == 'yes' ) ? 'yes' : '';				              
        $cat_show     = ( $settings['blog_category_show_hide'] == 'yes' ) ? 'yes' : '';	        
        $date_show    = ( $settings['blog_date_show_hide'] == 'yes' ) ? 'yes' : '';	          
        $blog_link_dis = ( $settings['blog_link_dis'] == 'yes' ) ? 'rt--link-dis' : '' ;	
        $blog_img_dis = ( $settings['blog_img_dis'] == 'yes' ) ? 'blog-img-dis' : '' ;	

        ?>
		<div class="blog-grid <?php echo esc_attr( $style ); ?>">   
            <div class="row blog-gird-item <?php echo esc_attr( $blog_link_dis ); ?>">
			 	<?php
			        $cat = $settings['category'];     
                    global $paged;
                    $paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
                    $args = array(
                        'post_type'      => 'post',
                        'posts_per_page' => $settings['per_page'],
                        'offset'         => $settings['post_offset'],
                        'orderby'        => isset($settings['order_by']) ? $settings['order_by'] : 'date',
                        'order'          => isset($settings['order']) ? $settings['order'] : 'DESC',
                    );

                    if ( $settings['blog_pagination_show_hide'] === 'yes' ) {
                        $args['paged'] = $paged;
                    }

                    if ( !empty( $cat ) ) {
                        $args['tax_query'] = array(
                            array(
                                'taxonomy' => 'category',
                                'field'    => 'slug',
                                'terms'    => $cat,
                            ),
                        );
                    }

                    $best_wp = new WP_Query( $args );
			        $x       = 1;
					while( $best_wp->have_posts() ): $best_wp->the_post(); 
                        $termsArray = get_the_terms( $best_wp->ID, "category" );
                        $termsString = ""; 
                        foreach ( $termsArray as $term ) {
                            $termsString .= 'filter_'.$term->slug.' '; 
                        }
                        $cats_name = get_the_term_list( $best_wp->ID, 'category', ' ', '<span class="separator">,</span>' );                        
                        $blog_date    = get_the_date();	
                        $post_admin   = get_the_author();    

                        if( $style == $style ) {
                            require plugin_dir_path(__FILE__) . "/$style.php";
                        }

                        $x++;
					endwhile;                    
					wp_reset_query(); 
                ?>        
            </div>  
           
           <?php 
                $blog_item_data = array(
                'per_page'  => $settings['per_page']
            );

			$paginate = paginate_links( array(
			    'total' => $best_wp->max_num_pages
			));

			if(!empty($paginate ) && ($settings['blog_pagination_show_hide'] == 'yes')){ ?>
				<div class="reactheme-pagination-area"><div class="nav-links"><?php echo wp_kses_post($paginate); ?></div></div>
			<?php } ?>              
		</div>
	   <?php

	}
}?>