<?php
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

defined('ABSPATH') || die();
class ReacTheme_Widget_Accordion extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'rt-custom-accordions';
    }

	//register css
	public function get_style_depends() {
		wp_register_style( 'accordion-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'accordion-style'
		];
	}
    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */

    public function get_title()
    {
        return esc_html__('RT Accordion', 'rtelements');
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-accordion';
    }


    public function get_categories()
    {
        return ['pielements_category'];
    }

    public function get_keywords()
    {
        return ['Accordion'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            '_section_logo',
            [
                'label' => esc_html__('Item', 'rtelements'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'accordion_style',
            [
                'label'   => esc_html__('Select Style', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [
                    'style1' => 'Style 1',
                    'style2' => 'Style 2',
                    'style3' => 'Style 3',
                ],
            ]
        );
        $repeater = new Repeater();     
        $repeater->add_control(
            'accordion_style',
            [
                'label'   => esc_html__('Select Style', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [
                    'style1' => 'Style 1',
                    'style2' => 'Style 2',
                ],
            ]
        );
        $repeater->add_control(
            'right_icon',
            [
                'label' => esc_html__('Right Icon', 'rtelements'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-laptop-house',
                    'library' => 'solid',
                ],
                'condition' => [
                    'accordion_style' => ['style2']
                ]
            ]
        );       
        $repeater->add_control(
            'name',
            [
                'label' => esc_html__('Item Title', 'rtelements'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('', 'rtelements'),
                'label_block' => true,
                'placeholder' => esc_html__('Title', 'rtelements'),
            ]
        );
        $repeater->add_control(
            'description',
            [
                'label' => esc_html__('Item Description', 'rtelements'),
                'type' => Controls_Manager::TEXTAREA ,
                'default' => esc_html__('', 'rtelements'),
                'label_block' => true,
                'placeholder' => esc_html__('Description', 'rtelements'),
                'separator'   => 'before',
            ]
        );  
        $repeater->add_control(
            'button_text',
            [
                'label' => esc_html__('Button Text', 'rtelements'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Make Appointment', 'rtelements'),
                'label_block' => true,
                'placeholder' => esc_html__('Write your button text', 'rtelements'),
                'condition' => [
                    'accordion_style' => ['style2']
                ]
            ]
        );   
        $repeater->add_control(
            'btn_url',
            [
                'label' => esc_html__('Button URL', 'rtelements'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#'
                ],
                'label_block' => true,
                'placeholder' => esc_html__('Insert your link here', 'rtelements'),
                'condition' => [
                    'accordion_style' => ['style2']
                ]
            ]
        ); 
        $repeater->add_control(
            'btn_icon',
            [
                'label' => esc_html__('Button Icon', 'rtelements'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'rt rt-arrow-up-right',
                    'library' => 'rt-icons',
                ],
                'separator' => 'before',
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'accordion_style' => ['style2']
                ]
            ]
        );    
        $this->add_control(
            'logo_list',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ name }}}',

            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label'   => esc_html__('Title Heading HTML Tag', 'rtelements'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'h3',
                'options' => [
                    'h1' => esc_html__('H1', 'rtelements'),
                    'h2' => esc_html__('H2', 'rtelements'),
                    'h3' => esc_html__('H3', 'rtelements'),
                    'h4' => esc_html__('H4', 'rtelements'),
                    'h5' => esc_html__('H5', 'rtelements'),
                    'h6' => esc_html__('H6', 'rtelements'),
                    'p' => esc_html__('P', 'rtelements'),
                    'span' => esc_html__('Span', 'rtelements'),
                ],
            ]
        );         
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'item_bg_color',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .rts-accordion .accordion-item',

			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'item_border',
				'selector' => '{{WRAPPER}} .rts-accordion .accordion-item',
			]
		);
        $this->add_responsive_control(
			'item_bottom_gap',
			[
				'label' => esc_html__( 'Item Bottom Spacing', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rts-accordion .accordion-item' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);  
        $this->add_responsive_control(
            'item_border_radius',
            [
                'label' => esc_html__('Border Radius', 'rtelements'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .rts-accordion .accordion-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('Item Padding', 'rtelements'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .rts-accordion .accordion-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'item_icon_content',
            [
                'label' => esc_html__('Icon', 'rtelements'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'accordion_style' => ['style1']
                ]
            ]
        );
        $this->add_control(
            'accordion_icon',
            [
                'label' => esc_html__('Accordion Regular Icon', 'rtelements'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'solid',
                ],
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'accordion_active_icon',
            [
                'label' => esc_html__('Accordion Active Icon', 'rtelements'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-up',
                    'library' => 'solid',
                ],
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
			'icon_left_right_position',
			[
				'label' => esc_html__( 'Icon Left & Right Position', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		); 
        $this->end_controls_section();   

        $this->start_controls_section(
            'accordion_head_style',
            [
                'label' => esc_html__('Header', 'rtelements'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'accordion_head_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rts-accordion .accordion-item .accordion-button' => 'color: {{VALUE}} !important',
				],
			]
		);
        $this->add_control(
			'accordion_head_active_color',
			[
				'label' => esc_html__( 'Active Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rts-accordion .accordion-item .accordion-button[aria-expanded=true]' => 'color: {{VALUE}} !important',                                  
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'head_typo',
				'selector' => '{{WRAPPER}} .rts-accordion .accordion-item .accordion-button',
			]
		);        
        $this->add_control(
			'accordion_head_bg',
			[
				'label' => esc_html__( 'Background', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rts-accordion .accordion-item .accordion-button' => 'background: {{VALUE}} !important',                   
				],
			]
		);
        $this->add_control(
			'accordion_head_active_bg',
			[
				'label' => esc_html__( 'Active Background', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rts-accordion .accordion-item .accordion-button[aria-expanded=true]' => 'background: {{VALUE}} !important',                   
				],
			]
		);  
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'head_border',
				'selector' => '{{WRAPPER}} .rts-accordion .accordion-item .accordion-button',
			]
		);   
        $this->add_responsive_control(
            'accordion_head_padding',
            [
                'label' => esc_html__('Padding', 'rtelements'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .rts-accordion .accordion-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'accordion_des_style',
            [
                'label' => esc_html__('Description', 'rtelements'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'des_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rts-accordion .accordion-item .accordion-body' => 'color: {{VALUE}} !important',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'des_typo',
				'selector' => '{{WRAPPER}} .rts-accordion .accordion-item .accordion-body',
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'des_bg',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .rts-accordion .accordion-item .accordion-body'
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'des_border',
				'selector' => '{{WRAPPER}} .rts-accordion .accordion-item .accordion-body',
			]
		);
        $this->add_responsive_control(
            'des_padding',
            [
                'label' => esc_html__('Padding', 'rtelements'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .rts-accordion .accordion-item .accordion-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

		$this->start_controls_section(
		    '_section_style_icon',
		    [
		        'label' => esc_html__( 'Icon', 'rtelements' ),
		        'tab' => Controls_Manager::TAB_STYLE,
		    ]
		);
		$this->add_control(
		    'icon__color',
		    [
		        'label' => esc_html__( 'Color', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon i' => 'color: {{VALUE}};',
		            '{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon svg path' => 'fill: {{VALUE}};',
		        ],
		    ]
		);	        	
		$this->add_control(
		    'icon_border_active_color',
		    [
		        'label' => esc_html__( 'Active Color', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .accordion-icon-active.icon i' => 'color: {{VALUE}};',
		        ],
                'condition' => [
                    'accordion_style' => ['style1']
                ]
		    ]
		);	
         
        $this->add_control(
		    'icon__bgcolor',
		    [
		        'label' => esc_html__( 'Background Color', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon' => 'background: {{VALUE}};',
		        ], 
		    ]
		);	     
        $this->add_control(
		    'icon__border_color',
		    [
		        'label' => esc_html__( 'Border Color', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon::before' => 'border-color: {{VALUE}};',
		        ], 
                'condition' => [
                    'accordion_style' => ['style2']
                ]
		    ]
		);	  
        $this->add_responsive_control(
            'icon_border_radius',
            [
                'label' => esc_html__('Border Radius', 'rtelements'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    '{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ], 
            ]
        );   	
        $this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 120,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon i' => 'font-size: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		);  
        $this->add_responsive_control(
			'icon_box_width',
			[
				'label' => esc_html__( 'Box Width', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'icon_box_height',
			[
				'label' => esc_html__( 'Box Height', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		); 
        $this->add_responsive_control(
			'icon_box_line_height',
			[
				'label' => esc_html__( 'Box Line Height', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon' => 'line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);  
        $this->add_responsive_control(
			'icon_box_border_wh',
			[
				'label' => esc_html__( 'Border Width & Height', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rts-accordion .accordion-item .accordion-header .accordion-button .icon::before' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],                
                'condition' => [
                    'accordion_style' => ['style2']
                ]
			]
		); 
		$this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $unique = wp_unique_id('accordion_');
        $blank = '';

        // Ensure required settings are present
        $accordion_style = isset($settings['accordion_style']) ? $settings['accordion_style'] : 'style1';
        $title_tag_raw = isset($settings['title_tag']) ? strtolower($settings['title_tag']) : 'h3';
        $allowed_tags = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6'];
        $title_tag = in_array($title_tag_raw, $allowed_tags) ? $title_tag_raw : 'h3';

        if (!empty($settings['logo_list']) && is_array($settings['logo_list'])) : ?>
            <div class="rts-accordion <?php echo esc_attr($accordion_style); ?>" id="<?php echo esc_attr($unique); ?>">
                <?php
                $x = 0;
                foreach ($settings['logo_list'] as $index => $item) :
                    $title = !empty($item['name']) ? $item['name'] : '';
                    $description = !empty($item['description']) ? $item['description'] : '';
                    $button = !empty($item['button_text']) ? $item['button_text'] : '';
                    $btn_url = !empty($item['btn_url']['url']) ? $item['btn_url']['url'] : '';
                    $dataUnique = $unique . '-' . $x;

                    $x++;
                    $is_first = $x === 1;
                    $collapse = $is_first ? '' : 'collapsed';
                    $show = $is_first ? 'show' : '';
                    $true = $is_first ? 'true' : 'false';
                    $bg_color = $is_first ? 'bg_color' : '';
                    $active = $is_first ? 'active' : '';

                    ?>
                    <div class="accordion-item <?php echo esc_attr($bg_color); ?>">
                        <div class="accordion-header" id="heading-<?php echo esc_attr($dataUnique); ?>">
                            <<?php echo esc_attr($title_tag); ?> class="accordion-button m-0 <?php echo esc_attr($active); ?> <?php echo esc_attr($collapse); ?>" data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo esc_attr($dataUnique); ?>" aria-expanded="<?php echo esc_attr($true); ?>" aria-controls="collapse-<?php echo esc_attr($dataUnique); ?>">
                                <?php echo wp_kses_post($title); ?>
                                <?php if ($accordion_style === 'style2' && !empty($item['right_icon']['value'])) : ?>
                                    <span class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon($item['right_icon'], ['aria-hidden' => 'true']); ?>
                                    </span>
                                <?php elseif (!empty($item['title_icon']['value'])) : ?>
                                    <span class="title_icon">
                                        <?php \Elementor\Icons_Manager::render_icon($item['title_icon'], ['aria-hidden' => 'true']); ?>
                                    </span>
                                <?php endif; ?>

                                <?php if ($accordion_style === 'style1' || $accordion_style === 'style2') : ?>
                                    <span class="accordion-icon icon"><?php \Elementor\Icons_Manager::render_icon($settings['accordion_icon'], ['aria-hidden' => 'true']); ?></span>
                                    <span class="accordion-icon-active icon"><?php \Elementor\Icons_Manager::render_icon($settings['accordion_active_icon'], ['aria-hidden' => 'true']); ?></span>
                                <?php elseif (!empty($settings['accordion_icons_options']) && $settings['accordion_icons_options'] === 'number') : ?>
                                    <span class="accordion-icon number"><?php echo str_pad($x, 2, '0', STR_PAD_LEFT); ?></span>
                                <?php endif; ?>
                            </<?php echo esc_attr($title_tag); ?>>
                        </div>
                        <div id="collapse-<?php echo esc_attr($dataUnique); ?>" class="accordion-collapse collapse <?php echo esc_attr($show); ?>" aria-labelledby="heading-<?php echo esc_attr($dataUnique); ?>" data-bs-parent="#<?php echo esc_attr($unique); ?>">
                            <div class="accordion-body m-0">
                                <?php echo do_shortcode($description); ?>                                
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>


        <script>
            jQuery(document).ready(function () {
                jQuery('.rts-accordion .accordion-button').click(function () {                  
                    jQuery('.rts-accordion .accordion-item').removeClass("bg_color");                                       
                    jQuery(this).closest('.accordion-item').addClass("bg_color");
                });
            });
        </script>
<?php
    }
} ?>