<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
defined( 'ABSPATH' ) || die();

class RTS_Product_Cart extends \Elementor\Widget_Base {

	public function get_name() {
		return 'rt-productcart';
	}

	public function get_title() {
		return __( 'RT Woo Cart', 'rsaddon' );
	}

	public function get_icon() {
		return 'rt-e-icon';
	}

	public function get_categories() {
        return [ 'pielements_category' ];
    }

	public function get_keywords() {
		return [ 'product', 'list', 'category' ];
	}

	protected function register_controls()
    {
    	$this->start_controls_section(
            'rt_cart_content',
            [
                'label' => esc_html__('Cart Item', 'rsaddon'),
               
            ]
        );
        $this->add_control(
			'cart_icon',
			[
				'label'       => __( 'Cart Icon', 'rtelements' ),
				'type'        => Controls_Manager::ICONS,
				'default' => [
					'value' => 'rt rt-cart-shopping',
					'library' => 'rt-icons',
				]
            ]
		);

          $this->end_controls_section();

        $this->start_controls_section(
            'rs_section_product_grid_typography',
            [
                'label' => esc_html__('Icon', 'rsaddon'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'cart_icon_color',
            [
				'label'   => esc_html__('Icon Color', 'rsaddon'),
				'type'    => Controls_Manager::COLOR,
				'default' => '#040404',
                'selectors' => [
                    '{{WRAPPER}} .menu-cart-area i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .menu-cart-area svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );
		  
        $this->add_responsive_control(
			'icon_size',
			[
				 'label' => esc_html__( 'Icon Size', 'plugin-name' ),
				 'type' => \Elementor\Controls_Manager::SLIDER,
				 'size_units' => [ 'px', '%' ],
				 'range' => [
					  'px' => [
							'min' => 0,
							'max' => 100,
							'step' => 1,
					  ],
					  '%' => [
							'min' => 0,
							'max' => 100,
					  ],
				 ],				 
				 'selectors' => [
					  '{{WRAPPER}} .menu-cart-area i' => 'font-size: {{SIZE}}{{UNIT}};',
					  '{{WRAPPER}} .menu-cart-area svg' => 'width: {{SIZE}}{{UNIT}};',
					  
				 ],
			]
	  );
        $this->add_responsive_control(
            'width',
            [
                'label' => esc_html__( 'Icon Box width', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                
                'selectors' => [
                    '{{WRAPPER}} .menu-cart-area' => 'width: {{SIZE}}{{UNIT}};',
                    
                ],
            ]
        );
          $this->add_responsive_control(
            'height',
            [
                'label' => esc_html__( 'Icon Box Height', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                
                'selectors' => [                    
                    '{{WRAPPER}} .menu-cart-area' => 'height: {{SIZE}}{{UNIT}};',
                   
                ],
            ]
        );
         $this->add_responsive_control(
            'line-height',
            [
                'label' => esc_html__( 'Icon Box Line Height', 'plugin-name' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],                
                'selectors' => [
                    '{{WRAPPER}} .menu-cart-area' => 'line-height: {{SIZE}}{{UNIT}};'
                ],
            ]
        );

        $this->add_responsive_control(
			'align',
			[
				'label'              => __( 'Icon Alignment', 'rtelements' ),
				'type'               => Controls_Manager::CHOOSE,
				'options'            => [
					'left'   => [
						'title' => __( 'Left', 'rtelements' ),
						'icon'  => 'eicon-h-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'rtelements' ),
						'icon'  => 'eicon-h-align-center',
					],
					'right'  => [
						'title' => __( 'Right', 'rtelements' ),
						'icon'  => 'eicon-h-align-right',
					],
				],				
				'selectors'          => [
					'{{WRAPPER}} .menu-cart-area' => 'text-align: {{VALUE}};',
				],
				'frontend_available' => true,
			]
		); 
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bg',
                'label' => esc_html__( 'Icon Box Background', 'rsaddon' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '.menu-cart-area',
            ]
        ); 
        $this->add_control(
            'icon_border_radius',
            [
                'label' => esc_html__( 'Icon Box Border Radius', 'rtelements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '.menu-cart-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        ); 
		  
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'icon__border',
				'selector' => '{{WRAPPER}} .menu-cart-area',
			]
		); 
      $this->end_controls_section(); 
    }

    protected function render(){
      $settings = $this->get_settings_for_display();
		global $woocommerce;
		if ( class_exists( 'WooCommerce' ) ) {?>
			<div class="woocomerce menu-cart-area">
				<?php \Elementor\Icons_Manager::render_icon( $settings['cart_icon'], [ 'aria-hidden' => 'true' ] ); ?> 	
			</div>			
		<?php } 
    	
    }   

}