<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

defined('ABSPATH') || die();

class Reactheme_Elementor_Video_Widget extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'react-video';
	}

	public function get_style_depends() {
		wp_register_style( 'rt-video-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'rt-video-style'
		];
	}

	public function get_title()
	{
		return __('RT Video', 'rtelements');
	}

	public function get_icon()
	{
		return 'rt-e-icon';
	}

	public function get_categories()
	{
		return ['rtelements_category'];
	}

	public function get_keywords()
	{
		return ['video'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'section_counter',
			[
				'label' => esc_html__('Content', 'rtelements'),
			]
		);
		$this->add_control(
			'select_style',
			[
				'label' => esc_html__( 'Video Mode', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'rtelements' ),
					'rotate' => esc_html__( 'Rotate', 'rtelements' ),
				],
			]
		);				
		$this->add_control(
			'popup_video',
			[
				'label' => esc_html__( 'Video Popup', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'yes' => esc_html__( 'Yes', 'rtelements' ),
				'no' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'video_link',
			[
				'label' => esc_html__('Link', 'rtelements'),
				'type' => Controls_Manager::TEXT,
				'default'     => '#',
				'placeholder' => esc_html__('Video link here', 'rtelements'),
				'condition' => ['popup_video' => 'yes']
			]
		);
		$this->add_control(
			'label',
			[
				'label' => esc_html__('Label', 'rtelements'),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__('Label text here', 'rtelements'),
			]
		);
		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__('Alignment', 'rtelements'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'rtelements'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'rtelements'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'rtelements'),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__('Justify', 'rtelements'),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'default'     => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .react-video' => 'text-align: {{VALUE}}'
				],
				'condition' => [
					'select_style' => 'default'
				]
			]
		);		
		$this->add_control(
			'video_icon',
			[
				'label' => esc_html__( 'Video Icon', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'recommended' => [
					'fa-solid' => [
						'circle',
						'dot-circle',
						'square-full',
					],
					'fa-regular' => [
						'circle',
						'dot-circle',
						'square-full',
					],
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__('Content', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'content_area_bg_color',
			[
				'label' => esc_html__('Background Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .react-video .video-icon' => 'background: {{VALUE}};',
					'{{WRAPPER}} .react-video .circle' => 'background: {{VALUE}};',
				],
			]
		);		
		$this->add_control(
			'video_popup_color',
			[
				'label' => esc_html__('Popup Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .react-video .rts__circle::before' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'select_style' => 'default'
				]
			]
		);
		$this->add_responsive_control(
			'content_area_width',
			[
				'label' => esc_html__('Width', 'rtelements'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['%','px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .react-video .video-icon' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .react-video .circle' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);	
		$this->add_responsive_control(
			'content_area_height',
			[
				'label' => esc_html__('Height', 'rtelements'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['%','px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .react-video .video-icon' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .react-video .circle' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'content_area_line_height',
			[
				'label' => esc_html__('Line Height', 'rtelements'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['%','px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .react-video .video-icon' => 'line-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .react-video .circle' => 'line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);		
		$this->add_responsive_control(
			'content_area_align',
			[
				'label' => esc_html__('Alignment', 'rtelements'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'rtelements'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'rtelements'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'rtelements'),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__('Justify', 'rtelements'),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .react-video .video-icon' => 'text-align: {{VALUE}}'
				],
				'condition' => [
					'select_style' => 'default'
				]
			]
		);	
		$this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
		      'name' => 'content_area_border',
		      'selector' => '{{WRAPPER}} .react-video .video-icon',
				'condition' => [
					'select_style' => 'default'
				]
		    ]
		);
		$this->add_control(
		    'content_area_border_radius',
		    [
		        'label' => esc_html__( 'Border Radius', 'rtelements' ),
		        'type' => Controls_Manager::DIMENSIONS,
		        'size_units' => [ 'px', '%' ],
		        'selectors' => [
		            '{{WRAPPER}} .react-video .video-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',       
		        ],
				'condition' => [
					'select_style' => 'default'
				]
		    ]
		);
		$this->add_control(
		    'content_area_padding',
		    [
				'label' => esc_html__( 'Padding', 'rtelements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .react-video .video-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',       
				],				
				'condition' => [
					'select_style' => 'default'
				]
		    ]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_icon',
			[
				'label' => esc_html__('Icon', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__('Icon Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .react-video .video-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .react-video .video-icon svg path' => 'fill: {{VALUE}};',
				],
			]
		);	
		$this->add_responsive_control(
			'icon_with',
			[
				'label' => esc_html__('Icon Width', 'rtelements'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['%','px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .react-video .video-icon' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .react-video .video-icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		);					
		$this->end_controls_section();

		$this->start_controls_section(
			'video_label',
			[
				'label' => esc_html__('Label', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'label_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .react-video .video-icon .label' => 'color: {{VALUE}};',
					'{{WRAPPER}} .circle text ' => 'fill: {{VALUE}};',
				],
			]
		);	
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'label_typography',
				'selector' => '{{WRAPPER}} .react-video .video-icon .label,{{WRAPPER}} .circle text',
			]
		);
		$this->add_responsive_control(
			'label_pading',
			[
				 'label' => esc_html__( 'Padding', 'rtelements' ),
				 'type' => Controls_Manager::DIMENSIONS,
				 'size_units' => [ 'px', '%' ],
				 'selectors' => [
					  '{{WRAPPER}} .react-video .video-icon .label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',       
				 ],				 			
				'condition' => [
					'select_style' => 'default'
				]
			]
	  );
	  $this->add_responsive_control(
		  'label_margin',
		  [
				'label' => esc_html__( 'Margin', 'rtelements' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					 '{{WRAPPER}} .react-video .video-icon .label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',       
				],			
				'condition' => [
					'select_style' => 'default'
				]
		  ]
	 );
		$this->end_controls_section();
	}

	protected function render() {

		$settings	 = $this->get_settings_for_display();
		$style		 = $settings['select_style'];
		$rand 		 = rand(12, 3330);		
		$popup_video = (!empty($settings['popup_video'] === 'yes') ? 'popup-videos' : 'popup_of');
		$video_link	 = ($settings['popup_video'] === 'yes') ? 'href="' . esc_url($settings['video_link']) . '"' : '';
		?>

		<div class="react-video video-item-<?php echo esc_attr( $rand ); ?>">
			<div class="overly-border">
				<div class="banner__content--circle rts__circle <?php echo esc_attr( $style ); ?>">
					<?php
					if( $settings['select_style'] === 'rotate' ) : ?>	
						<div class="circle-text-main">
							<div class="circle">
								<a aria-label="video" class="video-icon icon <?php echo esc_attr($popup_video); ?>" <?php echo $video_link; ?>>						
									<?php if(!empty($settings['video_icon']['value'])) : ?>	
										<?php \Elementor\Icons_Manager::render_icon( $settings['video_icon'], [ 'aria-hidden' => 'true' ] ); ?>
										<?php 
									else : ?>
										<i class="fa fa-play"></i>
										<?php 
									endif; ?>
								</a>
								<?php 
								if( !empty( $settings['label'] )) : ?>
									<svg class="text" viewBox="0 0 100 100">
										<defs>
											<path id="circle" d="M50,50 m-37,0a37,37 0 1,1 74,0a37,37 0 1,1 -74,0"></path>
										</defs>
										<text fill="#fff">
											<textPath xlink:href="#circle"><?php echo wp_kses_post($settings['label']); ?></textPath>
										</text>
									</svg>
									<?php 
								endif; ?>
							</div>
						</div>
						<?php 
					else : ?>
						<a aria-label="video" class="video-icon <?php echo esc_attr($popup_video); ?>" <?php echo $video_link; ?>>						
							<?php if(!empty($settings['video_icon']['value'])) : ?>	
								<?php \Elementor\Icons_Manager::render_icon( $settings['video_icon'], [ 'aria-hidden' => 'true' ] ); ?>
								<?php 
							else : ?>
								<i class="fa fa-play"></i>
								<?php 
							endif;
							if(!empty($settings['label'])) : ?>
								<span class="label"> <?php echo wp_kses_post($settings['label']); ?></span>
								<?php 
							endif; ?>
						</a>
						<?php 
					endif; ?>
				</div>				
			</div>
		</div>
	<?php
	}
}