<div class="service-grid-1 item <?php echo esc_attr( $img_left ); ?>">
   <div class="content-area-wrapper">
      <?php 
      if( !empty( $settings['icon']['value'] ) ) : ?>
         <div class="icon">
            <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
         </div>
         <?php 
      else : ?>
         <div class="icon">
            <i class="rt rt-icon-check"></i>
         </div>
         <?php 
      endif;
      if( !empty( $settings['title'] ) ) : ?>
         <<?php echo esc_attr( $settings['title_tag'] ); ?> class="title">
            <?php echo wp_kses_post( $settings['title'] ); ?>
         </<?php echo esc_attr( $settings['title_tag'] ); ?>>
         <?php
      endif;  
      if( !empty( $settings['des'] ) ) : ?>
         <p class="des"><?php echo wp_kses_post( $settings['des'] ); ?></p>
         <?php 
      endif; 
      if( !empty( $settings['button'] ) ) : ?>	     
         <a aria-label="service button" href="<?php echo esc_url( $settings['button_url']['url'] ); ?>" class="button"><?php echo wp_kses_post( $settings['button'] ); ?> <i class="rt rt-arrow-right-regular"></i></a>
         <?php 
      endif; ?>
   </div>
   <?php 
   if( !empty( $image ) ) : ?>
      <div class="thumbnail">
         <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
      </div>
      <?php 
   endif; ?>
</div>
