<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Utils;

defined( 'ABSPATH' ) || die();

class ReacThemes_Service_Grid_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'rt-service-grid';
    }	 

	public function get_style_depends() {
		wp_register_style( 'service-grid-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'service-grid-style'
		];
	}

    public function get_title() {
        return esc_html__( 'RT Service Grid', 'rtelements' );
    }
   
    public function get_icon() {
        return 'rt-e-icon';
    }
    public function get_categories() {
        return [ 'pielements_category' ];
    }
    public function get_keywords() {
        return ['service'];
    }
    protected function register_controls() {

		$this->start_controls_section(
			'_section_service',
			[
					'label' => esc_html__( 'Service Settings', 'rtelements' ),
					'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'select_style',
			[
				'label' => esc_html__( 'Select Style', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => esc_html__( 'Style 1', 'rtelements' ),
					'style2' => esc_html__( 'Style 2', 'rtelements' ),
					'style3' => esc_html__( 'Style 3', 'rtelements' )
				],
			]
		);		
		
		$this->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'select_style' => 'style1'
				]
			]
		);

		$this->add_control(
			'img_direction',
			[
				'label' => esc_html__( 'Image Direction Left', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'select_style' => 'style1'
				]
			]
		);

		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Service Icon', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::ICONS,		
				'condition' => [
					'select_style' => ['style1', 'style3']
				]	
			]
		);

      $this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Business Solution', 'rtelements' ),
				'placeholder' => esc_html__( 'Type your title here', 'rtelements' ),
         	'label_block' => true,
				'condition' => [
					'select_style' => ['style1', 'style3']
				]
			]
		);

      $this->add_control(
			'des',
			[
				'label' => esc_html__( 'Description', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Fusce dignissim erat dis proin ornare class sem nibh', 'rtelements' ),
            'label_block' => true,		
				'condition' => [
					'select_style' => ['style1', 'style3']
				]		
			]
		);	

		$this->add_control(
			'button',
			[
				'label' => esc_html__( 'Button', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Read More' , 'rtelements' ),
				'label_block' => true,
				'condition' => [
					'select_style' =>['style1', 'style3']
				]
			]
      );	

		$this->add_control(
			'button_url',
			[
				'label' => esc_html__( 'URL', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::URL,
				'default' => [
					'url' => '#'
				],
				'placeholder' => esc_html__( 'Insert your link here', 'rtelements' ),
            'label_block' => true,
				'condition' => [
					'select_style' => ['style1', 'style3']
				]
			]
		);	

		// Start repeater
		$repeater = new Repeater();
		
		$repeater->add_control(
			'image_2',
			[
				'label' => esc_html__('Choose Image', 'rtelements'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'icon_2',
			[
				'label' => esc_html__('Service Icon', 'rtelements'),
				'type' => Controls_Manager::ICONS,
			]
		);
		$repeater->add_control(
			'title_2',
			[
				'label' => esc_html__('Title', 'rtelements'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Business Solution', 'rtelements'),
				'placeholder' => esc_html__('Type your title here', 'rtelements'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'des_2_hide',
			[
				'label' => esc_html__( 'Description Hide', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$repeater->add_control(
			'des_2',
			[
				'label' => esc_html__('Description', 'rtelements'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('comprehensive set of strategies, tools, technologies, and processes challenges, optimize operations, and drive business growth.', 'rtelements'),
				'label_block' => true,
				'condition' => [
					'des_2_hide!' => 'yes',
				]
			]
		);
		$repeater->add_control(
			'button_url_2',
			[
				'label' => esc_html__('URL', 'rtelements'),
				'type' => Controls_Manager::URL,
				'default' => [
					'url' => '#'
				],
				'placeholder' => esc_html__('Insert your link here', 'rtelements'),
				'label_block' => true,
			]
		);
		// Add repeater to main control
		$this->add_control(
			'repeater_items',
			[
				'label' => esc_html__('Service Items', 'rtelements'),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'title_2' => esc_html__('Business Solution 1', 'rtelements'),
						'des_2' => esc_html__('comprehensive set of strategies, tools, technologies, and processes challenges, optimize operations, and drive business growth.', 'rtelements'),
						'button_2' => esc_html__('Read More', 'rtelements'),
						'button_url_2' => ['url' => '#'],
					],
					[
						'title_2' => esc_html__('Business Solution 2', 'rtelements'),
						'des_2' => esc_html__('comprehensive set of strategies, tools, technologies, and processes challenges, optimize operations, and drive business growth.', 'rtelements'),
						'button_2' => esc_html__('Read More', 'rtelements'),
						'button_url_2' => ['url' => '#'],
					],
					[
						'title_2' => esc_html__('Business Solution 3', 'rtelements'),
						'des_2' => esc_html__('comprehensive set of strategies, tools, technologies, and processes challenges, optimize operations, and drive business growth.', 'rtelements'),
						'button_2' => esc_html__('Read More', 'rtelements'),
						'button_url_2' => ['url' => '#'],
					],
				],
				'title_field' => '{{{ title_2  }}}',
				'condition' => [
					'select_style' => 'style2'
				]
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__('Title HTML Tag', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('span', 'rtelements'),
				],
			]
		);
		$this->end_controls_section();	
		
		$this->start_controls_section(
			'item_styles',
			[
				'label' => esc_html__( 'Item', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,			
				'condition' => [
					'select_style' => ['style2', 'style3']
				]		
			]
		);	

		$this->add_control(
			'item_bg',
			[
				'label' => esc_html__( 'Background', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-item::before' => 'background: {{VALUE}}',
					'{{WRAPPER}} .service-grid-3 .inner' => 'background: {{VALUE}}',
				],
				'condition' => [
					'select_style' => ['style2', 'style3']
				]	
			]
		); 

		$this->add_control(
			'item_border_color',
			[
				'label' => esc_html__( 'Border Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item::after' => 'background: {{VALUE}}',
				],
				'condition' => [
					'select_style' => 'style3'
				]	
			]
		); 

		$this->add_responsive_control(
			'item_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rtelements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ], 
					'selectors' => [
					'{{WRAPPER}} .single-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],     
				'condition' => [
					'select_style' => 'style2'
				]	          
			]
		); 
		$this->end_controls_section();	

      $this->start_controls_section(
			'title_styles',
			[
				'label' => esc_html__( 'Title', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,			
				'condition' => [
					'title!' => ''
				]		
			]
		);	

		$this->add_control(
		'title_color',
		[
			'label' => esc_html__( 'Color', 'rtelements' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .title' => 'color: {{VALUE}}',
			],
		]
		); 

		$this->add_control(
			'title_h_color',
			[
				'label' => esc_html__( 'Hover Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-item:hover .title' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select_style' => 'style2'
				]
			]
		); 	

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'rtelements'),
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .title',
				'fields_options' => [
					'font_size' => [
						'selectors' => [
							'{{WRAPPER}} .title' => 'font-size: {{SIZE}}{{UNIT}} !important;',
						],
					],
				],
			]
		);         
      $this->end_controls_section();

		$this->start_controls_section(
			'des_styles',
			[
				'label' => esc_html__( 'Description', 'rtelements' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'des!' => '',
				],
			]
		);
		$this->add_control(
			'des_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .des' => 'color: {{VALUE}} !important',
				],
			]
		);  

		$this->add_control(
			'des_h_color',
			[
				'label' => esc_html__( 'Hover Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-item:hover .des' => 'color: {{VALUE}} !important',
				],
				'condition' => [
					'select_style' => 'style2'
				]
			]
		); 
		    
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'rtelements'),
				'name'     => 'desc_typography',
				'selector' => '{{WRAPPER}} .des',
				'fields_options' => [
					'font_size' => [
						'selectors' => [
							'{{WRAPPER}} .des' => 'font-size: {{SIZE}}{{UNIT}} !important;',
						],
					],
				],
			]
		);  
      $this->end_controls_section(); 

		$this->start_controls_section(
			'_section_style_button',
			[
				 'label' => esc_html__( 'Button', 'rtelements' ),
				 'tab' => Controls_Manager::TAB_STYLE,
				 'condition' => [
					'button!' => ''
				]
			]
	  );	  
	  
	  $this->add_control(
			'btn_color',
			[
				 'label' => esc_html__( 'Color', 'rtelements' ),
				 'type' => Controls_Manager::COLOR,		      
				 'selectors' => [
					  '{{WRAPPER}} .button' => 'color: {{VALUE}};',
				 ],
			]
	  ); 

	  $this->add_control(
			'btn_text_h_color',
			[
				 'label' => esc_html__( 'Hover Color', 'rtelements' ),
				 'type' => Controls_Manager::COLOR,		      
				 'selectors' => [
					  '{{WRAPPER}} .button:hover' => 'color: {{VALUE}};',
				 ],				 
				'condition' => [
					'select_style' => 'style1'
				]
			]
	  );

	  $this->add_control(
			'btn_icon_h_color',
			[
				 'label' => esc_html__( 'Hover Color', 'rtelements' ),
				 'type' => Controls_Manager::COLOR,		      
				 'selectors' => [
					  '{{WRAPPER}} .single-item:hover .button' => 'color: {{VALUE}};',
				 ],				 
				'condition' => [
					'select_style' => 'style2'
				]
			]
	  );

	  $this->add_control(
			'btn_icon_bgcolor',
			[
				 'label' => esc_html__( 'Background', 'rtelements' ),
				 'type' => Controls_Manager::COLOR,		      
				 'selectors' => [
					  '{{WRAPPER}} .button' => 'background: {{VALUE}};',
				 ],				 
				'condition' => [
					'select_style' => 'style2'
				]
			]
	  );

	  $this->add_control(
			'btn_icon_h_bg',
			[
				 'label' => esc_html__( 'Hover Background', 'rtelements' ),
				 'type' => Controls_Manager::COLOR,		      
				 'selectors' => [
					  '{{WRAPPER}} .single-item:hover .button' => 'background: {{VALUE}};',
				 ],				 
				'condition' => [
					'select_style' => 'style2'
				]
			]
	  );

	  $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				 'name' => 'btn_typography',
				 'selector' => '{{WRAPPER}} .button',				 
			]
	  );		  
		$this->end_controls_section();

		$this->start_controls_section(
			'icon_styles',
			[
				'label' => esc_html__( 'Icon', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,			
			]
		);	

		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => Controls_Manager::COLOR,		      
				'selectors' => [
					'{{WRAPPER}} .icon svg path' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .icon i' => 'color: {{VALUE}};',
				]
			]
	  );

	  $this->add_control(
			'icon_bgcolor',
			[
				'label' => esc_html__( 'Background Color', 'rtelements' ),
				'type' => Controls_Manager::COLOR,		      
				'selectors' => [
					'{{WRAPPER}} .icon' => 'background: {{VALUE}};',
				],							 
				'condition' => [
					'select_style' => 'style3'
				]
			]
	  );

	  $this->add_control(
			'icon_h_color',
			[
				'label' => esc_html__( 'Hover Color', 'rtelements' ),
				'type' => Controls_Manager::COLOR,		      
				'selectors' => [
					'{{WRAPPER}} .single-item:hover .icon svg path' => 'fill: {{VALUE}};',
					'{{WRAPPER}} .single-item:hover .icon i' => 'color: {{VALUE}};',
				],							 
				'condition' => [
					'select_style' => 'style2'
				]
			]
	  );

      $this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Size', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],				
				'selectors' => [
					'{{WRAPPER}} .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		); 	
      $this->end_controls_section();	

		$this->start_controls_section(
			'image_styles',
			[
				'label' => esc_html__( 'Image', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,				 						 
				'condition' => [
					'select_style' => 'style1'
				]
			]
	  );	
		$this->add_responsive_control(
		'img__height',
		[
			'label' => esc_html__( 'Height', 'rtelements' ),
			'type' => \Elementor\Controls_Manager::SLIDER,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
			'selectors' => [
				'{{WRAPPER}} .item .thumbnail img' => 'height: {{SIZE}}{{UNIT}};',
			],
		]
		);	  	
	  $this->end_controls_section();  

   }
   protected function render() {
		$settings 	= $this->get_settings_for_display();  
		$style 	 	= $settings['select_style'];
		$image    	= !empty( $settings['image']['url'] ) ? $settings['image']['url'] : '';
		$image_alt  = !empty( $settings['image']['alt'] ) ? $settings['image']['alt'] : '';
		$img_left 	= ( $settings['img_direction'] == 'yes' ) ? 'img_left' : '';		
		
		if ( $style == $style ) {
			require plugin_dir_path(__FILE__)."/$style.php";
		}
		
   }
}