<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

defined( 'ABSPATH' ) || die();

class ReacTheme_Elementor_Process_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'rt-working-process';
    }   

	public function get_style_depends() {
		wp_register_style( 'working-process-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'working-process-style'
		];
	}
  
    public function get_title() {
        return esc_html__( 'RT Working Process', 'rtelements' );
    }

    public function get_icon() {
        return 'rt-e-icon';
    }

    public function get_categories() {
        return [ 'pielements_category' ];
    }

    public function get_keywords() {
        return [ 'pricing', 'table', 'package', 'product', 'plan' ];
    }

	protected function register_controls() {

		$this->start_controls_section(
			'working_process',
			[
					'label' => esc_html__( 'Process', 'rtelements' ),
			]
		);		  	

		$this->add_control(
			'select_style',
			[
				'label' => esc_html__( 'Select Style', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' => esc_html__( 'Style 1', 'rtelements' ),
					'style2' => esc_html__( 'Style 2', 'rtelements' )
				],
			]
		);		

		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-users-cog',
					'library' => 'fa-solid',
				],
			]
		);

        $this->add_control(
            'number',
            [
                'label' => esc_html__( 'Number', 'rtelements' ),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '01', 'rtelements' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'rtelements' ),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Client Discovery', 'rtelements' ),
            ]
        ); 
        $this->add_control(
            'des',
            [
                'label' => esc_html__( 'Content', 'rtelements' ),
                'label_block' => true,
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( "The agency begins by understanding the client's needs, goals, and", "rtelements" ),
            ]
        ); 
		$this->add_control(
			'icon_position',
			[
				'label' => esc_html__( 'Icon Position Top', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'no',				
				'condition' => [
					'select_style' => 'style1'
				]
			]
		);

		$this->add_control(
			'scale_item',
			[
				'label' => esc_html__( 'Item Scale', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'select_style' => 'style2'
				]
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__( 'Select HTML Tag', 'rtelements' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('span', 'rtelements'),
				],
			]
		); 
      $this->end_controls_section();

		 $this->start_controls_section(
		    'content_styles',
		    [
		        'label' => esc_html__( 'Content Area', 'rtelements' ),
		        'tab' => Controls_Manager::TAB_STYLE,
				  'condition' => [
						'select_style' => 'style1'
				  ]
		    ]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'content_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .inner-content,{{WRAPPER}} .number-main::after',
			]
		);		
		$this->add_responsive_control(
			'content__align',
			[
				'label' => esc_html__( 'Alignment', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .inner-content' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'content_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rtelements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ], 
					'selectors' => [
					'{{WRAPPER}} .inner-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],               
			]
		); 
		$this->add_responsive_control(
            'content_padding',
            [
                'label' => esc_html__( 'Padding', 'rtelements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ], 
                'selectors' => [
					'{{WRAPPER}} .inner-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],               
         ]
      ); 
      $this->end_controls_section();

		$this->start_controls_section(
		    'icon_styles',
		    [
		        'label' => esc_html__( 'Icon', 'rtelements' ),
		        'tab' => Controls_Manager::TAB_STYLE,
		    ]
		);

      $this->add_control(
		    'icon_color',
		    [
		        'label' => esc_html__( 'Color', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .icon i' => 'color: {{VALUE}};',
		            '{{WRAPPER}} .icon svg path' => 'fill: {{VALUE}};',
		            '{{WRAPPER}} .icon::after' => 'background: {{VALUE}};',
		        ],
		    ]
		);	
		
		$this->add_control(
		    'icon_bg_color',
		    [
		        'label' => esc_html__( 'Background', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .icon' => 'background: {{VALUE}};',
		            '{{WRAPPER}} .icon::after' => 'border-color: {{VALUE}};',
		        ],
		    ]
		);		
		
		$this->add_control(
			'icon_border_color',
			[
				'label' => esc_html__( 'Border Color', 'rtelements' ),
				'type' => Controls_Manager::COLOR,		      
				'selectors' => [
					'{{WRAPPER}} .working-process-two .inner' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'select_style' => 'style2'
				]
			]
		);	

		$this->add_control(
			'icon_h_border_color',
			[
				'label' => esc_html__( 'Hover Border Color', 'rtelements' ),
				'type' => Controls_Manager::COLOR,		      
				'selectors' => [
					'{{WRAPPER}} .working-process-two:hover .inner' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'select_style' => 'style2'
				]
			]
		);	

		$this->add_responsive_control(
			'icon_size',
			[
					'label' => esc_html__( 'Size', 'rtelements' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'vh' ],
				'selectors' => [
					'{{WRAPPER}} .icon i' => 'font-size: {{SIZE}}{{UNIT}};',                    
					'{{WRAPPER}} .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',                    
				],                  
			]
		); 
		  
		$this->add_responsive_control(
			'icon_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rtelements' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%' ], 
					'selectors' => [
					'{{WRAPPER}} .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],   
				'condition' => [
					'select_style' => 'style1'
				]           
			]
		); 
      $this->end_controls_section();

      $this->start_controls_section(
		    'number_styles',
		    [
		        'label' => esc_html__( 'Number', 'rtelements' ),
		        'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'number!' => ''
                ]
		    ]
		);
      $this->add_control(
		    'number_color',
		    [
		        'label' => esc_html__( 'Color', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .number' => 'color: {{VALUE}};',
		        ],
		    ]
		);	
		$this->add_control(
		    'number_bg_color',
		    [
		        'label' => esc_html__( 'Background', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .number' => 'background: {{VALUE}};',
		        ],
		    ]
		);		
		$this->add_group_control(
		    Group_Control_Typography::get_type(),
		    [
		        'name' => 'number_typography',
		        'selector' => '{{WRAPPER}} .number',
		        
		    ]
		);	
      $this->end_controls_section();

        $this->start_controls_section(
		    'title_styles',
		    [
		        'label' => esc_html__( 'Title', 'rtelements' ),
		        'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'title!' => ''
                ]
		    ]
		);
        $this->add_control(
		    'title_color',
		    [
		        'label' => esc_html__( 'Color', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .title' => 'color: {{VALUE}};',
		        ],
		    ]
		);		
		$this->add_group_control(
		    Group_Control_Typography::get_type(),
		    [
		        'name' => 'title_typography',
		        'selector' => '{{WRAPPER}} .title',
		        
		    ]
		);	
        $this->end_controls_section();

        $this->start_controls_section(
		    'des_styles',
		    [
		        'label' => esc_html__( 'Description', 'rtelements' ),
		        'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'des!' => ''
                ]
		    ]
		);
      $this->add_control(
		    'des_color',
		    [
		        'label' => esc_html__( 'Color', 'rtelements' ),
		        'type' => Controls_Manager::COLOR,		      
		        'selectors' => [
		            '{{WRAPPER}} .des' => 'color: {{VALUE}};',
		        ],
		    ]
		);		
		$this->add_group_control(
		    Group_Control_Typography::get_type(),
		    [
		        'name' => 'des_typography',
		        'selector' => '{{WRAPPER}} .des',
		    ]
		);	
      $this->end_controls_section();
    }
	protected function render() {
      $settings	= $this->get_settings_for_display();
		$scale	= ( $settings['scale_item'] == 'yes' ) ? 'scale' : '';		
		$i_position = ( !empty( $settings['icon_position'] ) && $settings['icon_position'] === 'yes' ) ? 'icon_top' : '';
		
		if( $settings['select_style'] == 'style2' ) : ?>
			<div class="working-process-two dynamic">				
				<?php 
				if( !empty( $settings['icon']['value'] ) || !empty( $settings['number'] ) ) : ?>
					<div class="inner <?php echo esc_attr( $scale ); ?>">
						<?php 
						if( !empty( $settings['icon']['value'] ) ) : ?>
							<div class="icon">
								<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
							</div>
							<?php 
						endif;
						if( !empty( $settings['number'] ) ) : ?>
							<span class="number"><?php echo wp_kses_post($settings['number']); ?></span>
							<?php 
						endif; ?> 
					</div>
					<?php 
				endif; ?> 
				<div class="content">
					<?php 
					if(!empty($settings['title'])) : ?>
						<<?php echo esc_attr($settings['title_tag']); ?> class="title"><?php echo wp_kses_post($settings['title']); ?></<?php echo esc_attr($settings['title_tag']); ?>>
						<?php 
					endif; 		
					if(!empty($settings['des'])) : ?>
						<p class="des"><?php echo wp_kses_post($settings['des']); ?></p> 
						<?php 
					endif; ?>
				</div>
			</div>
			<?php 
		else : ?>
			<div class="working-process-one dynamic <?php echo esc_attr( $i_position ); ?>">
				<?php 
				if( !empty( $settings['icon']['value'] ) ) : ?>
					<div class="left">
						<div class="icon">
							<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
						</div>
					</div>
					<?php 
				endif; ?>
				<div class="inner-content">
					<?php 
					if( !empty( $settings['number'] ) ) : ?>
						<div class="number-main">
							<span class="number"><?php echo wp_kses_post($settings['number']); ?></span>
						</div>
						<?php 
					endif; 
					if(!empty($settings['title'])) : ?>
						<<?php echo esc_attr($settings['title_tag']); ?> class="title"><?php echo wp_kses_post($settings['title']); ?></<?php echo esc_attr($settings['title_tag']); ?>>
						<?php 
					endif; 					
					if(!empty($settings['des'])) : ?>
						<p class="des"><?php echo wp_kses_post($settings['des']); ?></p> 
						<?php 
					endif; ?>
				</div>
			</div>
			<?php 
		endif;
    }
}
