<div class="swiper-slide">		
	<div class="portfolio-slider-three dynamic <?php echo esc_attr( $img_left ); ?>">
		<div class="inner-content">
			<?php 
			if( !empty( $settings['left_icon']['value'] ) ) : ?>
				<div class="icon">
					<?php \Elementor\Icons_Manager::render_icon( $settings['left_icon'], [ 'aria-hidden' => 'true' ] ); ?>
				</div>
				<?php 
			endif; ?>
			<div class="title-area">
				<?php 
				if ( get_the_title() ) : ?>							
					<<?php echo esc_attr( $settings['title_tag'] ); ?> class="title">
						<?php echo wp_trim_words( get_the_title(), $t_word_count, '' ); ?>
					</<?php echo esc_attr( $settings['title_tag'] ); ?>>							
					<?php 
				endif; 

				if ( !empty( $cat_name ) && !is_wp_error( $cat_name ) ) :
					echo'<span class="cat">' . esc_html( $cat_name[0]->name ) . '</span>';
				endif; ?>
			</div>
			<div class="inner">
				<?php 
				if( !empty( $excerpt_data ) ) : ?>
					<p class="des">
						<?php echo wp_kses_post( wp_trim_words( $excerpt_data, $des_word_count, '' ) ); ?>
					</p>
					<?php 
				endif;
				if ( !empty( $settings['button'] ) ) : ?>
					<a href="<?php the_permalink(); ?>" class="react_button elementor-button"><?php echo wp_kses_post( $settings['button'] ); ?></a>
					<?php 
				endif; ?>
			</div>
		</div>	
		<?php 		
		if( has_post_thumbnail() ): ?>
			<a aria-label="project thumbnail" class="thumbnail" href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail(); ?>
			</a>
			<?php 
		endif; ?>	
	</div>  
</div>
