<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

defined( 'ABSPATH' ) || die();

class Reactheme_Portfolio_Grid_Widget extends \Elementor\Widget_Base {
	
	public function get_name() {
		return 'rt-portfolio-grid';
	}	

	public function get_title() {
		return __( 'RT Portfolio Grid', 'rtelements' );
	}

	public function get_style_depends() {
		wp_register_style( 'project-grid-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'project-grid-style'
		];
	}

	public function get_icon() {
		return 'rt-e-icon';
	}

	public function get_categories() {
        return [ 'pielements_category' ];
    }

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Portfolio Settings', 'rtelements' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'select_styles',
			[
				'label'   => esc_html__( 'Select Style', 'rtelements' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',				
				'options' => [
					'style1' => 'Style 1',
					'style2' => 'Style 2'
				],											
			]
		);

		$this->add_control(
			'portfolio_category',
			[
				'label'   => esc_html__( 'Category', 'rtelements' ),
				'type'    => Controls_Manager::SELECT2,	
				'default' => 0,			
				'options' => $this->getCategories(),
				'multiple' => true,			
			]
		);

		$this->add_control(
			'order_by',
			[
					'label' => __('Order By', 'rtelements'),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'date',
					'options' => [
						'date' => __('Date', 'rtelements'),
						'title' => __('Title', 'rtelements'),
						'rand' => __('Random', 'rtelements'),
						'comment_count' => __('Comment Count', 'rtelements'),
						'menu_order' => __('Menu Order', 'rtelements'),
					],
			]
      );

		$this->add_control(
			'order',
			[
				'label' => __('Order', 'rtelements'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC' => __('Ascending', 'rtelements'),
					'DESC' => __('Descending', 'rtelements'),
				],
			]
		);

		$this->add_control(
			'per_page',
			[
				'label' => esc_html__( 'Per Page', 'rtelements' ),
				'type' => Controls_Manager::TEXT,
				'default' => -1,
			]
		);

	  	$this->add_control(
			'item_link_dis',
			[
				'label' => esc_html__( 'Link Disable', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'default' => 'no',
			]
		);		
		
		$this->add_control(
			'filter_enable',
			[
				'label' => esc_html__( 'Filter Enable', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'default' => 'no',
			]
		);		

		$this->add_control(
			'filter_title',
			[
				'label' => esc_html__( 'Button Default Text', 'rtelements' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'All', 'rtelements' ),			
				'condition' => [
					'filter_enable' => 'yes'
				]	
			]
		);	

		$this->add_control(
            'pagination_show_hide',
            [
                'label' => esc_html__( 'Pagination', 'rtelements' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'rtelements'),
	  	        'label_off' => esc_html__('No', 'rtelements'),      
	  	        'return_value' => 'yes', 
                'default' => 'no',               
            ]
        );  

        $this->add_responsive_control(
            'pagination_top_spacing',
            [
                'label' => esc_html__('Spacing', 'rtelements'),
                'type' => Controls_Manager::SLIDER,
                'show_label' => true,
                'size_units' => [ '%', 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .reactheme-pagination-area' => 'padding-top:{{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'pagination_show_hide' => 'yes'
                ]
            ]
        ); 

		$this->add_control(
			'title_word_count',
			[
				'label' => esc_html__('Title Word Limit', 'rtelements'),
				'type' => Controls_Manager::NUMBER,
				'default' => 5,
				'placeholder' => esc_html__('10', 'rtelements'),        
			]
		);

		$this->add_control(
			'des_word_count',
			[
				'label' => esc_html__('Excerpt Word Limit', 'rtelements'),
				'type' => Controls_Manager::NUMBER,
				'default' => 20,
				'placeholder' => esc_html__('30', 'rtelements'),        
				'condition' => [
					'select_styles' => 'style2'
				]
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__('Title HTML Tag', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('span', 'rtelements'),
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'grid_settings',
			[
				'label' => esc_html__( 'Grid Settings', 'rtelements' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'portfolio_columns',
			[
				'label'   => esc_html__( 'Columns', 'rtelements' ),
				'type'    => Controls_Manager::SELECT,			
				'default' => '4',	
				'options' => [
					'12' => esc_html__( '1 Column', 'rtelements' ),	
					'6' => esc_html__( '2 Column', 'rtelements' ),	
					'4' => esc_html__( '3 Column', 'rtelements' ),
					'3' => esc_html__( '4 Column', 'rtelements' ),
					'2' => esc_html__( '6 Column', 'rtelements' ),			
				],					
			]
		);

		$this->add_control(
		    'port_columns_md',
		    [
		        'label'   => esc_html__( 'Columns ≥768px', 'rtelements' ),
		        'type'    => Controls_Manager::SELECT,
		        'default' => '12',
		        'options' => [
		            '12' => esc_html__( '1 Column', 'rtelements' ),
		            '6'  => esc_html__( '2 Columns', 'rtelements' ),
		            '4'  => esc_html__( '3 Columns', 'rtelements' ),
		        ],	
		    ]
		);

		$this->add_control(
			'port_columns_sm',
			[
				 'label'   => esc_html__( 'Columns ≥576px', 'rtelements' ),
				 'type'    => Controls_Manager::SELECT,
				 'default' => '12',
				 'options' => [
					  '12' => esc_html__( '1 Column', 'rtelements' ),
					  '6'  => esc_html__( '2 Columns', 'rtelements' ),
					  '4'  => esc_html__( '3 Columns', 'rtelements' ),
				 ],	
			]
	  );
		
		$this->add_responsive_control(
			'item_middle_gap',
			[
				'label' => esc_html__('Item Middle Gap', 'rtelements'),
				'type' => Controls_Manager::SLIDER,
				'show_label' => true,
				'size_units' => [ '%', 'px' ],
				'range' => [
				'px' => [
					'min' => 0,
					'max' => 200,
					'step' => 1,
				],
				'%' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors' => [
				'{{WRAPPER}} .grid-portfolio .row' => '--bs-gutter-x:{{SIZE}}{{UNIT}} !important;',
			],	
		]
	  );

		$this->add_responsive_control(
			'item_bottom_gap',
			[
				'label' => esc_html__( 'Item Bottom Gap', 'rtelements' ),
				'type' => Controls_Manager::SLIDER,
				'show_label' => true,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'default' => [
					'size' => 20,
				],			
				'selectors' => [
					'{{WRAPPER}} .grid-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		); 
		$this->end_controls_section();	
		
		$this->start_controls_section(
			'portfolio_item',
			[
				'label' => esc_html__( 'Item', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'select_styles' => 'style1'
				] 
			]
		);
				
		$this->add_responsive_control(
			'item_radius',
			[
				'label' => esc_html__( 'Border Radius', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	
		$this->end_controls_section();	

		$this->start_controls_section(
			'portfolio_filter_content_styles',
			[
				'label' => esc_html__( 'Content Area', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'select_styles' => 'style1'
				] 
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'content_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .inner-content',
			]
		);
				
		$this->add_responsive_control(
			'content_radius',
			[
				'label' => esc_html__( 'Border Radius', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .inner-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	

		$this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__( 'Padding', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .inner-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	
		$this->end_controls_section();	
		
		$this->start_controls_section(
			'title_styles',
			[
				'label' => esc_html__( 'Title', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}};',                   
				],                
			]
		);

      $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Typography', 'rtelements' ),
				'selector' => '{{WRAPPER}} .title',                    
			]
		);	
		$this->end_controls_section();

		$this->start_controls_section(
			'des_styles',
			[
				'label' => esc_html__( 'Excerpt', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,                
				'condition' => [
					'select_styles' => 'style2'
				]
			]
		);	

      $this->add_control(
            'des_color',
            [
                'label' => esc_html__( 'Color', 'rtelements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .des' => 'color: {{VALUE}};',   
                ],                
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'des_typography',
				'label' => esc_html__( 'Typography', 'rtelements' ),
				'selector' => '{{WRAPPER}} .des',                    
			]
		);
      $this->end_controls_section();

		$this->start_controls_section(
			'cat_styles',
			[
				'label' => esc_html__( 'Category', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'select_styles' => 'style1'
				]
			]
		);

		$this->add_control(
			'cat_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cat' => 'color: {{VALUE}} !important;',  
				],                
			]
		);		

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'cat_typography',
				'label' => esc_html__( 'Typography', 'rtelements' ),
				'selector' => '{{WRAPPER}} .cat',
			]
		); 
		$this->end_controls_section();


		$this->start_controls_section(
			'img_styles',
			[
				'label' => esc_html__( 'Image', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);		
		$this->add_responsive_control(
			'img_height',
			[
				'label' => esc_html__( 'Height', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .thumbnail img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'img_radius',
			[
				'label' => esc_html__( 'Border Radius', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	
      $this->end_controls_section();

		$this->start_controls_section(
			'filter_button_styles',
			[
				'label' => esc_html__( 'Filter Button', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'filter_enable' => 'yes'
				]
			]
		);  

		$this->add_responsive_control(
			'filter__align',
			[
				'label' => esc_html__( 'Position', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .portfolio-filter' => 'justify-content: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'filter_mid_gap',
			[
				'label' => esc_html__( 'Middle Gap', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio-filter' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'filter_bottom_gap',
			[
				'label' => esc_html__( 'Bottom Gap', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio-filter' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		// filter button  
		$this->start_controls_tabs( 'filter_tab' );
			$this->start_controls_tab(
				'filter_normal_tab',
				[
					'label' => esc_html__( 'Normal', 'rtelements' ),
				]
			); 

			$this->add_control(
				'filter_nav_color',
				[
					'label' => esc_html__( 'Color', 'rtelements' ),
					'type' => Controls_Manager::COLOR,		      
					'selectors' => [
						'{{WRAPPER}} .portfolio-filter button' => 'color: {{VALUE}};',
					],
				]
			);	

			$this->add_control(
				'filter_nav_bgcolor',
				[
					'label' => esc_html__( 'Background', 'rtelements' ),
					'type' => Controls_Manager::COLOR,		      
					'selectors' => [
						'{{WRAPPER}} .portfolio-filter button' => 'background: {{VALUE}};',
					],
				]
			);	

			$this->add_control(
					'filter_nav_border_color',
					[
						'label' => esc_html__( 'Border Color', 'rtelements' ),
						'type' => Controls_Manager::COLOR,		      
						'selectors' => [
							'{{WRAPPER}} .portfolio-filter button' => 'border-color: {{VALUE}} !important;',
						],
					]
			);	

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'filter_normal_typography',
					'selector' => '{{WRAPPER}} .portfolio-filter button',
				]
			);					
		$this->end_controls_tab();

			$this->start_controls_tab(
				'filter_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'rtelements' ),
				]
			); 

			$this->add_control(
				'filter_hover_color',
				[
					'label' => esc_html__( 'Color', 'rtelements' ),
					'type' => Controls_Manager::COLOR,		      
					'selectors' => [
						'{{WRAPPER}} .portfolio-filter button:hover' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
			'filter_hover_bgcolor',
				[
				'label' => esc_html__( 'backround', 'rtelements' ),
				'type' => Controls_Manager::COLOR,		      
				'selectors' => [
						'{{WRAPPER}} .portfolio-filter button:hover' => 'background: {{VALUE}};',
				],
				]
			);	 
			
			$this->add_control(
				'filter_nav_h_border_color',
				[
					'label' => esc_html__( 'Border Color', 'rtelements' ),
					'type' => Controls_Manager::COLOR,		      
					'selectors' => [
						'{{WRAPPER}} .portfolio-filter button:hover' => 'border-color: {{VALUE}} !important;',
					],
				]
			);	
		$this->end_controls_tab();

		$this->start_controls_tab(
			'filter_active_tab',
			[
				'label' => esc_html__( 'Active', 'rtelements' ),
			]
		); 
			$this->add_control(
					'filter_active_color',
					[
						'label' => esc_html__( 'Color', 'rtelements' ),
						'type' => Controls_Manager::COLOR,		      
						'selectors' => [
							'{{WRAPPER}} .portfolio-filter button.active' => 'color: {{VALUE}};',
						],
					]
			);

			$this->add_control(
				'filter_active_bgcolor',
				[
						'label' => esc_html__( 'backround', 'rtelements' ),
						'type' => Controls_Manager::COLOR,		      
						'selectors' => [
							'{{WRAPPER}} .portfolio-filter button.active' => 'background: {{VALUE}};',
						],
				]
			);

			$this->add_control(
				'filter_nav_active_border_color',
				[
					'label' => esc_html__( 'Border Color', 'rtelements' ),
					'type' => Controls_Manager::COLOR,		      
					'selectors' => [
						'{{WRAPPER}} .portfolio-filter button.active' => 'border-color: {{VALUE}} !important;',
					],
				]
			);	

        	$this->end_controls_tab();				
        	$this->end_controls_tabs();	
      $this->end_controls_section();		

		$this->start_controls_section(
        'pagination_styles',
        [
            'label' => esc_html__( 'Pagination', 'rtelements' ),
            'tab' => Controls_Manager::TAB_STYLE,
            'condition' => [
                'pagination_show_hide' => 'yes' 
            ]
        ]
    	);

    	$this->add_control(
        'pagination_color',
        [
            'label' => esc_html__( 'Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a' => 'color: {{VALUE}};',                       
            ],           
        ]
    );

	  $this->add_control(
        'pagination_border_color',
        [
            'label' => esc_html__( 'Border Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a' => 'border-color: {{VALUE}};',                       
            ],           
        ]
    );
    
    $this->add_control(
        'pagination_active_color',
        [
            'label' => esc_html__( 'Hover & Active Color', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a:hover' => 'color: {{VALUE}};',                       
                '{{WRAPPER}} .reactheme-pagination-area .nav-links .current' => 'color: {{VALUE}};',                       
            ],           
        ]
    );

    $this->add_control(
        'pagination_bgcolor',
        [
            'label' => esc_html__( 'Background', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a' => 'background: {{VALUE}};',                       
            ],           
        ]
    );
    
    $this->add_control(
        'pagination_active_bgcolor',
        [
            'label' => esc_html__( 'Hover & Active Background', 'rtelements' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [                     
                '{{WRAPPER}} .reactheme-pagination-area .nav-links a:hover' => 'background: {{VALUE}};',   
                '{{WRAPPER}} .reactheme-pagination-area .nav-links .current' => 'background: {{VALUE}};',                      
            ],           
        ]
    );

	$this->add_control(
		'pagination_active_border_color',
		[
			'label' => esc_html__( 'Hover & Active Border Color', 'rtelements' ),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .reactheme-pagination-area .nav-links a:hover' => 'border-color: {{VALUE}};', 
				'{{WRAPPER}} .reactheme-pagination-area .nav-links .current' => 'border-color: {{VALUE}};',                         
			],           
		]
    );    
    $this->end_controls_section();
	}

	protected function render() {

		$settings 			= $this->get_settings_for_display();			
		$style 				= $settings['select_styles'];
		$filter_title     = !empty( $settings['filter_title'] ) ? $settings['filter_title'] : 'All';
		$select_cat       = !empty( $settings['portfolio_category'] ) ? $settings['portfolio_category'] : [];
		$per_page         = !empty( $settings['per_page'] ) ? $settings['per_page'] : 6;
		$portfolio_columns = !empty( $settings['portfolio_columns'] ) ? $settings['portfolio_columns'] : '4';
		$gatter           = !empty( $settings['gatter'] ) ? $settings['gatter'] : '';
		$taxonomy         = 'rt-portfolio-category';	
		$title_tag 			= !empty( $settings['title_tag'] ) ? $settings['title_tag'] : 'h3';
		$t_word_count 	   = !empty( $settings['title_word_count'] ) ? (int) $settings['title_word_count'] : 5;		
		$d_word_count 	   = !empty( $settings['des_word_count'] ) ? (int) $settings['des_word_count'] : 20;		
    	$item_link_dis 	= ($settings['item_link_dis'] == 'yes') ? 'rt--link-dis' : '' ;

		if ( !empty( $settings['filter_enable'] ) && $settings['filter_enable'] === 'yes' ) : ?>
			<nav class="portfolio-filter">
				<button class="active" data-filter="*"><?php echo esc_html( $filter_title ); ?></button>
				<?php
				foreach ( $select_cat as $catid ) {
					$term = get_term_by( 'slug', $catid, $taxonomy );
					if ( $term ) { ?>
						<button data-filter=".filter_<?php echo esc_attr( $term->slug ); ?>"><?php echo esc_html( $term->name ); ?></button>
						<?php
					}
				}
				?>
			</nav>
			<?php 
		endif; ?>
		
		<div class="grid-portfolio">

			<?php echo ( ! empty( $settings['filter_enable'] ) && $settings['filter_enable'] === 'yes' ) ? '<div class="rts-filter">' : ''; ?>

				<div class="row <?php echo esc_attr( $gatter ); ?>">
					<?php
					$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;	
					$args = array(
						'post_type'      => 'rt-portfolios',
						'posts_per_page' => $per_page,
						'paged'          => $paged,
						'orderby'        => isset( $settings['order_by'] ) ? $settings['order_by'] : 'date',
						'order'          => isset( $settings['order'] ) ? $settings['order'] : 'DESC',
					);	

					if ( $settings['pagination_show_hide'] === 'yes' ) {
						$args['paged'] = $paged;
					}

					if ( !empty( $select_cat ) ) {
						$args['tax_query'] = array(
							array(
								'taxonomy' => $taxonomy,
								'field'    => 'slug',
								'terms'    => $select_cat,
							),
						);
					}
	
					$best_wp = new WP_Query( $args );
	
					if ( $best_wp->have_posts() ) :
						while ( $best_wp->have_posts() ) : $best_wp->the_post();
							$termsArray = get_the_terms( get_the_ID(), $taxonomy );
							$termsString = '';
	
							if ( $termsArray && !is_wp_error( $termsArray ) ) {
								foreach ( $termsArray as $term ) {
									$termsString .= 'filter_' . $term->slug . ' ';
								}
							}	
							$cats_show = get_the_term_list(get_the_ID(), $taxonomy, '', '<span class="separator">,</span> ', '');
							$excerpt_data = get_the_excerpt();	

							$termsString = ( $settings['filter_enable'] ?? '' ) === 'yes' ? $termsString : '';

							if ( $style == $style ) {
								require plugin_dir_path(__FILE__) . "/$style.php";
							} 

						endwhile;
					else :
						echo '<p class="no-results">' . esc_html('No portfolio items found.') . '</p>';
					endif;	
					wp_reset_postdata();
					?>
				</div>

			<?php echo ( ! empty( $settings['filter_enable'] ) && $settings['filter_enable'] === 'yes' ) ? '<div>' : ''; ?>	

			<?php 
				$blog_item_data = array(
				'per_page'  => $settings['per_page']
			);
			$paginate = paginate_links( array(
				'total' => $best_wp->max_num_pages
			));
			if(!empty($paginate ) && ($settings['pagination_show_hide'] == 'yes')){ ?>
				<div class="reactheme-pagination-area"><div class="nav-links"><?php echo wp_kses_post($paginate); ?></div></div>
			<?php } ?> 

		</div>
		<?php
	}	
	
	public function getCategories() {
		$cat_list = [];	
		if ( post_type_exists('rt-portfolios') ) {
			$terms = get_terms( array(
				'taxonomy'   => 'rt-portfolio-category',
				'hide_empty' => true,
			) );
	
			if ( !is_wp_error( $terms ) ) {
				foreach ( $terms as $term ) {
					$cat_list[$term->slug] = $term->name;
				}
			}
		}	
		return $cat_list;
	}	
} ?>