<?php
use Elementor\Controls_Manager;
defined( 'ABSPATH' ) || die();

class Reactheme_Image_Showcase_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'rt-react-image';
    }

    public function get_title() {
        return esc_html__( 'RT Image', 'rtelements' );
    }

    public function get_style_depends() {
        wp_register_style( 'rt-image-style', plugins_url( 'css/image.css', __FILE__ ) );		
        return [
            'rt-image-style'
        ];
    }

    public function get_icon() {
        return 'rt-e-icon';
    }
    public function get_categories() {
        return [ 'pielements_category' ];
    }
    public function get_keywords() {
        return [ 'logo', 'clients', 'brand', 'parnter', 'image' ];
    }
	protected function register_controls() {
		$this->start_controls_section(
            '_section_logo',
            [
                'label' => esc_html__( 'Image Settings', 'rtelements' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        ); 
        $this->add_control(
            'image',
            [
                'label' => esc_html__( 'Choose Image', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::MEDIA,    
                'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
            ]
        ); 
        $this->add_responsive_control(
            'react_image_width',
            [
                'label' => esc_html__( 'Width', 'rtelements' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'vh' ],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors' => [
					'{{WRAPPER}} .react-multi-image' => 'width: {{SIZE}}{{UNIT}} !important;',                     
				],                  
            ]
        ); 

        $this->add_responsive_control(
            'react_image_height',
            [
                'label' => esc_html__( 'Height', 'rtelements' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'vh' ],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors' => [               
					'{{WRAPPER}} .react-multi-image' => 'height: {{SIZE}}{{UNIT}} !important;',                 
				],                  
            ]
        ); 
        $this->add_responsive_control(
            'react_image_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'rtelements' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ], 
                'selectors' => [
					'{{WRAPPER}} .react-multi-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],               
            ]
        ); 
        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__( 'Alignment', 'rtelements' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'rtelements' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'rtelements' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'rtelements' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'toggle' => true,
            ]
        );

        $this->add_control(
            'image_animation_rotate',
            [
                'label' => esc_html__( 'Rotate', 'rtelements' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'rtelements' ),
                'label_off' => esc_html__( 'Hide', 'rtelements' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        ); 

        $this->add_control(
            'image_animation',
            [
                'label' => esc_html__( 'Animation', 'rtelements' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'rtelements' ),
                'label_off' => esc_html__( 'Hide', 'rtelements' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        
        $this->add_control(
            'images_translate',
            [
                'label'   => esc_html__( 'Translate Position', 'rtelements' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'vertical',
                'options' => [                  
                    'vertical' => esc_html__( 'Vertical', 'rtelements'),
                    'horizontal' => esc_html__( 'Horizontal', 'rtelements'),
                ],
                'condition' => [
                    'image_animation' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'rs_image_duration',
            [

                'label' => esc_html__( 'Animation Duration', 'rtelements' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                   'px' => [
                       'min' => 0,
                       'max' => 20,
                   ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .react-image.react-multi-image' => 'animation-duration: {{SIZE}}s;',
                ],
                'condition' => [
                    'image_animation' => 'yes',
                ],
            ]
        ); 

        $this->add_responsive_control(
            'react_image_animation_start_x',
            [

                'label' => esc_html__( 'Translate X Start', 'rtelements' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                   'px' => [
                       'min' => 0,
                       'max' => 100,
                   ],
                ],
                'condition' => [
                    'image_animation' => 'yes',
                    'images_translate' => 'horizontal',
                ],
            ]
        );  
        $this->add_responsive_control(
            'react_image_animation_end_x',
            [

                'label' => esc_html__( 'Translate X End', 'rtelements' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                   'px' => [
                       'min' => -100,
                       'max' => 100,
                   ],
                ],
                'condition' => [
                    'image_animation' => 'yes',
                    'images_translate' => 'horizontal',
                ],
            ]
        ); 
        $this->add_responsive_control(
            'react_image_animation_start_y',
            [

                'label' => esc_html__( 'Translate Y Start', 'rtelements' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                   'px' => [
                       'min' => 0,
                       'max' => 100,
                   ],
                ],
                'condition' => [
                    'image_animation' => 'yes',
                    'images_translate' => 'vertical',
                ],
            ]
        ); 
        $this->add_responsive_control(
            'react_image_animation_end_y',
            [

                'label' => esc_html__( 'Translate Y End', 'rtelements' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                   'px' => [
                       'min' => -100,
                       'max' => 100,
                   ],
                ],
                'condition' => [
                    'image_animation' => 'yes',
                    'images_translate' => 'vertical',
                ],
            ]
        );

        $this->add_control(
            'image_scroll_animate',
            [
                'label' => esc_html__( 'Scroll Animation Horizontal', 'rtelements' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'rtelements' ),
                'label_off' => esc_html__( 'Hide', 'rtelements' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );  

        $this->add_control(
            'img_scroll_animate_vertical',
            [
                'label' => esc_html__( 'Scroll Animation Vertical', 'rtelements' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'rtelements' ),
                'label_off' => esc_html__( 'Hide', 'rtelements' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );  

         $this->add_control(
            'image_clip_path',
            [
                'label' => esc_html__( 'Clip Path', 'rtelements' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'rtelements' ),
                'label_off' => esc_html__( 'Hide', 'rtelements' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );  

        $this->add_control(
            'image_reveal',
            [
                'label' => esc_html__( 'Reveal', 'rtelements' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'rtelements' ),
                'label_off' => esc_html__( 'Hide', 'rtelements' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        
        $this->end_controls_section();
    }

    protected function render() {
        $settings       = $this->get_settings_for_display(); 
        $image          = !empty( $settings['image']['url'] ) ? $settings['image']['url'] : '';
        $image_alt      = !empty( $settings['image']['alt'] ) ? $settings['image']['alt'] : '';
        $image_rotate   =  ( $settings['image_animation_rotate'] == 'yes' ) ? 'image-rotate' : '';
        $scroll_animate = ( $settings['image_scroll_animate'] == 'yes' ) ? 'scroll-animate-img' : '';
        $clip_path      = ( $settings['image_clip_path'] == 'yes' ) ? 'clip-path-yes' : '';
        $alignment      = !empty( $settings['align'] ) ? $settings['align'] : '';
        $reveals        = ( $settings['image_reveal'] == 'yes' ) ? 'rts-reveal-one' : '';
        $reveal         = ( $settings['image_reveal'] == 'yes' ) ? 'rts-reveal-image-one' : '';
        $s_anim_vertical = ( $settings['img_scroll_animate_vertical'] == 'yes' ) ? 'scroll-animate-vertical' : '';
        ?>

        <div class="react-image animate-<?php echo esc_attr( $settings['image_animation'] ); ?> <?php echo esc_attr( $scroll_animate ); ?> <?php echo esc_attr( $clip_path ); ?> <?php echo esc_attr( $reveals ); ?>">
            <?php if( !empty( $image ) ) : ?>
                <img loading="lazy" class="react-multi-image <?php echo esc_attr( $reveal ); ?>  <?php echo esc_attr ($settings['images_translate'] ); ?> <?php echo esc_attr( $image_rotate ); ?> <?php echo esc_attr( $alignment ); ?> <?php echo esc_attr( $s_anim_vertical ); ?>" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_url( $image_alt ); ?>"/>
            <?php endif; ?>
        </div>

        <?php        
            if(!empty($settings['react_image_animation_start_x']['size'])):
                $start   = $settings['react_image_animation_start_x']['size'].$settings['react_image_animation_start_x']['unit'];   
            endif; 

            if(!empty($settings['react_image_animation_end_x']['size'])):         
            $end     = $settings['react_image_animation_end_x']['size'].$settings['react_image_animation_end_x']['unit'];  
            endif;

            if(!empty($settings['react_image_animation_start_y']['size'])):          
            $start_y = $settings['react_image_animation_start_y']['size'].$settings['react_image_animation_start_y']['unit'];  
            endif; 

            if(!empty($settings['react_image_animation_end_y']['size'])):          
            $end_y   = $settings['react_image_animation_end_y']['size'].$settings['react_image_animation_end_y']['unit'];
            endif; 
        ?>
       
    <?php
    }
}