<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
defined('ABSPATH') || die();
class Reactheme_Elementor_Heading_Widget extends \Elementor\Widget_Base {

	public function get_name()
	{
		return 'react-heading';
	}

	public function get_style_depends() {
		wp_register_style( 'heading-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'heading-style'
		];
	}

	public function get_title()
	{
		return esc_html__('RT Heading', 'rtelements');
	}

	public function get_icon()
	{
		return 'rt-e-icon';
	}

	public function get_categories()
	{
		return ['pielements_category'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__('Heading', 'rtelements'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_responsive_control(
			'heading_alignments',
			[
				'label' => esc_html__( 'Alignment', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .react-heading' => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .react-heading .split-line' => 'text-align: {{VALUE}} !important;',
				],
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'     => esc_html__('Sub Title', 'rtelements'),
				'type'      => Controls_Manager::TEXT,
				'default'   => esc_html__('Sub title', 'rtelements'),
				'label_block' => true
			]
		);
		
		$this->add_control(
			'subtitle_tag',
			[
				'label'   => esc_html__('Subtitle HTML Tag', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'span',
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('span', 'rtelements'),
				],
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => esc_html__('Title', 'rtelements'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Invena Heading', 'rtelements'),
				'label_block' => true
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__('Title HTML Tag', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h2',
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('span', 'rtelements'),

				],
			]
		);

					
		
		$this->add_control(
			'watermark_yes',
			[
				'label' => esc_html__( 'Watermark', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'watermark_text',
			[
				'label' => esc_html__('Text', 'rtelements'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Welcome Invena', 'rtelements'),
				'label_block' => true,
				'condition' => [
					'watermark_yes' => 'yes'
				]
			]
		);

		$this->add_control(
			'stroke_yes',
			[
				'label' => esc_html__( 'Text Stroke', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'stroke_text',
			[
				'label' => esc_html__('Text', 'rtelements'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Stroke', 'rtelements'),
				'label_block' => true,
				'condition' => [
					'stroke_yes' => 'yes'
				]
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Text_Stroke::get_type(),
			[
				'name' => 'text_stroke',
				'selector' => '{{WRAPPER}} .stroke_text',
				'condition' => [
					'stroke_yes' => 'yes' 
				]
			]
		);

		$this->add_control(
			'title_animate',
			[
				'label' => esc_html__( 'Text Animation', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);		

		$this->add_control(
			'vertical_animate',
			[
				'label'        => esc_html__('Vertical Animation', 'rtelements'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__('Yes', 'rtelements'),
				'label_off'    => esc_html__('No', 'rtelements'),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);
		
		$this->add_control(
			'heading_border_yes',
			[
				'label' => esc_html__( 'Bottom Border', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);	
		$this->end_controls_section();	

		$this->start_controls_section(
			'section_subtitle_style',
			[
				'label' => esc_html__('Subtitle', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'subtitle!' => '' 
				]
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .react-heading .sub-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .react-heading .sub-text',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'subtitle_border',
				'selector' => '{{WRAPPER}} .react-heading .sub-text',
			]
		);

		$this->add_responsive_control(
			'subtitle_radius',
			[
				'label' => esc_html__('Border Radius', 'rtelements'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .react-heading .sub-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	

		$this->add_responsive_control(
			'subtitle_padding',
			[
				'label' => esc_html__('Padding', 'rtelements'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .react-heading .sub-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	

		$this->add_responsive_control(
			'subtitle_margin',
			[
				'label' => esc_html__('Margin', 'rtelements'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .react-heading .sub-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	
		$this->end_controls_section();

		$this->start_controls_section(
			'title_style',
			[
				'label' => esc_html__('Title', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,				
				'condition' => [
					'title!' => '' 
				]
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .react-heading .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .react-heading .title',
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__('Padding', 'rtelements'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .react-heading .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);		

		$this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__('Margin', 'rtelements'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .react-heading .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	
		$this->end_controls_section();	

		$this->start_controls_section(
			'watermark_style',
			[
				'label' => esc_html__('Watermark', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,				
				'condition' => [
					'watermark_yes' => 'yes' 
				]
			]
		);

		$this->add_control(
			'watermark_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .react-heading .watermark' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'watermark_typography',
				'selector' => '{{WRAPPER}} .react-heading .watermark',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				 'name' => 'watermark_yes_color',
				 'types' => ['gradient'],
				 'selector' => '{{WRAPPER}} .react-heading .watermark::after',				 
			]
	  	);

		$this->add_control(
			'wmark_opacity',
			[
				'label' => esc_html__( 'Opacity', 'rtelements' ),
				'placeholder' => esc_html__( '.5', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => .1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .react-heading .watermark' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Text_Stroke::get_type(),
			[
				'name' => 'wmark_text_stroke',
				'selector' => '{{WRAPPER}} .react-heading .watermark',
			]
		);		

		$this->add_responsive_control(
			'wmark_position_left',
			[
				'label' => esc_html__( 'Position Left to Right', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .react-heading .watermark' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'wmark_position_top',
			[
				'label' => esc_html__( 'Position Top to Bottom', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .react-heading .watermark' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'bottom_border_style',
			[
				'label' => esc_html__('Bottom Border', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,				
				'condition' => [
					'heading_border_yes' => 'yes' 
				]
			]
		);

		$this->add_control(
			'b_border_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .react-heading .heading_border_yes::before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .react-heading .heading_border_yes::after' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'b_border_position',
			[
				'label' => esc_html__( 'Position', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .react-heading .heading_border_yes::before' => 'bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .react-heading .heading_border_yes::after' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'animate_box_styles',
			[
				'label' => esc_html__('Animate Box', 'rtelements'),
				'tab' => Controls_Manager::TAB_STYLE,				
				'condition' => [
					'vertical_animate' => ['yes'] 
				]
			]
		);

		$this->add_control(
			'animate_box_bgcolor',
			[
				'label' => esc_html__('Background Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .react-heading.vertical' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'animate_radius',
			[
				'label' => esc_html__('Border Radius', 'rtelements'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .react-heading.vertical' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'animate_box',
			[
				'label' => esc_html__('Padding', 'rtelements'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .react-heading.vertical' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$vertical_animate = !empty($settings['vertical_animate']) && $settings['vertical_animate'] === 'yes';
		$animate_position = $vertical_animate ? 'vertical' : '';

		$bottom_border = (!empty($settings['heading_border_yes']) && $settings['heading_border_yes'] === 'yes') ? 'heading_border_yes' : '';
		$animate = (!empty($settings['title_animate']) && $settings['title_animate'] === 'yes') ? 'rts-text-anime-style-1' : '';

		$sub_text = !empty($settings['subtitle']) ? sprintf(
			'<%1$s class="sub-text">%2$s</%1$s>',
			esc_attr($settings['subtitle_tag']),
			wp_kses_post($settings['subtitle'])
		) : '';

		$main_title = !empty($settings['title']) ||
						!empty($settings['stroke_text']) ? sprintf( 
		'<%1$s class="title %2$s %3$s">%4$s <span class="stroke_text">%5$s</span></%1$s>',
			esc_attr($settings['title_tag']),
			esc_attr($bottom_border),
			esc_attr($animate),
			wp_kses_post($settings['title'] ?? ''), 
			wp_kses_post($settings['stroke_text'] ?? '') 
		) : '';

		$watermark = !empty($settings['watermark_text']) ? sprintf(
			'<span class="watermark">%s</span>',
			wp_kses_post($settings['watermark_text'])
		) : '';

		if ($vertical_animate) {
			echo '<div class="animate-yes">';
		}
		?>
			<div class="react-heading <?php echo esc_attr($animate_position); ?>">
				<?php 
					echo $watermark;
					echo $sub_text;
					echo $main_title;
				?>		
			</div>	
		<?php
		if ($vertical_animate) {
			echo '</div>';
		}
	}

} ?>