<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

defined( 'ABSPATH' ) || die();

class RTS_Topbar_Icon_List_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'topbar-icon-list';
    }   

    public function get_title() {
        return esc_html__( 'RT Icon list', 'rtelements' );
    }

    public function get_icon() {
        return 'rt-e-icon';
    }

    public function get_categories() {
        return [ 'header_footer_rts' ];
    }

    public function get_keywords() {
        return [ 'list', 'title', 'features', 'heading', 'plan' ];
    }

	protected function register_controls() {
		$this->start_controls_section(
			'_section_header',
			[
				'label' => esc_html__( 'Content', 'rtelements' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);  
        $this->add_control(
            'field_type',
            [
                'label'        => __( 'Field Type', 'rtelements'),
                'type'         => Controls_Manager::SELECT,
                'default'      => 'default',
                'options'      => [
                    'default' => __( 'Default Icon box', 'rtelements'),
                    'mail'      => __( 'Mail Field', 'rtelements'),
                    'phone'      => __( 'Phone Field', 'rtelements'),
                   
                ],               
            ]
        );   
        $this->add_control(
            'text',
            [
                'label' => esc_html__( 'Title', 'rtelements' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Invena icon text', 'rtelements' ),
            ]
        );

        $this->add_control(
            'subtext',
            [
                'label' => esc_html__( 'Subtitle', 'rtelements' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Call us anytime', 'rtelements' ),
            ]
        );

        $this->add_control(
            'subtitle_inline',
            [
                'label' => esc_html__( 'Inline Block', 'rtelements' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'rtelements' ),
                'label_off' => esc_html__( 'No', 'rtelements' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'subtext!' => ''
                ]
            ]
        ); 

        $this->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],                 
            ]
        );
        
        $this->add_responsive_control(
            'icon__gaps',
            [
                'label' => esc_html__( 'Icon Gap', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],			
				'selectors' => [	
                    '{{WRAPPER}} .rt-icons' => 'gap: {{SIZE}}{{UNIT}};',
				],
                'condition' => [
                    'icon[value]!' => ''
                ],
            ]
        ); 

        $this->add_responsive_control(
			'align',
			[
				 'label' => esc_html__( 'Icon Position', 'rtelements' ),
				 'type' => Controls_Manager::CHOOSE,
				 'options' => [
					  'start' => [
							'title' => esc_html__( 'Start', 'rtelements' ),
							'icon' => 'eicon-text-align-left',
					  ],
					  'center' => [
							'title' => esc_html__( 'Center', 'rtelements' ),
							'icon' => 'eicon-text-align-center',
					  ],
					  'end' => [
							'title' => esc_html__( 'Bottom', 'rtelements' ),
							'icon' => 'eicon-text-align-right',
					  ],
				],
				'toggle' => true,
                'condition' => [
                    'icon[value]!' => ''
                ],
				'selectors' => [
					'{{WRAPPER}} .rt-icons' => 'align-items: {{VALUE}}'
				]
			]
	  	);        
        $this->end_controls_section();
           
        $this->start_controls_section(
            '_section_style_text',
            [
                'label' => esc_html__( 'Title', 'rtelements' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );     
        $this->add_control(
            'title_text_color',
            [
                'label' => esc_html__( 'Color', 'rtelements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rt-icons .title' => 'color: {{VALUE}};',
                ],  
                'condition' => [
                    'text!' => ''
                ]
            ]
        ); 
        $this->add_control(
            'title_hover_color',
            [
                'label' => esc_html__( 'Hover Color', 'rtelements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rt-icons .title:hover' => 'color: {{VALUE}};',
                ],
                'condition' =>[
                    'text!' => '',
                    'field_type' => [ 'mail', 'phone', 'default' ]
                ]
            ]
        );             
        $this->add_control(
            'title_border_color',
            [
                'label' => esc_html__( 'Hover Border Color', 'rtelements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rt-icons::after' => 'background: {{VALUE}};',
                ],  
            ]
        ); 
         $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_text_typography',
                'selector' => '{{WRAPPER}} .rt-icons .title',                  
                'condition' => [
                    'text!' => ''
                ]
            ]
        );  

        $this->start_controls_tabs( '_tabs_title_margin' );

        $this->start_controls_tab(
            '_tab_title_margin_normal',
            [
                'label' => esc_html__( 'Normal', 'rtelements' ),
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__( 'Margin', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .rt-icons .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'text!' => ''
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_title_margin_hover',
            [
                'label' => esc_html__( 'Hover', 'rtelements' ),
            ]
        );

        $this->add_responsive_control(
            'title_margin_hover',
            [
                'label' => esc_html__( 'Margin', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .rt-icons .title:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'text!' => ''
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();      

        $this->start_controls_section(
            'subtext_style',
            [
                'label' => esc_html__( 'Subtitle', 'rtelements' ),
                'tab'   => Controls_Manager::TAB_STYLE, 
                'condition' =>[
                    'subtext!' => '',
                ]
            ]
        );     
        $this->add_control(
            'subtext_color',
            [
                'label' => esc_html__( 'Color', 'rtelements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rt-icons .subtitle' => 'color: {{VALUE}};',
                ],  
            ]
        );   
         $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtext_typography',
                'selector' => '{{WRAPPER}} .rt-icons .subtitle', 
            ]
        );  
        $this->end_controls_section();    

        $this->start_controls_section(
            '_section_style_icon',
            [
                'label' => esc_html__( 'Icon', 'rtelements' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'icon[value]!' => ''
                ]
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__( 'Color', 'rtelements' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rt-icons .icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .rt-icons .icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );            
        $this->add_responsive_control(
            'icon_width',
            [
                'label' => esc_html__( 'Icon Size', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],				
				'selectors' => [
					'{{WRAPPER}} .rt-icons .icon svg' => 'width: {{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}} ',
                    '{{WRAPPER}} .rt-icons .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bg',
                'label' => esc_html__( 'Icon Background', 'rtelements' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .rt-icons .icon',
            ]
        ); 
        $this->add_responsive_control(
            'icon_box_width',
            [
                'label' => esc_html__( 'Icon Box Width', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],				
				'selectors' => [					
                    '{{WRAPPER}} .rt-icons .icon' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_box_height',
            [
                'label' => esc_html__( 'Icon Box Height', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],				
				'selectors' => [                    
                    '{{WRAPPER}} .rt-icons .icon' => 'height: {{SIZE}}{{UNIT}};',                   
				],
            ]
        );
        $this->add_responsive_control(
            'icon_box_lineheight',
            [
                'label' => esc_html__( 'Icon Box Line height', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],				
				'selectors' => [
                    '{{WRAPPER}} .rt-icons .icon' => 'line-height: {{SIZE}}{{UNIT}};',
				],
            ]
        );
        $this->add_control(
			'icon_align',
			[
				'label' => esc_html__( 'Alignment', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .rt-icons .icon' => 'text-align: {{VALUE}};',
				],
			]
		);     
        $this->add_responsive_control(
			'border-radius',
			[
				'label' => esc_html__( 'Border Radius', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .rt-icons .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'icon__border',
				'selector' => '{{WRAPPER}} .rt-icons .icon',
			]
		);
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'general_hover_box_shadow',
                'exclude' => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .rt-icons .icon'
            ]
        );         
        $this->end_controls_section();
    } 

	protected function render() {
        $settings   = $this->get_settings_for_display();
        $inline     = ( $settings['subtitle_inline'] == 'yes' ) ? 'inline' : '';
        ?> 
        <div class="rt-icons">              
            <?php 
            if ( !empty( $settings['icon']['value'] ) ) : ?>
               <div class="icon-wrap"><div class="icon"><?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?></div>          </div>                  
                <?php 
            endif; ?>
            <div class="text">
                <?php 
                if( !empty( $settings['subtext'] ) ) : ?>
                    <span class='subtitle <?php echo esc_attr( $inline ); ?>'><?php  echo wp_kses_post( $settings['subtext'] ); ?></span>
                    <?php 
                endif; 
                if( 'mail' == $settings['field_type'] ) : 
                    if(!empty($settings['text'])) : ?>
                        <a href="mailto:<?php echo esc_attr($settings['text']);?>"><span class="title"><?php echo wp_kses_post( $settings['text'] ); ?></span></a>  
                        <?php 
                    endif;  
                elseif( 'phone' == $settings['field_type'] ) :                     
                    if( !empty( $settings['text'] ) ) : ?>
                        <a href="tel:<?php echo esc_attr(str_replace(" ","",($settings['text'])))?>"><span class="title"><?php echo wp_kses_post( $settings['text'] ); ?></span></a>
                        <?php 
                    endif; 
                else: 
                    if( !empty( $settings['text'] ) ) : ?>
                        <span class="title"><?php echo wp_kses_post( $settings['text'] ); ?></span>
                        <?php 
                    endif;
                endif; ?>
            </div>                      
        </div>
        <?php
    }
}