<?php 
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit;   // Exit if accessed directly.
}

class RTS_Offcanvas extends Widget_Base {

	public function get_name() {
		return 'site-off-canvas';
	}

	public function get_title() {
		return __( 'Site OffCanvas', 'rtelements' );
	}

	public function get_icon() {
		return 'rt-e-icon';
	}

	public function get_categories() {
		return [ 'header_footer_rts' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
            'section_general_fields',
            [
                'label' => __( 'Canvas Settings', 'rtelements'),
            ]
        );    
        $this->add_control(
            'dot_icon_color',
            [
                'label'     => __( 'Icon Color', 'rtelements'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [                   
                    '{{WRAPPER}} .offcanvas-icon .nav-link-container svg rect' => 'fill: {{VALUE}}', 
                ],                
            ]
        );
			$this->add_control(
            'dot_icon_color_hover',
            [
                'label'     => __( 'Icon Hover Color', 'rtelements'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [                   
                    '{{WRAPPER}}  .offcanvas-icon .nav-link-container:hover svg rect' => 'fill: {{VALUE}}',           
                ],         
            ]
      );		  
		$this->add_control(
			'box__bg',
			[
				 'label'     => __( 'Background', 'rtelements'),
				 'type'      => Controls_Manager::COLOR,
				 'selectors' => [                   
					  '{{WRAPPER}} .offcanvas-icon .nav-link-container' => 'background: {{VALUE}}',
				 ],				 
			]
	  	);  
		$this->add_control(
			'box_hover_bg',
			[
				'label'     => __( 'Hover Background', 'rtelements'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [                   
					'{{WRAPPER}} .offcanvas-icon .nav-link-container:hover' => 'background: {{VALUE}}',
				],				 
			]
		);
		$this->add_responsive_control(
			'icon__size',
			[
				'label' => esc_html__( 'Icon Size', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],				
				'selectors' => [
					'{{WRAPPER}} .offcanvas-icon .nav-link-container svg rect' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
      $this->add_responsive_control(
			'width',
			[
				'label' => esc_html__( 'Box Width', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],				
				'selectors' => [
					'{{WRAPPER}} ul.offcanvas-icon .nav-link-container' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'height',
			[
				'label' => esc_html__( 'Box Height', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				
				'selectors' => [
					'{{WRAPPER}} ul.offcanvas-icon .nav-link-container' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'line-height',
			[
				'label' => esc_html__( 'Box Line Height', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				
				'selectors' => [
					'{{WRAPPER}} ul.offcanvas-icon .nav-link-container' => 'line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .offcanvas-icon .nav-link-container',
			]
		);		
      $this->add_responsive_control(
			'dropdown_border_radius',
			[
				'label'       => __( 'Border Radius', 'rtelements' ),
				'type'        => Controls_Manager::DIMENSIONS,
				'size_units'  => [ 'px', '%' ],
				'selectors'   => [
					'{{WRAPPER}} ul.offcanvas-icon .nav-link-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);		
      $this->add_control(
			'icon_align',
			[
				'label' => esc_html__( 'Alignment', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),	
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-text-align-right',
					],
				],				
				'toggle' => true,
				'selectors' => [
				    '{{WRAPPER}} .offcanvas-icon .nav-menu-link' => 'text-align: {{VALUE}}'
				],
			]
		);
		$this->end_controls_section();
	}
	
	protected function render() {		
		$settings = $this->get_settings_for_display(); ?>
		<div class="sidebarmenu-area text-right desktop rt-elements-canvas">			
			<ul class="offcanvas-icon">
				<li class="nav-link-container "> 
					<a aria-label="off canvas" href='#' class="nav-menu-link menu-button">
						<svg xmlns="http://www.w3.org/2000/svg" width="18" height="16" viewBox="0 0 18 16" fill="none">
							<rect width="18" height="2" rx="1" fill="#141416"/>
							<rect x="2" y="7" width="14" height="2" rx="1" fill="#141416"/>
							<rect y="14" width="18" height="2" rx="1" fill="#141416"/>
						</svg>                                       
					</a> 
				</li>
			</ul>		
		</div>
	<?php
	}
}