<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

defined('ABSPATH') || die();

class Reactheme_Elementor_Page_Title_Widget extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'react-page-title';
	}

	public function get_title()
	{
		return esc_html__('RT Page Title', 'rtelements');
	}

	public function get_icon()
	{
		return 'rt-e-icon';
	}

	public function get_categories() {
		return ['pielements_category'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__('Title', 'rtelements'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_responsive_control(
			'heading_alignments',
			[
				'label' => esc_html__( 'Alignment', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'rtelements' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'rtelements' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'rtelements' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .title' => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .title .split-line' => 'text-align: {{VALUE}} !important;',
				],
			]
		);

		$this->add_control(
			'title_animate',
			[
				'label' => esc_html__( 'Text Animation', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'rtelements' ),
				'label_off' => esc_html__( 'No', 'rtelements' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);	
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'rtelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .title',
			]
		);

		$this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__('Margin', 'rtelements'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	

		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__('Select HTML Tag', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h2',
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('span', 'rtelements'),

				],
			]
		);
		$this->end_controls_section();			
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$animate = (!empty($settings['title_animate']) && $settings['title_animate'] === 'yes') ? 'rts-text-anime-style-1' : '';		
		?>
			<div class="rt-page-title">
				<<?php echo esc_attr($settings['title_tag']); ?> class="title <?php echo esc_attr( $animate ); ?>">				
						<?php the_title(); ?>	
				</<?php echo esc_attr($settings['title_tag']); ?>>	
			</div>
		<?php
	}

} ?>