<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;

defined( 'ABSPATH' ) || die();

class ReacThemes_Features_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'rt-features';
    }

    public function get_title() {
        return esc_html__( 'RT features', 'rtelements' );
    }

	 public function get_style_depends() {
		wp_register_style( 'features-style', plugins_url( 'css/style.css', __FILE__ ) );		
		return [
			'features-style'
		];
	}

    public function get_icon() {
        return 'rt-e-icon';
    }

    public function get_categories() {
        return [ 'pielements_category' ];
    }

    public function get_keywords() {
        return ['features'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            '_section_features',
            [
                'label' => esc_html__( 'Features', 'rtelements' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

		  $this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'rt-icon-check',
					'library' => 'rt-icons',
				],
			]
		);
		  
      $this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Strategic Vision Work', 'rtelements' ),
				'placeholder' => esc_html__( 'Type your title here', 'rtelements' ),
         	'label_block' => true,
			]
		);
		  
      $this->add_control(
			'des',
			[
				'label' => esc_html__( 'Description', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Dorem ipsum dolor sit amet, consectetu mod tempor incididunt business phasellus gravida', 'rtelements' ),
				'placeholder' => esc_html__( 'Type your description here', 'rtelements' ),
         	'label_block' => true,
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'   => esc_html__('Select HTML Tag', 'rtelements'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1' => esc_html__('H1', 'rtelements'),
					'h2' => esc_html__('H2', 'rtelements'),
					'h3' => esc_html__('H3', 'rtelements'),
					'h4' => esc_html__('H4', 'rtelements'),
					'h5' => esc_html__('H5', 'rtelements'),
					'h6' => esc_html__('H6', 'rtelements'),
					'p' => esc_html__('P', 'rtelements'),
					'span' => esc_html__('span', 'rtelements'),
				],
			]
		);						
		$this->end_controls_section();

		$this->start_controls_section(
			'wrap_styles',
			[
					'label' => esc_html__( 'Wrapper', 'rtelements' ),
					'tab' => Controls_Manager::TAB_STYLE,
			]
		);   
       
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'wrap_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .rt-features',
			]
		);	

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'wrap_box_shadow',
				'selector' => '{{WRAPPER}} .rt-features',
			]
		);

      $this->add_responsive_control(
			'wrap_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .rt-features' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);	

      $this->add_responsive_control(
			'wrap_border_padding',
			[
				'label' => esc_html__( 'Padding', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .rt-features' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	
      $this->end_controls_section();

		$this->start_controls_section(
			'icon_styles',
			[
				'label' => esc_html__( 'Icon', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);	

      $this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Size', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		); 		

		 $this->add_responsive_control(
			'icon_line_height',
			[
				'label' => esc_html__( 'Line Height', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .icon' => 'line-height: {{SIZE}}{{UNIT}};',
				],
			]
		); 
      $this->end_controls_section();		

      $this->start_controls_section(
			'title_styles',
			[
				'label' => esc_html__( 'Title', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,		
				'condition' => [
					'title!' => '' 
				]			
			]
		);	

      $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'rtelements'),
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .title',
				'fields_options' => [
					'font_size' => [
						'selectors' => [
							'{{WRAPPER}} .title' => 'font-size: {{SIZE}}{{UNIT}} !important;',
						],
					],
				],
			]
		);  
      $this->end_controls_section();

      $this->start_controls_section(
			'des_styles',
			[
				'label' => esc_html__( 'Description', 'rtelements' ),
				'tab' => Controls_Manager::TAB_STYLE,	
				'condition' => [
					'des!' => '' 
				]				
			]
		);	

      $this->add_control(
			'des_color',
			[
				'label' => esc_html__( 'Color', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .des' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'rtelements'),
				'name'     => 'des_typography',
				'selector' => '{{WRAPPER}} .des',
				'fields_options' => [
					'font_size' => [
						'selectors' => [
							'{{WRAPPER}} .des' => 'font-size: {{SIZE}}{{UNIT}} !important;',
						],
					],
				],
			]
		);  
      $this->end_controls_section();

    }
   protected function render() {
		$settings = $this->get_settings_for_display();  
		?>

		<div class="rt-features">			
			<?php 
			if( !empty( $settings['icon']['value'] ) ) : ?>
				<div class="icon">
					<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
				</div>
				<?php 
			endif; 	
			if( !empty( $settings['title'] ) ) : ?>
				<<?php echo esc_attr( $settings['title_tag'] ); ?> class="title"><?php echo wp_kses_post( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
				<?php 
			endif;
			if( !empty( $settings['des'] ) ) : ?>
				<p class="des"><?php echo wp_kses_post( $settings['des'] ); ?></p>
				<?php 
			endif; ?>
		</div>
		<?php 
   }
}