<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

defined( 'ABSPATH' ) || die();

class Rsaddon_Elementor_Pro_Countdown_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve counter widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'counterdown';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve counter widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'RT Countdown', 'rsaddon' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'rt-e-icon';
	}

	/**
	 * Retrieve the list of scripts the counter widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.3.0
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_categories() {
        return [ 'rsaddon_category' ];
    }
	 //register css
	public function get_style_depends() {
		wp_register_style( 'countdown-style', plugins_url( 'countdown.css', __FILE__ ) );		
		return [
			'countdown-style'
		];
	}
	/**
	 * Register services widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		// Start a section for countdown settings
		$this->start_controls_section(
			 'countdown_settings',
			 [
				  'label' => esc_html__('Settings', 'rtelements'),
			 ]
		);
		$this->add_control(
			'day_label',
			[
				'label' => esc_html__( 'Days', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Days', 'rtelements' ),
				'placeholder' => esc_html__( 'Type your days here', 'rtelements' ),
			]
		);  
		$this->add_control(
			'hours_label',
			[
				'label' => esc_html__( 'Hours', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Hours', 'rtelements' ),
				'placeholder' => esc_html__( 'Type your hours here', 'rtelements' ),
			]
		);  
		$this->add_control(
			'minute_label',
			[
				'label' => esc_html__( 'Minute', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Minutes', 'rtelements' ),
				'placeholder' => esc_html__( 'Type your minute here', 'rtelements' ),
			]
		); 
		$this->add_control(
			'seconds_label',
			[
				'label' => esc_html__( 'Seconds', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Seconds', 'rtelements' ),
				'placeholder' => esc_html__( 'Type your seconds here', 'rtelements' ),
			]
		);
		$this->add_control(
			 'target_date',
			 [
				  'label' => esc_html__('Target Date', 'rtelements'),
				  'type' => \Elementor\Controls_Manager::DATE_TIME,
				  'picker_options' => [
						'enableTime' => true,
						'time_24hr' => true,
				  ],
				  'default' => date('Y-m-d H:i:s', strtotime('+1 day')), 
			 ]
		);  
		$this->end_controls_section();

		   // Style section for label typography and colors
			$this->start_controls_section(
				'label_style',
				[
					 'label' => esc_html__('Label', 'rtelements'),
					 'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
		  );
	 
		  // Typography for labels
		  $this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					 'name' => 'label_typography',
					 'label' => esc_html__('Typography', 'rtelements'),
					 'selector' => '{{WRAPPER}} .counter-down li',
				]
		  );
	 
		  // Label color
		  $this->add_control(
				'label_color',
				[
					 'label' => esc_html__('Label Color', 'rtelements'),
					 'type' => \Elementor\Controls_Manager::COLOR,
					 'selectors' => [
						  '{{WRAPPER}} .counter-down li' => 'color: {{VALUE}};',
					 ],
				]
		  );
		$this->add_responsive_control(
			'label_spacing_margin',
			[
				'label' => esc_html__( 'Margin', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .counter-down li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		// Days Style
		$this->start_controls_section(
			'days_style',
			[
				 'label' => esc_html__('Days', 'rtelements'),
				 'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
	  ); 
	  $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				 'name' => 'days_typography',
				 'label' => esc_html__('Typography', 'rtelements'),
				 'selector' => '{{WRAPPER}} #days',
			]
	  ); 
	  $this->add_control(
			'days_color',
			[
				 'label' => esc_html__('Color', 'rtelements'),
				 'type' => \Elementor\Controls_Manager::COLOR,
				 'selectors' => [
					  '{{WRAPPER}} #days' => 'color: {{VALUE}};',
				 ],
			]
	  ); 
	$this->add_responsive_control(
		'days_spacing_margin',
		[
			'label' => esc_html__( 'Margin', 'rtelements' ),
			'type' => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} #days' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	); 
	$this->end_controls_section();
 
	  // Hours Style
	  $this->start_controls_section(
			'hours_style',
			[
				 'label' => esc_html__('Hours', 'rtelements'),
				 'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
	  );
 
	  $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				 'name' => 'hours_typography',
				 'label' => esc_html__('Typography', 'rtelements'),
				 'selector' => '{{WRAPPER}} #hours',
			]
	  ); 
	  $this->add_control(
			'hours__color',
			[
				 'label' => esc_html__('Color', 'rtelements'),
				 'type' => \Elementor\Controls_Manager::COLOR,
				 'selectors' => [
					  '{{WRAPPER}} #hours' => 'color: {{VALUE}} !important;',
				 ],
			]
	  );
	  $this->add_responsive_control(
			'hours_spacing_margin',
			[
				'label' => esc_html__( 'Margin', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} #hours' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
	  $this->end_controls_section();
 
	  // Minutes Style
	  $this->start_controls_section(
			'minutes_style',
			[
				 'label' => esc_html__('Minutes', 'rtelements'),
				 'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
	  );
 
	  $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				 'name' => 'minutes_typography',
				 'label' => esc_html__('Typography', 'rtelements'),
				 'selector' => '{{WRAPPER}} #minutes',
			]
	  ); 
	  $this->add_control(
		'minutes__color',
		[
			 'label' => esc_html__('Color', 'rtelements'),
			 'type' => \Elementor\Controls_Manager::COLOR,
			 'selectors' => [
				  '{{WRAPPER}} #minutes' => 'color: {{VALUE}};',
			 ],
		]
  );
	  $this->add_responsive_control(
		'minutes_spacing_margin',
		[
			'label' => esc_html__( 'Margin', 'rtelements' ),
			'type' => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
			'selectors' => [
				'{{WRAPPER}} #minutes' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	); 
	  $this->end_controls_section();
 
	  // Seconds Style
	  $this->start_controls_section(
			'seconds_style',
			[
				 'label' => esc_html__('Seconds', 'rtelements'),
				 'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
	  ); 
	  $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				 'name' => 'seconds_typography',
				 'label' => esc_html__('Typography', 'rtelements'),
				 'selector' => '{{WRAPPER}} #seconds',
			]
	  ); 
	  $this->add_control(
		'seconds__color',
		[
			'label' => esc_html__('Color', 'rtelements'),
			'type' => \Elementor\Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} #seconds' => 'color: {{VALUE}};',
			],
		]
  	);
	  $this->add_responsive_control(
		'second_spacing_margin',
			[
				'label' => esc_html__( 'Margin', 'rtelements' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} #seconds' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
	  $this->end_controls_section();
  }
  
  protected function render() {
		$settings = $this->get_settings_for_display();
  
		// Get the target date set by the user
		$target_date = isset($settings['target_date']) ? $settings['target_date'] : date('Y-m-d H:i:s', strtotime('+1 day'));
		?>
		<div id="countdown">
			 <ul class="counter-down">
				  <li><span id="days" class="days"></span> <?php echo wp_kses_post($settings['day_label']); ?></li>
				  <li><span id="hours" class="hours"></span> <?php echo wp_kses_post($settings['hours_label']); ?></li>
				  <li><span id="minutes" class="minutes"></span> <?php echo wp_kses_post($settings['minute_label']); ?></li>
				  <li><span id="seconds" class="seconds"></span> <?php echo wp_kses_post($settings['seconds_label']); ?></li>
			 </ul>
		</div>
  
		<script>
			 document.addEventListener('DOMContentLoaded', function () {
				  const second = 1000,
						minute = second * 60,
						hour = minute * 60,
						day = hour * 24;
  
				  // Set the target date from PHP
				  const countDownDate = new Date("<?php echo esc_js($target_date); ?>").getTime();
  
				  // Countdown function
				  const x = setInterval(function () {
						const now = new Date().getTime(),
							 distance = countDownDate - now;
  
						document.getElementById("days").innerText = Math.floor(distance / day);
						document.getElementById("hours").innerText = Math.floor((distance % day) / hour);
						document.getElementById("minutes").innerText = Math.floor((distance % hour) / minute);
						document.getElementById("seconds").innerText = Math.floor((distance % minute) / second);
  
						if (distance < 0) {
							 document.getElementById("countdown").innerHTML = "Countdown Finished!";
							 clearInterval(x);
						}
				  }, 1000);
			 });
		</script>

		<?php 
	}
}