<div class="grid-item <?php echo esc_html( $col ); ?>">     
   <div class="blog-grid-five item <?php echo esc_attr( $blog_img_dis ); ?>">         
      <?php 
      if ( has_post_thumbnail() ) : ?>
         <div class="blog-img">
            <a aria-label="Thumbnail" href="<?php the_permalink(); ?>" class="thumbnail">
               <?php the_post_thumbnail(); ?>
            </a>
         </div>
         <?php 
      endif; ?>
      <div class="post-content">
         <?php   
         if( !empty( $cat_show || $author_show || $date_show ) ) : ?>
            <p class="blog-meta">                
               <?php    
               if( !empty( $date_show ) ) : ?>                  
                  <span class="date"><i class="rt-circle-check"></i> <?php echo get_the_date(); ?></span> 
                  <?php 
               endif; 
               if ( ! empty( $cat_show ) && ! empty( $term ) ) : ?>
                  <span class="cat"><?php echo wp_kses_post( $cats_name ); ?></span>
                  <?php 
               endif;
               if ( ! empty( $author_show ) ) : 
                  $author_id = get_the_author_meta( 'ID' );
                  ?>
                  <span class="author"><a aria-label="Author Name" href="<?php echo esc_url( get_author_posts_url( $author_id ) ); ?>">
                      <?php echo esc_html( get_the_author() ); ?>
                  </a></span>
               <?php 
               endif; ?>
            </p> 
            <?php                
         endif;
         if ( trim( get_the_title() ) !== '' ) : ?>
            <a aria-label="Blog Title" href="<?php the_permalink(); ?>">
               <<?php echo esc_attr($settings['title_tag']); ?> class="title"> 
                     <?php echo esc_html( wp_trim_words( get_the_title(), $limit ?? 5, '' ) ); ?>
               </<?php echo esc_attr( $settings['title_tag'] ); ?>>   
            </a>
            <?php 
         endif;     
         if( !empty( $settings['blog_btn_text'] ) ) : ?>
            <a class="button" href="<?php the_permalink(); ?>"><?php echo wp_kses_post( $settings['blog_btn_text'] ); ?><i class=" rt-arrow-right-regular"></i></a>
            <?php 
         endif; ?>
      </div>
   </div>
</div>

                     