<?php
/**
 * Team custom post type
 * This file is the basic custom post type for use any where in theme.
 * 
 * @package Team Post Type
 * @author ReacTheme
 * @link http://www.reactheme.com
 */
// Register Team Post Type
function reactheme_team_register_post_type() {
	$labels = array(
		'name'               => esc_html__( 'Team', 'rtelements'),
		'singular_name'      => esc_html__( 'Team', 'rtelements'),
		'add_new'            => esc_html_x( 'Add New Team', 'rtelements'),
		'add_new_item'       => esc_html__( 'Add New Team', 'rtelements'),
		'edit_item'          => esc_html__( 'Edit Team', 'rtelements'),
		'new_item'           => esc_html__( 'New Team', 'rtelements'),
		'all_items'          => esc_html__( 'All Team', 'rtelements'),
		'view_item'          => esc_html__( 'View Team', 'rtelements'),
		'search_items'       => esc_html__( 'Search Teams', 'rtelements'),
		'not_found'          => esc_html__( 'No Teams found', 'rtelements'),
		'not_found_in_trash' => esc_html__( 'No Teams found in Trash', 'rtelements'),
		'parent_item_colon'  => esc_html__( 'Parent Team:', 'rtelements'),
		'menu_name'          => esc_html__( 'Teams', 'rtelements'),
	);		
	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'publicly_queryable' => true,
		'show_in_menu'       => true,
		'show_in_admin_bar'  => true,
		'can_export'         => true,
		'has_archive'        => false,
		'hierarchical'       => false,
		'menu_position'      => 20,		
		'menu_icon'          =>  plugins_url( 'img/icon.png', __FILE__ ),
		'supports'           => array( 'title', 'thumbnail', 'page-attributes', 'excerpt' )
	);
	register_post_type( 'teams', $args );
}
add_action( 'init', 'reactheme_team_register_post_type' );

function reactheme_tr_create_team() {
	
	register_taxonomy(
		'team-category',
		'teams',
		array(
			'label' => esc_html__( 'Team Categories','rtelements'),			
			'hierarchical' => true,
			'show_admin_column' => true,		
		)
	);
}
add_action( 'init', 'reactheme_tr_create_team' );


