<?php
// Elementor Advance Options Inlcude
use Elementor\Controls_Manager;
use Elementor\Element_Base;

defined('ABSPATH') || die();

class RT_E_CONTAINER_RT_OPTIONS {
    
    public static function init() {
        add_action( 'elementor/element/container/section_layout/after_section_end', [__CLASS__, 'rt_hover_color_options'], 1 );
        add_action( 'elementor/element/image-gallery/section_gallery_images/after_section_start', [__CLASS__, 'inject_image_gallery_controls'], 10, 2 );
        add_action( 'elementor/frontend/widget/before_render', [__CLASS__, 'before_image_gallery_elements_section_render'], 1 );

    }
    public static function rt_hover_color_options( Element_Base $element ) {
        $element->start_controls_section(
            'rt_e_hover_color_settings',
            [
                'label' => __('Invena Options', 'rtelements'),
                'tab'   => Controls_Manager::TAB_ADVANCED,
            ]
        );

        $element->add_control(
            'rt_e_hover_text_color_yes',
            [
                'label'        => esc_html__('Color Changes (Hover)', 'rtelements'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__('Yes', 'rtelements'),
                'label_off'    => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default'      => '',
                'prefix_class' => 'e-rt-hover-text-color-',
                'description'  => esc_html__('Note: The color of the text and icons inside the container can be changed on hover.', 'rtelements'),
            ]
        );

        $element->add_control(
            'rt_e_hover_text_color_select',
            [
                'label' => esc_html__('Select Color', 'rtelements'),
                'type' => Controls_Manager::COLOR,
                'condition' => [ 'rt_e_hover_text_color_yes' => 'yes' ],
                'selectors' => array_fill_keys([
                    '{{WRAPPER}}.e-rt-hover-text-color-yes:hover .react-heading h2',
                    '{{WRAPPER}}.e-rt-hover-text-color-yes:hover .react-heading span',
                    '{{WRAPPER}}.e-rt-hover-text-color-yes:hover .elementor-widget-container',
                    '{{WRAPPER}}.e-rt-hover-text-color-yes:hover .elementor-heading-title',
                    '{{WRAPPER}}.e-rt-hover-text-color-yes:hover .elementor-icon-list-text',
                    '{{WRAPPER}}.e-rt-hover-text-color-yes:hover .elementor-image-box-title',
                    '{{WRAPPER}}.e-rt-hover-text-color-yes:hover .elementor-icon-box-title',
                    '{{WRAPPER}}.e-rt-hover-text-color-yes:hover .elementor-icon i',
                    '{{WRAPPER}}.e-rt-hover-text-color-yes:hover .elementor-icon-box-description'
                ], 'color: {{VALUE}} !important;') + array_fill_keys([
                    '{{WRAPPER}}.e-rt-hover-text-color-yes:hover .elementor-icon-list-icon svg',
                    '{{WRAPPER}}.e-rt-hover-text-color-yes:hover .elementor-icon svg',
                ], 'fill: {{VALUE}} !important;'),
            ]
        );

        // Clip Path one 
        $element->add_control(
            'rt_clip_path_one',
            [
                'label'        => esc_html__('Enable Clip Path Style One', 'rtelements'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__('Yes', 'rtelements'),
                'label_off'    => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default'      => '',
                'prefix_class' => 'rt-clip-path-one-',
                'description'  => esc_html__('Apply Clip Path Style One to the container. ', 'rtelements'),
            ]
        );

        // Clip Path two
        $element->add_control(
            'rt_clip_path_two',
            [
                'label'        => esc_html__('Enable Clip Path Style Two', 'rtelements'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__('Yes', 'rtelements'),
                'label_off'    => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default'      => '',
                'prefix_class' => 'rt-clip-path-two-',
                'description'  => esc_html__('Apply Clip Path Style Two to the container. ', 'rtelements'),
            ]
        );

        // Clip Path three
        $element->add_control(
            'rt_clip_path_three',
            [
                'label'        => esc_html__('Enable Clip Path Style Three', 'rtelements'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__('Yes', 'rtelements'),
                'label_off'    => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default'      => '',
                'prefix_class' => 'rt-clip-path-three-',
                'description'  => esc_html__('Apply Clip Path Style Three to the container. ', 'rtelements'),
            ]
        );

        // Clip Path four
        $element->add_control(
            'rt_clip_path_four',
            [
                'label'        => esc_html__('Enable Clip Path Style Four', 'rtelements'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__('Yes', 'rtelements'),
                'label_off'    => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default'      => '',
                'prefix_class' => 'rt-clip-path-four-',
                'description'  => esc_html__('Apply Clip Path Style Four to the container. ', 'rtelements'),
            ]
        );

        // Clip Path five
        $element->add_control(
            'rt_clip_path_five',
            [
                'label'        => esc_html__('Enable Clip Path Style Five', 'rtelements'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__('Yes', 'rtelements'),
                'label_off'    => esc_html__('No', 'rtelements'),
                'return_value' => 'yes',
                'default'      => '',
                'prefix_class' => 'rt-clip-path-five-',
                'description'  => esc_html__('Apply Clip Path Style Five to the container. ', 'rtelements'),
            ]
        );

        $element->end_controls_section();
    }

    
    public static function inject_image_gallery_controls( $element, $args ) {
        $element->add_control(
            'enable_view_btn',
            [
                'label' => esc_html__( 'Show View Icon', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'rtelements' ),
                'label_off' => esc_html__( 'No', 'rtelements' ),
                'return_value' => 'yes',
                'prefix_class' => 'has-view-icon-',
            ]
        );
        $element->add_control(
            'gl_view_icon',
            [
                'label' => esc_html__( 'View Icon Color', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '.elementor-widget-image-gallery.has-view-icon-yes .gallery-item .gallery-icon a::before' => 'color: {{VALUE}}; border-color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'enable_view_btn' => 'yes',
                ],
            ]
        );
        $element->add_control(
            'gl_view_overly_bg',
            [
                'label' => esc_html__( 'View Overlay BG', 'rtelements' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '.elementor-widget-image-gallery.has-view-icon-yes .gallery-item .gallery-icon a::after' => 'background: {{VALUE}} !important;',
                ],
                'condition' => [
                    'enable_view_btn' => 'yes',
                ],
            ]
        );
    }

    public static function before_image_gallery_elements_section_render( Element_Base $element ){
        $view_btn_cls_settings = $element->get_settings_for_display( 'enable_view_btn' );
        $cls = '';
        if ( $view_btn_cls_settings && is_array( $view_btn_cls_settings ) ) {
            $cls = $view_btn_cls_settings['enable_view_btn'];
            if ( $cls ) {
                $element->add_render_attribute(
                    '_wrapper',
                    [
                        'class' => esc_attr( $cls ),
                    ]
                );
            }
        }
    }

}
RT_E_CONTAINER_RT_OPTIONS::init();


// woocommerce product category 
function rselemetns_woocommerce_product_categories(){
    $terms = get_terms(array(
        'taxonomy' => 'product_cat',
        'hide_empty' => true,
    ));

    if (!empty($terms) && !is_wp_error($terms)) {
        foreach ($terms as $term) {
            $options[$term->slug] = $term->name;
        }
        return $options;
    }
}
function rtelements_elementor_support_for_custom_post_type() {
    $post_types = array('rt-portfolios', 'teams', 'rtelements_pro', 'rts-canvans');
    foreach ( $post_types as $post_type ) {
        add_post_type_support( $post_type, 'elementor' );
    }
}
add_action('init', 'rtelements_elementor_support_for_custom_post_type');

