<?php
define( 'Rts_HFE_VER', '1.6.13' );
define( 'Rts_HFE_FILE', __FILE__ );
define( 'Rts_HFE_DIR', plugin_dir_path( __FILE__ ) );
define( 'Rts_HFE_URL', plugins_url( '/', __FILE__ ) );
define( 'Rts_HFE_PATH', plugin_basename( __FILE__ ) );
define( 'Rts_HFE_DOMAIN', trailingslashit( '' ) );

/**
 * Load the class loader.
 */
require_once Rts_HFE_DIR . '/inc/class-header-footer-elementor.php';

/**
 * Load the Plugin Class.
 */
function Rts_hfe_plugin_activation() {
	update_option( 'Rts_hfe_plugin_is_activated', 'yes' );
}

register_activation_hook( Rts_HFE_FILE, 'Rts_hfe_plugin_activation' );

/**
 * Load the Plugin Class.
 */
function Rts_hfe_init() {
	Rts_Header_Footer_Elementor::instance();
}

add_action( 'plugins_loaded', 'Rts_hfe_init' );


function easy_h_enqueue_font_awesome() {
    if ( class_exists( 'Elementor\Plugin' ) ) {
        // Ensure Elementor Icons CSS is loaded.
        wp_enqueue_style(
            'hfe-elementor-icons',
            plugins_url( '/elementor/assets/lib/eicons/css/elementor-icons.min.css', 'easy-elements' ),
            [],
            '5.34.0'
        );
        wp_enqueue_style(
            'hfe-icons-list',
            plugins_url( '/elementor/assets/css/widget-icon-list.min.css', 'easy-elements' ),
            [],
            '3.24.3'
        );
        wp_enqueue_style(
            'hfe-social-icons',
            plugins_url( '/elementor/assets/css/widget-social-icons.min.css', 'easy-elements' ),
            [],
            '3.24.0'
        );
        wp_enqueue_style(
            'hfe-social-share-icons-brands',
            plugins_url( '/elementor/assets/lib/font-awesome/css/brands.css', 'easy-elements' ),
            [],
            '5.15.3'
        );
        wp_enqueue_style(
            'hfe-social-share-icons-fontawesome',
            plugins_url( '/elementor/assets/lib/font-awesome/css/fontawesome.css', 'easy-elements' ),
            [],
            '5.15.3'
        );
        wp_enqueue_style(
            'hfe-nav-menu-icons',
            plugins_url( '/elementor/assets/lib/font-awesome/css/solid.css', 'easy-elements' ),
            [],
            '5.15.3'
        );
        wp_enqueue_style(
             'elementor-icons-invena', ELEMENTOR_ASSETS_URL . 'css/widget-icon-box.min.css',
        [],
        '5.27.0' // Update based on current Elementor version              
        );
    }
}
add_action( 'wp_enqueue_scripts', 'easy_h_enqueue_font_awesome', 20 );

/**
 * Full WPML + Polylang compatibility fix 
 * for Header Footer Elementor template switching.
 *
 * This ensures each language loads its own translated header/footer.
 */

 function tw_translate_hfe_template( $template_id ) {

    // --- Polylang Support ---
    if ( function_exists( 'pll_get_post' ) ) {
        $translated = pll_get_post( $template_id );
        if ( $translated ) {
            $template_id = $translated;
        }
    }

    // --- WPML Support ---
    if ( has_filter( 'wpml_object_id' ) ) {
        $translated = apply_filters( 'wpml_object_id', $template_id, 'rts-elementor-hf', true );
        if ( $translated ) {
            $template_id = $translated;
        }
    }

    return $template_id;
}

/* Apply translation logic to all HFE template types */
add_filter( 'hfe_get_settings_Rts_type_header', 'tw_translate_hfe_template' );
add_filter( 'hfe_get_settings_Rts_type_footer', 'tw_translate_hfe_template' );
add_filter( 'hfe_get_settings_type_Rts_topbar', 'tw_translate_hfe_template' );
add_filter( 'hfe_get_settings_type_Rts_after__header', 'tw_translate_hfe_template' );
add_filter( 'hfe_get_settings_type_before_footer', 'tw_translate_hfe_template' );
