<?php
class RT_Elements_Templates_Library{

	private $assets_url;
	private $rest_url;


	public function __construct() {

		// get current module's url.
		$this->assets_url = RTTMPL_PL_URL . 'assets/';

        // get current module's url.
		$this->rest_url = RTTMPL_REST_SITE_URL . '/wp-json/rtTemplates/v1/templates';
		
		// print variables on footer.
		add_action( 'elementor/editor/footer', array( $this, 'editor_footer_script' ) );

		// enqueue editor js for elementor.
		add_action( 'elementor/editor/before_enqueue_scripts', array( $this, 'editor_scripts' ), 1 );

		// enqueue editor css.
		add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'editor_styles' ) );

		// enqueue modal's preview css.
		add_action( 'elementor/preview/enqueue_styles', array( $this, 'preview_styles' ) );

	}

	public function editor_scripts() {
		wp_enqueue_script( 'rtelements-template-library-script', $this->assets_url . 'js/rtElements-template-library.js', array( 'jquery', 'wp-element' ), RTTMPL_VERSION, true );
		wp_enqueue_script( 'rtelements-template-library-isotope-script', 'https://unpkg.com/isotope-layout@3.0.6/dist/isotope.pkgd.min.js', array( 'jquery', 'wp-element' ), RTTMPL_VERSION, true );
    }

	public function editor_styles() {
		wp_enqueue_style( 'rtelements-template-library-style', $this->assets_url . 'css/rtelements-template-library.css', array(), RTTMPL_VERSION );
	}

	public function preview_styles() {
		wp_enqueue_style( 'rtelements-template-library-preview-style', $this->assets_url . 'css/preview.css', array(), RTTMPL_VERSION );
	}

	public function editor_footer_script() { ?>
		<script type="text/javascript">

            var rtElementsTemplatesManager = {
                "activeTab": "sections",
                "nonce": "<?php echo esc_attr(wp_create_nonce( 'wp_rest' )); ?>",
                "buttonIcon": "<?php echo  esc_url( $this->assets_url . 'img/rt-template-logo.webp' ); ?>",
                "logoUrl": "<?php echo  esc_url( $this->assets_url . 'img/rt-template-logo-sm.webp' ); ?>",
                "headerLogoUrl": "<?php echo  esc_url( $this->assets_url . 'img/rt-template-logo.webp' ); ?>",
                "bannerAdUrl": "<?php echo  esc_url( $this->assets_url . 'img/rttemplates-banner-ad.webp' ); ?>",
                "apiUrl": "<?php echo esc_url( $this->rest_url); ?>",
                "thumbnailPlaceholderUrl": "https://library.elementor.com/wp-content/uploads/2022/09/About-1.jpg",
                "templatesContainer": document.querySelector('#rtElementsTemplatesLibrary #elementor-template-library-templates-container')
            };

		</script> 
		<?php
	}


}